--CONNECT USERNAME:admuser
print 'Creating procedure UTIL_SETLIST'

--METADATA  TYPE:SSCR NAME:UTIL_SETLIST OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UTIL_SETLIST' and type in ('P'))
  DROP PROCEDURE UTIL_SETLIST
go
--METADATA NAME:UTIL_SETLIST TYPE:PROCEDURE SET:UTILS CHANGE:CREATE
CREATE PROCEDURE UTIL_SETLIST
(@psession_id int,@proj_list varchar(8000),@pret_val int OUTPUT,@pret_msg varchar(4000) OUTPUT )
WITH ENCRYPTION AS
  declare @proj_id int,@end int,@newlist varchar(8000), @cnt int
  set @newlist = @proj_list
  if len(@newlist)>0 
  begin
  set @end = patindex('%,%',@proj_list)
  set @cnt=0
  delete from pkxref where system_id=@psession_id and context_name='PROJLIST'
  begin TRY
  while @end > 0 
   begin
    set @proj_id = cast(substring(@newlist,1,@end-1) as int )
    set @cnt=@cnt+1
    set @newlist = substring(@newlist,@end+1,len(@newlist))
    insert into pkxref(system_id,context_name,pk1,pk2) values(@psession_id,'PROJLIST',@proj_id,@cnt)
    
    set @end = patindex('%,%',@newlist)
   end 
   set @proj_id = cast(@newlist as int)
   set @cnt=@cnt+1
  insert into pkxref(system_id,context_name,pk1,pk2) values(@psession_id,'PROJLIST',@proj_id,@cnt)
   set @pret_val=0
   set @pret_msg='Success:execute utl_setlist';
   
   end TRY
  BEGIN CATCH
    SELECT @pret_val=-1,@pret_msg=ERROR_MESSAGE() 
   END CATCH
end
go
--METADATA NAME:UTIL_SETLIST TYPE:GRANT TABLE_NAME:UTIL_SETLIST CHANGE:CREATE
GRANT EXECUTE ON UTIL_SETLIST TO ${pm.ss.privileged_user}
go
print 'Creating procedure UTIL_GETNEXTLISTVAL'

--METADATA  TYPE:SSCR NAME:UTIL_GETNEXTLISTVAL OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UTIL_GETNEXTLISTVAL' and type in ('P'))
  DROP PROCEDURE UTIL_GETNEXTLISTVAL
go
--METADATA NAME:UTIL_GETNEXTLISTVAL TYPE:PROCEDURE SET:UTILS CHANGE:CREATE
CREATE PROCEDURE UTIL_GETNEXTLISTVAL
(@psession_id int,@proj_id int OUTPUT,@pret_msg varchar(4000) OUTPUT )
WITH ENCRYPTION AS
declare @cnt int 
select @cnt=count(*) from pkxref where system_id=@psession_id and context_name='PROJLIST'
if @cnt=0 
begin
  set @proj_id=-1;
  return
end
else
 begin
  select top(1) @proj_id=pk1 from pkxref where system_id=@psession_id and context_name='PROJLIST' and pk2=(select min(pk2) from pkxref where system_id=@psession_id and context_name='PROJLIST')
  delete from pkxref where system_id=@psession_id and context_name='PROJLIST' and pk1=@proj_id
 end
go
--METADATA NAME:UTIL_GETNEXTLISTVAL TYPE:GRANT TABLE_NAME:UTIL_GETNEXTLISTVAL CHANGE:CREATE
GRANT EXECUTE ON UTIL_GETNEXTLISTVAL TO ${pm.ss.privileged_user}
go
print 'Creating function GET_FIRST_DAY_OF_QUARTER'

--METADATA  TYPE:SSCR NAME:GET_FIRST_DAY_OF_QUARTER OBJECT_TYPE:FUNCTION
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_FIRST_DAY_OF_QUARTER' and type in ('FN','TF'))
  DROP FUNCTION GET_FIRST_DAY_OF_QUARTER
go
--METADATA NAME:GET_FIRST_DAY_OF_QUARTER TYPE:FUNCTION SET:HELPER_FUNCTIONS CHANGE:CREATE
CREATE FUNCTION GET_FIRST_DAY_OF_QUARTER
( @pInputDate    DATETIME )
RETURNS DATETIME
BEGIN    
DECLARE @vOutputDate  DATETIME    
SET @vOutputDate = CAST(YEAR(@pInputDate) AS VARCHAR(4)) +                       
CASE 
            WHEN MONTH(@pInputDate) IN ( 1,  2,  3) THEN '/01/01'                            
            WHEN MONTH(@pInputDate) IN ( 4,  5,  6) THEN '/04/01'                            
            WHEN MONTH(@pInputDate) IN ( 7,  8,  9) THEN '/07/01'                            
            WHEN MONTH(@pInputDate) IN (10, 11, 12) THEN '/10/01'                       
END    
RETURN @vOutputDate
END
go
--METADATA NAME:GET_FIRST_DAY_OF_QUARTER TYPE:GRANT TABLE_NAME:GET_FIRST_DAY_OF_QUARTER CHANGE:CREATE
GRANT EXECUTE ON GET_FIRST_DAY_OF_QUARTER TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_READ_STRING'

--METADATA  TYPE:SSCR NAME:SETTINGS_READ_STRING OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_READ_STRING' and type in ('P'))
  DROP PROCEDURE SETTINGS_READ_STRING
go
--METADATA NAME:SETTINGS_READ_STRING TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_READ_STRING
(@result varchar(4000) OUTPUT, @pnamespace varchar(255)
,@pname varchar(255), @default_value varchar(4000) = ''
,@puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  if @puser_id is null 
    select @result = setting_value
    from settings
    where namespace = @pnamespace
    and setting_name = @pname;
  else
    select @result = setting_value
    from settings
    where namespace = @pnamespace
    and setting_name = @pname
    and user_id = @puser_id;

  if @@ROWCOUNT = 0 
     set @result = @default_value
go
--METADATA NAME:SETTINGS_READ_STRING TYPE:GRANT TABLE_NAME:SETTINGS_READ_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_STRING TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_READ_NUMBER'

--METADATA  TYPE:SSCR NAME:SETTINGS_READ_NUMBER OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_READ_NUMBER' and type in ('P'))
  DROP PROCEDURE SETTINGS_READ_NUMBER
go
--METADATA NAME:SETTINGS_READ_NUMBER TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_READ_NUMBER
(@result decimal(20,6) OUTPUT, @pnamespace varchar(255)
,@pname varchar(255), @default_value decimal(20,6) = null
,@puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @sresult varchar(255), @sdefault varchar(255)
  set @sdefault = str(@default_value)
  exec settings_read_string @sresult OUTPUT,@pnamespace,@pname,@sdefault,@puser_id 
  set @result = cast(@sresult AS decimal(20,6))
go
--METADATA NAME:SETTINGS_READ_NUMBER TYPE:GRANT TABLE_NAME:SETTINGS_READ_NUMBER CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_NUMBER TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_READ_BOOL'

--METADATA  TYPE:SSCR NAME:SETTINGS_READ_BOOL OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_READ_BOOL' and type in ('P'))
  DROP PROCEDURE SETTINGS_READ_BOOL
go
--METADATA NAME:SETTINGS_READ_BOOL TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_READ_BOOL
(@result int OUTPUT, @pnamespace varchar(255)
,@pname varchar(255), @default_value int = 0
,@puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @sresult varchar(255), @sdefault varchar(255)
  if @default_value > 0 
    set @sdefault = 'TRUE'
  else
    set @sdefault = 'FALSE'
    
  exec settings_read_string @sresult OUTPUT,@pnamespace,@pname,@sdefault,@puser_id 
  set @sresult = upper(@sresult)
  if @sresult = 'TRUE' or @sresult = 'T' 
     or @sresult = '1' or @sresult = 'Y'
     or @sresult = 'YES' or @sresult = 'ON'
    set @result = 1
  else
    set @result = 0

go
--METADATA NAME:SETTINGS_READ_BOOL TYPE:GRANT TABLE_NAME:SETTINGS_READ_BOOL CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_BOOL TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_READ_DATE'

--METADATA  TYPE:SSCR NAME:SETTINGS_READ_DATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_READ_DATE' and type in ('P'))
  DROP PROCEDURE SETTINGS_READ_DATE
go
--METADATA NAME:SETTINGS_READ_DATE TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_READ_DATE
(@result datetime OUTPUT, @pnamespace varchar(255)
,@pname varchar(255), @default_value datetime = null
,@puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @sresult varchar(255), @sdefault varchar(255)
  set @sdefault =  convert(varchar(30),@default_value,120)
  exec settings_read_string @sresult OUTPUT,@pnamespace,@pname,@sdefault,@puser_id 
  set @result = convert(datetime,@sresult,120)
go
--METADATA NAME:SETTINGS_READ_DATE TYPE:GRANT TABLE_NAME:SETTINGS_READ_DATE CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_READ_DATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_WRITE_STRING'

--METADATA  TYPE:SSCR NAME:SETTINGS_WRITE_STRING OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_WRITE_STRING' and type in ('P'))
  DROP PROCEDURE SETTINGS_WRITE_STRING
go
--METADATA NAME:SETTINGS_WRITE_STRING TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_WRITE_STRING
(@pvalue varchar(4000) , @pnamespace varchar(255)
,@pname varchar(255), @puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  if @puser_id is null
    update settings 
    set setting_value = @pvalue
    where namespace = @pnamespace 
    and setting_name = @pname;
  else
    update settings 
    set setting_value = @pvalue
    where namespace = @pnamespace 
    and setting_name = @pname
    and user_id = @puser_id;

  if @@ROWCOUNT = 0 
    insert into settings (namespace,setting_name,setting_value,user_id)
    values(@pnamespace,@pname,@pvalue,@puser_id);
go
--METADATA NAME:SETTINGS_WRITE_STRING TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_STRING CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_STRING TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_WRITE_NUMBER'

--METADATA  TYPE:SSCR NAME:SETTINGS_WRITE_NUMBER OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_WRITE_NUMBER' and type in ('P'))
  DROP PROCEDURE SETTINGS_WRITE_NUMBER
go
--METADATA NAME:SETTINGS_WRITE_NUMBER TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_WRITE_NUMBER
(@pvalue decimal(20,6) , @pnamespace varchar(255)
,@pname varchar(255), @puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @nstr varchar(1000)
  set @nstr = ltrim(str(@pvalue))
  exec settings_write_string @nstr,@pnamespace,@pname,@puser_id
go
--METADATA NAME:SETTINGS_WRITE_NUMBER TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_NUMBER CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_NUMBER TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_WRITE_BOOL'

--METADATA  TYPE:SSCR NAME:SETTINGS_WRITE_BOOL OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_WRITE_BOOL' and type in ('P'))
  DROP PROCEDURE SETTINGS_WRITE_BOOL
go
--METADATA NAME:SETTINGS_WRITE_BOOL TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_WRITE_BOOL
(@pvalue int,  @pnamespace varchar(255)
,@pname varchar(255), @puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @boolstr varchar(5)
  if @pvalue > 0 
    set @boolstr = 'TRUE'
  else
    set @boolstr = 'FALSE'
  exec settings_write_string @boolstr,@pnamespace,@pname,@puser_id

go
--METADATA NAME:SETTINGS_WRITE_BOOL TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_BOOL CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_BOOL TO ${pm.ss.privileged_user}
go
print 'Creating procedure SETTINGS_WRITE_DATE'

--METADATA  TYPE:SSCR NAME:SETTINGS_WRITE_DATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SETTINGS_WRITE_DATE' and type in ('P'))
  DROP PROCEDURE SETTINGS_WRITE_DATE
go
--METADATA NAME:SETTINGS_WRITE_DATE TYPE:PROCEDURE SET:SETTINGS_API CHANGE:CREATE
CREATE PROCEDURE SETTINGS_WRITE_DATE
(@pvalue datetime, @pnamespace varchar(255)
,@pname varchar(255), @puser_id int = null)
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @datestr varchar(30);
  set @datestr =  convert(varchar(30),@pvalue,120)
  exec settings_write_string @datestr,@pnamespace,@pname,@puser_id

go
--METADATA NAME:SETTINGS_WRITE_DATE TYPE:GRANT TABLE_NAME:SETTINGS_WRITE_DATE CHANGE:CREATE
GRANT EXECUTE ON SETTINGS_WRITE_DATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure BGP_WRITE_TO_LOG'

--METADATA  TYPE:SSCR NAME:BGP_WRITE_TO_LOG OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BGP_WRITE_TO_LOG' and type in ('P'))
  DROP PROCEDURE BGP_WRITE_TO_LOG
go
--METADATA NAME:BGP_WRITE_TO_LOG TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE BGP_WRITE_TO_LOG
  (@source varchar(255), @desc varchar(255), @type varchar(255) = 'INFORMATION'
   ,@error_ret int=null, @error_msg varchar(4000)=null,@pbegindate datetime=null)
WITH ENCRYPTION AS
  declare @msg varchar(4000), @newtype varchar(255),@penddate datetime,@elatime integer
  set @penddate=getdate()
  if @type is not null
    set @newtype = @type
  else
     set @newtype = 'INFORMATION'
  if @error_ret is null 
    set @msg = @desc
  else
  begin
    if @error_ret < 0 
    begin
      set @msg = 'ERROR (' + ltrim(str(@error_ret)) + '): ' + 
               @error_msg + '(' + @desc + ')'
      set @newtype = 'ERROR'
    end
    else
    begin
      set @msg = @desc + ' (' + ltrim(str(@error_ret)) + ')'
      if @newtype is null 
        set @newtype = 'INFORMATION'
    end
  end
  if (@pbegindate is not null and @type = 'ELAPSED TIME') 
  begin
      set @elatime=DATEDIFF(SECOND,@pbegindate ,@penddate ) 
      set @msg= @msg + '-' + ltrim(STR(@elatime)) + ' Sec'
  end
  insert into bgplog (log_time, source, type, description)
  values (GetDate(),@source,@newtype,@msg)
go
--METADATA NAME:BGP_WRITE_TO_LOG TYPE:GRANT TABLE_NAME:BGP_WRITE_TO_LOG CHANGE:CREATE
GRANT EXECUTE ON BGP_WRITE_TO_LOG TO ${pm.ss.privileged_user}
go
print 'Creating function CURRENT_SESSION'

--METADATA  TYPE:SSCR NAME:CURRENT_SESSION OBJECT_TYPE:FUNCTION
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CURRENT_SESSION' and type in ('FN','TF'))
  DROP FUNCTION CURRENT_SESSION
go
--METADATA NAME:CURRENT_SESSION TYPE:FUNCTION SET:GET_FUNCTIONS CHANGE:CREATE
CREATE FUNCTION CURRENT_SESSION
(@context varchar(20))
returns int
WITH ENCRYPTION AS
begin
  declare @sess_id int, @uid int
  if ( upper(@context) = 'SESSIONID' ) 
  begin
    set @sess_id=0
    select @sess_id=session_id from usession where spid=@@spid and delete_session_id is null
    return(@sess_id)
  end
  if ( upper(@context) = 'USERID' ) 
  begin
    set @uid=0
    select @uid=user_id from usession where spid=@@spid and delete_session_id is null
    return(@uid)
  end
  return(0)
end
go
--METADATA NAME:CURRENT_SESSION TYPE:GRANT TABLE_NAME:CURRENT_SESSION CHANGE:CREATE
GRANT EXECUTE ON CURRENT_SESSION TO ${pm.ss.privileged_user}
go
print 'Creating procedure GET_INTERVAL_DIFFERENCE'

--METADATA  TYPE:SSCR NAME:GET_INTERVAL_DIFFERENCE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_INTERVAL_DIFFERENCE' and type in ('P'))
  DROP PROCEDURE GET_INTERVAL_DIFFERENCE
go
--METADATA NAME:GET_INTERVAL_DIFFERENCE TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE PROCEDURE GET_INTERVAL_DIFFERENCE
(@interval_val varchar(10), @difference decimal(20,6) OUTPUT, @day_adjust decimal(20,6)=0.5)
WITH ENCRYPTION AS
BEGIN
  declare @time_code varchar(1)
  declare @interval decimal(20,6), @scale decimal(20,6)
  set @time_code = substring(@interval_val,len(@interval_val),1)
  set @interval = convert(integer,substring(@interval_val,1,len(@interval_val)-1))
  if @time_code = 'm' 
    set  @scale = 1440
  else if @time_code = 's' 
    set  @scale = 86400
  else if @time_code = 'h' 
    set  @scale = 24
  else if @time_code = 'd'
  begin 
    set @difference = (@interval)-@day_adjust
    return
  end
  else
    RAISERROR('Invalid time code',10,1)

  set @difference=(@interval/@scale)

END
go
--METADATA NAME:GET_INTERVAL_DIFFERENCE TYPE:GRANT TABLE_NAME:GET_INTERVAL_DIFFERENCE CHANGE:CREATE
GRANT EXECUTE ON GET_INTERVAL_DIFFERENCE TO ${pm.ss.privileged_user}
go
print 'Creating procedure APPLY_ACTUALS_TASK'

--METADATA  TYPE:SSCR NAME:APPLY_ACTUALS_TASK OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'APPLY_ACTUALS_TASK' and type in ('P'))
  DROP PROCEDURE APPLY_ACTUALS_TASK
go
--METADATA NAME:APPLY_ACTUALS_TASK TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE PROCEDURE APPLY_ACTUALS_TASK
(@task_id           int,
 @status_code       varchar(15),
 @act_start_date    datetime,
 @act_end_date      datetime,
 @restart_date      datetime,
 @reend_date        datetime,
 @target_start_date datetime,
 @target_end_date   datetime,
 @act_work_qty      float = 0,
 @remain_work_qty   float = 0,
 @act_equip_qty     float = 0,
 @remain_equip_qty  float = 0
)
WITH ENCRYPTION AS

  update task
  set    status_code         = @status_code,
         act_start_date      = @act_start_date,
         act_end_date        = @act_end_date,
         restart_date        = @restart_date,
         reend_date          = @reend_date,
         target_start_date   = @target_start_date,
         target_end_date     = @target_end_date,
         act_work_qty        = @act_work_qty,
         remain_work_qty     = @remain_work_qty,
         act_equip_qty       = @act_equip_qty,
         remain_equip_qty    = @remain_equip_qty
  where  task_id             = @task_id

return
go
--METADATA NAME:APPLY_ACTUALS_TASK TYPE:GRANT TABLE_NAME:APPLY_ACTUALS_TASK CHANGE:CREATE
GRANT EXECUTE ON APPLY_ACTUALS_TASK TO ${pm.ss.privileged_user}
go
print 'Creating procedure APPLY_ACTUALS_TASKRSRC'

--METADATA  TYPE:SSCR NAME:APPLY_ACTUALS_TASKRSRC OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'APPLY_ACTUALS_TASKRSRC' and type in ('P'))
  DROP PROCEDURE APPLY_ACTUALS_TASKRSRC
go
--METADATA NAME:APPLY_ACTUALS_TASKRSRC TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE PROCEDURE APPLY_ACTUALS_TASKRSRC
(@taskrsrc_id int,
 @target_start_date datetime,
 @target_end_date datetime,
 @restart_date datetime,
 @reend_date datetime,
 @act_start_date datetime,
 @act_end_date datetime,
 @act_reg_qty float = 0,
 @act_ot_qty float = 0,
 @remain_qty float = 0
)
WITH ENCRYPTION AS

  update taskrsrc
  set    target_start_date   = @target_start_date,
         target_end_date     = @target_end_date,
         restart_date        = @restart_date,
         reend_date          = @reend_date,
         act_start_date      = @act_start_date,
         act_end_date        = @act_end_date,
         act_reg_qty         = @act_reg_qty,
         act_ot_qty          = @act_ot_qty,
         remain_qty          = @remain_qty
  where  taskrsrc_id         = @taskrsrc_id

return
go
--METADATA NAME:APPLY_ACTUALS_TASKRSRC TYPE:GRANT TABLE_NAME:APPLY_ACTUALS_TASKRSRC CHANGE:CREATE
GRANT EXECUTE ON APPLY_ACTUALS_TASKRSRC TO ${pm.ss.privileged_user}
go
print 'Creating procedure APPLY_ESTIMATE_TASK'

--METADATA  TYPE:SSCR NAME:APPLY_ESTIMATE_TASK OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'APPLY_ESTIMATE_TASK' and type in ('P'))
  DROP PROCEDURE APPLY_ESTIMATE_TASK
go
--METADATA NAME:APPLY_ESTIMATE_TASK TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE PROCEDURE APPLY_ESTIMATE_TASK
(@task_id int,
 @reend_date datetime,
 @target_end_date datetime,
 @target_work_qty float = 0,
 @remain_work_qty float = 0,
 @target_equip_qty float = 0,
 @remain_equip_qty float = 0,
 @target_drtn_hr_cnt float = 0,
 @remain_drtn_hr_cnt float = 0
)

WITH ENCRYPTION AS

  update task
  set    reend_date          = @reend_date,
         target_end_date     = @target_end_date,
         target_work_qty     = @target_work_qty,
         remain_work_qty     = @remain_work_qty,
         target_equip_qty    = @target_equip_qty,
         remain_equip_qty    = @remain_equip_qty,
         target_drtn_hr_cnt  = @target_drtn_hr_cnt,
         remain_drtn_hr_cnt  = @remain_drtn_hr_cnt
  where  task_id             = @task_id

return
go
--METADATA NAME:APPLY_ESTIMATE_TASK TYPE:GRANT TABLE_NAME:APPLY_ESTIMATE_TASK CHANGE:CREATE
GRANT EXECUTE ON APPLY_ESTIMATE_TASK TO ${pm.ss.privileged_user}
go
print 'Creating procedure APPLY_ESTIMATE_TASKRSRC'

--METADATA  TYPE:SSCR NAME:APPLY_ESTIMATE_TASKRSRC OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'APPLY_ESTIMATE_TASKRSRC' and type in ('P'))
  DROP PROCEDURE APPLY_ESTIMATE_TASKRSRC
go
--METADATA NAME:APPLY_ESTIMATE_TASKRSRC TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE PROCEDURE APPLY_ESTIMATE_TASKRSRC
(@taskrsrc_id int,
 @target_end_date datetime,
 @reend_date datetime,
 @target_qty float = 0,
 @target_qty_per_hr float = 0,
 @remain_qty float = 0,
 @remain_qty_per_hr float = 0
)
WITH ENCRYPTION AS

  update taskrsrc
  set    target_end_date    = @target_end_date,
         reend_date         = @reend_date,
         remain_qty         = @remain_qty,
         remain_qty_per_hr  = @remain_qty_per_hr,
         target_qty         = @target_qty,
         target_qty_per_hr  = @target_qty_per_hr
  where  taskrsrc_id        = @taskrsrc_id

return
go
--METADATA NAME:APPLY_ESTIMATE_TASKRSRC TYPE:GRANT TABLE_NAME:APPLY_ESTIMATE_TASKRSRC CHANGE:CREATE
GRANT EXECUTE ON APPLY_ESTIMATE_TASKRSRC TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJSHAR_INSERT'

--METADATA  TYPE:SSCR NAME:PROJSHAR_INSERT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJSHAR_INSERT' and type in ('P'))
  DROP PROCEDURE PROJSHAR_INSERT
go
--METADATA NAME:PROJSHAR_INSERT TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE PROCEDURE PROJSHAR_INSERT
  	@pwbs_id 	int,
	@paccess_level	int,
	@psession_id	int,
	@pret_val	int OUTPUT,
	@ppfolio_id	int = null
WITH ENCRYPTION AS
  DECLARE wbsCur CURSOR LOCAL FOR 
     select wbs_id 
     from projwbs
     where parent_wbs_id = @pwbs_id 
     and proj_node_flag = 'Y'
     and delete_session_id is null

  DECLARE @lwbs_id int
  DECLARE @vproj_id int
  DECLARE @vorig_proj_id int
  DECLARE @vproj_flag varchar(1)
  DECLARE @acnt int

  select @vproj_id = p.proj_id,
	@vproj_flag = p.project_flag,
	@vorig_proj_id = p.orig_proj_id 
  from projwbs pw, project p
  where p.proj_id = pw.proj_id
  and wbs_id = @pwbs_id 
  and proj_node_flag = 'Y'
  and pw.delete_session_id is null and p.delete_session_id is null

  if @vproj_id is null 
  BEGIN
    set @pret_val = -3
    RETURN
  END
    

  set @pret_val = 0
--  if (@@NESTLEVEL = 1) 
--  BEGIN 
--    BEGIN TRANSACTION 
--  END 

  if @vproj_flag = 'Y' and @vorig_proj_id is null 
  BEGIN
    if @ppfolio_id is not null
    BEGIN
      select @acnt=count(*) from pfolio where pfolio_id = @ppfolio_id and delete_session_id is null;
      if @acnt = 1 
      BEGIN
        select @acnt=count(*) from prpfolio 
	where wbs_id = @pwbs_id
	and pfolio_id = @ppfolio_id
        and delete_session_id is null;
        if @acnt = 0 
          RETURN
      END
    END
    if @paccess_level >= 1
    BEGIN
      if @paccess_level = 1
      BEGIN
        select @acnt = count(*)
        from projshar
        where proj_id = @vproj_id
        and session_id <> @psession_id 
        and access_level = 2 

        if @acnt > 0 
        BEGIN
          set @pret_val = -2
          RETURN
        END

      END
      ELSE
      BEGIN
        select @acnt = count(*)
        from projshar
        where proj_id = @vproj_id
        and session_id <> @psession_id 
        and access_level > 0 

        if @acnt > 0 
        BEGIN
          set @pret_val = -2
          RETURN
        END
      END
    END

    -- Verify count and add to projshar
    select @acnt = count(*) 
    from projshar
    where proj_id = @vproj_id
    and session_id = @psession_id

    if @acnt = 0
    BEGIN
      insert into projshar (PROJ_ID, SESSION_ID, ACCESS_LEVEL, load_status ) 
      values (@vproj_id, @psession_id, @paccess_level, 'L' )  
    END
    else
    BEGIN
      update projshar 
	set ACCESS_LEVEL = @paccess_level, LOAD_status = 'L'
        where proj_id = @vproj_id and session_id = @psession_id;

    END
    RETURN
  END


  -- Do Recursion
  OPEN wbsCur
  FETCH NEXT FROM wbsCur INTO @lwbs_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    EXEC projshar_insert @lwbs_id, @paccess_level, @psession_id , @pret_val OUT, @ppfolio_id
    if @pret_val < 0 
    BEGIN
      BREAK
    END
    FETCH NEXT FROM wbsCur INTO @lwbs_id
  END
  CLOSE wbsCur
  DEALLOCATE wbsCur

--  if (@@NESTLEVEL = 1) 
--    if @pret_val = 0 
--      COMMIT TRANSACTION 
 
go
--METADATA NAME:PROJSHAR_INSERT TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJSHAR_INSERT_UPD'

--METADATA  TYPE:SSCR NAME:PROJSHAR_INSERT_UPD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJSHAR_INSERT_UPD' and type in ('P'))
  DROP PROCEDURE PROJSHAR_INSERT_UPD
go
--METADATA NAME:PROJSHAR_INSERT_UPD TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE PROCEDURE PROJSHAR_INSERT_UPD
	@psession_id	int,
	@pload_status	varchar,
	@pret_val	int OUTPUT 
WITH ENCRYPTION AS

  update projshar
  set load_status = @pload_status
  where session_id = @psession_id
  and load_status <> @pload_status

  if ( @@ERROR <> 0 )
    set @pret_val = -1
  else
    set @pret_val = 0
go
--METADATA NAME:PROJSHAR_INSERT_UPD TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT_UPD CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT_UPD TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJSHAR_INSERT_MULTIPLE_IDS'

--METADATA  TYPE:SSCR NAME:PROJSHAR_INSERT_MULTIPLE_IDS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJSHAR_INSERT_MULTIPLE_IDS' and type in ('P'))
  DROP PROCEDURE PROJSHAR_INSERT_MULTIPLE_IDS
go
--METADATA NAME:PROJSHAR_INSERT_MULTIPLE_IDS TYPE:PROCEDURE SET:PROJSHAR_INS CHANGE:CREATE
CREATE PROCEDURE PROJSHAR_INSERT_MULTIPLE_IDS
	@StringWithDelimiter VARCHAR(MAX),
	@paccess_level	int,
	@psession_id	int,
	@pret_val	VARCHAR(MAX) OUTPUT,
	@ppfolio_id	int = null
WITH ENCRYPTION AS
BEGIN
    DECLARE @StartingPosition INT;
    DECLARE @ItemInString VARCHAR(MAX);
    DECLARE @Delimiter VARCHAR(8);
    DECLARE @v_string VARCHAR(100);
    DECLARE @ret_val INT;

    SELECT @Delimiter = ',';
    SELECT @StartingPosition = 1;
    IF LEN(@StringWithDelimiter) = 0 OR @StringWithDelimiter IS NULL RETURN;
    SET @pret_val=''; 
    WHILE @StartingPosition > 0
    BEGIN
        SET @StartingPosition = CHARINDEX(@Delimiter,@StringWithDelimiter); 
        IF @StartingPosition > 0                
            SET @ItemInString = SUBSTRING(@StringWithDelimiter,0,@StartingPosition)
        ELSE
            SET @ItemInString = @StringWithDelimiter;
        	IF( LEN(@ItemInString) > 0)
        	 EXEC projshar_insert @ItemInString,@paccess_level,@psession_id,@ret_val OUT,@ppfolio_id;
         	SET @v_string = @ItemInString +':'+CAST(@ret_val AS VARCHAR);
         	IF(@pret_val = '')
				SET @pret_val = @v_string;
         	ELSE
				SET @pret_val = @pret_val+','+@v_string;
		 	SET @StringWithDelimiter = SUBSTRING(@StringWithDelimiter,@StartingPosition + 
                     LEN(@Delimiter),LEN(@StringWithDelimiter) - @StartingPosition)
		IF LEN(@StringWithDelimiter) = 0 BREAK;
	END
END

grant execute on projshar_insert_multiple_ids to ${pm.ss.privileged_user}
go
--METADATA NAME:PROJSHAR_INSERT_MULTIPLE_IDS TYPE:GRANT TABLE_NAME:PROJSHAR_INSERT_MULTIPLE_IDS CHANGE:CREATE
GRANT EXECUTE ON PROJSHAR_INSERT_MULTIPLE_IDS TO ${pm.ss.privileged_user}
go
print 'Creating procedure POPULATE_UACCESS'

--METADATA  TYPE:SSCR NAME:POPULATE_UACCESS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'POPULATE_UACCESS' and type in ('P'))
  DROP PROCEDURE POPULATE_UACCESS
go
--METADATA NAME:POPULATE_UACCESS TYPE:PROCEDURE SET:POPULATE_UACCESS CHANGE:CREATE
CREATE PROCEDURE POPULATE_UACCESS
        @puser_id INT,
        @pret_val INT OUTPUT,
        @padd_parents varchar(1) = 'N'
WITH ENCRYPTION AS
  set nocount on 
  declare @usr int, @vwbs_id int, @vparent_wbs_id int, @vproj_id int
  declare @ins_wbs_id int, @ins_proj_id int
  set @usr = @puser_id

  delete from uaccess 
  where user_id = @usr
  if ( @@ERROR <> 0 ) 
  BEGIN
    set @pret_val=-1
    RETURN
  END

  -- Insert all the direct nodes
  insert into uaccess (user_id,proj_id,access_flag,wbs_id,parent_wbs_id)
  select distinct @usr,o.proj_id,'Y',(select w.wbs_id from projwbs w where w.proj_id = o.proj_id and w.proj_node_flag = 'Y')
  ,(select pw.parent_wbs_id from projwbs pw where pw.wbs_id = (select pwbs.wbs_id from projwbs pwbs where pwbs.proj_id = o.proj_id and pwbs.proj_node_flag = 'Y'))
  from obsproj o
  where o.obs_id in (select obs_id from userobs where user_id =@usr and delete_session_id is null)

  if @padd_parents = 'Y'
  BEGIN
    create table #roots ( wbs_id int)
    insert into #roots
    select wbs_id from uaccess where user_id = @usr 
    and parent_wbs_id not in (select wbs_id from uaccess where user_id = @usr);

    select top 1 @vwbs_id=wbs_id from #roots
    while (select count(*) from #roots) > 0 
    BEGIN
      select @vparent_wbs_id=parent_wbs_id from projwbs where wbs_id = @vwbs_id and delete_session_id is null;
      while (@vparent_wbs_id is not null)
      BEGIN
        set @ins_wbs_id = @vparent_wbs_id
        select @vparent_wbs_id=parent_wbs_id, @vproj_id=proj_id from projwbs where wbs_id = @vparent_wbs_id and delete_session_id is null;
        if @@rowcount=0 BREAK
        if (select count(*) from uaccess where user_id = @usr and proj_id = @vproj_id) = 0 
          insert into uaccess (user_id,proj_id,access_flag,wbs_id,parent_wbs_id)
          values (@usr,@vproj_id,'N',@ins_wbs_id,null)
      END

      delete from #roots where wbs_id = @vwbs_id
      select top 1 @vwbs_id=wbs_id from #roots
    END
  END

  set @pret_val = 0

go
--METADATA NAME:POPULATE_UACCESS TYPE:GRANT TABLE_NAME:POPULATE_UACCESS CHANGE:CREATE
GRANT EXECUTE ON POPULATE_UACCESS TO ${pm.ss.privileged_user}
go
print 'Creating procedure UACCESS_MAINTAIN_FOR_USER'

--METADATA  TYPE:SSCR NAME:UACCESS_MAINTAIN_FOR_USER OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UACCESS_MAINTAIN_FOR_USER' and type in ('P'))
  DROP PROCEDURE UACCESS_MAINTAIN_FOR_USER
go
--METADATA NAME:UACCESS_MAINTAIN_FOR_USER TYPE:PROCEDURE SET:UACCESS_MAINTAIN CHANGE:CREATE
CREATE PROCEDURE UACCESS_MAINTAIN_FOR_USER
        (@puser_id INT,
        @pret_val INT OUTPUT,
        @padd_parents varchar(1) = 'N')
WITH ENCRYPTION AS
declare @ret int
EXEC populate_uaccess @puser_id,@pret_val,@padd_parents
go
--METADATA NAME:UACCESS_MAINTAIN_FOR_USER TYPE:GRANT TABLE_NAME:UACCESS_MAINTAIN_FOR_USER CHANGE:CREATE
GRANT EXECUTE ON UACCESS_MAINTAIN_FOR_USER TO ${pm.ss.privileged_user}
go
print 'Creating procedure UPDATE_TASKACTV'

--METADATA  TYPE:SSCR NAME:UPDATE_TASKACTV OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UPDATE_TASKACTV' and type in ('P'))
  DROP PROCEDURE UPDATE_TASKACTV
go
--METADATA NAME:UPDATE_TASKACTV TYPE:PROCEDURE SET:ORIG_SCHEDULE CHANGE:CREATE
CREATE PROCEDURE UPDATE_TASKACTV
(
@task_id int, 
@actv_code_type_id int, 
@actv_code_id int
)
WITH ENCRYPTION AS

  update taskactv 
  set    actv_code_id      = @actv_code_id
  where  task_id           = @task_id 
  and    actv_code_type_id = @actv_code_type_id

return
go
--METADATA NAME:UPDATE_TASKACTV TYPE:GRANT TABLE_NAME:UPDATE_TASKACTV CHANGE:CREATE
GRANT EXECUTE ON UPDATE_TASKACTV TO ${pm.ss.privileged_user}
go
print 'Creating procedure GETNEXTKEYS'

--METADATA  TYPE:SSCR NAME:GETNEXTKEYS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GETNEXTKEYS' and type in ('P'))
  DROP PROCEDURE GETNEXTKEYS
go
--METADATA NAME:GETNEXTKEYS TYPE:PROCEDURE SET:GETNEXTKEYS CHANGE:CREATE
CREATE PROCEDURE GETNEXTKEYS
(
	@tabcol varchar(60) = 'TableColumn%',
        @nkeys integer = 'NumKeys%',
        @startkey integer OUTPUT
	 )
WITH ENCRYPTION AS 
  BEGIN TRAN
    UPDATE nextkey SET key_seq_num = (key_seq_num + @nkeys) WHERE key_name = @tabcol
    SELECT @startkey=key_seq_num-@nkeys FROM nextkey WHERE key_name = @tabcol
  COMMIT
go
--METADATA NAME:GETNEXTKEYS TYPE:GRANT TABLE_NAME:GETNEXTKEYS CHANGE:CREATE
GRANT EXECUTE ON GETNEXTKEYS TO ${pm.ss.privileged_user}
go
print 'Creating procedure BRE_ADD'

--METADATA  TYPE:SSCR NAME:BRE_ADD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BRE_ADD' and type in ('P'))
  DROP PROCEDURE BRE_ADD
go
--METADATA NAME:BRE_ADD TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE PROCEDURE BRE_ADD
(
	@g varchar(50) = 'bre_id%',
	@i varchar(30) = 'ipaddr%',
	@c varchar(50) = 'config%',
        @ret varchar(80) OUTPUT,
	@s char(1) = 'A' )
WITH ENCRYPTION AS 
insert into BRE_REGISTRY
  (bre_registry_id,ip_address,start_time,status_code, last_time, config_name)
  values (@g,@i,GETDATE(),@s,GETDATE(),@c)

SELECT @ret = 'BRE ' + @g + ' IS REGISTERED'
go
--METADATA NAME:BRE_ADD TYPE:GRANT TABLE_NAME:BRE_ADD CHANGE:CREATE
GRANT EXECUTE ON BRE_ADD TO ${pm.ss.privileged_user}
go
print 'Creating procedure BRE_CHECKCHANGE'

--METADATA  TYPE:SSCR NAME:BRE_CHECKCHANGE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BRE_CHECKCHANGE' and type in ('P'))
  DROP PROCEDURE BRE_CHECKCHANGE
go
--METADATA NAME:BRE_CHECKCHANGE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE PROCEDURE BRE_CHECKCHANGE
(
        @guid varchar(50) = 'BRE_REG_ID%',
	@chng char(1) OUTPUT
	)
WITH ENCRYPTION AS
DECLARE		@t varchar(1)
DECLARE		c1 CURSOR LOCAL  FOR select config_changed_flag from bre_registry 
			where config_changed_flag = 'Y' and bre_registry_id = @guid;
   BEGIN
		OPEN c1
		FETCH NEXT FROM c1 INTO @t
		IF @@FETCH_STATUS = 0 
     		BEGIN
			update bre_registry set config_changed_flag = 'N' where 
				bre_registry_id = @guid
			select @chng = 'Y'
		END
		ELSE
		BEGIN
			select @chng = 'N'
		END
		CLOSE c1
		DEALLOCATE c1
	RETURN
   END

go
--METADATA NAME:BRE_CHECKCHANGE TYPE:GRANT TABLE_NAME:BRE_CHECKCHANGE CHANGE:CREATE
GRANT EXECUTE ON BRE_CHECKCHANGE TO ${pm.ss.privileged_user}
go
print 'Creating procedure BRE_REMOVE'

--METADATA  TYPE:SSCR NAME:BRE_REMOVE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BRE_REMOVE' and type in ('P'))
  DROP PROCEDURE BRE_REMOVE
go
--METADATA NAME:BRE_REMOVE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE PROCEDURE BRE_REMOVE
(
	@handle varchar(50) = 'bre_id%',
        @del_amount integer OUTPUT
	 )
WITH ENCRYPTION AS 
SELECT @del_amount = count(*) from bre_registry where bre_registry_id = @handle
delete from bre_registry where bre_registry_id = @handle
go
--METADATA NAME:BRE_REMOVE TYPE:GRANT TABLE_NAME:BRE_REMOVE CHANGE:CREATE
GRANT EXECUTE ON BRE_REMOVE TO ${pm.ss.privileged_user}
go
print 'Creating procedure BRE_KEEPALIVE'

--METADATA  TYPE:SSCR NAME:BRE_KEEPALIVE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BRE_KEEPALIVE' and type in ('P'))
  DROP PROCEDURE BRE_KEEPALIVE
go
--METADATA NAME:BRE_KEEPALIVE TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE PROCEDURE BRE_KEEPALIVE
(
	@handle varchar(50) = 'bre_id%',
        @ret varchar(80) OUTPUT
	 )
WITH ENCRYPTION AS 
update bre_registry set last_time = GETDATE(), status_code = 'A'  where bre_registry_id = @handle
SELECT @ret = 'BRE TIME UPDATED'
go
--METADATA NAME:BRE_KEEPALIVE TYPE:GRANT TABLE_NAME:BRE_KEEPALIVE CHANGE:CREATE
GRANT EXECUTE ON BRE_KEEPALIVE TO ${pm.ss.privileged_user}
go
print 'Creating procedure BRE_PING'

--METADATA  TYPE:SSCR NAME:BRE_PING OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BRE_PING' and type in ('P'))
  DROP PROCEDURE BRE_PING
go
--METADATA NAME:BRE_PING TYPE:PROCEDURE SET:BRE_PROCS CHANGE:CREATE
CREATE PROCEDURE BRE_PING
(
	@tsec varchar(50) = 'timeout_secs%',
        @ret integer OUTPUT
	 )
WITH ENCRYPTION AS 
DECLARE OldCursor CURSOR LOCAL  FOR SELECT bre_registry_id from bre_registry 
           where round(cast( (GETDATE() - last_time ) as numeric(18,6))*(60*60*24),0) > @tsec

DECLARE @CurPK varchar(50), @Tcount int

   select @Tcount = 0
OPEN OldCursor

FETCH NEXT FROM OldCursor into @CurPK
WHILE @@FETCH_STATUS = 0
BEGIN
   select @Tcount = @Tcount+1
   update bre_registry set torched_time = GETDATE(), status_code = 'T' where bre_registry_id = @CurPK
   FETCH NEXT FROM OldCursor
END
CLOSE OldCursor
DEALLOCATE OldCursor
SELECT @ret = @Tcount
go
--METADATA NAME:BRE_PING TYPE:GRANT TABLE_NAME:BRE_PING CHANGE:CREATE
GRANT EXECUTE ON BRE_PING TO ${pm.ss.privileged_user}
go
print 'Creating procedure COUNT_RSRC_LVLS'

--METADATA  TYPE:SSCR NAME:COUNT_RSRC_LVLS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'COUNT_RSRC_LVLS' and type in ('P'))
  DROP PROCEDURE COUNT_RSRC_LVLS
go
--METADATA NAME:COUNT_RSRC_LVLS TYPE:PROCEDURE SET:RSRC_TREE_PROCS CHANGE:CREATE
CREATE PROCEDURE COUNT_RSRC_LVLS
(@start_id integer, @lvls integer OUTPUT )
WITH ENCRYPTION AS 
SET NOCOUNT ON
CREATE TABLE #stack (lvlst int, clvl int)
BEGIN
select @lvls = 1
INSERT INTO #stack values (@start_id, 1)
WHILE (select count(*) from rsrc where parent_rsrc_id in (select lvlst from #stack where clvl = @lvls) 
      and delete_session_id is null) != 0
   BEGIN
      select @lvls = @lvls + 1
      INSERT INTO #stack select rsrc_id, @lvls from rsrc where parent_rsrc_id in 
           (select lvlst from #stack where clvl = (@lvls-1))
           and delete_session_id is null ;
      DELETE FROM #stack where clvl = (@lvls-1)
   END
END
go
--METADATA NAME:COUNT_RSRC_LVLS TYPE:GRANT TABLE_NAME:COUNT_RSRC_LVLS CHANGE:CREATE
GRANT EXECUTE ON COUNT_RSRC_LVLS TO ${pm.ss.privileged_user}
go
print 'Creating procedure GET_RSRC_ASSOC_TYPES'

--METADATA  TYPE:SSCR NAME:GET_RSRC_ASSOC_TYPES OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_RSRC_ASSOC_TYPES' and type in ('P'))
  DROP PROCEDURE GET_RSRC_ASSOC_TYPES
go
--METADATA NAME:GET_RSRC_ASSOC_TYPES TYPE:PROCEDURE SET:RSRC_TREE_PROCS CHANGE:CREATE
CREATE PROCEDURE GET_RSRC_ASSOC_TYPES
(@rsrc_id numeric(10), @types varchar(300) OUTPUT)
WITH ENCRYPTION AS
  SET NOCOUNT ON
  CREATE TABLE #rsrctree (rsrc int, lvls int)
  DECLARE @lvl int
  DECLARE @rid numeric(10)
  DECLARE @lt int
  DECLARE @typl varchar(300)
BEGIN
  insert into #rsrctree values (@rsrc_id, 1)
  select @lvl = 1
  select @typl = ''

  WHILE (select count(*) from rsrc where parent_rsrc_id in (select rsrc from 
                               #rsrctree where lvls = @lvl) and delete_session_id is null) != 0
   BEGIN
      select @lvl = @lvl + 1
      INSERT INTO #rsrctree select rsrc_id, @lvl from rsrc where parent_rsrc_id in 
           (select rsrc from #rsrctree where lvls = (@lvl-1)) and delete_session_id is null 
   END

  if exists  ( select rsrc_id from  TASKRSRC
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
      select @typl = @typl + ',TASKRSRC'

  if exists  ( select rsrc_id from  PROJEST
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
      select @typl = @typl + ',PROJEST'

  if exists  ( select rsrc_id from  PROJISSU
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',PROJISSU'

  if exists  ( select rsrc_id from  TIMESHT
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',TIMESHT'

  if exists  ( select rsrc_id from  RSRFOLIO
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',RSRFOLIO'

  if exists ( select rsrc_id from TASKRSRC 
        where act_reg_qty + act_ot_qty > 0
    and rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
      select @typl = @typl + ',TSACTUALS'

  if exists  ( select rsrc_id from  PROJECT
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',PROJECT'

  if exists  ( select rsrc_id from  DOCUMENT
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',DOCUMENT'

  if exists  ( select rsrc_id from  WBSRSRC
        WHERE rsrc_id in ( select rsrc from #rsrctree) and delete_session_id is null)
     select @typl = @typl + ',WBSRSRC'
   
  select @lt = len(@typl) - 1
  IF @lt > 1 
  begin
     select @types = substring(@typl,2,@lt)
  end
END
go
--METADATA NAME:GET_RSRC_ASSOC_TYPES TYPE:GRANT TABLE_NAME:GET_RSRC_ASSOC_TYPES CHANGE:CREATE
GRANT EXECUTE ON GET_RSRC_ASSOC_TYPES TO ${pm.ss.privileged_user}
go
print 'Creating procedure BITWISE_LSHIFT'

--METADATA  TYPE:SSCR NAME:BITWISE_LSHIFT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BITWISE_LSHIFT' and type in ('P'))
  DROP PROCEDURE BITWISE_LSHIFT
go
--METADATA NAME:BITWISE_LSHIFT TYPE:PROCEDURE SET:GUID CHANGE:CREATE
CREATE PROCEDURE BITWISE_LSHIFT
	@p_value int, @p_times tinyint = 1, @pret int OUTPUT
WITH ENCRYPTION AS
  select @pret = @p_value * ( power( 2, @p_times) )
go
--METADATA NAME:BITWISE_LSHIFT TYPE:GRANT TABLE_NAME:BITWISE_LSHIFT CHANGE:CREATE
GRANT EXECUTE ON BITWISE_LSHIFT TO ${pm.ss.privileged_user}
go
print 'Creating procedure BITWISE_RSHIFT'

--METADATA  TYPE:SSCR NAME:BITWISE_RSHIFT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BITWISE_RSHIFT' and type in ('P'))
  DROP PROCEDURE BITWISE_RSHIFT
go
--METADATA NAME:BITWISE_RSHIFT TYPE:PROCEDURE SET:GUID CHANGE:CREATE
CREATE PROCEDURE BITWISE_RSHIFT
	@p_value int, @p_times tinyint = 1, @pret int OUTPUT
WITH ENCRYPTION AS
  select @pret = @p_value / ( power( 2, @p_times) )
go
--METADATA NAME:BITWISE_RSHIFT TYPE:GRANT TABLE_NAME:BITWISE_RSHIFT CHANGE:CREATE
GRANT EXECUTE ON BITWISE_RSHIFT TO ${pm.ss.privileged_user}
go
print 'Creating procedure MIME_ENCODE_CHAR'

--METADATA  TYPE:SSCR NAME:MIME_ENCODE_CHAR OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'MIME_ENCODE_CHAR' and type in ('P'))
  DROP PROCEDURE MIME_ENCODE_CHAR
go
--METADATA NAME:MIME_ENCODE_CHAR TYPE:PROCEDURE SET:GUID CHANGE:CREATE
CREATE PROCEDURE MIME_ENCODE_CHAR
	@c tinyint, @char char(1) OUTPUT
WITH ENCRYPTION AS
select @char =
  CASE
  when @c < 26 then char(ASCII('A')+@c)
  when @c < 52 then char(ASCII('a')+(@c-26) )
  when @c < 62 then char(ASCII('0')+(@c-52) )
  when @c = 62 then '+'
  else '/'
  end
go
--METADATA NAME:MIME_ENCODE_CHAR TYPE:GRANT TABLE_NAME:MIME_ENCODE_CHAR CHANGE:CREATE
GRANT EXECUTE ON MIME_ENCODE_CHAR TO ${pm.ss.privileged_user}
go
print 'Creating procedure MIME_ENCODE'

--METADATA  TYPE:SSCR NAME:MIME_ENCODE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'MIME_ENCODE' and type in ('P'))
  DROP PROCEDURE MIME_ENCODE
go
--METADATA NAME:MIME_ENCODE TYPE:PROCEDURE SET:GUID CHANGE:CREATE
CREATE PROCEDURE MIME_ENCODE
	@pbuf		varchar(8000),
	@padding	varchar(1)= 'N',
	@pEncStr	varchar(8000) OUTPUT 
WITH ENCRYPTION AS
  declare @i int, @k int, @n int, @n3byt int, @nrest int
  declare @b0 char, @b1 char, @b2 char, @b3 char 
  declare @d0 tinyint, @d1 tinyint,  @d2 tinyint,  @d3 tinyint 
  declare @av0 tinyint, @av1 tinyint, @av2 tinyint
  set @pEncStr =  ''
  set @n=len(@pbuf) set @n3byt=@n/3 set @nrest=@n%3 set @k=@n3byt * 3
  set @i=0
  while @i<@k
  begin
    set @av0 = ASCII( substring( @pbuf, @i+1, 1 ) ) & 252
    exec bitwise_rshift  @av0  , 2, @av0 OUTPUT
    exec mime_encode_char @av0, @b0 OUTPUT
    set @av0 = ASCII( substring( @pbuf, @i+1, 1 ) ) & 3
    exec bitwise_lshift  @av0  , 4, @av0 OUTPUT
    set @av1 = ASCII( substring( @pbuf, @i+2, 1 ) )  & 240
    exec bitwise_rshift  @av1  , 4, @av1 OUTPUT
    set @av1=@av0|@av1
    exec mime_encode_char @av1, @b1 OUTPUT

    set @av1 = ASCII( substring( @pbuf, @i+2, 1 ) )  & 15
    exec bitwise_lshift  @av1  , 2, @av1 OUTPUT
    set @av2 = ASCII( substring( @pbuf, @i+3, 1 ) )  & 192
    exec bitwise_rshift  @av2  , 6, @av2 OUTPUT
    set @av2=@av1|@av2
    exec mime_encode_char @av2, @b2 OUTPUT
    set @av2 = ASCII( substring( @pbuf, @i+3, 1 ) )  & 63
    exec mime_encode_char @av2, @b3 OUTPUT
  
    set @pEncStr = @pEncStr +@b0+@b1+@b2+@b3
    set @i=@i+3
  end			-- end while loop

  if @nrest = 2
  begin
    set @av0 = ASCII( substring( @pbuf, @k+1, 1 ) ) & 252
    exec bitwise_rshift  @av0  , 2, @av0 OUTPUT
    exec mime_encode_char @av0, @b0 OUTPUT

    set @av0 = ASCII( substring( @pbuf, @k+1, 1 ) ) & 3
    exec bitwise_lshift  @av0  , 4, @av0 OUTPUT
    set @av1 = ASCII( substring( @pbuf, @k+2, 1 ) )  & 240
    exec bitwise_rshift  @av1  , 4, @av1 OUTPUT
    set @av1=@av0|@av1
    exec mime_encode_char @av1, @b1 OUTPUT

    set @av1 = ASCII( substring( @pbuf, @k+2, 1 ) )  & 15
    exec bitwise_lshift  @av1  , 2, @av1 OUTPUT
    exec mime_encode_char @av1, @b2 OUTPUT
    set @pEncStr = @pEncStr +@b0+@b1+@b2
    if @padding ='Y' 
      set @pEncStr = @pEncStr + '='
  end
  else if @nrest = 1 
  begin
    set @av0 = ASCII( substring( @pbuf, @k+1, 1 ) ) & 252
    exec bitwise_rshift  @av0  , 2, @av0 OUTPUT
    exec mime_encode_char @av0, @b0 OUTPUT

    set @av0 = ASCII( substring( @pbuf, @k+1, 1 ) ) & 3
    exec bitwise_lshift  @av0  , 4, @av0 OUTPUT
    exec mime_encode_char @av0, @b1 OUTPUT
    set @pEncStr = @pEncStr +@b0+@b1
    if @padding ='Y' 
      set @pEncStr = @pEncStr + '=='
  end

go
--METADATA NAME:MIME_ENCODE TYPE:GRANT TABLE_NAME:MIME_ENCODE CHANGE:CREATE
GRANT EXECUTE ON MIME_ENCODE TO ${pm.ss.privileged_user}
go
print 'Creating procedure GET_GUID'

--METADATA  TYPE:SSCR NAME:GET_GUID OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_GUID' and type in ('P'))
  DROP PROCEDURE GET_GUID
go
--METADATA NAME:GET_GUID TYPE:PROCEDURE SET:GUID CHANGE:CREATE
CREATE PROCEDURE GET_GUID
	@EncGUID	varchar(22) OUTPUT
WITH ENCRYPTION AS
  declare @sGUID varchar(32), @i int, @buf varchar(16), @EncStr varchar(22)
  declare @hexstr varchar(4), @cmdstr nvarchar(255), @intval int
  set @sGUID = replace ( convert( varchar(36), newid()) , '-','')
  set @i = 1
  set @buf=''
  while @i < len(@sGUID)
  begin
    select @hexstr = '0x' + substring(@sGUID,@i,2)
    Select @cmdstr = N'Select @intval = convert( int , ' + @hexstr + ' )'
    Exec sp_ExecuteSql @cmdstr, N'@intval Int Out', @intval Out
    set @buf=@buf  + char(@intval)
    set @i=@i+2
  end
  exec mime_encode @pbuf=@buf, @pEncStr=@EncGUID OUTPUT
  --bug fix 7551.If sguid has space at the end the guid is 20 characters 
  if len(@EncGUID)=20
    set @EncGUID=@EncGUID+'IA'
  else if len(@EncGUID)<20
    set @EncGUID=null
go
--METADATA NAME:GET_GUID TYPE:GRANT TABLE_NAME:GET_GUID CHANGE:CREATE
GRANT EXECUTE ON GET_GUID TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_GET_NEXT_KEY'

--METADATA  TYPE:SSCR NAME:PC_GET_NEXT_KEY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_GET_NEXT_KEY' and type in ('P'))
  DROP PROCEDURE PC_GET_NEXT_KEY
go
--METADATA NAME:PC_GET_NEXT_KEY TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_GET_NEXT_KEY
	@pkey_name	varchar(60),
	@pseq_num	integer OUTPUT
WITH ENCRYPTION AS
  begin transaction
  update nextkey set key_seq_num = key_seq_num + 1 where key_name=@pkey_name
  if @@error > 0 or @@rowcount <> 1 
    return 

  select @pseq_num=key_seq_num-1 from nextkey where key_name=@pkey_name
  commit transaction
go
--METADATA NAME:PC_GET_NEXT_KEY TYPE:GRANT TABLE_NAME:PC_GET_NEXT_KEY CHANGE:CREATE
GRANT EXECUTE ON PC_GET_NEXT_KEY TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJ_LEVELED'

--METADATA  TYPE:SSCR NAME:PROJ_LEVELED OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJ_LEVELED' and type in ('P'))
  DROP PROCEDURE PROJ_LEVELED
go
--METADATA NAME:PROJ_LEVELED TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PROJ_LEVELED
	@v_proj_id integer,
	@v_levelled integer OUTPUT
WITH ENCRYPTION AS
	declare @v_blob_col_val varchar(max),@v_prop_name varchar(255), @v_count integer;
	SELECT @v_prop_name=prop_name,@v_blob_col_val=prop_value
	FROM projprop
	WHERE prop_name = 'scheduling' and proj_id=@v_proj_id;
	begin
		select @v_count=count(*)
		from projprop where proj_id=@v_proj_id
		and prop_name='scheduling' 
		and PATINDEX('%(0||LevelResourceList()()%',@v_blob_col_val) > 0;
 
		if @v_count=0
		set @v_levelled=1;
		else 
		set @v_levelled=0;
		return @v_levelled;
	end;
go
--METADATA NAME:PROJ_LEVELED TYPE:GRANT TABLE_NAME:PROJ_LEVELED CHANGE:CREATE
GRANT EXECUTE ON PROJ_LEVELED TO ${pm.ss.privileged_user}
go
print 'Creating procedure MODIFIED_BLOB_LEVELER'

--METADATA  TYPE:SSCR NAME:MODIFIED_BLOB_LEVELER OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'MODIFIED_BLOB_LEVELER' and type in ('P'))
  DROP PROCEDURE MODIFIED_BLOB_LEVELER
go
--METADATA NAME:MODIFIED_BLOB_LEVELER TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE MODIFIED_BLOB_LEVELER
	@v_proj_id integer,
	@v_prop_value varchar(max) OUTPUT
WITH ENCRYPTION AS 
	declare @v_blob_col_val varchar(max),@v_prop_name varchar(255), @v_len integer;
	declare @v_start_point integer,@v_final varchar(max),@v_rem varchar(max),@v_final_point integer;
	SELECT @v_prop_name=prop_name,@v_blob_col_val=prop_value
	FROM projprop
	WHERE prop_name = 'scheduling' and proj_id=@v_proj_id;
	set @v_len = DATALENGTH(@v_blob_col_val);
	if(@v_len IS NOT NULL AND @v_len > 0)
		begin
			set @v_start_point = charindex('LevelResourceList',@v_blob_col_val)-5;
			if ( @v_start_point is not null and @v_start_point > 0)
				begin
					set @v_final = left(@v_blob_col_val,@v_start_point)
				end
			set @v_final_point = charindex('LevelPriorityList',@v_blob_col_val);
			if ( @v_final_point is not null and @v_final_point > 0)
				begin
					set @v_rem = right(@v_blob_col_val,(@v_len-@v_final_point)+5)
				end;
			set @v_final = @v_final + '(0||LevelResourceList()())';
			set @v_final = @v_final + char(10) +'   '+ @v_rem;
			set @v_prop_value=@v_final;
			return;
		end;
go
--METADATA NAME:MODIFIED_BLOB_LEVELER TYPE:GRANT TABLE_NAME:MODIFIED_BLOB_LEVELER CHANGE:CREATE
GRANT EXECUTE ON MODIFIED_BLOB_LEVELER TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_INSERT_UDF'

--METADATA  TYPE:SSCR NAME:PC_INSERT_UDF OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_INSERT_UDF' and type in ('P'))
  DROP PROCEDURE PC_INSERT_UDF
go
--METADATA NAME:PC_INSERT_UDF TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_INSERT_UDF
	@ptable_name varchar(30), 
	@pfk integer,
        @pnew_fk integer,
	@pnew_proj_id integer
WITH ENCRYPTION AS
  insert into udfvalue (udf_type_id, fk_id, proj_id, udf_date,udf_text,udf_number,udf_code_id, table_name)   
  select ut.udf_type_id, @pnew_fk, @pnew_proj_id, udf_date, udf_text, udf_number,udf_code_id, ut.table_name 
  from udfvalue uv, udftype ut   
  where ut.table_name = upper(@ptable_name)   
  and uv.udf_type_id = ut.udf_type_id   
  and ut.super_flag = 'N'   
  and uv.fk_id = @pfk   
  and uv.delete_session_id is null 
  and ut.delete_session_id is null 
go
--METADATA NAME:PC_INSERT_UDF TYPE:GRANT TABLE_NAME:PC_INSERT_UDF CHANGE:CREATE
GRANT EXECUTE ON PC_INSERT_UDF TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_NEW_PROJ_SHORT_NAME'

--METADATA  TYPE:SSCR NAME:PC_NEW_PROJ_SHORT_NAME OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_NEW_PROJ_SHORT_NAME' and type in ('P'))
  DROP PROCEDURE PC_NEW_PROJ_SHORT_NAME
go
--METADATA NAME:PC_NEW_PROJ_SHORT_NAME TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_NEW_PROJ_SHORT_NAME
	@pproj_id		integer,
	@pnew_short_name	varchar(40) OUTPUT,
	@pbaseline		integer = 0,
    @pbaseline_suffix   varchar(10) = ' - B'
WITH ENCRYPTION AS
declare @pos integer, @pidx integer, @v_proj_suffix varchar(8)
declare @vold_short_name varchar(40), @vnoSuf varchar(40), @vcnt integer
declare @vSuffTerm varchar(10), @vSuffSearch varchar(12)
declare @vorig_proj_id integer 
set @vorig_proj_id=null
if @pbaseline = 1 
  set @vSuffTerm = @pbaseline_suffix
ELSE
  set @vSuffTerm = '-' 

set @vold_short_name=null
set @vSuffSearch = '%' + @vSuffTerm + '%'
select @vold_short_name=proj_short_name,@vorig_proj_id=orig_proj_id from project where proj_id = @pproj_id and delete_session_id is null 
if @vold_short_name is null
  return
 if @vorig_proj_id is not null and @pbaseline=1
  begin
    set @vold_short_name=substring(@vold_short_name,1,case when patindex(@vSuffSearch,@vold_short_name) >0 then patindex(@vSuffSearch,@vold_short_name)-1 else len(@vold_short_name) end)
  end
set @pos=len(@vold_short_name)
set @vnoSuf=@vold_short_name
while (@pos <> 0 ) 
begin
 set @pidx =  patindex(@vSuffSearch,substring(@vold_short_name,@pos,1) ) 
 if @pidx = 1 
 begin
   if IsNumeric ( substring(@vold_short_name,@pos+1,len(@vold_short_name) )  )  =1 
     set @vnoSuf = substring(@vold_short_name,1, @pos-1) 
   else
     set @vnoSuf = @vold_short_name 
   break
 end 
set @pos=@pos-1
end
set @pos=1
while (@pos <= 9999 )
begin
  set @v_proj_suffix =   @vSuffTerm + convert(varchar(10),@pos)
  if len( @vnoSuf + @v_proj_suffix ) > 40
   set @pnew_short_name = substring( @vnoSuf,1,40-len(@v_proj_suffix) )+ @v_proj_suffix
  else
    set @pnew_short_name =  @vnoSuf + @v_proj_suffix 
  select @vcnt=count(*) from project where proj_short_name= @pnew_short_name
  if @vcnt = 0
  BEGIN
    return
  END 
  set @pos=@pos+1
end
print @pos
set @pnew_short_name=null

go
--METADATA NAME:PC_NEW_PROJ_SHORT_NAME TYPE:GRANT TABLE_NAME:PC_NEW_PROJ_SHORT_NAME CHANGE:CREATE
GRANT EXECUTE ON PC_NEW_PROJ_SHORT_NAME TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_ACTVCODE_COPY'

--METADATA  TYPE:SSCR NAME:PC_ACTVCODE_COPY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_ACTVCODE_COPY' and type in ('P'))
  DROP PROCEDURE PC_ACTVCODE_COPY
go
--METADATA NAME:PC_ACTVCODE_COPY TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_ACTVCODE_COPY
	@pold_type_id	integer,
	@pold_code_id	integer,
	@pnew_type_id	integer,
	@pnew_code_id	integer,
	@pnew_proj_id	integer,
	@pret_val	integer OUTPUT
WITH ENCRYPTION AS
  DECLARE @new_actv_code_id integer, @vret integer, @old_actv_code_id integer
  DECLARE acodes CURSOR LOCAL FOR
  SELECT actv_code_id 
  FROM actvcode
  where actv_code_type_id = @pold_type_id
  and ISNULL(parent_actv_code_id, -1 ) = ISNULL( @pold_code_id , -1) 
  and delete_session_id is null
  OPEN acodes
  FETCH acodes INTO @old_actv_code_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    exec pc_get_next_key 'actvcode_actv_code_id', @new_actv_code_id OUTPUT
    insert into actvcode 
       (ACTV_CODE_ID,ACTV_CODE_TYPE_ID,SEQ_NUM,SHORT_NAME,PARENT_ACTV_CODE_ID
         ,ACTV_CODE_NAME,COLOR)
    select @new_actv_code_id,@pnew_type_id,SEQ_NUM,SHORT_NAME
		,@pnew_code_id
         ,ACTV_CODE_NAME,color
    FROM actvcode
    WHERE actv_code_id = @old_actv_code_id

    exec pc_actvcode_copy @pold_type_id, @old_actv_code_id,
			@pnew_type_id, @new_actv_code_id
				, @pnew_proj_id
				, @vret OUTPUT

    if @vret <> 0
    begin
      set @pret_val = -1 
      return
    end
    UPDATE taskactv
    set actv_code_type_id = @pnew_type_id, actv_code_id = @new_actv_code_id
    WHERE proj_id = @pnew_proj_id
    AND actv_code_type_id = @pold_type_id
    AND actv_code_id = @old_actv_code_id

    FETCH acodes INTO @old_actv_code_id

  END
  CLOSE acodes
  DEALLOCATE acodes



go
--METADATA NAME:PC_ACTVCODE_COPY TYPE:GRANT TABLE_NAME:PC_ACTVCODE_COPY CHANGE:CREATE
GRANT EXECUTE ON PC_ACTVCODE_COPY TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_ACTVTYPE_COPY'

--METADATA  TYPE:SSCR NAME:PC_ACTVTYPE_COPY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_ACTVTYPE_COPY' and type in ('P'))
  DROP PROCEDURE PC_ACTVTYPE_COPY
go
--METADATA NAME:PC_ACTVTYPE_COPY TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_ACTVTYPE_COPY
	@pold_proj_id	integer,
	@pnew_proj_id	integer,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT
WITH ENCRYPTION AS
  DECLARE @old_actv_code_type_id integer, @new_actv_code_type_id integer, @vret integer, @v_current_scope varchar(10)
  declare @vcreate_new_code bit, @v_new_wbs_id integer, @v_code_wbs_id integer, @v_scope varchar(10), @v_code_proj_id integer
  declare @has_access bit
  DECLARE pcodes CURSOR LOCAL FOR
    select at.actv_code_type_id, at.actv_code_type_scope, at.proj_id
    from actvtype at
    where proj_id = @pold_proj_id and actv_code_type_scope = 'AS_Project'
    and super_flag ='N'
    and delete_session_id is null
    union
    select at.actv_code_type_id, at.actv_code_type_scope, at.proj_id
    from actvtype at, taskactv ta
    where ta.proj_id = @pnew_proj_id
    and at.actv_code_type_id = ta.actv_code_type_id
    and at.actv_code_type_scope = 'AS_EPS'


  OPEN pcodes
  FETCH pcodes INTO @old_actv_code_type_id, @v_current_scope, @v_code_proj_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    set @vcreate_new_code = 0
    if @v_current_scope = 'AS_Project' 
    BEGIN
      set @vcreate_new_code = 1
      set @v_scope = @v_current_scope
    END
    ELSE
    BEGIN
      select @v_new_wbs_id = wbs_id
      from projwbs
      where proj_id = @pnew_proj_id 
      and proj_node_flag = 'Y';

      select  @v_code_wbs_id = wbs_id
      from projwbs
      where proj_id = @v_code_proj_id
      and proj_node_flag = 'Y';

      exec pc_has_eps_code_access @v_code_wbs_id, @v_new_wbs_id, @has_access OUTPUT
      if @has_access = 1 
        set @vcreate_new_code = 0
      else
        set @vcreate_new_code = 1

      set @v_scope = 'AS_Project';
    END

    if @vcreate_new_code = 1 
    BEGIN
      exec pc_get_next_key 'actvtype_actv_code_type_id', @new_actv_code_type_id OUTPUT
      insert into actvtype 
        (ACTV_CODE_TYPE_ID,ACTV_SHORT_LEN,SEQ_NUM,ACTV_CODE_TYPE,ACTV_CODE_TYPE_SCOPE   
	,PROJ_ID,SUPER_FLAG)
      select @new_actv_code_type_id, ACTV_SHORT_LEN,SEQ_NUM,ACTV_CODE_TYPE,@v_scope
	,@pnew_proj_id,SUPER_FLAG
      FROM actvtype
      WHERE actv_code_type_id = @old_actv_code_type_id

      exec pc_actvcode_copy @old_actv_code_type_id, null, 
			@new_actv_code_type_id, null, @pnew_proj_id, @vret OUTPUT

      if @vret <> 0
      begin
        set @pret_val = -1 
        set @pret_msg = 'Copy actvity codes failed'
        return
      end
    END

    FETCH pcodes INTO @old_actv_code_type_id, @v_current_scope, @v_code_proj_id
  END
  CLOSE pcodes
  DEALLOCATE pcodes
  set @pret_val = 0
go
--METADATA NAME:PC_ACTVTYPE_COPY TYPE:GRANT TABLE_NAME:PC_ACTVTYPE_COPY CHANGE:CREATE
GRANT EXECUTE ON PC_ACTVTYPE_COPY TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_TASKPRED_COPY'

--METADATA  TYPE:SSCR NAME:PC_TASKPRED_COPY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_TASKPRED_COPY' and type in ('P'))
  DROP PROCEDURE PC_TASKPRED_COPY
go
--METADATA NAME:PC_TASKPRED_COPY TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_TASKPRED_COPY
	@pwork_id	integer,
	@copy_bit	varchar(40),
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT
WITH ENCRYPTION AS
  DECLARE @tp_task_pred_id integer, @tp_proj_id integer, @tp_task_id integer
  DECLARE @tp_pred_proj_id integer, @tp_pred_task_id integer, @tp_pred_type varchar(12)
  DECLARE @tp_lag_hr_cnt numeric(10,2), @bin_copied bit, @vid integer ,@tp_comments varchar(250)
  DECLARE @vproj_id integer, @vtask_id integer, @vpred_proj_id integer, @vpred_task_id integer
  DECLARE @do_copy integer
  DECLARE tpc CURSOR FOR 
  select tp.task_pred_id,
        tp.proj_id,
	tp.task_id,
        tp.pred_proj_id,
	tp.pred_task_id,
	tp.pred_type,
	tp.lag_hr_cnt,
	tp.comments
    from taskpred tp, pkxref tpc
    where 
    (tp.pred_proj_id = tpc.old_pk1 and tp.pred_task_id = tpc.old_pk2 )
    and system_id = @pwork_id
    and context_name = 'T'
    and delete_session_id is null
    union
  select  tp.task_pred_id,
        tp.proj_id,
	tp.task_id,
        tp.pred_proj_id,
	tp.pred_task_id,
	tp.pred_type,
	tp.lag_hr_cnt,
	tp.comments
    from taskpred tp, pkxref tpc
    where 
    ( tp.proj_id = tpc.old_pk1 and tp.task_id = tpc.old_pk2 )
    and system_id = @pwork_id
    and context_name = 'T'
    and delete_session_id is null
  order by 1

  OPEN tpc   
  FETCH tpc INTO @tp_task_pred_id, @tp_proj_id, @tp_task_id, @tp_pred_proj_id, @tp_pred_task_id, @tp_pred_type, @tp_lag_hr_cnt, @tp_comments
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    set @bin_copied = 1
    set @do_copy = 1
    select @vproj_id = proj_id
    from project
    where proj_id = @tp_proj_id
    and orig_proj_id is null;
    if @@ROWCOUNT = 0 
    begin
      set @do_copy=0
    end    
    select @vproj_id = proj_id
    from project
    where proj_id = @tp_pred_proj_id
    and orig_proj_id is null;
    if @@ROWCOUNT = 0 
    begin
      set @do_copy=0
    end 
    if substring(@copy_bit,17,1)='1'
    begin
      set @do_copy=1
    end 
      
    select @vtask_id=pk2, @vproj_id=pk1
    from pkxref
    where old_pk1 = @tp_proj_id
         and old_pk2 = @tp_task_id
         and system_id = @pwork_id
         and context_name = 'T'
    if @@ROWCOUNT = 0 
    begin
      set @vtask_id=@tp_task_id
      set @vproj_id=@tp_proj_id
      set @bin_copied= 0
    end

    select @vpred_task_id=pk2, @vpred_proj_id=pk1
    from pkxref
    where old_pk1 = @tp_pred_proj_id
         and old_pk2 = @tp_pred_task_id
         and system_id = @pwork_id
         and context_name = 'T'
    if @@ROWCOUNT = 0 
    begin
      set @vpred_task_id=@tp_pred_task_id
      set @vpred_proj_id=@tp_pred_proj_id
      set @bin_copied= 0
    end
    if ( @do_copy = 1 ) 
    begin
      if ( not substring(@copy_bit,18,1)='1' ) or
	(substring(@copy_bit,18,1)='1' and @bin_copied = 1 ) 
      begin
         exec pc_get_next_key 'taskpred_task_pred_id', @vid OUTPUT
         insert into taskpred (task_pred_id, task_id, pred_task_id,
			proj_id, pred_proj_id, pred_type, lag_hr_cnt,comments)
         values ( @vid , @vtask_id, @vpred_task_id,
		@vproj_id, @vpred_proj_id, @tp_pred_type, 
		@tp_lag_hr_cnt, @tp_comments )

      end
    end
    FETCH tpc INTO @tp_task_pred_id, @tp_proj_id, @tp_task_id, @tp_pred_proj_id, @tp_pred_task_id, @tp_pred_type, @tp_lag_hr_cnt, @tp_comments

  END
  CLOSE tpc
  DEALLOCATE tpc
  set @pret_val = 0
go
--METADATA NAME:PC_TASKPRED_COPY TYPE:GRANT TABLE_NAME:PC_TASKPRED_COPY CHANGE:CREATE
GRANT EXECUTE ON PC_TASKPRED_COPY TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_TASKS_BY_WBS'

--METADATA  TYPE:SSCR NAME:PC_TASKS_BY_WBS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_TASKS_BY_WBS' and type in ('P'))
  DROP PROCEDURE PC_TASKS_BY_WBS
go
--METADATA NAME:PC_TASKS_BY_WBS TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_TASKS_BY_WBS
 	@pproj_id		integer,
 	@pwbs_id		integer,
 	@pold_wbs_id		integer,
 	@copy_bit		varchar(40),
 	@pret_val		integer OUTPUT,
 	@pret_msg		varchar(4000) OUTPUT,
  @psession_id		integer=null
WITH ENCRYPTION AS
   DECLARE @v_new_task_id integer, @vcnt integer, @vid integer, @vOldId integer, @vOldDocId integer,@vtemplate integer,@vtemplate_option integer, @pold_proj_id integer
   DECLARE @ptask_id integer,@vguid varchar(22), @pwork_id integer, @new_doc_id integer, @ptask_code varchar(40), @v_new_task_code varchar(40), @vdest_obs_id integer
   select @pwork_id=@@SPID
   declare @control_updates_flag varchar(1)
   select @pwork_id=@@SPID
   DECLARE tasks CURSOR FOR 
   select task_id, task_code 
   from task
   where wbs_id  = @pold_wbs_id 
   and delete_session_id is null
   order by task_id
   OPEN tasks
   FETCH NEXT FROM tasks INTO @ptask_id, @ptask_code
   WHILE (@@FETCH_STATUS = 0)
   BEGIN
     if substring(@copy_bit,19,1)='1'
       set @vguid = null
     else
       exec  get_guid @vguid OUTPUT
	if substring(@copy_bit,27,1)='1'
	  	set @vtemplate=1
	 else
		set @vtemplate=0 
	if substring(@copy_bit,28,1)='1'
	  	set @vtemplate_option=1
	 else
		set @vtemplate_option=0 

	if substring(@copy_bit,29,1)='1'
	  set @v_new_task_code = dbo.get_unique_task_code(@ptask_code, @pproj_id)
	else
    set @v_new_task_code = @ptask_code  
		
   if substring(@copy_bit,35,1)='1'
    select @vdest_obs_id=obs_id from projwbs where wbs_id = @pwbs_id
   else
    select @vdest_obs_id=obs_id from projwbs where wbs_id = @pold_wbs_id
   
     exec pc_get_next_key 'task_task_id', @v_new_task_id OUTPUT
     insert into task 
 	(TASK_ID,PROJ_ID,WBS_ID,CLNDR_ID,EST_WT,PHYS_COMPLETE_PCT,REV_FDBK_FLAG         
 	,LOCK_PLAN_FLAG,AUTO_COMPUTE_ACT_FLAG,COMPLETE_PCT_TYPE,TASK_TYPE              
 	,DURATION_TYPE,REVIEW_TYPE,STATUS_CODE,TASK_CODE,TASK_NAME,RSRC_ID             
 	,TOTAL_FLOAT_HR_CNT,FREE_FLOAT_HR_CNT,REMAIN_DRTN_HR_CNT,ACT_WORK_QTY          
 	,REMAIN_WORK_QTY,TARGET_WORK_QTY,TARGET_DRTN_HR_CNT,TARGET_EQUIP_QTY           
 	,ACT_EQUIP_QTY,REMAIN_EQUIP_QTY,CSTR_DATE,ACT_START_DATE,ACT_END_DATE          
 	,LATE_START_DATE,LATE_END_DATE,EXPECT_END_DATE,EARLY_START_DATE                
 	,EARLY_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE,TARGET_END_DATE      
 	,REVIEW_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE,CSTR_TYPE               
 	,PRIORITY_TYPE,GUID,TMPL_GUID,CSTR_DATE2,CSTR_TYPE2,FLOAT_PATH                 
 	,FLOAT_PATH_ORDER,ACT_THIS_PER_WORK_QTY,ACT_THIS_PER_EQUIP_QTY                 
 	,DRIVING_PATH_FLAG,SUSPEND_DATE,RESUME_DATE,EXTERNAL_EARLY_START_DATE          
 	,EXTERNAL_LATE_END_DATE,control_updates_flag,location_id)
 	select @v_new_task_id, 
 	 @pproj_id, @pwbs_id
 	,CLNDR_ID, EST_WT 
    	,CASE @vtemplate when 1 then 0 else PHYS_COMPLETE_PCT end
    	,CASE @vtemplate WHEN 1 then 'N' else REV_FDBK_FLAG end        
 	,LOCK_PLAN_FLAG,AUTO_COMPUTE_ACT_FLAG,COMPLETE_PCT_TYPE,TASK_TYPE              
 	,DURATION_TYPE,REVIEW_TYPE
    	,CASE @vtemplate when 1 then 'TK_NotStart' else STATUS_CODE end
    	,@v_new_task_code
      ,TASK_NAME,RSRC_ID             
 	,TOTAL_FLOAT_HR_CNT,FREE_FLOAT_HR_CNT
	, CASE @vtemplate when 1 then case @vtemplate_option when 1 then TARGET_DRTN_HR_CNT else ACT_WORK_QTY end else  REMAIN_DRTN_HR_CNT end
     	,CASE @vtemplate WHEN 1 then 0 else ACT_WORK_QTY end         
 	,CASE @vtemplate when 1 then case @vtemplate_option when 1 then TARGET_WORK_QTY else ACT_WORK_QTY end else REMAIN_WORK_QTY end 
    	,CASE @vtemplate when 1 then case @vtemplate_option when 1 then TARGET_WORK_QTY else ACT_WORK_QTY end else TARGET_WORK_QTY end 
    	,TARGET_DRTN_HR_CNT
    	,CASE @vtemplate when 1 then case @vtemplate_option when 1 then  TARGET_EQUIP_QTY else ACT_EQUIP_QTY end else TARGET_EQUIP_QTY end          
 	,CASE @vtemplate WHEN 1 then 0 else ACT_EQUIP_QTY end 
    	,CASE @vtemplate when 1 then case @vtemplate_option when 1 then TARGET_EQUIP_QTY else ACT_EQUIP_QTY end else REMAIN_EQUIP_QTY end
     	,CASE @vtemplate WHEN 1 then null else CSTR_DATE end 
     	,CASE @vtemplate WHEN 1 then null else ACT_START_DATE end
    	 ,CASE @vtemplate WHEN 1 then null else ACT_END_DATE end         
 	,LATE_START_DATE,LATE_END_DATE,EXPECT_END_DATE,EARLY_START_DATE                
 	,EARLY_END_DATE
    	,CASE @vtemplate when 1 then TARGET_START_DATE else RESTART_DATE end
    	,CASE @vtemplate when 1 then TARGET_END_DATE else REEND_DATE end
    	,TARGET_START_DATE,TARGET_END_DATE      
 	,REVIEW_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE
    	,CASE @vtemplate WHEN 1 then null else CSTR_TYPE end              
 	,PRIORITY_TYPE
 	,CASE WHEN @vguid is null THEN GUID ELSE @vguid END		
 	,TMPL_GUID
    	,CASE @vtemplate WHEN 1 then null else CSTR_DATE2 end 
    	,CASE @vtemplate WHEN 1 then null else CSTR_TYPE2 end
    	,FLOAT_PATH                 
 	,FLOAT_PATH_ORDER
    	,CASE @vtemplate WHEN 1 then null else ACT_THIS_PER_WORK_QTY end
    	,CASE @vtemplate WHEN 1 then null else ACT_THIS_PER_EQUIP_QTY end                 
 	,DRIVING_PATH_FLAG
    	,CASE @vtemplate WHEN 1 then null else SUSPEND_DATE end
    	,CASE @vtemplate WHEN 1 then null else RESUME_DATE end
    	,CASE @vtemplate WHEN 1 then null else EXTERNAL_EARLY_START_DATE end         
 	,CASE @vtemplate WHEN 1 then null else EXTERNAL_LATE_END_DATE end,
	CONTROL_UPDATES_FLAG,
	LOCATION_ID
      	  from task
          where task_id = @ptask_id;
 	 insert into taskuser
         (TASK_ID, USER_ID,PROJ_ID)
         select @v_new_task_id, user_id,@pproj_id
           from taskuser
          where task_id = @ptask_id;
	 --Multiple financial period feature
	 if @vtemplate <> 1 and substring(@copy_bit,21,1)='0'
	    begin
		update task
		    set act_this_per_work_qty =  act_work_qty ,
			    act_this_per_equip_qty = act_equip_qty
		  where task_id = @v_new_task_id;
		end

       if substring(@copy_bit,11,1)='0'
          update task 
          set rsrc_id = null
          where task_id = @v_new_task_id
          and rsrc_id is not null;
     if substring(@copy_bit,12,1)='1'
     BEGIN
       insert into pkxref (system_id, context_name, pk1,pk2,old_pk1,old_pk2 ,add_date)
       select @pwork_id, 'T', @pproj_id, @v_new_task_id, t.proj_id,t.task_id , getDate()
       from task t
       where task_id = @ptask_id
       and delete_session_id is null ;
     END
     if substring(@copy_bit,13,1)='1' and isnull(substring(@copy_bit,29,1),0)<>'1'
     BEGIN
       insert into taskactv
       (TASK_ID,ACTV_CODE_TYPE_ID,ACTV_CODE_ID,PROJ_ID)
        select @v_new_task_id , t.ACTV_CODE_TYPE_ID, t.ACTV_CODE_ID,
        @pproj_id 
        from actvtype a, taskactv t
        where t.task_id = @ptask_id
        and a.actv_code_type_id = t.actv_code_type_id
        and super_flag = 'N'
        and t.delete_session_id is null ;
     END
     else 
       if substring(@copy_bit,13,1)='1' and isnull(substring(@copy_bit,29,1),0)='1'
        BEGIN
          insert into taskactv
          (TASK_ID,ACTV_CODE_TYPE_ID,ACTV_CODE_ID,PROJ_ID)
           select @v_new_task_id , t.ACTV_CODE_TYPE_ID, t.ACTV_CODE_ID,
           @pproj_id
          from actvtype a, taskactv t
          where t.task_id = @ptask_id
          and a.actv_code_type_id = t.actv_code_type_id
          and super_flag = 'N'
          and a.Actv_code_type_scope = 'AS_Global'
          and t.delete_session_id is null ;
       END
     if substring(@copy_bit,21,1)='1'
     BEGIN
       insert into taskfin
       (FIN_DATES_ID,TASK_ID,PROJ_ID,ACT_WORK_QTY,ACT_WORK_COST,ACT_EQUIP_QTY
           ,ACT_EQUIP_COST,ACT_MAT_COST,ACT_EXPENSE_COST,BCWP,SCHED_WORK_QTY,BCWS,PERFM_WORK_QTY)
       select FIN_DATES_ID,@v_new_task_id,@pproj_id,ACT_WORK_QTY,ACT_WORK_COST,ACT_EQUIP_QTY
           ,ACT_EQUIP_COST,ACT_MAT_COST,ACT_EXPENSE_COST,BCWP,SCHED_WORK_QTY,BCWS,PERFM_WORK_QTY
       from taskfin
       where task_id = @ptask_id;
     END
     if substring(@copy_bit,11,1)='1'
     BEGIN
      DECLARE tr CURSOR FOR select taskrsrc_id from taskrsrc where task_id = @ptask_id and delete_session_id is null order by taskrsrc_id
      OPEN tr
      FETCH NEXT FROM tr INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec  get_guid @vguid OUTPUT
        exec pc_get_next_key 'taskrsrc_taskrsrc_id', @vid OUTPUT
        insert into taskrsrc 
 	(TASKRSRC_ID,TASK_ID,PROJ_ID,RSRC_TYPE,COST_QTY_LINK_FLAG,ROLE_ID               
 	,ACCT_ID,RSRC_ID,SKILL_LEVEL,PEND_COMPLETE_PCT,REMAIN_QTY,PEND_REMAIN_QTY      
 	,TARGET_QTY,REMAIN_QTY_PER_HR,PEND_ACT_REG_QTY,TARGET_LAG_DRTN_HR_CNT          
 	,TARGET_QTY_PER_HR,ACT_OT_QTY,PEND_ACT_OT_QTY,ACT_REG_QTY,RELAG_DRTN_HR_CNT    
 	,OT_FACTOR,COST_PER_QTY,TARGET_COST,ACT_REG_COST,ACT_OT_COST,REMAIN_COST       
 	,ACT_START_DATE,ACT_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE         
 	,TARGET_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE,GUID,RATE_TYPE          
 	,ACT_THIS_PER_COST,ACT_THIS_PER_QTY,CURV_ID,ROLLUP_DATES_FLAG                  
 	,COST_PER_QTY_SOURCE_TYPE,RSRC_REQUEST_DATA,TARGET_CRV,REMAIN_CRV,ACTUAL_CRV)
        select @vid, @v_new_task_id, @pproj_id
 	,RSRC_TYPE,COST_QTY_LINK_FLAG,ROLE_ID               
 	,ACCT_ID,RSRC_ID,SKILL_LEVEL
   	,CASE @vtemplate WHEN 1 then null else PEND_COMPLETE_PCT end 
   	,CASE @vtemplate WHEN 1 then  CASE @vtemplate_option when 1 then TARGET_QTY else isnull(ACT_REG_QTY,0)+isnull(ACT_OT_QTY,0) end else REMAIN_QTY end 
   	,CASE @vtemplate WHEN 1 then null  else PEND_REMAIN_QTY end     
 	,CASE @vtemplate WHEN 1 then CASE @vtemplate_option When 1 then TARGET_QTY else isnull(ACT_REG_QTY,0)+isnull(ACT_OT_QTY,0) end else TARGET_QTY end
    	,CASE @vtemplate WHEN 1 then CASE @vtemplate_option When 1 then TARGET_QTY_PER_HR else 1 end else REMAIN_QTY_PER_HR end
    	,CASE @vtemplate WHEN 1 then null else PEND_ACT_REG_QTY end
     	,TARGET_LAG_DRTN_HR_CNT
     	,CASE @vtemplate WHEN 1 then CASE @vtemplate_option When 1 then TARGET_QTY_PER_HR else 1 end else TARGET_QTY_PER_HR  end
 	,CASE @vtemplate WHEN 1 then 0 else ACT_OT_QTY end
    	,CASE @vtemplate WHEN 1 then null else PEND_ACT_OT_QTY end
    	,CASE @vtemplate WHEN 1 then 0 else ACT_REG_QTY end 
    	, CASE @vtemplate WHEN 1 then TARGET_LAG_DRTN_HR_CNT else RELAG_DRTN_HR_CNT end    
 	,OT_FACTOR,COST_PER_QTY
    	,CASE @vtemplate WHEN 1 then CASE @vtemplate_option WHEN 1 then TARGET_COST else isnull(ACT_REG_COST,0)+isnull(ACT_OT_COST,0) end else TARGET_COST end
    	,CASE @vtemplate WHEN 1 then 0 else ACT_REG_COST end
    	,CASE @vtemplate WHEN 1 then 0 else ACT_OT_COST end 
    	,CASE @vtemplate WHEN 1 then CASE @vtemplate_option WHEN 1 then TARGET_COST else isnull(ACT_REG_COST,0)+isnull(ACT_OT_COST,0) end else REMAIN_COST end      
 	,CASE @vtemplate WHEN 1 then null else ACT_START_DATE end 
    	,CASE @vtemplate WHEN 1 then null else ACT_END_DATE end 
    	,CASE @vtemplate WHEN 1 then TARGET_START_DATE else RESTART_DATE end
    	,CASE @vtemplate WHEN 1 then TARGET_END_DATE else REEND_DATE end
    	,TARGET_START_DATE         
 	,TARGET_END_DATE
    	,CASE @vtemplate WHEN 1 then null else REM_LATE_START_DATE end
    	,CASE @vtemplate WHEN 1 then null else REM_LATE_END_DATE end
 	,@vguid
 	,RATE_TYPE          
 	,CASE @vtemplate WHEN 1 then null else ACT_THIS_PER_COST end 
    	,CASE @vtemplate WHEN 1 then null else  ACT_THIS_PER_QTY end
        ,CASE @vtemplate WHEN 1 then CASE CURV_ID WHEN 9 then null else CURV_ID end else CURV_ID end 
	,ROLLUP_DATES_FLAG                  
 	,COST_PER_QTY_SOURCE_TYPE,RSRC_REQUEST_DATA
	,CASE @vtemplate WHEN 1 then null else TARGET_CRV end 
	,CASE @vtemplate WHEN 1 then null else REMAIN_CRV end 
	,CASE @vtemplate WHEN 1 then null else ACTUAL_CRV end
             from taskrsrc
             where taskrsrc_id = @vOldId;
        exec pc_insert_udf 'taskrsrc', @vOldId,  @vid, @pproj_id
		--Multiple financial period feature
	    if @vtemplate <> 1 and substring(@copy_bit,21,1)='0'
		begin
         update taskrsrc
		    set act_this_per_cost = act_reg_cost ,
			    act_this_per_qty = act_reg_qty
		  where taskrsrc_id = @vid;
	    end
		  
        if substring(@copy_bit,21,1)='1'
        begin
          insert into trsrcfin
          (fin_dates_id,taskrsrc_id,task_id,proj_id,act_qty,act_cost)
          select fin_dates_id,@vid,@v_new_task_id,@pproj_id,act_qty,act_cost
          from trsrcfin
          where taskrsrc_id = @vOldId;
        end
		
		if substring(@copy_bit,33,1)='1'
		begin
		insert into ASGNMNTACAT 
 	    (taskrsrc_id ,asgnmnt_catg_type_id ,asgnmnt_catg_id ,proj_id )
         select @vid, asgnmnt_catg_type_id, asgnmnt_catg_id, @pproj_id
  	     from ASGNMNTACAT
		 where taskrsrc_id = @vOldId;
		end
		
        FETCH NEXT FROM tr INTO @vOldId
      END 
      CLOSE tr
      DEALLOCATE tr
     END
	 
     if substring(@copy_bit,14,1)='1'
     BEGIN
      DECLARE tm CURSOR FOR select memo_id from taskmemo where task_id = @ptask_id and delete_session_id is null order by memo_id
      OPEN tm
      FETCH NEXT FROM tm INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'taskmemo_memo_id', @vid OUTPUT
        insert into taskmemo 
 	(memo_id, task_id, memo_type_id, proj_id, task_memo )
        select @vid , @v_new_task_id, memo_type_id, @pproj_id, task_memo
  	from taskmemo
 	where memo_id = @vOldId
        FETCH NEXT FROM tm INTO @vOldId
      END 
      CLOSE tm
      DEALLOCATE tm
     END
     if substring(@copy_bit,17,1)='1' and isnull(@vtemplate,0)<>1
     BEGIN
      DECLARE td CURSOR FOR select taskdoc_id,doc_id from taskdoc where task_id = @ptask_id and delete_session_id is null order by taskdoc_id
      OPEN td
      FETCH NEXT FROM td INTO @vOldId, @vOldDocId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'taskdoc_taskdoc_id', @vid OUTPUT
        set @new_doc_id = 0
        select @new_doc_id=new_doc_id from ##DocId where old_doc_id=@vOldDocId
        and system_id = @@SPID;
        if @new_doc_id >0
        BEGIN
           insert into taskdoc 
 		( TASKDOC_ID,DOC_ID,PROJ_ID,WBS_ID,WP_FLAG,TASK_ID )
           select @vid, @new_doc_id, @pproj_id, @pwbs_id, 		
 		wp_flag, @v_new_task_id
 	  from taskdoc
 	  where taskdoc_id = @vOldId
        END
        FETCH NEXT FROM td INTO @vOldId, @vOldDocId
      END 
      DEALLOCATE td
    END
     if substring(@copy_bit,16,1)='1'
     BEGIN
      DECLARE tp CURSOR FOR select proc_id from taskproc where task_id = @ptask_id and delete_session_id is null order by proc_id
      OPEN tp
      FETCH NEXT FROM tp INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'taskproc_proc_id', @vid OUTPUT
        insert into taskproc 
 		( proc_id, task_id, seq_num, proj_id, complete_flag
 		,proc_name, proc_wt , proc_descr         
 		,COMPLETE_PCT) 
        select   @vid, @v_new_task_id, seq_num, @pproj_id,
 		CASE @vtemplate WHEN 1 then 'N' else complete_flag end, proc_name, proc_wt, proc_descr
 		,CASE @vtemplate WHEN 1 then null else COMPLETE_PCT end 
 	from taskproc
  	where proc_id = @vOldId
        exec pc_insert_udf 'taskproc', @vOldId,  @vid, @pproj_id
        FETCH NEXT FROM tp INTO @vOldId
      END 
      CLOSE tp
      DEALLOCATE tp
     END
     if substring(@copy_bit,15,1)='1'
     BEGIN
      DECLARE pc CURSOR FOR select cost_item_id from projcost where task_id = @ptask_id and delete_session_id is null order by cost_item_id
      OPEN pc
      FETCH NEXT FROM pc INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'projcost_cost_item_id', @vid OUTPUT
        insert into projcost
 	( COST_ITEM_ID,PROJ_ID,TASK_ID,AUTO_COMPUTE_ACT_FLAG,COST_LOAD_TYPE              
 	,ACCT_ID,COST_TYPE_ID,TARGET_COST,ACT_COST,REMAIN_COST,QTY_NAME                
 	,TARGET_QTY,COST_PER_QTY,PO_NUMBER,VENDOR_NAME,COST_NAME,COST_DESCR) 
        select @vid, @pproj_id, @v_new_task_id
 	,AUTO_COMPUTE_ACT_FLAG,COST_LOAD_TYPE              
 	,ACCT_ID,COST_TYPE_ID,
	CASE @vtemplate when 1 then CASE @vtemplate_option when 1 then  TARGET_COST else ACT_COST end else TARGET_COST end,
        CASE @vtemplate WHEN 1 then null else ACT_COST end,CASE @vtemplate when 1 then CASE @vtemplate_option when 1 then  TARGET_COST else ACT_COST end else REMAIN_COST end ,QTY_NAME                
 	,TARGET_QTY,
        CASE @vtemplate when 1 then CASE @vtemplate_option when 1 then COST_PER_QTY else ACT_COST end else COST_PER_QTY end
        ,PO_NUMBER,VENDOR_NAME,COST_NAME,COST_DESCR
        from projcost
        where cost_item_id = @vOldId
        exec pc_insert_udf 'projcost', @vOldId,  @vid, @pproj_id
        FETCH NEXT FROM pc INTO @vOldId
      END 
      CLOSE pc
      DEALLOCATE pc
     END
   if substring(@copy_bit,2,1)='1' and isnull(@vtemplate,0)<>1
   BEGIN
      DECLARE cpi CURSOR FOR select issue_id from projissu where task_id = @ptask_id and delete_session_id is null order by issue_id
      OPEN cpi
      FETCH NEXT FROM cpi INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        set @vdest_obs_id = null
        if substring(@copy_bit,35,1)='1'
            select @vdest_obs_id=obs_id from projwbs where wbs_id = @pwbs_id
        exec pc_get_next_key 'projissu_issue_id', @vid OUTPUT
         insert into projissu
 		(ISSUE_ID,PROJ_ID,OBS_ID,PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
 		,TRACK_VIEW_ID,WBS_ID,TASK_ID,RSRC_ID,THRESH_PARM_ID,BASE_PROJ_ID              
 		,WORKSPACE_ID,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
 		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES) 
         select @vid, @pproj_id
 		,CASE WHEN @vdest_obs_id IS NULL THEN obs_id
         ELSE @vdest_obs_id END,
         PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
 		,TRACK_VIEW_ID
 		,@pwbs_id,@v_new_task_id
 		,RSRC_ID,THRESH_PARM_ID,BASE_PROJ_ID              
 		,WORKSPACE_ID,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
 		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES
 	from projissu
         where issue_id = @vOldId;
         insert into issuhist (issue_id,proj_id,issue_history)
         select @vid,@pproj_id, issue_history
         from issuhist
         where issue_id = @vOldId
         and delete_session_id is null ;
         exec pc_insert_udf 'projissu', @vOldId, @vid, @pproj_id 
        FETCH NEXT FROM cpi INTO @vOldId
      END 
      DEALLOCATE cpi
    END
     exec pc_insert_udf 'task', @ptask_id,  @v_new_task_id, @pproj_id

     if substring(@copy_bit,1,1)='1' and substring(@copy_bit,32,1)='1'
     begin
       select @pold_proj_id = proj_id from task where task_id = @ptask_id;
       exec pc_activity_copy_risk @v_new_task_id, @ptask_id, @pproj_id, @pold_proj_id, @psession_id
     end

     FETCH NEXT FROM tasks INTO @ptask_id,@ptask_code
   END
   close tasks
   DEALLOCATE tasks
go
--METADATA NAME:PC_TASKS_BY_WBS TYPE:GRANT TABLE_NAME:PC_TASKS_BY_WBS CHANGE:CREATE
GRANT EXECUTE ON PC_TASKS_BY_WBS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_NEW_WBS'

--METADATA  TYPE:SSCR NAME:PC_NEW_WBS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_NEW_WBS' and type in ('P'))
  DROP PROCEDURE PC_NEW_WBS
go
--METADATA NAME:PC_NEW_WBS TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_NEW_WBS
	@pold_wbs_id		integer,
 	@pproj_id		integer,
 	@pparent_wbs_id		integer,
 	@pproject_flag		char(1),
 	@copy_bit		varchar(40),
 	@pret_val		integer OUTPUT,
 	@pret_msg		varchar(4000) OUTPUT,
 	@prepl_proj_id integer=null,
 	@vorig_proj_id integer=null,
 	@pold_proj_id integer=null,
	@plevel	      integer=null,
	@psession_id		integer=null
WITH ENCRYPTION AS
   DECLARE @v_new_wbs_id integer, @vcnt integer, @vid integer, @vOldId integer,@vtemplate integer,@vcopytowbs integer,@vwbs_status_code varchar(20)
   DECLARE @vwbs_short_name varchar(40),@vnew_short_name varchar(40),@pos integer,@v_wbs_suffix varchar(8),@vdoc_name varchar(120),@vnew_doc_name varchar(120),@v_doc_suffix varchar(8)
   DECLARE @vret integer, @new_doc_id integer, @v_bl_flag char(1),@vguid varchar(22)
   DECLARE @vOldDocId integer, @vNewProjShortName varchar(40), @vNewWbsName varchar(100)
   DECLARE @vSuffix varchar(10), @vNodeFlag char(1)
   DECLARE @vstatus_reviewer integer
   declare @obs_id int,@seq_num int,@est_wt numeric(10,2),@proj_node_flag varchar(1),@sum_data_flag varchar(1),@status_code varchar(20)
   declare @phase_id int,@ev_user_pct int,@ev_etc_user_value numeric(10,2),@orig_cost numeric(23,6),@indep_remain_total_cost numeric(23,6)
   declare @ann_dscnt_rate_pct numeric(18,6),@dscnt_period_type varchar(20),@indep_remain_work_qty numeric(17,6),@anticip_start_date datetime
   declare @anticip_end_date datetime,@ev_compute_type varchar(20),@ev_etc_compute_type varchar(20),@resp_team_id int,@iteration_id int,@vstatus_code varchar(20)
   declare @tmpl_guid varchar(22),@original_qty numeric(17,6),@rqmt_rem_qty numeric(17,6), @pwork_id integer, @vdest_obs_id integer
   select @vNewProjShortName= proj_short_name from project where proj_id = @pproj_id
   select @vNewWbsName=wbs_name,@vstatus_code=status_code from projwbs where wbs_id = @pold_wbs_id
   
   if substring(@copy_bit,35,1)='1'
    select @vdest_obs_id=obs_id from projwbs where wbs_id = @pparent_wbs_id
   else
    select @vdest_obs_id=obs_id from projwbs where wbs_id = @pold_wbs_id
   
   if @prepl_proj_id is null
 	BEGIN
 		exec pc_get_next_key 'projwbs_wbs_id', @v_new_wbs_id OUTPUT
 		if substring(@copy_bit,23,1)='1'
 		begin
 			select @vNewProjShortName=wbs_short_name , @vNodeFlag=proj_node_flag
 			from projwbs where wbs_id = @pold_wbs_id
 		end
 		else if substring(@copy_bit,19,1)='1' or substring(@copy_bit,24,1)='1'
 		begin
 		  if @vorig_proj_id is not null
 		  begin
 		   if ( patindex('% - B%',@vNewWbsName )-1) >0 
 		  	set @vNewWbsName=substring(@vNewWbsName,1, patindex('% - B%',@vNewWbsName )-1)
 		  end
 			set @vSuffix=substring(@vNewProjShortName,patindex('% - B%',@vNewProjShortName ),len(@vNewProjShortName))
 			if len(@vNewWbsName+@vSuffix) > 100 
 				set @vNewWbsName=substring(@vNewWbsName,1, len(@vnewWbsName)-len(@vSuffix))+@vSuffix
 			else
 				set @vNewWbsName=@vNewWbsName+@vSuffix


 			set @v_bl_flag = 'Y'
 		end
 		else
 		begin
 			set @v_bl_flag = 'N'
 		end 
         
		 if substring(@copy_bit,27,1)=1 or (@vstatus_code='WS_Template' and  substring(@copy_bit,27,1)<>1 and substring(@copy_bit,30,1)<>1)
		  	set @vtemplate=1
		 else
			set @vtemplate=0 
		
		if substring(@copy_bit,29,1)=1

		begin
		
	  	  	set @vcopytowbs=1
		  	select @vwbs_status_code=status_code  from projwbs where wbs_id = @pparent_wbs_id;
		  	select @vwbs_short_name=wbs_short_name from projwbs  where wbs_id = @pold_wbs_id and delete_session_id is null;
			 set   @vnew_short_name = @vwbs_short_name;
			       if @plevel=0 
				 begin
				    set @pos=1
				   while (@pos <= 9999 )
				   begin
					select @vcnt=count(*) from projwbs where wbs_short_name= @vnew_short_name and parent_wbs_id=@pparent_wbs_id and delete_session_id is null
					  if @vcnt = 0
						break;
					set @v_wbs_suffix =    convert(varchar(10),@pos)
					if len( @vnew_short_name + @v_wbs_suffix ) > 40
						set @vnew_short_name = substring( @vnew_short_name,1,40-len(@v_wbs_suffix) )+ @v_wbs_suffix
				        else
						set @vnew_short_name =  @vnew_short_name + @v_wbs_suffix
				    set @pos=@pos+1
				   end
				 end
                end
		else
		 	set @vcopytowbs=0

 		exec  get_guid @vguid OUTPUT
 		insert into projwbs
 		(WBS_ID,PROJ_ID,OBS_ID,SEQ_NUM,EST_WT,PROJ_NODE_FLAG,SUM_DATA_FLAG              
 		,STATUS_CODE,WBS_SHORT_NAME,WBS_NAME,PHASE_ID,PARENT_WBS_ID,EV_USER_PCT        
 		,EV_ETC_USER_VALUE,ORIG_COST,INDEP_REMAIN_TOTAL_COST,ANN_DSCNT_RATE_PCT        
 		,DSCNT_PERIOD_TYPE,INDEP_REMAIN_WORK_QTY,ANTICIP_START_DATE,ANTICIP_END_DATE   
 		,EV_COMPUTE_TYPE,EV_ETC_COMPUTE_TYPE,RESP_TEAM_ID,ITERATION_ID                 
 		,GUID,TMPL_GUID,ORIGINAL_QTY,STATUS_REVIEWER)
 		select @v_new_wbs_id, @pproj_id
 		,@vdest_obs_id,SEQ_NUM,EST_WT,CASE WHEN @vcopytowbs=1 then 'N' else PROJ_NODE_FLAG end, CASE WHEN @vtemplate=1 then 'N' else SUM_DATA_FLAG end             
 		,CASE WHEN @vtemplate=1 then 'WS_Template' else CASE WHEN STATUS_CODE='WS_Template' then CASE WHEN @vcopytowbs=1 then @vwbs_status_code else 'WS_Open' end else STATUS_CODE end end
 		,CASE WHEN proj_node_flag = 'Y' THEN  CASE WHEN @vcopytowbs=1 then @vnew_short_name else  @vNewProjShortName end ELSE CASE WHEN @vcopytowbs=1 then @vnew_short_name else wbs_short_name END END
 		,CASE WHEN @v_bl_flag = 'Y' and proj_node_flag='Y' THEN @vNewWbsName
 				ELSE WBS_NAME END
 		,PHASE_ID
 		,@pparent_wbs_id
 		,EV_USER_PCT        
 		,EV_ETC_USER_VALUE,ORIG_COST,INDEP_REMAIN_TOTAL_COST,ANN_DSCNT_RATE_PCT        
 		,DSCNT_PERIOD_TYPE,INDEP_REMAIN_WORK_QTY,CASE WHEN @vtemplate=1 then null else ANTICIP_START_DATE end ,CASE WHEN @vtemplate=1 then null else ANTICIP_END_DATE end   
 		,EV_COMPUTE_TYPE,EV_ETC_COMPUTE_TYPE
 		,null,null
 		,@vguid
 		,TMPL_GUID,ORIGINAL_QTY,STATUS_REVIEWER
 		from projwbs
 		where wbs_id = @pold_wbs_id;
   END
   ELSE
   BEGIN
     select @v_new_wbs_id=wbs_id from projwbs where proj_id = @prepl_proj_id and proj_node_flag='Y'
     SELECT @obs_id=obs_id,@seq_num=seq_num,@est_wt=est_wt,@proj_node_flag=proj_node_flag,@sum_data_flag=sum_data_flag,@status_code=status_code,
       @phase_id=phase_id,@ev_user_pct=ev_user_pct,@ev_etc_user_value=ev_etc_user_value,@orig_cost=orig_cost,@indep_remain_total_cost=indep_remain_total_cost,
       @ann_dscnt_rate_pct=ann_dscnt_rate_pct,@dscnt_period_type=dscnt_period_type,@indep_remain_work_qty=indep_remain_work_qty,@anticip_start_date=anticip_start_date,
       @anticip_end_date=anticip_end_date,@ev_compute_type=ev_compute_type,@ev_etc_compute_type=ev_etc_compute_type,@resp_team_id=resp_team_id,
       @iteration_id=iteration_id,@tmpl_guid=tmpl_guid,@original_qty=original_qty,@rqmt_rem_qty=rqmt_rem_qty,@vstatus_reviewer=status_reviewer
     FROM PROJWBS WHERE wbs_id = @pold_wbs_id
     UPDATE PROJWBS SET seq_num=@seq_num,est_wt=@est_wt,proj_node_flag=@proj_node_flag,sum_data_flag=@sum_data_flag,status_code=@status_code,
       phase_id=@phase_id,ev_user_pct=@ev_user_pct,ev_etc_user_value=@ev_etc_user_value,orig_cost=@orig_cost,indep_remain_total_cost=@indep_remain_total_cost,
       ann_dscnt_rate_pct=@ann_dscnt_rate_pct,dscnt_period_type=@dscnt_period_type,indep_remain_work_qty=@indep_remain_work_qty,anticip_start_date=@anticip_start_date,
       anticip_end_date=@anticip_end_date,ev_compute_type=@ev_compute_type,ev_etc_compute_type=@ev_etc_compute_type,resp_team_id=@resp_team_id,
       iteration_id=@iteration_id,tmpl_guid=@tmpl_guid,original_qty=@original_qty,rqmt_rem_qty=@rqmt_rem_qty,status_reviewer=@vstatus_reviewer
     WHERE wbs_id = @v_new_wbs_id
     UPDATE projwbs SET parent_wbs_id=@pparent_wbs_id
     WHERE wbs_id = @v_new_wbs_id
   END 
   if substring(@copy_bit,23,1)='1'
     update projwbs set phase_id = null
     where wbs_id = @v_new_wbs_id;
    IF @vcopytowbs = 1 AND @plevel = 0
       BEGIN
         IF Substring(@copy_bit,5,1) = '1' and isnull(@vtemplate,0)<>1
           BEGIN
             DECLARE doc CURSOR  FOR
             SELECT   doc_id,
                      doc_name
             FROM     document
             WHERE    proj_id = @pold_proj_id
                      AND delete_session_id IS NULL
                      AND doc_mgmt_type = 'DM_Local'
             ORDER BY doc_id
             OPEN doc
             
             FETCH NEXT FROM doc
             INTO @vOldId, @vdoc_name
             
             WHILE (@@FETCH_STATUS = 0)
               BEGIN
                 SET @vnew_doc_name = @vdoc_name;
                 
                 IF @plevel = 0
                   BEGIN
                     SET @pos = 1
                     
                     WHILE (@pos <= 9999)
                       BEGIN
                         SELECT @vcnt = Count(* )
                         FROM   document
                         WHERE  doc_name = @vnew_doc_name
                                AND proj_id = @pproj_id
                                AND delete_session_id IS NULL
                         
                         IF @vcnt = 0
                           BREAK;
                         
                         SET @v_doc_suffix = Convert(VARCHAR(10),@pos)
                         
                         IF Len(@vnew_doc_name + @v_doc_suffix) > 40
                           SET @vnew_doc_name = Substring(@vnew_doc_name,1,40 - Len(@v_doc_suffix)) + @v_doc_suffix
                         ELSE
                           SET @vnew_doc_name = @vnew_doc_name + @v_doc_suffix
                          
                         SET @pos = @pos + 1
                       END
                   END
                 
                 EXEC Get_guid    @vguid OUTPUT
                 
                 EXEC Pc_get_next_key 'document_doc_id' ,  @vid OUTPUT
                 
                 INSERT INTO document
                            (doc_id,
                             doc_seq_num,
                             deliv_flag,
                             doc_name,
                             parent_doc_id,
                             proj_id,
                             doc_status_id,
                             doc_catg_id,
                             doc_date,
                             version_name,
                             guid,
                             tmpl_guid,
                             doc_short_name,
                             author_name,
                             private_loc,
                             public_loc,
                             doc_content,
                             rsrc_id,
                             doc_mgmt_type,
                             external_doc_key)
                 SELECT @vid,
                        doc_seq_num,
                        deliv_flag,
                        @vnew_doc_name,
                        parent_doc_id,
                        @pproj_id,
                        doc_status_id,
                        doc_catg_id,
                        doc_date,
                        version_name,
                        @vguid,
                        tmpl_guid,
                        doc_short_name,
                        author_name,
                        private_loc,
                        public_loc,
                        doc_content,
                        rsrc_id,
                        doc_mgmt_type,
                        external_doc_key
                 FROM   document
                 WHERE  doc_id = @vOldId;
                 
                 INSERT INTO ##docid
                 VALUES     (@@SPID,
                             @vOldId,
                             @vid)
                 
                 EXEC Pc_insert_udf
                   'document' ,
                   @vOldId ,
                   @vid ,
                   @pproj_id
                 
                 FETCH NEXT FROM doc
                 INTO @vOldId,
                      @vdoc_name
               END
             
             DEALLOCATE doc
             
             DECLARE doc2 CURSOR  FOR
             SELECT   doc_id,
                      parent_doc_id
             FROM     document
             WHERE    proj_id = @pproj_id
                      AND delete_session_id IS NULL
             ORDER BY doc_id
             
             DECLARE  @new_pdoc_id INT,
                      @vdocid      INT,
                      @old_pdoc_id INT
             
             OPEN doc2
             
             FETCH NEXT FROM doc2
             INTO @vdocid,
                  @old_pdoc_id
             
             WHILE (@@FETCH_STATUS = 0)
               BEGIN
                 SET @new_pdoc_id = NULL
                 
                 SELECT @new_pdoc_id = new_doc_id
                 FROM   ##docid
                 WHERE  old_doc_id = @old_pdoc_id
                 
                 IF @new_pdoc_id IS NOT NULL
                   BEGIN
                     UPDATE document
                     SET    parent_doc_id = @new_pdoc_id
                     WHERE  doc_id = @vdocid
                   END
                 
                 FETCH NEXT FROM doc2
                 INTO @vdocid,
                      @old_pdoc_id
               END
             
             DEALLOCATE doc2
           END
       END
   if substring(@copy_bit,2,1)='1' and isnull(@vtemplate,0)<>1
   BEGIN
      DECLARE cpi CURSOR FOR select issue_id from projissu where wbs_id = @pold_wbs_id and task_id is null and delete_session_id is null order by issue_id
      OPEN cpi
      FETCH NEXT FROM cpi INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        set @vdest_obs_id = null
        if substring(@copy_bit,35,1)='1'
           select @vdest_obs_id=obs_id from projwbs where wbs_id = @pparent_wbs_id
        exec pc_get_next_key 'projissu_issue_id', @vid OUTPUT
         insert into projissu
 		(ISSUE_ID,PROJ_ID,OBS_ID,PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
 		,TRACK_VIEW_ID,WBS_ID,TASK_ID,RSRC_ID,THRESH_PARM_ID,BASE_PROJ_ID              
 		,WORKSPACE_ID,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
 		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES) 
         select @vid, @pproj_id,
         CASE WHEN @vdest_obs_id IS NULL THEN obs_id
         ELSE @vdest_obs_id END,
 		 PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
 		,TRACK_VIEW_ID
 		,@v_new_wbs_id
 		,TASK_ID,RSRC_ID,THRESH_PARM_ID,BASE_PROJ_ID              
 		,WORKSPACE_ID,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
 		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES
 	from projissu
         where issue_id = @vOldId;
         insert into issuhist (issue_id,proj_id,issue_history)
         select @vid,@pproj_id, issue_history
         from issuhist
         where issue_id = @vOldId
         and delete_session_id is null;
        exec pc_insert_udf 'projissu', @vOldId,  @vid, @pproj_id
        FETCH NEXT FROM cpi INTO @vOldId
      END 
      DEALLOCATE cpi
    END
   if substring(@copy_bit,3,1)='1' and isnull(@vtemplate,0)=0
   BEGIN
      DECLARE pt CURSOR FOR select thresh_id from projthrs where wbs_id = @pold_wbs_id and delete_session_id is null order by thresh_id
      OPEN pt
      FETCH NEXT FROM pt INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        set @vdest_obs_id = null
	    if substring(@copy_bit,35,1)='1'
            select @vdest_obs_id=obs_id from projwbs where wbs_id = @pparent_wbs_id
        exec pc_get_next_key 'projthrs_thresh_id', @vid OUTPUT
         insert into projthrs 
 		( THRESH_ID,PROJ_ID,OBS_ID,THRESH_PARM_ID,
 				STATUS_CODE,PRIORITY_TYPE,THRESH_TYPE,
 				WBS_ID,TRACK_VIEW_ID,LO_PARM_VALUE,
 				HI_PARM_VALUE,WINDOW_START,WINDOW_END ) 
         select @vid,@pproj_id ,
                CASE WHEN @vdest_obs_id IS NULL THEN obs_id
                ELSE @vdest_obs_id END,THRESH_PARM_ID,
 				STATUS_CODE,PRIORITY_TYPE,THRESH_TYPE,
 				@v_new_wbs_id ,TRACK_VIEW_ID,LO_PARM_VALUE,
 				HI_PARM_VALUE,WINDOW_START,WINDOW_END
         from projthrs
         where thresh_id = @vOldId;
 	INSERT INTO ##ProjThrsID values ( @@SPID,@vOldId, @vid)	
        FETCH NEXT FROM pt INTO @vOldId
      END 
      DEALLOCATE pt
    END
   if substring(@copy_bit,7,1)='1'
   BEGIN
      DECLARE wm CURSOR FOR select wbs_memo_id from wbsmemo where wbs_id = @pold_wbs_id and delete_session_id is null order by wbs_memo_id
      OPEN wm
      FETCH NEXT FROM wm INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'wbsmemo_wbs_memo_id', @vid OUTPUT
         insert into wbsmemo 
 		(WBS_MEMO_ID,PROJ_ID,WBS_ID,MEMO_TYPE_ID,WBS_MEMO)
         select @vid, @pproj_id, @v_new_wbs_id, memo_type_id, wbs_memo 
 	from wbsmemo
    	where wbs_memo_id = @vOldId
        FETCH NEXT FROM wm INTO @vOldId
      END 
      DEALLOCATE wm
    END
   if substring(@copy_bit,8,1)='1'
   BEGIN
      DECLARE ws CURSOR FOR select wbs_step_id from wbsstep where wbs_id = @pold_wbs_id and delete_session_id is null order by wbs_step_id
      OPEN ws
      FETCH NEXT FROM ws INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'wbsstep_wbs_step_id', @vid OUTPUT
         insert into wbsstep 
 			( 	WBS_STEP_ID,PROJ_ID,WBS_ID,SEQ_NUM,
 				COMPLETE_FLAG,STEP_NAME,STEP_WT )
         SELECT @vid, @pproj_id, @v_new_wbs_id, seq_num, CASE @vtemplate when 1 then 'N' else complete_flag end,
 		step_name, step_wt 
 	from wbsstep
    	where wbs_step_id = @vOldId
        FETCH NEXT FROM ws INTO @vOldId
      END 
      DEALLOCATE ws
    END
   if(substring(@copy_bit,17,1)='1' or substring(@copy_bit,9,1)='1' ) and isnull(@vtemplate,0)<>1
   BEGIN
      DECLARE td CURSOR FOR select taskdoc_id , doc_id from taskdoc where wbs_id = @pold_wbs_id and task_id is null and delete_session_id is null order by taskdoc_id
      OPEN td
      FETCH NEXT FROM td INTO @vOldId, @vOldDocId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'taskdoc_taskdoc_id', @vid OUTPUT
        set @new_doc_id = 0
        select @new_doc_id=new_doc_id from ##DocId where old_doc_id=@vOldDocId
        and system_id = @@SPID;
        if @new_doc_id >0
        BEGIN
           insert into taskdoc 
 		( TASKDOC_ID,DOC_ID,PROJ_ID,WBS_ID,WP_FLAG,TASK_ID )
           select @vid, @new_doc_id, @pproj_id, @v_new_wbs_id, 
 		wp_flag, null
 	  from taskdoc
 	  where taskdoc_id = @vOldId
        END
        FETCH NEXT FROM td INTO @vOldId,@vOldDocId
      END 
      DEALLOCATE td
    END
      DECLARE bc CURSOR FOR select budg_chng_id from budgchng where wbs_id = @pold_wbs_id and delete_session_id is null order by budg_chng_id
      OPEN bc
      FETCH NEXT FROM bc INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'budgchng_budg_chng_id', @vid OUTPUT
        insert into budgchng 
 				( BUDG_CHNG_ID,PROJ_ID,WBS_ID,CHNG_DATE,
 				CHNG_SHORT_NAME,CHNG_COST,CHNG_BY_NAME,
 				STATUS_CODE, chng_descr )
        select @vid, @pproj_id, @v_new_wbs_id,
 		CHNG_DATE,CHNG_SHORT_NAME,CHNG_COST,CHNG_BY_NAME,
 		STATUS_CODE, chng_descr 		
 	from budgchng
  	where budg_chng_id = @vOldId
        FETCH NEXT FROM bc INTO @vOldId
      END 
      DEALLOCATE bc
      DECLARE wb CURSOR FOR select wbs_budg_id from wbsbudg where wbs_id = @pold_wbs_id and delete_session_id is null order by wbs_budg_id
      OPEN wb
      FETCH NEXT FROM wb INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'wbsbudg_wbs_budg_id', @vid OUTPUT
       insert into wbsbudg 
 	(WBS_BUDG_ID,PROJ_ID,WBS_ID,START_DATE, SPEND_COST,BENEFIT_COST )
        select @vid, @pproj_id, @v_new_wbs_id,
 		START_DATE, SPEND_COST,BENEFIT_COST
 	from wbsbudg
 	where wbs_budg_id = @vOldId
        FETCH NEXT FROM wb INTO @vOldId
      END 
      DEALLOCATE wb
   if substring(@copy_bit,22,1)='1'
   BEGIN
      DECLARE wr CURSOR FOR select wbsrsrc_id from wbsrsrc where wbs_id = @pold_wbs_id and delete_session_id is null order by wbsrsrc_id
      OPEN wr
      FETCH NEXT FROM wr INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'wbsrsrc_wbsrsrc_id', @vid OUTPUT
       insert into wbsrsrc 
 	(WBSRSRC_ID,WBS_ID,RSRC_ID,ROLE_ID,PROJ_ID,COMMITTED_FLAG,START_DATE,END_DATE,AUTO_COMPUTE_DATES_FLAG,RSRC_REQUEST_DATA)
        select @vid, @v_new_wbs_id, RSRC_ID, ROLE_ID, @pproj_id,
 		COMMITTED_FLAG,START_DATE,END_DATE,AUTO_COMPUTE_DATES_FLAG,RSRC_REQUEST_DATA
 	from wbsrsrc
 	where wbsrsrc_id = @vOldId
        insert into WBSRSRC_QTY (WBSRSRC_ID,WEEK_START,MONTH_START,QTY,FIN_DATES_ID1,FIN_QTY1,FIN_DATES_ID2,FIN_QTY2)
        select @vid, week_start, month_start, qty,fin_dates_id1,fin_qty1,fin_dates_id2,fin_qty2
        from wbsrsrc_qty
        where wbsrsrc_id = @vOldId;
        FETCH NEXT FROM wr INTO @vOldId
      END 
      DEALLOCATE wr
   END
   if @pproject_flag = 'Y' and substring(@copy_bit,10,1)='1'
   BEGIN
     exec pc_tasks_by_wbs @pproj_id, @v_new_wbs_id, @pold_wbs_id, @copy_bit, @pret_val OUTPUT, @pret_msg OUTPUT, @psession_id

     if @pret_val < 0 
     begin
       return
     end
   END
   if (substring(@copy_bit,26,1)='1' or substring(@copy_bit,23,1)='1') and (substring(@copy_bit,24,1)='0' or substring(@copy_bit,24,1)='')
   BEGIN
        INSERT INTO SUMTASK
             ( PROJ_ID, WBS_ID, BCWP, BCWS, EAC, EAC_WORK_QTY, ETC, ETC_WORK_QTY, PERFM_WORK_QTY, SCHED_WORK_QTY,
              COMPLETE_CNT, ACTIVE_CNT, NOTSTARTED_CNT, BASE_COMPLETE_CNT, BASE_ACTIVE_CNT, BASE_NOTSTARTED_CNT, ACT_DRTN_HR_CNT,
              TOTAL_DRTN_HR_CNT, BASE_DRTN_HR_CNT, REMAIN_DRTN_HR_CNT, TOTAL_FLOAT_HR_CNT, ACT_END_DATE, ACT_START_DATE, BASE_END_DATE,
              BASE_START_DATE, REEND_DATE, RESTART_DATE, ACT_THIS_PER_WORK_COST, ACT_THIS_PER_WORK_QTY, ACT_THIS_PER_EQUIP_COST, ACT_THIS_PER_EQUIP_QTY,
              ACT_THIS_PER_MAT_COST, ACT_COST, ACT_EQUIP_COST, ACT_EXPENSE_COST, ACT_MAT_COST, ACT_WORK_COST, ACT_EQUIP_QTY, ACT_WORK_QTY, BASE_COST,
              BASE_EQUIP_COST, BASE_EXPENSE_COST, BASE_MAT_COST, BASE_WORK_COST, BASE_EQUIP_QTY, BASE_WORK_QTY, REMAIN_COST, REMAIN_EQUIP_COST,
              REMAIN_EXPENSE_COST, REMAIN_MAT_COST, REMAIN_WORK_COST, REMAIN_EQUIP_QTY, REMAIN_WORK_QTY, TARGET_COST, TARGET_EQUIP_COST,
              TARGET_EXPENSE_COST, TARGET_MAT_COST, TARGET_WORK_COST, TARGET_EQUIP_QTY, TARGET_WORK_QTY, TOTAL_COST, TOTAL_EQUIP_COST, TOTAL_EXPENSE_COST,
              TOTAL_MAT_COST, TOTAL_WORK_COST, TOTAL_EQUIP_QTY, TOTAL_WORK_QTY,TARGET_START_DATE,TARGET_END_DATE,TARGET_DRTN_HR_CNT)
 	      select 	@pproj_id, @v_new_wbs_id, BCWP, BCWS, EAC, EAC_WORK_QTY, ETC, ETC_WORK_QTY, PERFM_WORK_QTY, SCHED_WORK_QTY,
              COMPLETE_CNT, ACTIVE_CNT, NOTSTARTED_CNT, BASE_COMPLETE_CNT, BASE_ACTIVE_CNT, BASE_NOTSTARTED_CNT, ACT_DRTN_HR_CNT,
              TOTAL_DRTN_HR_CNT, BASE_DRTN_HR_CNT, REMAIN_DRTN_HR_CNT, TOTAL_FLOAT_HR_CNT, ACT_END_DATE, ACT_START_DATE, BASE_END_DATE,
              BASE_START_DATE, REEND_DATE, RESTART_DATE, ACT_THIS_PER_WORK_COST, ACT_THIS_PER_WORK_QTY, ACT_THIS_PER_EQUIP_COST, ACT_THIS_PER_EQUIP_QTY,
              ACT_THIS_PER_MAT_COST, ACT_COST, ACT_EQUIP_COST, ACT_EXPENSE_COST, ACT_MAT_COST, ACT_WORK_COST, ACT_EQUIP_QTY, ACT_WORK_QTY, BASE_COST,
              BASE_EQUIP_COST, BASE_EXPENSE_COST, BASE_MAT_COST, BASE_WORK_COST, BASE_EQUIP_QTY, BASE_WORK_QTY, REMAIN_COST, REMAIN_EQUIP_COST,
              REMAIN_EXPENSE_COST, REMAIN_MAT_COST, REMAIN_WORK_COST, REMAIN_EQUIP_QTY, REMAIN_WORK_QTY, TARGET_COST, TARGET_EQUIP_COST,
              TARGET_EXPENSE_COST, TARGET_MAT_COST, TARGET_WORK_COST, TARGET_EQUIP_QTY, TARGET_WORK_QTY, TOTAL_COST, TOTAL_EQUIP_COST, TOTAL_EXPENSE_COST,
              TOTAL_MAT_COST, TOTAL_WORK_COST, TOTAL_EQUIP_QTY, TOTAL_WORK_QTY, TARGET_START_DATE, TARGET_END_DATE, TARGET_DRTN_HR_CNT
        from sumtask
    	  where wbs_id = @pold_wbs_id;

        INSERT INTO SUMTASKSPREAD
             (PROJ_ID, WBS_ID, START_DATE, END_DATE, SPREAD_TYPE, ACT_COST, ACT_EQUIP_COST, ACT_EXPENSE_COST, ACT_MAT_COST, ACT_WORK_COST,
            ACT_EQUIP_QTY, ACT_WORK_QTY, BASE_COST, BASE_EQUIP_COST, BASE_EXPENSE_COST, BASE_MAT_COST, BASE_WORK_COST, BASE_EQUIP_QTY,
            BASE_WORK_QTY, LATE_REMAIN_COST, LATE_REMAIN_EQUIP_COST, LATE_REMAIN_EXPENSE_COST, LATE_REMAIN_MAT_COST, LATE_REMAIN_WORK_COST,
            LATE_REMAIN_EQUIP_QTY, LATE_REMAIN_WORK_QTY, REMAIN_COST, REMAIN_EQUIP_COST, REMAIN_EXPENSE_COST, REMAIN_MAT_COST, REMAIN_WORK_COST,
            REMAIN_EQUIP_QTY, REMAIN_WORK_QTY, TARGET_COST, TARGET_EQUIP_COST, TARGET_EXPENSE_COST, TARGET_MAT_COST, TARGET_WORK_COST,
            TARGET_EQUIP_QTY, TARGET_WORK_QTY, TOTAL_COST, TOTAL_EQUIP_COST, TOTAL_EXPENSE_COST, TOTAL_MAT_COST, TOTAL_WORK_COST, TOTAL_EQUIP_QTY,
            TOTAL_WORK_QTY, BCWP, BCWS, EAC, EAC_WORK_QTY, ETC, ETC_WORK_QTY, PERFM_WORK_QTY, SCHED_WORK_QTY, FIN_PERIOD_ACT_WORK_QTY,
            FIN_PERIOD_ACT_WORK_COST, FIN_PERIOD_ACT_EQUIP_QTY, FIN_PERIOD_ACT_EQUIP_COST, FIN_PERIOD_ACT_MAT_COST, FIN_PERIOD_ACT_EXPENSE_COST,
            FIN_PERIOD_TOTAL_WORK_QTY, FIN_PERIOD_TOTAL_WORK_COST, FIN_PERIOD_TOTAL_EQUIP_QTY, FIN_PERIOD_TOTAL_EQUIP_COST,
            FIN_PERIOD_TOTAL_MAT_COST, FIN_PERIOD_TOTAL_EXPENSE_COST, FIN_PERIOD_TOTAL_COST, FIN_PERIOD_ACT_COST, FIN_PERIOD_BCWP,
            FIN_PERIOD_PERFM_WORK_QTY, FIN_PERIOD_EAC, FIN_PERIOD_EAC_WORK_QTY, FIN_PERIOD_BCWS, FIN_PERIOD_SCHED_WORK_QTY)
 	      select 	@pproj_id, @v_new_wbs_id, START_DATE, END_DATE, SPREAD_TYPE, ACT_COST, ACT_EQUIP_COST, ACT_EXPENSE_COST, ACT_MAT_COST, ACT_WORK_COST,
            ACT_EQUIP_QTY, ACT_WORK_QTY, BASE_COST, BASE_EQUIP_COST, BASE_EXPENSE_COST, BASE_MAT_COST, BASE_WORK_COST, BASE_EQUIP_QTY,
            BASE_WORK_QTY, LATE_REMAIN_COST, LATE_REMAIN_EQUIP_COST, LATE_REMAIN_EXPENSE_COST, LATE_REMAIN_MAT_COST, LATE_REMAIN_WORK_COST,
            LATE_REMAIN_EQUIP_QTY, LATE_REMAIN_WORK_QTY, REMAIN_COST, REMAIN_EQUIP_COST, REMAIN_EXPENSE_COST, REMAIN_MAT_COST, REMAIN_WORK_COST,
            REMAIN_EQUIP_QTY, REMAIN_WORK_QTY, TARGET_COST, TARGET_EQUIP_COST, TARGET_EXPENSE_COST, TARGET_MAT_COST, TARGET_WORK_COST,
            TARGET_EQUIP_QTY, TARGET_WORK_QTY, TOTAL_COST, TOTAL_EQUIP_COST, TOTAL_EXPENSE_COST, TOTAL_MAT_COST, TOTAL_WORK_COST, TOTAL_EQUIP_QTY,
            TOTAL_WORK_QTY, BCWP, BCWS, EAC, EAC_WORK_QTY, ETC, ETC_WORK_QTY, PERFM_WORK_QTY, SCHED_WORK_QTY, FIN_PERIOD_ACT_WORK_QTY,
            FIN_PERIOD_ACT_WORK_COST, FIN_PERIOD_ACT_EQUIP_QTY, FIN_PERIOD_ACT_EQUIP_COST, FIN_PERIOD_ACT_MAT_COST, FIN_PERIOD_ACT_EXPENSE_COST,
            FIN_PERIOD_TOTAL_WORK_QTY, FIN_PERIOD_TOTAL_WORK_COST, FIN_PERIOD_TOTAL_EQUIP_QTY, FIN_PERIOD_TOTAL_EQUIP_COST, FIN_PERIOD_TOTAL_MAT_COST,
            FIN_PERIOD_TOTAL_EXPENSE_COST, FIN_PERIOD_TOTAL_COST, FIN_PERIOD_ACT_COST, FIN_PERIOD_BCWP, FIN_PERIOD_PERFM_WORK_QTY, FIN_PERIOD_EAC,
            FIN_PERIOD_EAC_WORK_QTY, FIN_PERIOD_BCWS, FIN_PERIOD_SCHED_WORK_QTY
        from sumtaskspread
    	  where wbs_id = @pold_wbs_id   
   END

   if (substring(@copy_bit,23,1)='1' or substring(@copy_bit,25,1)='1') and (substring(@copy_bit,24,1)='0' or substring(@copy_bit,24,1)='')
   BEGIN
    DECLARE sumtr CURSOR FOR select sumtrsrc_id from sumtrsrc where wbs_id = @pold_wbs_id
      OPEN sumtr
      FETCH NEXT FROM sumtr INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'sumtrsrc_sumtrsrc_id', @vid OUTPUT
        INSERT INTO SUMTRSRC
            (SUMTRSRC_ID, PROJ_ID, WBS_ID, START_DATE, END_DATE, SPREAD_TYPE, RSRC_ID, ROLE_ID, ACT_START_DATE, ACT_END_DATE, REMAIN_START_DATE,
            REMAIN_END_DATE, STAFFED_ACT_QTY, UNSTAFFED_ACT_QTY, STAFFED_ACT_COST, UNSTAFFED_ACT_COST, STAFFED_ACT_OT_QTY, UNSTAFFED_ACT_OT_QTY,
            STAFFED_ACT_OT_COST, UNSTAFFED_ACT_OT_COST, STAFFED_ACT_REG_COST, UNSTAFFED_ACT_REG_COST, STAFFED_ACT_REG_QTY, UNSTAFFED_ACT_REG_QTY,
            STAFFED_LATE_REMAIN_QTY, UNSTAFFED_LATE_REMAIN_QTY, STAFFED_LATE_REMAIN_COST, UNSTAFFED_LATE_REMAIN_COST, STAFFED_REMAIN_QTY,
            UNSTAFFED_REMAIN_QTY, STAFFED_REMAIN_COST, UNSTAFFED_REMAIN_COST, STAFFED_TARGET_QTY, UNSTAFFED_TARGET_QTY, STAFFED_TARGET_COST,
            UNSTAFFED_TARGET_COST, STAFFED_TOTAL_QTY, UNSTAFFED_TOTAL_QTY, STAFFED_TOTAL_COST, UNSTAFFED_TOTAL_COST, FIN_PERIOD_ACT_QTY,
            FIN_PERIOD_ACT_COST, FIN_PERIOD_TOTAL_QTY, FIN_PERIOD_TOTAL_COST, OVERALLOC_DATE)
 	      select @vid, @pproj_id, @v_new_wbs_id, START_DATE, END_DATE, SPREAD_TYPE, RSRC_ID, ROLE_ID, ACT_START_DATE, ACT_END_DATE, REMAIN_START_DATE,
            REMAIN_END_DATE, STAFFED_ACT_QTY, UNSTAFFED_ACT_QTY, STAFFED_ACT_COST, UNSTAFFED_ACT_COST, STAFFED_ACT_OT_QTY, UNSTAFFED_ACT_OT_QTY,
            STAFFED_ACT_OT_COST, UNSTAFFED_ACT_OT_COST, STAFFED_ACT_REG_COST, UNSTAFFED_ACT_REG_COST, STAFFED_ACT_REG_QTY, UNSTAFFED_ACT_REG_QTY,
            STAFFED_LATE_REMAIN_QTY, UNSTAFFED_LATE_REMAIN_QTY, STAFFED_LATE_REMAIN_COST, UNSTAFFED_LATE_REMAIN_COST, STAFFED_REMAIN_QTY,
            UNSTAFFED_REMAIN_QTY, STAFFED_REMAIN_COST, UNSTAFFED_REMAIN_COST, STAFFED_TARGET_QTY, UNSTAFFED_TARGET_QTY, STAFFED_TARGET_COST,
            UNSTAFFED_TARGET_COST, STAFFED_TOTAL_QTY, UNSTAFFED_TOTAL_QTY, STAFFED_TOTAL_COST, UNSTAFFED_TOTAL_COST, FIN_PERIOD_ACT_QTY,
            FIN_PERIOD_ACT_COST, FIN_PERIOD_TOTAL_QTY, FIN_PERIOD_TOTAL_COST, OVERALLOC_DATE 	
        from sumtrsrc 
    	  where sumtrsrc_id = @vOldId
 	      FETCH NEXT FROM sumtr INTO @vOldId
      END 
    DEALLOCATE sumtr    	    
   END
   exec pc_insert_udf 'projwbs', @pold_wbs_id,  @v_new_wbs_id, @pproj_id
   set @pret_val = @v_new_wbs_id
go
--METADATA NAME:PC_NEW_WBS TYPE:GRANT TABLE_NAME:PC_NEW_WBS CHANGE:CREATE
GRANT EXECUTE ON PC_NEW_WBS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_NEW_PROJECT'

--METADATA  TYPE:SSCR NAME:PC_NEW_PROJECT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_NEW_PROJECT' and type in ('P'))
  DROP PROCEDURE PC_NEW_PROJECT
go
--METADATA NAME:PC_NEW_PROJECT TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_NEW_PROJECT
	@pold_proj_id	integer,
 	@copy_bit		varchar(40),
 	@pret_val		integer OUTPUT,
 	@pret_msg		varchar(4000) OUTPUT,
 	@puser_name		varchar(255) = null,
 	@vdest_proj_id    integer=null,
 	@vdest_wbs_id 	integer=null,
  	@prepl_proj_id integer=null,
 	@vorig_proj_id integer=null,
	@psession_id		integer=null,
	@pservice_id	integer = null,
	@vis_project_baseline char(1)= null
	
WITH ENCRYPTION AS
   DECLARE @vproj_id integer, @vprop_name varchar(32),@vtemplate integer
   DECLARE @v_levelled integer,@v_prop_value varchar(max)
   DECLARE @vnew_proj_short_name varchar(40), @v_orig_proj_id integer,@vview_id integer 
   DECLARE @vid integer, @v_new_proj_id integer, @vguid varchar(22), @vOldId integer;
   declare @fy_start_month_num int,@chng_eff_cmp_pct_flag varchar(1),@rsrc_self_add_flag varchar(1),@rsrc_role_match_flag varchar(1),@allow_complete_flag varchar(1),@rsrc_multi_assign_flag varchar(1)
   declare @checkout_flag varchar(1),@project_flag varchar(1),@step_complete_flag varchar(1),@cost_qty_recalc_flag varchar(1),@sum_only_flag varchar(1)
   declare @batch_sum_flag varchar(1),@name_sep_char varchar(2),@def_complete_pct_type varchar(10),@acct_id int,@source_proj_id int,@base_type_id int
   declare @clndr_id int,@task_code_base int,@task_code_step int,@priority_num int,@wbs_max_sum_level int,@risk_level int,@strgy_priority_num int
   declare @last_checksum int,@critical_drtn_hr_cnt numeric(10,2),@def_cost_per_qty numeric(21,8),@last_recalc_date datetime,@plan_start_date datetime
   declare @plan_end_date datetime,@scd_end_date datetime,@sum_data_date datetime,@last_tasksum_date datetime,@fcst_start_date datetime
   declare @def_duration_type varchar(12),@task_code_prefix varchar(20),@def_qty_type varchar(24),@web_local_root_path varchar(120),@proj_url varchar(200)
   declare @def_rate_type varchar(14),@act_this_per_link_flag varchar(1),@def_task_type varchar(12),@act_pct_link_flag varchar(1),@add_act_remain_flag varchar(1)
   declare @critical_path_type varchar(12),@task_code_prefix_flag varchar(1),@def_rollup_dates_flag varchar(1),@rem_target_link_flag varchar(1)
   declare @reset_planned_flag varchar(1),@allow_neg_act_flag varchar(1),@rsrc_id int,@checkout_date datetime,@checkout_user_id int,@sum_assign_level varchar(12)
   declare @last_fin_dates_id int,@use_project_baseline_flag varchar(1),@ts_rsrc_vw_compl_asgn_flag varchar(1),@ts_rsrc_mark_act_finish_flag varchar(1)
   declare @ts_rsrc_vw_inact_actv_flag varchar(1)
   declare @description varchar(500)
   declare @matrix_id integer
   declare @proj_status_code varchar(40)
   declare @copy_description integer
   declare @control_updates_flag varchar(1)
   declare @hist_interval varchar(25)
   declare @hist_level varchar(10)
   declare @fintmpl_id int

   set @proj_status_code = ( select status_code from projwbs where proj_id = @pold_proj_id and proj_node_flag = 'Y' and delete_session_id is null)

   if @proj_status_code = 'WS_Template'  -- Source is Template
   begin
	    if substring(@copy_bit,27,1)='1'   --destination is template
      begin
	  	  set @vtemplate=1
        set @copy_description=1          -- copy T 2 T 
      end
	    else                               
      begin
		    set @vtemplate=0 
        set @copy_description=0          -- don't T 2 P
      end
   end
   else                                  -- Source is Project
   begin
	    if substring(@copy_bit,27,1)='1'   --destination is template
      begin
	  	  set @vtemplate=1                  
        set @copy_description=0           -- don't copy P 2 T
      end
	    else                               
        begin
		    set @vtemplate=0 
        set @copy_description=1           -- copy P 2 P     
      end
   end 

   if @prepl_proj_id is null 
 	BEGIN
 		exec pc_get_next_key 'project_proj_id', @v_new_proj_id OUTPUT
 		if substring(@copy_bit,23,1)='1'
 		begin
 			set @v_orig_proj_id = @v_new_proj_id
 			exec pc_new_proj_short_name @pold_proj_id, @vnew_proj_short_name OUTPUT, 1, ' - S'
 		end
 		else
 		if substring(@copy_bit,19,1)='1'
 		begin
 		 if @vorig_proj_id is not null 
 		   set @v_orig_proj_id = @vorig_proj_id
 		else
 		   set @v_orig_proj_id = @pold_proj_id
 		exec pc_new_proj_short_name @pold_proj_id, @vnew_proj_short_name OUTPUT, 1
 		end
 		else
 			if substring(@copy_bit,24,1)='1'
 		begin
 			set @v_orig_proj_id = @vdest_proj_id
 			exec pc_new_proj_short_name @vdest_proj_id, @vnew_proj_short_name OUTPUT, 1
 		end
 		else
 		begin
 			set @v_orig_proj_id = null
 		 exec pc_new_proj_short_name @pold_proj_id, @vnew_proj_short_name OUTPUT , 0
 		end 
		  
 		exec  get_guid @vguid OUTPUT
 		insert into project  
 		(PROJ_ID,FY_START_MONTH_NUM,CHNG_EFF_CMP_PCT_FLAG,RSRC_SELF_ADD_FLAG            
 		,RSRC_ROLE_MATCH_FLAG,ALLOW_COMPLETE_FLAG,RSRC_MULTI_ASSIGN_FLAG,CHECKOUT_FLAG,PROJECT_FLAG         
 		,STEP_COMPLETE_FLAG,COST_QTY_RECALC_FLAG,SUM_ONLY_FLAG,BATCH_SUM_FLAG          
 		,NAME_SEP_CHAR,DEF_COMPLETE_PCT_TYPE,PROJ_SHORT_NAME,ACCT_ID,ORIG_PROJ_ID,SOURCE_PROJ_ID
 		,BASE_TYPE_ID,CLNDR_ID,SUM_BASE_PROJ_ID,TASK_CODE_BASE,TASK_CODE_STEP          
 		,PRIORITY_NUM,WBS_MAX_SUM_LEVEL,RISK_LEVEL,STRGY_PRIORITY_NUM                  
 		,LAST_CHECKSUM,CRITICAL_DRTN_HR_CNT,DEF_COST_PER_QTY,LAST_RECALC_DATE          
 		,PLAN_START_DATE,PLAN_END_DATE,SCD_END_DATE,ADD_DATE,SUM_DATA_DATE             
 		,LAST_TASKSUM_DATE,FCST_START_DATE,DEF_DURATION_TYPE,TASK_CODE_PREFIX          
 		,GUID,DEF_QTY_TYPE,ADD_BY_NAME,WEB_LOCAL_ROOT_PATH,PROJ_URL,DEF_RATE_TYPE      
 		,ACT_THIS_PER_LINK_FLAG,DEF_TASK_TYPE,ACT_PCT_LINK_FLAG,ADD_ACT_REMAIN_FLAG    
 		,CRITICAL_PATH_TYPE,TASK_CODE_PREFIX_FLAG,DEF_ROLLUP_DATES_FLAG                
 		,REM_TARGET_LINK_FLAG,RESET_PLANNED_FLAG,ALLOW_NEG_ACT_FLAG,RSRC_ID            
 		,MSP_MANAGED_FLAG,MSP_UPDATE_ACTUALS_FLAG,CHECKOUT_DATE,CHECKOUT_USER_ID       
 		,SUM_ASSIGN_LEVEL,LAST_FIN_DATES_ID,USE_PROJECT_BASELINE_FLAG                  
 		,LAST_BASELINE_UPDATE_DATE,TS_RSRC_MARK_ACT_FINISH_FLAG,TS_RSRC_VW_INACT_ACTV_FLAG,DESCRIPTION,LOCATION_ID,CONTROL_UPDATES_FLAG
    ,MATRIX_ID,FINTMPL_ID)
 			select @v_new_proj_id
 		,FY_START_MONTH_NUM,CHNG_EFF_CMP_PCT_FLAG,RSRC_SELF_ADD_FLAG ,RSRC_ROLE_MATCH_FLAG,ALLOW_COMPLETE_FLAG,RSRC_MULTI_ASSIGN_FLAG,case @vtemplate when 1 then 'N' else CHECKOUT_FLAG end,PROJECT_FLAG         
 		,STEP_COMPLETE_FLAG,COST_QTY_RECALC_FLAG,SUM_ONLY_FLAG,case @vtemplate when 1 then 'N' else BATCH_SUM_FLAG end         
 		,NAME_SEP_CHAR,DEF_COMPLETE_PCT_TYPE
 		,@vnew_proj_short_name
 		,ACCT_ID
 		,@v_orig_proj_id 
 		,SOURCE_PROJ_ID     
 		,BASE_TYPE_ID,CLNDR_ID
 		,null
 		,TASK_CODE_BASE,TASK_CODE_STEP          
 		,PRIORITY_NUM,WBS_MAX_SUM_LEVEL,RISK_LEVEL,STRGY_PRIORITY_NUM                  
 		,LAST_CHECKSUM,CRITICAL_DRTN_HR_CNT,DEF_COST_PER_QTY,case @vtemplate when 1 then null else LAST_RECALC_DATE end          
 		,PLAN_START_DATE,case @vtemplate when 1 then null else PLAN_END_DATE end,SCD_END_DATE
 		,getDate()
 		,case @vtemplate when 1 then null else SUM_DATA_DATE end            
 		,case @vtemplate when 1 then null else LAST_TASKSUM_DATE end,FCST_START_DATE,DEF_DURATION_TYPE,TASK_CODE_PREFIX          
 		,@vguid
 		,DEF_QTY_TYPE
 		,@puser_name
 		,WEB_LOCAL_ROOT_PATH,PROJ_URL,DEF_RATE_TYPE      
 		,ACT_THIS_PER_LINK_FLAG,DEF_TASK_TYPE,ACT_PCT_LINK_FLAG,ADD_ACT_REMAIN_FLAG    
 		,CRITICAL_PATH_TYPE,TASK_CODE_PREFIX_FLAG,DEF_ROLLUP_DATES_FLAG                
 		,REM_TARGET_LINK_FLAG,RESET_PLANNED_FLAG,ALLOW_NEG_ACT_FLAG,RSRC_ID            
 		,'N' MSP_MANAGED_FLAG,'N' MSP_UPDATE_ACTUALS_FLAG,case @vtemplate when 1 then null else CHECKOUT_DATE end,case @vtemplate when 1 then null else CHECKOUT_USER_ID end       
 		,SUM_ASSIGN_LEVEL,LAST_FIN_DATES_ID,USE_PROJECT_BASELINE_FLAG                  
 		,LAST_BASELINE_UPDATE_DATE,TS_RSRC_MARK_ACT_FINISH_FLAG,TS_RSRC_VW_INACT_ACTV_FLAG
		,case @copy_description when 1 then DESCRIPTION else null end
    ,LOCATION_ID,CONTROL_UPDATES_FLAG,MATRIX_ID,FINTMPL_ID
 			from project
 			where proj_id = @pold_proj_id
   END
   else
   BEGIN
     set @v_new_proj_id = @prepl_proj_id
     SELECT @fy_start_month_num=fy_start_month_num,@chng_eff_cmp_pct_flag=chng_eff_cmp_pct_flag,@rsrc_self_add_flag=rsrc_self_add_flag,@rsrc_role_match_flag=rsrc_role_match_flag,
       @allow_complete_flag=allow_complete_flag,@rsrc_multi_assign_flag=rsrc_multi_assign_flag,@checkout_flag=checkout_flag,@project_flag=project_flag,
       @step_complete_flag=step_complete_flag,@cost_qty_recalc_flag=cost_qty_recalc_flag,@sum_only_flag=sum_only_flag,@batch_sum_flag=batch_sum_flag,
       @name_sep_char=name_sep_char,@def_complete_pct_type=def_complete_pct_type,@acct_id=acct_id,@source_proj_id=source_proj_id,@base_type_id=base_type_id,
       @clndr_id=clndr_id,@task_code_base=task_code_base,@task_code_step=task_code_step,@priority_num=priority_num,@wbs_max_sum_level=wbs_max_sum_level,
       @risk_level=risk_level,@strgy_priority_num=strgy_priority_num,@last_checksum=last_checksum,@critical_drtn_hr_cnt=critical_drtn_hr_cnt,
       @def_cost_per_qty=def_cost_per_qty,@last_recalc_date=last_recalc_date,@plan_start_date=plan_start_date,@plan_end_date=plan_end_date,
       @scd_end_date=scd_end_date,@sum_data_date=sum_data_date,@last_tasksum_date=last_tasksum_date,@fcst_start_date=fcst_start_date,@def_duration_type=def_duration_type,
       @task_code_prefix=task_code_prefix,@def_qty_type=def_qty_type,@web_local_root_path=web_local_root_path,@proj_url=proj_url,@def_rate_type=def_rate_type,
       @act_this_per_link_flag=act_this_per_link_flag,@def_task_type=def_task_type,@act_pct_link_flag=act_pct_link_flag,@add_act_remain_flag=add_act_remain_flag,
       @critical_path_type=critical_path_type,@task_code_prefix_flag=task_code_prefix_flag,@def_rollup_dates_flag=def_rollup_dates_flag,
       @rem_target_link_flag=rem_target_link_flag,@reset_planned_flag=reset_planned_flag,@allow_neg_act_flag=allow_neg_act_flag,@rsrc_id=rsrc_id,
       @checkout_date=checkout_date,@checkout_user_id=checkout_user_id,@sum_assign_level=sum_assign_level,@last_fin_dates_id=last_fin_dates_id,
       @use_project_baseline_flag=use_project_baseline_flag,@ts_rsrc_vw_compl_asgn_flag=ts_rsrc_vw_compl_asgn_flag,@ts_rsrc_mark_act_finish_flag=ts_rsrc_mark_act_finish_flag,
       @ts_rsrc_vw_inact_actv_flag=ts_rsrc_vw_inact_actv_flag,@description=description,@matrix_id=matrix_id,@control_updates_flag=control_updates_flag,@hist_interval=hist_interval,@hist_level=hist_level,@fintmpl_id=fintmpl_id
     FROM PROJECT WHERE proj_id = @pold_proj_id
     UPDATE PROJECT SET fy_start_month_num=@fy_start_month_num,chng_eff_cmp_pct_flag=@chng_eff_cmp_pct_flag,rsrc_self_add_flag=@rsrc_self_add_flag,rsrc_role_match_flag=@rsrc_role_match_flag,
       allow_complete_flag=@allow_complete_flag,rsrc_multi_assign_flag=@rsrc_multi_assign_flag,checkout_flag=@checkout_flag,project_flag=@project_flag,
       step_complete_flag=@step_complete_flag,cost_qty_recalc_flag=@cost_qty_recalc_flag,sum_only_flag=@sum_only_flag,batch_sum_flag=@batch_sum_flag,
       name_sep_char=@name_sep_char,def_complete_pct_type=@def_complete_pct_type,acct_id=@acct_id,base_type_id=@base_type_id,
       clndr_id=@clndr_id,task_code_base=@task_code_base,task_code_step=@task_code_step,priority_num=@priority_num,wbs_max_sum_level=@wbs_max_sum_level,
       risk_level=@risk_level,strgy_priority_num=@strgy_priority_num,last_checksum=@last_checksum,critical_drtn_hr_cnt=@critical_drtn_hr_cnt,
       def_cost_per_qty=@def_cost_per_qty,last_recalc_date=@last_recalc_date,plan_start_date=@plan_start_date,plan_end_date=@plan_end_date,
       scd_end_date=@scd_end_date,sum_data_date=@sum_data_date,last_tasksum_date=@last_tasksum_date,fcst_start_date=@fcst_start_date,def_duration_type=@def_duration_type,
       task_code_prefix=@task_code_prefix,def_qty_type=@def_qty_type,web_local_root_path=@web_local_root_path,proj_url=@proj_url,def_rate_type=@def_rate_type,
       act_this_per_link_flag=@act_this_per_link_flag,def_task_type=@def_task_type,act_pct_link_flag=@act_pct_link_flag,add_act_remain_flag=@add_act_remain_flag,
       critical_path_type=@critical_path_type,task_code_prefix_flag=@task_code_prefix_flag,def_rollup_dates_flag=@def_rollup_dates_flag,
       rem_target_link_flag=@rem_target_link_flag,reset_planned_flag=@reset_planned_flag,allow_neg_act_flag=@allow_neg_act_flag,rsrc_id=@rsrc_id,
       checkout_date=@checkout_date,checkout_user_id=@checkout_user_id,sum_assign_level=@sum_assign_level,last_fin_dates_id=@last_fin_dates_id,
       use_project_baseline_flag=@use_project_baseline_flag,ts_rsrc_vw_compl_asgn_flag=@ts_rsrc_vw_compl_asgn_flag,ts_rsrc_mark_act_finish_flag=@ts_rsrc_mark_act_finish_flag,
       ts_rsrc_vw_inact_actv_flag=@ts_rsrc_vw_inact_actv_flag,description = case @copy_description when 1 then @description else null  end,matrix_id=@matrix_id,control_updates_flag=@control_updates_flag,hist_interval=@hist_interval,hist_level=@hist_level,fintmpl_id=@fintmpl_id
     WHERE proj_id = @v_new_proj_id
     UPDATE PROJECT set MSP_MANAGED_FLAG='N', MSP_UPDATE_ACTUALS_FLAG='N'
                       ,add_date=getDate(),add_by_name=@puser_name
     WHERE proj_id = @v_new_proj_id
   END
   if substring(@copy_bit,23,1)='1'
     update project
     set sum_base_proj_id = (select sum_base_proj_id from project where proj_id = @pold_proj_id)
     where proj_id = @v_new_proj_id;
   if substring(@copy_bit,19,1)='1' and @vorig_proj_id is null
     update project
     set last_baseline_update_date = GetDate()
     where proj_id = @v_new_proj_id;
   if @vis_project_baseline='Y' and @pservice_id=1
     update project
	 set sum_base_proj_id = @v_new_proj_id
         where proj_id = @vdest_proj_id;
   if substring(@copy_bit,5,1)='1' and isnull(@vtemplate,0)<>1
   BEGIN
      DECLARE doc CURSOR FOR select doc_id from document where proj_id = @pold_proj_id and delete_session_id is null and DOC_MGMT_TYPE = 'DM_Local' order by doc_id
      OPEN doc
      FETCH NEXT FROM doc INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec  get_guid @vguid OUTPUT
        exec pc_get_next_key 'document_doc_id', @vid OUTPUT
         insert into document
 		( DOC_ID,DOC_SEQ_NUM,DELIV_FLAG,DOC_NAME,PARENT_DOC_ID,PROJ_ID,DOC_STATUS_ID     
 		,DOC_CATG_ID,DOC_DATE,VERSION_NAME,GUID,TMPL_GUID,DOC_SHORT_NAME               
 		,AUTHOR_NAME,PRIVATE_LOC,PUBLIC_LOC,DOC_CONTENT,RSRC_ID,DOC_MGMT_TYPE          
 		,EXTERNAL_DOC_KEY)
         select @vid
 		,DOC_SEQ_NUM,DELIV_FLAG,DOC_NAME,PARENT_DOC_ID
 		,@v_new_proj_id
 		,DOC_STATUS_ID     
 		,DOC_CATG_ID,DOC_DATE,VERSION_NAME
 		,@vguid
 		,TMPL_GUID,DOC_SHORT_NAME               
 		,AUTHOR_NAME,PRIVATE_LOC,PUBLIC_LOC,DOC_CONTENT,RSRC_ID,DOC_MGMT_TYPE          
 		,EXTERNAL_DOC_KEY
         from document
         where doc_id = @vOldId;
        INSERT INTO ##DocID values ( @@SPID,@vOldId, @vid)
        exec pc_insert_udf 'document', @vOldId,  @vid, @v_new_proj_id
        FETCH NEXT FROM doc INTO @vOldId
      END 
      DEALLOCATE doc
      DECLARE doc2 CURSOR FOR select doc_id, parent_doc_id from document where proj_id = @v_new_proj_id and delete_session_id is null order by doc_id
      DECLARE @new_pdoc_id int, @vdocid int, @old_pdoc_id int
      OPEN doc2
      FETCH NEXT FROM doc2 INTO @vdocid,  @old_pdoc_id
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        set @new_pdoc_id=NULL
        select @new_pdoc_id=new_doc_id
        from ##DocID
        where old_doc_id = @old_pdoc_id
        if @new_pdoc_id is not null
        begin
          update document
          set parent_doc_id = @new_pdoc_id
          where doc_id = @vdocid
        end
        FETCH NEXT FROM doc2 INTO @vdocid, @old_pdoc_id
      END 
      DEALLOCATE doc2
    END
   if substring(@copy_bit,3,1)='1' and isnull(@vtemplate,0)=0
   BEGIN
      DECLARE pt CURSOR FOR select thresh_id from projthrs 
 	where proj_id = @pold_proj_id and wbs_id is null and delete_session_id is null order by thresh_id
      OPEN pt
      FETCH NEXT FROM pt INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'projthrs_thresh_id', @vid OUTPUT
         insert into projthrs
 	 ( THRESH_ID,PROJ_ID,OBS_ID,THRESH_PARM_ID,
 				STATUS_CODE,PRIORITY_TYPE,THRESH_TYPE,
 				WBS_ID,TRACK_VIEW_ID,LO_PARM_VALUE,
 				HI_PARM_VALUE,WINDOW_START,WINDOW_END ) 
         select @vid, @v_new_proj_id ,OBS_ID,THRESH_PARM_ID,
 				STATUS_CODE,PRIORITY_TYPE,THRESH_TYPE,
 				WBS_ID,TRACK_VIEW_ID,LO_PARM_VALUE,
 				HI_PARM_VALUE,WINDOW_START,WINDOW_END
         from projthrs
         where thresh_id = @vOldId;
 	INSERT INTO ##ProjThrsID values ( @@SPID,@vOldId, @vid)	
        FETCH NEXT FROM pt INTO @vOldId
      END 
      DEALLOCATE pt
    END
   if substring(@copy_bit,6,1)='1'
   BEGIN
      DECLARE pf CURSOR FOR select proj_fund_id from projfund where proj_id = @pold_proj_id and delete_session_id is null order by proj_fund_id
      OPEN pf
      FETCH NEXT FROM pf INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'projfund_proj_fund_id', @vid OUTPUT
         insert into projfund (PROJ_FUND_ID,FUND_ID,PROJ_ID,FUND_COST,FUND_WT)
          select @vid, FUND_ID,@v_new_proj_id,FUND_COST,FUND_WT
  	from projfund
 	where proj_fund_id = @vOldId
 	       FETCH NEXT FROM pf INTO @vOldId
      END 
      DEALLOCATE pf
    END
   --bit 34 is for visualizer reports copy 
   if substring(@copy_bit,4,1)='1' and substring(@copy_bit,34,1)='1'
   BEGIN
      DECLARE rpt CURSOR FOR select rpt_id from rpt where proj_id = @pold_proj_id and delete_session_id is null order by rpt_id
      OPEN rpt
      FETCH NEXT FROM rpt INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'rpt_rpt_id', @vid OUTPUT
         insert into rpt
 		(RPT_ID, GLOBAL_FLAG, RPT_TYPE, RPT_NAME, RPT_AREA, RPT_GROUP_ID
 		,PROJ_ID, RPT_STATE, RPT_DATA) 
 	select @vid
 		, GLOBAL_FLAG, RPT_TYPE, RPT_NAME, RPT_AREA, RPT_GROUP_ID
 		,@v_new_proj_id, RPT_STATE, RPT_DATA       
         from rpt
         where rpt_id= @vOldId;
        FETCH NEXT FROM rpt INTO @vOldId
      END 
      DEALLOCATE rpt
    END
   if substring(@copy_bit,4,1)='1' and substring(@copy_bit,34,1)='0'
   BEGIN
      DECLARE novisualrpt CURSOR FOR select rpt_id from rpt where proj_id = @pold_proj_id and delete_session_id is null and rpt_type != 'RP_Visual' order by rpt_id
      OPEN novisualrpt
      FETCH NEXT FROM novisualrpt INTO @vOldId
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        exec pc_get_next_key 'rpt_rpt_id', @vid OUTPUT
         insert into rpt
 		(RPT_ID, GLOBAL_FLAG, RPT_TYPE, RPT_NAME, RPT_AREA, RPT_GROUP_ID
 		,PROJ_ID, RPT_STATE, RPT_DATA) 
 	select @vid
 		, GLOBAL_FLAG, RPT_TYPE, RPT_NAME, RPT_AREA, RPT_GROUP_ID
 		,@v_new_proj_id, RPT_STATE, RPT_DATA       
         from rpt
         where rpt_id= @vOldId;
        FETCH NEXT FROM novisualrpt INTO @vOldId
      END 
      DEALLOCATE novisualrpt
    END
     if substring(@copy_bit,23,1)='1'
       insert into projpcat 
       (PROJ_ID,PROJ_CATG_TYPE_ID,PROJ_CATG_ID)
       select @v_new_proj_id, pp.proj_catg_type_id, pp.proj_catg_id 
       from pcattype pt, projpcat pp
       where pp.proj_id = @pold_proj_id
       and pp.proj_catg_type_id = pt.proj_catg_type_id
       and pp.delete_session_id is null and pt.delete_session_id is null;
     ELSE
       insert into projpcat 
       (PROJ_ID,PROJ_CATG_TYPE_ID,PROJ_CATG_ID)
       select @v_new_proj_id, pp.proj_catg_type_id, pp.proj_catg_id 
       from pcattype pt, projpcat pp
       where pp.proj_id = @pold_proj_id
       and pp.proj_catg_type_id = pt.proj_catg_type_id
       and pt.super_flag ='N'
       and pp.delete_session_id is null and pt.delete_session_id is null;
    exec pc_insert_udf 'project', @pold_proj_id,  @v_new_proj_id, @v_new_proj_id
    if substring(@copy_bit,23,1)='0'
    BEGIN
    exec proj_leveled @pold_proj_id ,@v_levelled OUTPUT;
	if @v_levelled = 0	
      insert into projprop
      (proj_id, prop_name, prop_value)
      select @v_new_proj_id, prop_name, prop_value
      from projprop
      where proj_id = @pold_proj_id and delete_session_id is null;
	  else if (@v_levelled = 1 and substring(@copy_bit,11,1)='0') 
	  begin
		exec modified_blob_leveler @pold_proj_id ,@v_prop_value OUTPUT;
		     insert into projprop (proj_id, prop_name, prop_value)
              select @v_new_proj_id, prop_name, @v_prop_value
                from projprop
               where proj_id = @pold_proj_id
              and delete_session_id is null;
	  end;
		  else if (@v_levelled = 1 and substring(@copy_bit,11,1)='1' )
		     insert into projprop (proj_id, prop_name, prop_value)
               select @v_new_proj_id, prop_name, prop_value
                from projprop
               where proj_id = @pold_proj_id
              and delete_session_id is null;
		  else 
		  begin
			set @pret_val=-1
			set @pret_msg = 'Copy Projprop failed'
		    return 
		  end;
	  
      END;

	if @vtemplate=0
	begin
    DECLARE LayoutCur CURSOR LOCAL FOR select view_id from viewprop where proj_id = @pold_proj_id and delete_session_id is null
    OPEN LayoutCur
    FETCH NEXT FROM LayoutCur INTO @vview_id  
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      exec pc_get_next_key 'viewprop_view_id', @vid OUTPUT
      insert into viewprop
      (view_id, view_name,view_type, view_data,proj_id)
       select @vid, view_name, view_type, view_data,@v_new_proj_id
       from viewprop
        where view_id = @vview_id;
 	 FETCH NEXT FROM LayoutCur INTO @vview_id  
    END
     Close  LayoutCur
     Deallocate LayoutCur
	end

  if substring(@copy_bit,1,1)='1'	
  begin
    exec pc_project_copy_risk @v_new_proj_id, @pold_proj_id, @psession_id, @copy_bit
  end

    set @pret_val = @v_new_proj_id
go
--METADATA NAME:PC_NEW_PROJECT TYPE:GRANT TABLE_NAME:PC_NEW_PROJECT CHANGE:CREATE
GRANT EXECUTE ON PC_NEW_PROJECT TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_PROCESS_LEVEL'

--METADATA  TYPE:SSCR NAME:PC_PROCESS_LEVEL OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_PROCESS_LEVEL' and type in ('P'))
  DROP PROCEDURE PC_PROCESS_LEVEL
go
--METADATA NAME:PC_PROCESS_LEVEL TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_PROCESS_LEVEL
	@pwbs_id		integer,
	@pparent_wbs_id		integer,
	@plevel			integer,
	@pnew_parent_wbs_id	integer,
	@pnew_proj_id		integer,
	@copy_bit		varchar(40),
	@max_wbs_id		integer,
	@pret_val		integer OUTPUT,
	@pret_msg		varchar(4000) OUTPUT,
	@ppfolio_id		integer = null,
	@puser_name		varchar(255) = null,
	@psession_id		integer=null,
	@pservice_id	integer = null,
	@vis_project_baseline char(1)= null,
    @prepl_proj_id  integer=null,
	@iswbs		varchar(1)='N'
WITH ENCRYPTION AS
declare @vproj_id integer, @vpflag char(1), @v_new_proj_id integer, @vnode_flag char(1)
 declare @vLevel integer, @vnew_wbs_id integer, @vwbs_name varchar(100)
 declare @vret integer, @vmsg varchar(4000) ,@vorig_proj_id integer, @fwbs_id integer
 declare @vclndr_id integer, @vid integer, @vcnt integer, @vprojwbs_status_code varchar(20)
 declare @wbs_max_sum_level integer
 declare @vtarget_proj_id integer
 declare @vtarget_wbs_id integer

 DECLARE wbsCur CURSOR LOCAL FOR 
   select wbs_id from projwbs (nolock)
   where parent_wbs_id = @pwbs_id
   and wbs_id < = @max_wbs_id
   and delete_session_id is null 
-- DECLARE calCur CURSOR LOCAL FOR
--   select clndr_id from calendar
--   where proj_id = @vproj_id
--   order by clndr_id
  --END declarations

 WHILE (len(@copy_bit) < 30) 
 BEGIN
   set @copy_bit = rtrim(@copy_bit) + '0'
 END

 set @pret_val=0
 set @vLevel = @plevel + 1
 set @vnew_wbs_id = 0
 select @vpflag=p.project_flag, @vproj_id=p.proj_id, @vwbs_name=wbs_name,
	@vnode_flag=proj_node_flag, @vorig_proj_id=orig_proj_id,
        @vprojwbs_status_code=pw.status_code,
    @wbs_max_sum_level=wbs_max_sum_level
 from project p, projwbs pw
 where p.proj_id = pw.proj_id
 and pw.wbs_id = @pwbs_id

-- if this is a scenario baseline then exit if reached max levels
if @wbs_max_sum_level<>0 and substring(@copy_bit,23,1)='1' and @vlevel > @wbs_max_sum_level
  return

-- allow to copy  baseline 
 if @vorig_proj_id is not null and (substring(@copy_bit,24,1)='0' or substring(@copy_bit,24,1)='') and  (substring(@copy_bit,19,1)='0' or substring(@copy_bit,19,1)='')
   return
 -- Exit if this is a project node and the project is not in the pfolio
 if @ppfolio_id is not null and @vpflag = 'Y' and @vnode_flag = 'Y'
 begin
   select @vcnt=count(*) 
   from prpfolio
   where pfolio_id = @ppfolio_id 
   and wbs_id = @pwbs_id;
   if @vcnt = 0 
   begin
         select @vcnt=count(*) 
          from prpfolio pf, projwbs pw, project pj 
          where pw.proj_node_flag = 'Y' 
            and pj.project_flag = 'Y' 
            and pw.proj_id = pj.orig_proj_id 
            and pj.proj_id = @vproj_id 
            and pf.wbs_id = pw.wbs_id 
            and pf.pfolio_id = @ppfolio_id  
            and pj.delete_session_id is null  
            and pw.delete_session_id is null
            and pf.delete_session_id is null;       
		if @vcnt = 0 
			return
		set @vproj_id = null;
   end 
 end

 if substring(@copy_bit,20,1)<>'1' and @vprojwbs_status_code = 'WS_Requested' 
   return

 if @vnode_flag ='Y' and substring(@copy_bit,29,1)<>'1'
 begin
   set @pret_val =0
   -- this is an EPS node so get create a new project
  if substring(@copy_bit,24,1)='1' 
  begin
    select @vorig_proj_id=orig_proj_id from project where proj_id=@vproj_id
		select @vtarget_proj_id=target_proj_id,@vtarget_wbs_id=target_wbs_id from TPROJMAP where source_proj_id=@vorig_proj_id and session_id=@psession_id
  	if @vtarget_proj_id is null or @vtarget_wbs_id is null 
  	begin 
      set @pret_val=-1
		  set @pret_msg='target project to copy baseline to does not exist'
		  return
	  end
	  else
  		exec pc_new_project @vproj_id, @copy_bit, @v_new_proj_id OUTPUT, @vmsg OUTPUT, @puser_name,@vtarget_proj_id,@vtarget_wbs_id,null,@vorig_proj_id,@psession_id,@pservice_id,@vis_project_baseline
	end 
  else
  begin
	  exec pc_new_project @vproj_id, @copy_bit, @v_new_proj_id OUTPUT, @vmsg OUTPUT, @puser_name,null,null,@prepl_proj_id,@vorig_proj_id,@psession_id,@pservice_id,@vis_project_baseline
  end

   if not @v_new_proj_id > 0 
   begin
      set @pret_msg ='Error creating new Project|' + @vmsg
      set @pret_val = -1
      return
   end 

   -- Also create the new WBS node
   exec pc_new_wbs @pwbs_id, @v_new_proj_id, @pnew_parent_wbs_id, @vpflag, @copy_bit,
			@vnew_wbs_id OUTPUT, @vmsg OUTPUT,@prepl_proj_id,@vorig_proj_id,null,null,@psession_id
   if not @vnew_wbs_id > 0 
   begin
      set @pret_msg ='Error creating new wbs|' + @vmsg
      set @pret_val = -1
      return
   end 
   if (substring(@copy_bit,24,1)='0' or substring(@copy_bit,24,1)='') AND @psession_id IS NOT null
    begin
     select @vcnt=count(1) from TPROJMAP where source_proj_id=@vproj_id and session_id=@psession_id
     if @vcnt =0 
        insert into TPROJMAP values(@psession_id,1,@vproj_id,@v_new_proj_id,@vnew_wbs_id)  
     else		 	
	update TPROJMAP set target_proj_id=@v_new_proj_id,target_wbs_id=@vnew_wbs_id where source_proj_id=@vproj_id and session_id=@psession_id
     end
    
     
   if @ppfolio_id is not null and @vpflag = 'Y'
     insert into prpfolio (pfolio_id, wbs_id ) 
     values ( @ppfolio_id, @vnew_wbs_id ) 

 
 end
 else
 begin
   set @pret_val =0
   -- this is a regular WBS node
   set @v_new_proj_id = @pnew_proj_id
   exec pc_new_wbs @pwbs_id, @v_new_proj_id, @pnew_parent_wbs_id, @vpflag, @copy_bit,
			@vnew_wbs_id OUTPUT, @vmsg OUTPUT,null,@vorig_proj_id,@vproj_id,@plevel,@psession_id
   if not @vnew_wbs_id > 0 
   begin
      set @pret_msg ='Error creating new wbs|' + @vmsg
      set @pret_val = -1
      return
   end 
 
 end
 
 if @plevel=0 
  
 begin
    
    delete from pkxref
       where system_id = @psession_id
         and context_name = 'PWBSID'
      insert into pkxref
        (system_id, context_name, pk1, pk2)
      values
        (@psession_id, 'PWBSID', @vnew_wbs_id, @plevel)
 end
 declare @recurse_tree bit
 if substring(@copy_bit,23,1)='1' and @vpflag = 'N'
   set @recurse_tree = 0
 else
   set @recurse_tree = 1


 if @recurse_tree = 1 
 BEGIN
   -- Now Recurse WBS tree
   OPEN wbsCur
   FETCH NEXT FROM wbsCur INTO @fwbs_id
   WHILE (@@FETCH_STATUS = 0)
   BEGIN
     exec pc_process_level @fwbs_id , @pwbs_id, @vLevel,
  		  @vnew_wbs_id, @v_new_proj_id, @copy_bit, 
  		  @max_wbs_id ,
		  @pret_val output, @pret_msg output, 
		  @ppfolio_id,@puser_name,@psession_id,
		  @pservice_id,@vis_project_baseline
		 
     if @pret_val < 0 
     begin
       -- CLEAN up everything for return to caller.
       CLOSE wbsCur
       DEALLOCATE wbsCur
       DEALLOCATE calCur
       return
     end

     FETCH NEXT FROM wbsCur INTO @fwbs_id
   END
   CLOSE wbsCur 
 END

--fix thresh_id in projissu

     DECLARE cpi CURSOR FOR select issue_id,thresh_id from projissu where proj_id = @v_new_proj_id and  delete_session_id is null order by issue_id
     DECLARE @new_pthresh_id int, @vissueid int, @old_pthresh_id int
     OPEN cpi
     FETCH NEXT FROM cpi INTO @vissueid,@old_pthresh_id
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       set @new_pthresh_id=NULL
       select @new_pthresh_id=new_thresh_id
       from ##ProjthrsID
       where old_thresh_id = @old_pthresh_id
       if @new_pthresh_id is not null
       begin
         update projissu set thresh_id= @new_pthresh_id
         where issue_id = @vissueid
       end
       FETCH NEXT FROM cpi INTO @vissueid,@old_pthresh_id
     END 
     DEALLOCATE cpi


   DECLARE calCur CURSOR LOCAL FOR
   select clndr_id from calendar
   where proj_id = @vproj_id
   and delete_session_id is null 
   order by clndr_id 

   
 -- Do Project level ACTV codes and Calendars if this is a project node
 if @vnode_flag = 'Y' and  isnull(substring(@copy_bit,29,1),0)<>'1'
 BEGIN
   exec pc_actvtype_copy @vproj_id, @v_new_proj_id, @pret_val OUTPUT, @pret_msg OUTPUT
   if @pret_val <> 0 
   begin
     DEALLOCATE wbsCur
     DEALLOCATE calCur
     return
  end

   OPEN calCur
   FETCH NEXT FROM calCur INTO @vclndr_id  
   WHILE (@@FETCH_STATUS = 0)
   BEGIN
     exec pc_get_next_key 'calendar_clndr_id', @vid OUTPUT
     insert into calendar
		( CLNDR_ID,DEFAULT_FLAG,CLNDR_NAME,PROJ_ID,BASE_CLNDR_ID  
		,LAST_CHNG_DATE,CLNDR_TYPE,CLNDR_DATA,DAY_HR_CNT,WEEK_HR_CNT,MONTH_HR_CNT,YEAR_HR_CNT)
     select @vid
		,DEFAULT_FLAG,CLNDR_NAME
		,@v_new_proj_id ,BASE_CLNDR_ID  
		,LAST_CHNG_DATE,CLNDR_TYPE,CLNDR_DATA,DAY_HR_CNT,WEEK_HR_CNT,MONTH_HR_CNT,YEAR_HR_CNT     
     from calendar
     where clndr_id = @vclndr_id;

     update task
     set clndr_id = @vid
     where clndr_id = @vclndr_id
     and proj_id = @v_new_proj_id;

     update project
     set clndr_id = @vid
     where clndr_id = @vclndr_id
     and proj_id = @v_new_proj_id;

     FETCH NEXT FROM calCur INTO @vclndr_id  
   
   END
   CLOSE calCur
 END



 set @pret_val = @v_new_proj_id
 set @pret_msg = 'complete'
 DEALLOCATE wbsCur
 DEALLOCATE calCur
go
--METADATA NAME:PC_PROCESS_LEVEL TYPE:GRANT TABLE_NAME:PC_PROCESS_LEVEL CHANGE:CREATE
GRANT EXECUTE ON PC_PROCESS_LEVEL TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_HAS_EPS_CODE_ACCESS'

--METADATA  TYPE:SSCR NAME:PC_HAS_EPS_CODE_ACCESS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_HAS_EPS_CODE_ACCESS' and type in ('P'))
  DROP PROCEDURE PC_HAS_EPS_CODE_ACCESS
go
--METADATA NAME:PC_HAS_EPS_CODE_ACCESS TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_HAS_EPS_CODE_ACCESS
( @pcode_wbs_id integer, @ptarget_wbs_id integer, @has_access bit OUTPUT )
WITH ENCRYPTION AS
  set @has_access = 0

  declare @v_new_wbs_id integer
  if @pcode_wbs_id = @ptarget_wbs_id 
  begin
    set @has_access = 1
    return
  end

  select @v_new_wbs_id = parent_wbs_id
  from projwbs
  where wbs_id = @ptarget_wbs_id
  and parent_wbs_id is not null;

  if @v_new_wbs_id is null
    return 

  exec pc_has_eps_code_access @pcode_wbs_id, @v_new_wbs_id, @has_access OUTPUT

go
--METADATA NAME:PC_HAS_EPS_CODE_ACCESS TYPE:GRANT TABLE_NAME:PC_HAS_EPS_CODE_ACCESS CHANGE:CREATE
GRANT EXECUTE ON PC_HAS_EPS_CODE_ACCESS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_PROJECT_COPY_RISK'

--METADATA  TYPE:SSCR NAME:PC_PROJECT_COPY_RISK OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_PROJECT_COPY_RISK' and type in ('P'))
  DROP PROCEDURE PC_PROJECT_COPY_RISK
go
--METADATA NAME:PC_PROJECT_COPY_RISK TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_PROJECT_COPY_RISK
  @pproj_id integer,
	@pold_proj_id	integer,
  @psession_id integer,
	@copy_bit	varchar(40)
WITH ENCRYPTION AS
  DECLARE   @v_first_id integer
  DECLARE   @ids_count integer
  DECLARE   @r_flag integer
  DECLARE   @v_datetime datetime
  DECLARE   @i   integer
  DECLARE   @id1 integer
  DECLARE   @id2 integer
  DECLARE   @v_create_project_template varchar(1)
  DECLARE   @v_create_project_from_template varchar(1)
  DECLARE   @vtemplate integer
  DECLARE   @vtemplate_option integer
  begin
    --clean pkxref for the current session
      delete from pkxref
      where system_id = @psession_id
            and (context_name = 'PROJRISK' )
  
   set @v_datetime = getDate()
    select @ids_count = count(*) from projrisk where proj_id = @pold_proj_id
      if @ids_count > 0 
      begin
        exec getnextkeys 'projrisk_risk_id', @ids_count, @v_first_id OUTPUT
        insert into pkxref (system_id, context_name, pk1, pk2, old_pk1, old_pk2, add_date)
        select @psession_id, 'PROJRISK', @pproj_id, ROW_NUMBER() OVER(ORDER BY create_date DESC) + @v_first_id - 1, @pold_proj_id, r.risk_id, @v_datetime
        from projrisk r
        where proj_id = @pold_proj_id
      
        insert into projrisk 
        (risk_id,proj_id,add_date,status_code,risk_name,risk_type_id,rsrc_id,risk_to_type,identified_by_id,response_type,response_text,pre_rsp_prblty,pre_rsp_schd_prblty,pre_rsp_cost_prblty,post_rsp_prblty,post_rsp_schd_prblty,post_rsp_cost_prblty,risk_cause,risk_effect,notes,risk_code,risk_desc)
        select x.pk2, @pproj_id, r.add_date, r.status_code,r.risk_name,r.risk_type_id,r.rsrc_id, r.risk_to_type,r.identified_by_id, r.response_type,r.response_text,r.pre_rsp_prblty,r.pre_rsp_schd_prblty,r.pre_rsp_cost_prblty,r.post_rsp_prblty,r.post_rsp_schd_prblty,r.post_rsp_cost_prblty,r.risk_cause,r.risk_effect,r.notes,r.risk_code,r.risk_desc
        from projrisk r, pkxref x
        where r.risk_id = x.old_pk2 and system_id = @psession_id and x.context_name = 'PROJRISK'
  
        set @i = 1
        while @i <= @ids_count 
           begin
             select @id1 = old_pk2, @id2 = pk2 from (
                 select old_pk2, pk2, ROW_NUMBER () OVER (ORDER BY old_pk2, pk2) as r  
                 from pkxref where system_id = @psession_id and context_name = 'PROJRISK' and pk1 = @pproj_id) x
             where r = @i
  
             exec pc_insert_udf 'projrisk', @id1,  @id2, @pproj_id
             set @i = @i + 1
           end 
        
        insert into riskctrl (risk_id, proj_id, risk_control)
                select x.pk2, @pproj_id, r.risk_control
                from riskctrl r, pkxref x
                where r.risk_id = x.old_pk2 and x.system_id = @psession_id and context_name = 'PROJRISK'; 
  
      end
 
  end
go
--METADATA NAME:PC_PROJECT_COPY_RISK TYPE:GRANT TABLE_NAME:PC_PROJECT_COPY_RISK CHANGE:CREATE
GRANT EXECUTE ON PC_PROJECT_COPY_RISK TO ${pm.ss.privileged_user}
go
print 'Creating procedure PC_ACTIVITY_COPY_RISK'

--METADATA  TYPE:SSCR NAME:PC_ACTIVITY_COPY_RISK OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PC_ACTIVITY_COPY_RISK' and type in ('P'))
  DROP PROCEDURE PC_ACTIVITY_COPY_RISK
go
--METADATA NAME:PC_ACTIVITY_COPY_RISK TYPE:PROCEDURE SET:CPDP CHANGE:CREATE
CREATE PROCEDURE PC_ACTIVITY_COPY_RISK
  @new_task_id integer,
  @old_task_id integer,
  @pproj_id integer,
  @pold_proj_id integer,
  @psession_id integer
WITH ENCRYPTION AS
begin
    --insert into taskrisk
    insert into taskrisk(task_id, risk_id, proj_id)
    select @new_task_id, x.pk2, @pproj_id
    from taskrisk tr, pkxref x
    where tr.task_id = @old_task_id and tr.risk_id = x.old_pk2 and x.context_name = 'PROJRISK' and x.system_id = @psession_id;
 end
go
--METADATA NAME:PC_ACTIVITY_COPY_RISK TYPE:GRANT TABLE_NAME:PC_ACTIVITY_COPY_RISK CHANGE:CREATE
GRANT EXECUTE ON PC_ACTIVITY_COPY_RISK TO ${pm.ss.privileged_user}
go
print 'Creating procedure MULTI_PROJECT_COPY'

--METADATA  TYPE:SSCR NAME:MULTI_PROJECT_COPY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'MULTI_PROJECT_COPY' and type in ('P'))
  DROP PROCEDURE MULTI_PROJECT_COPY
go
--METADATA NAME:MULTI_PROJECT_COPY TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE PROCEDURE MULTI_PROJECT_COPY
	@pproj_list varchar(8000),
	@dest_wbs_id	integer,
	@copy_bit	varchar(40),
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT,
	@ppfolio_id	integer = null,
	@psession_id	integer = null,
	@pservice_id	integer = null,
	@vis_project_baseline char(1)= null,
 	@prepl_proj_id integer = null,
 	@pscenario_id integer=null,
  @vstatus_code integer=null
WITH ENCRYPTION AS
set nocount on 
declare @vwbs_id integer, @vdest_wbs_id integer, @vret integer,@pproj_id integer
declare @wbs_pflag char(1), @node_flag char(1), @pflag char(1)
declare @max_wbs_id integer, @user_name varchar(255), @cnt integer,@new_proj_list varchar(8000)
set @pproj_id=0
if @@trancount = 0
   begin transaction

exec util_setlist @psession_id,@pproj_list,@pret_val OUTPUT,@pret_msg OUTPUT

while (@pproj_id  >-1) 
begin
 exec util_getnextlistval @psession_id,@pproj_id OUTPUT,@pret_msg OUTPUT  
   
  if @pproj_id =-1
      break ;

  if substring(@copy_bit,19,1)='1' 
  begin 
    select @vstatus_code=1 from projwbs where proj_id=@pproj_id and proj_node_flag='Y' and status_code = 'WS_Template'
    if @vstatus_code  = 1
    begin
	    set @pret_msg = 'Can not make a template project as a baseline'
	    set @pret_val = -1
	    return
    end  
  end 
  
set @node_flag=null
select @node_flag=proj_node_flag from projwbs where wbs_id=@dest_wbs_id and delete_session_id is null 

set @vwbs_id=null
select @vwbs_id=wbs_id from projwbs where proj_id=@pproj_id and proj_node_flag = 'Y' and delete_session_id is null 
if @vwbs_id is null 
begin
  set @pret_msg = 'WBS ID does not exist for project ' + convert(varchar(30), @pproj_id)
  set @pret_val = -1
  return
end
set @wbs_pflag=null
select @wbs_pflag=project_flag , @vdest_wbs_id=parent_wbs_id
from projwbs pw, project p 
where p.proj_id = pw.proj_id
and pw.wbs_id = @dest_wbs_id
and pw.delete_session_id is null 

if @wbs_pflag = 'N'
  set @vdest_wbs_id=@dest_wbs_id
else if substring(@copy_bit,23,1)='1'
  select @vdest_wbs_id=parent_wbs_id
  from projwbs pw
  where pw.proj_id = @pproj_id
  and proj_node_flag = 'Y';

set @pflag=null
select @pflag=project_flag from project where proj_id = @pproj_id and delete_session_id is null 
if substring(@copy_bit,19,1)='1' and @pflag='N' and not substring(@copy_bit,23,1)='1'
begin
  set @pret_msg = 'Cannot copy baseline from EPS Node'
  set @pret_val = -1
  return
end

--Setup DOCID temp table
if exists (SELECT name FROM tempdb..sysobjects  WHERE name = '##DocID' AND type = 'U')
 delete from ##DocId 
 where system_id = @@spid
ELSE
  create table ##DocID ( system_id integer,old_doc_id int, new_doc_id int ) 

--Setup threshold id table
if exists (SELECT name FROM tempdb..sysobjects  WHERE name = '##ProjthrsID' AND type = 'U')
 delete from ##ProjthrsId 
 where system_id = @@spid
ELSE
  create table ##ProjthrsID ( system_id integer,old_thresh_id int, new_thresh_id int )

select @max_wbs_id= max(wbs_id) 
from projwbs
where delete_session_id is null 

if @psession_id is not null
begin
  set @user_name = null
  select @user_name=user_name 
  from users u, usession us
  where u.user_id = us.user_id
  and us.session_id = @psession_id
  and us.delete_session_id is null ;
  if @user_name is null
     set @user_name = 'system'
end
else
  set @user_name = 'system'
--Validate portfolio id
if @ppfolio_id is not null
begin
  select @cnt=count(*) from pfolio where pfolio_id = @ppfolio_id
  if @cnt = 0 
    set @ppfolio_id = null
end
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

-- If destination WBS_ID is a project then make destination one level up
exec pc_process_level @vwbs_id, @vdest_wbs_id, 0,@vdest_wbs_id, @pproj_id, @copy_bit,@max_wbs_id,@pret_val output, @pret_msg output, @ppfolio_id ,@user_name,@psession_id,@pservice_id,@vis_project_baseline,@prepl_proj_id
delete from pkxref
where system_id = @psession_id
  and (context_name = 'RISK' or context_name = 'RISKRSPPLN' or context_name = 'RISKMIT')

if @pret_val < 0 
begin
  set @pret_msg = 'pc_process_level failed|' + @pret_msg
  rollback transaction
  return
end
else
begin
  if @new_proj_list is NULL 
     set @new_proj_list=ltrim(str(@pret_val))
  else
	 set @new_proj_list= @new_proj_list + ','+ ltrim(str(@pret_val))
end
if substring(@copy_bit,23,1)='1'
    insert into scenproj (scenario_id, proj_id) values (@pscenario_id,@pret_val)
end 

exec pc_taskpred_copy @@SPID, @copy_bit, @vret output, @pret_msg output
if @vret <> 0 
begin
  set @pret_msg = 'pc_taskpred copy failed|' + @pret_msg
  rollback transaction
  return
end
set @pret_msg=@new_proj_list
delete from pkxref where system_id=@@SPID and context_name = 'T'

begin
if @@TRANCOUNT > 0 
   commit transaction
end

go
--METADATA NAME:MULTI_PROJECT_COPY TYPE:GRANT TABLE_NAME:MULTI_PROJECT_COPY CHANGE:CREATE
GRANT EXECUTE ON MULTI_PROJECT_COPY TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJECT_COPY'

--METADATA  TYPE:SSCR NAME:PROJECT_COPY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_COPY' and type in ('P'))
  DROP PROCEDURE PROJECT_COPY
go
--METADATA NAME:PROJECT_COPY TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE PROCEDURE PROJECT_COPY
	@pproj_id	integer,
	@dest_wbs_id	integer,
	@copy_bit	varchar(40),
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT,
	@ppfolio_id	integer = null,
	@psession_id	integer = null,
	@pservice_id	integer = null,
	@vis_project_baseline char(1)= null,
    @prepl_proj_id integer = null
WITH ENCRYPTION AS
declare @proj_list varchar(2000)
set nocount on 
set @proj_list=str(@pproj_id)
exec multi_project_copy @proj_list,@dest_wbs_id,@copy_bit,@pret_val OUTPUT,@pret_msg OUTPUT,@ppfolio_id,@psession_id,@pservice_id,@vis_project_baseline,@prepl_proj_id
go
--METADATA NAME:PROJECT_COPY TYPE:GRANT TABLE_NAME:PROJECT_COPY CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY TO ${pm.ss.privileged_user}
go
print 'Creating procedure TIME_APPROVAL_WBS_LEVEL'

--METADATA  TYPE:SSCR NAME:TIME_APPROVAL_WBS_LEVEL OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIME_APPROVAL_WBS_LEVEL' and type in ('P'))
  DROP PROCEDURE TIME_APPROVAL_WBS_LEVEL
go
--METADATA NAME:TIME_APPROVAL_WBS_LEVEL TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE PROCEDURE TIME_APPROVAL_WBS_LEVEL
	(@pwbs_id integer, @psession_id integer, 
	@pcontext_id integer, @pret_val integer OUTPUT,
	@pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS 
  DECLARE wbs_child CURSOR LOCAL FOR
  select pw.wbs_id 
  from  projwbs pw
  where parent_wbs_id = @pwbs_id
  and delete_session_id is null

  DECLARE @vwbs_id int

  OPEN wbs_child
  FETCH NEXT FROM wbs_child INTO @vwbs_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    exec time_approval_wbs_level @vwbs_id, @psession_id, @pcontext_id, @pret_val OUTPUT , @pret_msg OUTPUT
    FETCH NEXT FROM wbs_child INTO  @vwbs_id
  END
  CLOSE wbs_child
  DEALLOCATE wbs_child

  
  if ( select count(*) from upklist where session_id = @psession_id and context_id = @pcontext_id
	and pk_id = @pwbs_id ) = 0 
  begin
    insert into upklist (session_id, context_id, pk_id ) 
    values (@psession_id, @pcontext_id, @pwbs_id);
  end

go
--METADATA NAME:TIME_APPROVAL_WBS_LEVEL TYPE:GRANT TABLE_NAME:TIME_APPROVAL_WBS_LEVEL CHANGE:CREATE
GRANT EXECUTE ON TIME_APPROVAL_WBS_LEVEL TO ${pm.ss.privileged_user}
go
print 'Creating procedure TIME_APPROVAL_WBS'

--METADATA  TYPE:SSCR NAME:TIME_APPROVAL_WBS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TIME_APPROVAL_WBS' and type in ('P'))
  DROP PROCEDURE TIME_APPROVAL_WBS
go
--METADATA NAME:TIME_APPROVAL_WBS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE PROCEDURE TIME_APPROVAL_WBS
	(@puser_id integer, @psession_id integer,@pcontext_id integer, 
	 @ppriv_num integer,@pret_val integer OUTPUT,
	@pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS 
  set nocount on
  declare @vwbs_id integer, @cnt integer, @vparent_wbs_id integer

  delete from upklist 
  where session_id = @psession_id
  and context_id = @pcontext_id

  create table #ta_wbs (wbs_id integer, parent_wbs_id integer)
  insert into #ta_wbs
  select wbs_id, parent_wbs_id
  from projwbs pw, userobs uo, profpriv pp
  where pp.priv_num =  @ppriv_num
  and pp.prof_id = uo.prof_id
  and uo.user_id = @puser_id
  and pp.allow_flag = 'Y'
  and pw.obs_id = uo.obs_id
  and pw.delete_session_id is null 
  and uo.delete_session_id is null
  and pp.delete_session_id is null


  select count(*) from #ta_wbs;

  DECLARE ta_wbs CURSOR FOR
  select wbs_id, parent_wbs_id
  from #ta_wbs
  order by wbs_id

  OPEN ta_wbs
  FETCH NEXT FROM ta_wbs INTO @vwbs_id, @vparent_wbs_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN

    if ( SELECT count(*)
    FROM upklist u
    where session_id = @psession_id and context_id = @pcontext_id 
    and pk_id = @vparent_wbs_id ) = 0 
    begin

      exec time_approval_wbs_level @vwbs_id, @psession_id, @pcontext_id, @pret_val OUTPUT , @pret_msg OUTPUT
      if ( @pret_val <> 0 )
      BEGIN
        set @pret_val = -1 
        RETURN
      END

    end 

    FETCH NEXT FROM ta_wbs INTO @vwbs_id, @vparent_wbs_id
  END
  CLOSE ta_wbs
  DEALLOCATE ta_wbs
  
go
--METADATA NAME:TIME_APPROVAL_WBS TYPE:GRANT TABLE_NAME:TIME_APPROVAL_WBS CHANGE:CREATE
GRANT EXECUTE ON TIME_APPROVAL_WBS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PV_WBS_ROOT_PROC_CAND'

--METADATA  TYPE:SSCR NAME:PV_WBS_ROOT_PROC_CAND OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PV_WBS_ROOT_PROC_CAND' and type in ('P'))
  DROP PROCEDURE PV_WBS_ROOT_PROC_CAND
go
--METADATA NAME:PV_WBS_ROOT_PROC_CAND TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE PROCEDURE PV_WBS_ROOT_PROC_CAND
@puser_id int, @pwbs_id int, @pret_val int OUTPUT
WITH ENCRYPTION AS
  declare @pwid int, @oid int,  @cnt int

  set @pret_val = 0;

  select @pwid=parent_wbs_id , @oid=obs_id
  from projwbs
  where wbs_id = @pwbs_id
  and delete_session_id is null;
  if @@ROWCOUNT=0 
    RETURN;

  select @cnt=count(*) 
  from profpriv pv, userobs uo
  where uo.user_id = @puser_id
  and uo.obs_id = @oid
  and uo.prof_id = pv.prof_id
  and pv.priv_num = 12 and pv.allow_flag = 'Y'  
  and uo.delete_session_id is null and pv.delete_session_id is null;

  if @cnt > 0 
  begin
    set @pret_val = 1
    return
  end
  else
  begin
    exec pv_wbs_root_proc_cand  @puser_id, @pwid, @pret_val OUTPUT
  end
go
--METADATA NAME:PV_WBS_ROOT_PROC_CAND TYPE:GRANT TABLE_NAME:PV_WBS_ROOT_PROC_CAND CHANGE:CREATE
GRANT EXECUTE ON PV_WBS_ROOT_PROC_CAND TO ${pm.ss.privileged_user}
go
print 'Creating procedure PV_WBS_ROOT_NODES'

--METADATA  TYPE:SSCR NAME:PV_WBS_ROOT_NODES OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PV_WBS_ROOT_NODES' and type in ('P'))
  DROP PROCEDURE PV_WBS_ROOT_NODES
go
--METADATA NAME:PV_WBS_ROOT_NODES TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE PROCEDURE PV_WBS_ROOT_NODES
@puser_id int, @pwbs_list varchar(4000) OUTPUT, 
@pwbs_list2 varchar(4000) OUTPUT , @pret_val int OUTPUT , @pret_msg varchar OUTPUT
WITH ENCRYPTION AS

  DECLARE ua CURSOR LOCAL FOR 
  select pw.proj_id, pw.wbs_id, project_flag
  from project p, uaccess ua , projwbs pw
  where ua.user_id = @puser_id
  and pw.proj_id = ua.proj_id
  and pw.proj_node_flag = 'Y'
  and p.proj_id = pw.proj_id
  and pw.delete_session_id is null and p.delete_session_id is null
  and not exists ( select * from uaccess ua2, projwbs pw2
           where user_id = @puser_id
           and ua2.proj_id = pw2.proj_id
           and pw.proj_node_flag = 'Y'
           and pw2.wbs_id = pw.parent_wbs_id 
           and pw2.delete_session_id is null);
  
  DECLARE cr CURSOR LOCAL FOR 
  select pw.wbs_id, pw.parent_wbs_id
  from profpriv pv, userobs uo, uaccess ua , projwbs pw
  where ua.user_id = @puser_id
  and pw.proj_id = ua.proj_id and pw.obs_id = uo.obs_id
  and uo.user_id = @puser_id and uo.prof_id = pv.prof_id
  and pv.priv_num = 12 and pv.allow_flag = 'Y'
  and pw.delete_session_id is null and pv.delete_session_id is null and uo.delete_session_id is null
  and not exists ( select *
           from profpriv pv, userobs uo,uaccess ua2, projwbs pw2
            where ua2.user_id = @puser_id
            and ua2.proj_id = pw2.proj_id and pw2.obs_id = uo.obs_id
            and uo.user_id = @puser_id and uo.prof_id = pv.prof_id
            and pv.priv_num = 12 and pv.allow_flag = 'Y'
            and pw2.wbs_id = pw.parent_wbs_id
            and pw2.delete_session_id is null and pv.delete_session_id is null and uo.delete_session_id is null);

  declare @cnt  int, @cntList2 int, @vstepmsg  varchar(60)
  declare @vproj_id int, @vwbs_id int, @vproject_flag varchar(1), @vparent_wbs_id int

  set @pwbs_list = null
  set @pwbs_list2 = null;
  set @cntList2 =0

  set @vstepmsg = 'POPULATE_UACCESS procedure.';
  exec populate_uaccess @puser_id, @pret_val OUTPUT

  if @pret_val <> 0 
  begin
   set @pret_msg = 'Error running POPULATE_UACCESS procedure'
   return
  end

  set @vstepmsg = ' project node query loop.'

  OPEN ua
  FETCH NEXT FROM ua INTO @vproj_id, @vwbs_id , @vproject_flag
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    print @vwbs_id
    if @pwbs_list is null
      set @pwbs_list = convert(varchar(10),@vwbs_id)
    else
      set @pwbs_list = @pwbs_list +','+ convert(varchar(10),@vwbs_id)

    FETCH NEXT FROM ua INTO @vproj_id, @vwbs_id , @vproject_flag
  END
  CLOSE ua
  DEALLOCATE ua

  set @vstepmsg = 'candidate financial node query loop.'

  OPEN cr
  FETCH NEXT FROM cr INTO  @vwbs_id , @vparent_wbs_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    exec pv_wbs_root_proc_cand @puser_id, @vparent_wbs_id , @pret_val OUTPUT
    if @pret_val = 0 
    BEGIN
      set @cntList2 = @cntList2 + 1
      if @pwbs_list2 is null
        set @pwbs_list2 = convert(varchar(10),@vwbs_id)
      else
        set @pwbs_list2 = @pwbs_list2 +','+ convert(varchar(10),@vwbs_id)
    END
    FETCH NEXT FROM cr INTO  @vwbs_id , @vparent_wbs_id
  END
  CLOSE cr
  DEALLOCATE cr
  
go
--METADATA NAME:PV_WBS_ROOT_NODES TYPE:GRANT TABLE_NAME:PV_WBS_ROOT_NODES CHANGE:CREATE
GRANT EXECUTE ON PV_WBS_ROOT_NODES TO ${pm.ss.privileged_user}
go
print 'Creating procedure WBS_TREE_HAS_RSRC_ASSGN'

--METADATA  TYPE:SSCR NAME:WBS_TREE_HAS_RSRC_ASSGN OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBS_TREE_HAS_RSRC_ASSGN' and type in ('P'))
  DROP PROCEDURE WBS_TREE_HAS_RSRC_ASSGN
go
--METADATA NAME:WBS_TREE_HAS_RSRC_ASSGN TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE PROCEDURE WBS_TREE_HAS_RSRC_ASSGN
  (@pwbs_id int, @prsrc_id int, @pret_val int OUTPUT, @pret_msg VARCHAR(1000) OUTPUT)
WITH ENCRYPTION AS
  set nocount on
  declare  @v_child_wbs_id INT, @wbsrsrc_cnt INT

  BEGIN
    set @pret_val = 0
    set @wbsrsrc_cnt = 0
   
    if @prsrc_id = -1
    BEGIN
      set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
      where wbs_id = @pwbs_id
      and delete_session_id is null)
    END
    ELSE
    BEGIN
      set @wbsrsrc_cnt =  (select count(*) from wbsrsrc 
      where wbs_id = @pwbs_id
      and rsrc_id = @prsrc_id
      and delete_session_id is null)
    END

    if @wbsrsrc_cnt != 0
    BEGIN
      set @pret_msg = 'WBS Resource Assignments found'
      set @pret_val = 1
      return
    END
  
    set @pret_val = 0
    set @wbsrsrc_cnt = 0 

    DECLARE rChildCur CURSOR LOCAL FOR 
    select wbs_id 
    from projwbs
    where parent_wbs_id = @pwbs_id
    and delete_session_id is null;

    OPEN rChildCur
    FETCH NEXT FROM rChildCur INTO @v_child_wbs_id
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      if @prsrc_id = -1 
      BEGIN
        set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
        where wbs_id = @v_child_wbs_id
        and delete_session_id is null)
      END
      ELSE
      BEGIN
        set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
        where wbs_id = @v_child_wbs_id
        and rsrc_id = @prsrc_id
        and delete_session_id is null)
      END

      if @wbsrsrc_cnt != 0
      BEGIN
        set @pret_msg = 'WBS Resource Assignments found'
        set @pret_val = 1
        return
      END
      ELSE
      BEGIN
        exec wbs_tree_has_rsrc_assgn @v_child_wbs_id, @prsrc_id, @pret_val OUTPUT, @pret_msg OUTPUT 

        if @pret_val <> 0 
        BEGIN 
          return
        END 

       FETCH NEXT FROM rChildCur INTO @v_child_wbs_id
      END
    END
    CLOSE rChildCur
    DEALLOCATE rChildCur


  END
go
--METADATA NAME:WBS_TREE_HAS_RSRC_ASSGN TYPE:GRANT TABLE_NAME:WBS_TREE_HAS_RSRC_ASSGN CHANGE:CREATE
GRANT EXECUTE ON WBS_TREE_HAS_RSRC_ASSGN TO ${pm.ss.privileged_user}
go
print 'Creating procedure WBS_TREE_HAS_ROLE_ASSGN'

--METADATA  TYPE:SSCR NAME:WBS_TREE_HAS_ROLE_ASSGN OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBS_TREE_HAS_ROLE_ASSGN' and type in ('P'))
  DROP PROCEDURE WBS_TREE_HAS_ROLE_ASSGN
go
--METADATA NAME:WBS_TREE_HAS_ROLE_ASSGN TYPE:PROCEDURE SET:PV_NODE_PROCS CHANGE:CREATE
CREATE PROCEDURE WBS_TREE_HAS_ROLE_ASSGN
  (@pwbs_id int, @prole_id int, @pret_val int OUTPUT, @pret_msg VARCHAR(1000) OUTPUT)
WITH ENCRYPTION AS
  set nocount on
  declare  @v_child_wbs_id INT, @wbsrsrc_cnt INT

  BEGIN
    set @pret_val = 0
    set @wbsrsrc_cnt = 0
   
    if @prole_id = -1
    BEGIN
      set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
      where wbs_id = @pwbs_id
      and delete_session_id is null)
    END
    ELSE
    BEGIN
      set @wbsrsrc_cnt =  (select count(*) from wbsrsrc 
      where wbs_id = @pwbs_id
      and role_id = @prole_id
      and delete_session_id is null)
    END

    if @wbsrsrc_cnt != 0
    BEGIN
      set @pret_msg = 'WBS Role Assignments found'
      set @pret_val = 1
      return
    END
  
    set @pret_val = 0
    set @wbsrsrc_cnt = 0 

    DECLARE rChildCur CURSOR LOCAL FOR 
    select wbs_id 
    from projwbs
    where parent_wbs_id = @pwbs_id
    and delete_session_id is null;

    OPEN rChildCur
    FETCH NEXT FROM rChildCur INTO @v_child_wbs_id
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      if @prole_id = -1 
      BEGIN
        set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
        where wbs_id = @v_child_wbs_id
        and delete_session_id is null)
      END
      ELSE
      BEGIN
        set @wbsrsrc_cnt = (select count(*) from wbsrsrc 
        where wbs_id = @v_child_wbs_id
        and role_id = @prole_id
        and delete_session_id is null)
      END

      if @wbsrsrc_cnt != 0
      BEGIN
        set @pret_msg = 'WBS Role Assignments found'
        set @pret_val = 1
        return
      END
      ELSE
      BEGIN
        exec wbs_tree_has_rsrc_assgn @v_child_wbs_id, @prole_id, @pret_val OUTPUT, @pret_msg OUTPUT 

        if @pret_val <> 0 
        BEGIN 
          return
        END 

       FETCH NEXT FROM rChildCur INTO @v_child_wbs_id
      END
    END
    CLOSE rChildCur
    DEALLOCATE rChildCur


  END
go
--METADATA NAME:WBS_TREE_HAS_ROLE_ASSGN TYPE:GRANT TABLE_NAME:WBS_TREE_HAS_ROLE_ASSGN CHANGE:CREATE
GRANT EXECUTE ON WBS_TREE_HAS_ROLE_ASSGN TO ${pm.ss.privileged_user}
go
print 'Creating procedure DB_TO_IANA_CHARSET'

--METADATA  TYPE:SSCR NAME:DB_TO_IANA_CHARSET OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DB_TO_IANA_CHARSET' and type in ('P'))
  DROP PROCEDURE DB_TO_IANA_CHARSET
go
--METADATA NAME:DB_TO_IANA_CHARSET TYPE:PROCEDURE SET:I18N_PROCS CHANGE:CREATE
CREATE PROCEDURE DB_TO_IANA_CHARSET
( @pcharset varchar(100) OUT )
WITH ENCRYPTION AS
  declare @servercollation sysname
  declare @verstr varchar(4), @dbname sysname, @sql nvarchar(1000)
  
  select @verstr = substring(replace(@@version,' ',''),19,4)

  select @dbname=name from master..sysdatabases 
  where dbid = (select dbid from master..sysprocesses where spid = @@spid)

  set @pcharset = 'ISO-8859-1'
    set @sql = N'select @sc = upper(convert(sysname, databasepropertyex('''+@dbname+''',''collation'')))';
    EXEC sp_executesql  @sql, N'@sc sysname OUTPUT', @servercollation OUT;

    print @servercollation  
    if @servercollation like 'CYRILLIC%'
      set @pcharset = 'windows-1251'
    else if @servercollation like 'JAPANESE%'
      set @pcharset = 'Shift_JIS'
    else if @servercollation like 'KOREAN%'
      set @pcharset = 'EUC-KR'
    else if @servercollation like 'CHINESE_PRC%'
      set @pcharset = 'GBK'
    else if @servercollation like 'CHINESE_TAIWAN%'
      set @pcharset = 'BIG5'
    else if @servercollation like 'ARABIC%'
      set @pcharset = 'ISO-8859-6'
    else if @servercollation like 'HEBREW%'
      set @pcharset = 'ISO-8859-8'
    else if @servercollation like 'TURKISH%'
      set @pcharset = 'windows-1254'
    else if @servercollation like 'GREEK%'
      set @pcharset = 'ISO-8859-7'
    else if @servercollation like 'ESTONIAN%' or
            @servercollation like 'LATVIAN%' or
            @servercollation like 'LITHUANIAN%' 
      set @pcharset = 'windows-1257'
    else if @servercollation like 'CZECH%' or
            @servercollation like 'ALBANIAN%' or
            @servercollation like 'CROATIAN%' or
            @servercollation like 'HUNGARIAN%' or
            @servercollation like 'POLISH%' or
            @servercollation like 'ROMANIAN%' or
            @servercollation like 'SLOVAK%' or
            @servercollation like 'SLOVENIAN%'
      set @pcharset = 'windows-1250'
    else if @servercollation like 'VIETNAMESE%'
      set @pcharset = 'windows-1258'

go
--METADATA NAME:DB_TO_IANA_CHARSET TYPE:GRANT TABLE_NAME:DB_TO_IANA_CHARSET CHANGE:CREATE
GRANT EXECUTE ON DB_TO_IANA_CHARSET TO ${pm.ss.privileged_user}
go
print 'Creating procedure SET_REFRDEL_PROJECT_BYPASS'

--METADATA  TYPE:SSCR NAME:SET_REFRDEL_PROJECT_BYPASS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SET_REFRDEL_PROJECT_BYPASS' and type in ('P'))
  DROP PROCEDURE SET_REFRDEL_PROJECT_BYPASS
go
--METADATA NAME:SET_REFRDEL_PROJECT_BYPASS TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE PROCEDURE SET_REFRDEL_PROJECT_BYPASS
	(@val	integer)

WITH ENCRYPTION AS
begin
declare @cnt integer
  select @cnt=count(*) from spidmap where spid = @@spid
   if @cnt = 0
    insert into spidmap (spid,refrdel_project_bypass)
    values(@@spid,@val)
   ELSE
    update spidmap
    set refrdel_project_bypass = @val
    where spid = @@spid 
END
go
--METADATA NAME:SET_REFRDEL_PROJECT_BYPASS TYPE:GRANT TABLE_NAME:SET_REFRDEL_PROJECT_BYPASS CHANGE:CREATE
GRANT EXECUTE ON SET_REFRDEL_PROJECT_BYPASS TO ${pm.ss.privileged_user}
go
print 'Creating procedure GET_SAFETY_DATE'

--METADATA  TYPE:SSCR NAME:GET_SAFETY_DATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_SAFETY_DATE' and type in ('P'))
  DROP PROCEDURE GET_SAFETY_DATE
go
--METADATA NAME:GET_SAFETY_DATE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE PROCEDURE GET_SAFETY_DATE
	@psafety_date	datetime OUTPUT,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT
WITH ENCRYPTION AS
declare @currtime datetime
set @currtime=getDate()
set @pret_val = 0
select @psafety_date = min(login_time)  from master..sysprocesses where dbid in (
select dbid from master..sysprocesses
where spid = @@spid)
and open_tran > 0

if @psafety_date is null 
  set @psafety_date = @currtime
go
--METADATA NAME:GET_SAFETY_DATE TYPE:GRANT TABLE_NAME:GET_SAFETY_DATE CHANGE:CREATE
GRANT EXECUTE ON GET_SAFETY_DATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure POPULATE_DELAYED_LOADING'

--METADATA  TYPE:SSCR NAME:POPULATE_DELAYED_LOADING OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'POPULATE_DELAYED_LOADING' and type in ('P'))
  DROP PROCEDURE POPULATE_DELAYED_LOADING
go
--METADATA NAME:POPULATE_DELAYED_LOADING TYPE:PROCEDURE SET:DL_PROC CHANGE:CREATE
CREATE PROCEDURE POPULATE_DELAYED_LOADING
	@psession_id	integer,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT,
        @pchange_bits   varchar(255) = 'ALL'
WITH ENCRYPTION AS
  set nocount on 
  set transaction isolation level READ UNCOMMITTED 
  declare @updated_rsrc bit, @updated_role bit, @updated_obs bit, @user_id int
  declare @sid int
  set @sid=@psession_id

  set @updated_rsrc = 0
  set @updated_role = 0
  set @updated_obs = 0
  if @pchange_bits = 'ALL' 
     or substring(@pchange_bits,72,1) = '1'		--task
     or substring(@pchange_bits,80,1) = '1'		--taskrsrc
     or substring(@pchange_bits,42,1) = '1'		--projrisk
     or substring(@pchange_bits,37,1) = '1'		--projest
     or substring(@pchange_bits,39,1) = '1'		--projissu
     or substring(@pchange_bits,119,1) = '1'		--wbsrsrc
  begin
    set @updated_rsrc = 1
    delete from dltrsrc where session_id = @sid;
  
    insert into DLTRSRC (session_id, rsrc_id)  
    SELECT @sid, IsNull(rsrc_id,0) FROM  projshar ps inner loop join task t 
    ON ps.proj_id = t.proj_id and ps.session_id = @sid
    UNION SELECT @sid, IsNull(rsrc_id,0) FROM  projshar ps inner loop join taskrsrc tr 
    ON ps.proj_id = tr.proj_id and ps.session_id = @sid
    UNION SELECT @sid, IsNull(rsrc_id,0) FROM projshar ps inner loop join projest pe
    ON ps.proj_id = pe.proj_id and ps.session_id = @sid
    UNION SELECT @sid, IsNull(rsrc_id,0) FROM projshar ps inner loop join projissu pi
    ON ps.proj_id = pi.proj_id and ps.session_id = @sid
    UNION SELECT @sid, IsNull(rsrc_id,0) FROM projshar ps inner loop join wbsrsrc wr
    ON ps.proj_id = wr.proj_id and ps.session_id = @sid

  end

  if @pchange_bits = 'ALL' or @updated_rsrc = 1
     or substring(@pchange_bits,80,1) = '1'		--taskrsrc
     or substring(@pchange_bits,119,1) = '1'		--wbsrsrc
  begin
    set @updated_role = 1
    delete from dltrole where session_id = @sid;
 
    insert into DLTROLE (session_id, role_id)  
    SELECT @sid, IsNull(role_id,0) FROM projshar ps inner loop join taskrsrc tr
    ON ps.proj_id = tr.proj_id and ps.session_id = @sid
    UNION SELECT @sid, IsNull(role_id,0) FROM dltrsrc dr inner loop join rsrc r 
    ON r.rsrc_id = dr.rsrc_id and dr.session_id = @sid
    UNION SELECT @sid, IsNull(role_id,0) FROM  dltrsrc dr inner loop join rsrcrole rs
    ON rs.rsrc_id = dr.rsrc_id and  rs.role_id IS NOT NULL and dr.session_id = @sid
    UNION SELECT @sid, IsNull(role_id,0) FROM PROJSHAR ps inner loop join wbsrsrc wr 
    ON ps.proj_id = wr.proj_id and ps.session_id = @sid;

  end

  if @pchange_bits = 'ALL' or @updated_rsrc = 1 or @updated_role = 1 
  begin
    delete from dltrsrl where session_id = @sid;
 
    insert into DLTRSRL (session_id, rsrc_id, role_id)  
    SELECT @sid, rr.rsrc_id, rr.role_id FROM dltrole drl inner loop join rsrcrole rr
    ON rr.role_id = drl.role_id and drl.session_id = @sid
    UNION SELECT @sid, rr.rsrc_id, rr.role_id FROM dltrsrc dr inner loop join rsrcrole rr
    ON rr.rsrc_id = dr.rsrc_id and dr.session_id = @sid
  end

  if @pchange_bits = 'ALL'
     or substring(@pchange_bits,45,1) = '1'		--projwbs
     or substring(@pchange_bits,42,1) = '1'		--projrisk
     or substring(@pchange_bits,44,1) = '1'		--projthrs
     or substring(@pchange_bits,39,1) = '1'		--projissu
  begin
    set @updated_obs = 1
    delete from dltobs where session_id = @sid;
 
    insert into DLTOBS (session_id, obs_id)  
    SELECT @sid, obs_id from projwbs pw, projshar ps where ps.proj_id = pw.proj_id and session_id = @sid    
    UNION SELECT @sid, obs_id from projissu pi, projshar ps where ps.proj_id = pi.proj_id and session_id = @sid    
    UNION SELECT @sid, obs_id from projthrs pt, projshar ps where ps.proj_id = pt.proj_id and session_id = @sid    
  end

  if @pchange_bits = 'ALL'
     or substring(@pchange_bits,36,1) = '1'		--project
     or substring(@pchange_bits,80,1) = '1'		--taskrsrc
     or substring(@pchange_bits,35,1) = '1'		--projcost
  begin
    delete from dltacct where session_id = @sid;
 
    insert into DLTACCT (session_id, acct_id)  
    SELECT @sid, IsNull(acct_id,0) from projshar ps inner loop join taskrsrc tr
    ON ps.proj_id = tr.proj_id and session_id = @sid
    UNION SELECT @sid, IsNull(acct_id,0) from projshar ps inner loop join project p
    ON ps.proj_id = p.proj_id and session_id = @sid
    UNION SELECT @sid, IsNull(acct_id,0) from projshar ps inner loop join projcost pc
    ON ps.proj_id = pc.proj_id and session_id = @sid
  end

  if @pchange_bits = 'ALL' or @updated_obs = 1
     or substring(@pchange_bits,62,1) = '1'		--rsrc
     or substring(@pchange_bits,97,1) = '1'		--userobs
  begin
    select @user_id=user_id from usession where session_id = @sid;

    delete from dltuser where session_id = @sid;
 
    insert into DLTUSER (session_id, user_id)  
    SELECT @sid, IsNull(@user_id,0)
    UNION SELECT @sid, IsNull(user_id,0) from dltrsrc dr, rsrc r
    where dr.rsrc_id = r.rsrc_id and session_id = @sid
    UNION SELECT @sid, IsNull(ts_approve_user_id,0) from dltrsrc dr, rsrc r
    where dr.rsrc_id = r.rsrc_id and session_id = @sid
    UNION SELECT @sid, user_id from dltobs dr, userobs uo
    where uo.obs_id = dr.obs_id and session_id = @sid
  end

  if @pchange_bits = 'ALL' 
     or substring(@pchange_bits,73,1) = '1'		--taskactv
     or substring(@pchange_bits,2,1) = '1'		--actvcode
     or substring(@pchange_bits,3,1) = '1'		--actvtype
  begin
    delete from dltactv where session_id = @sid;

  insert into DLTACTV (session_id, actv_code_id,parent_actv_code_id)  
    SELECT @sid, ac.actv_code_id,ac.parent_actv_code_id from  projshar ps inner loop join taskactv ta
    on ps.proj_id = ta.proj_id and session_id = @sid,actvcode ac where ac.actv_code_id=ta.actv_code_id
    UNION SELECT @sid, actv_code_id,parent_actv_code_id from projshar ps inner loop join actvtype at 
          on session_id = @sid and ps.proj_id = at.proj_id
    , actvcode ac
    where ac.actv_code_type_id = at.actv_code_type_id 
  end

  set @pret_val=0
go
--METADATA NAME:POPULATE_DELAYED_LOADING TYPE:GRANT TABLE_NAME:POPULATE_DELAYED_LOADING CHANGE:CREATE
GRANT EXECUTE ON POPULATE_DELAYED_LOADING TO ${pm.ss.privileged_user}
go
print 'Creating procedure GLOBAL_TABLE_CHANGE'

--METADATA  TYPE:SSCR NAME:GLOBAL_TABLE_CHANGE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GLOBAL_TABLE_CHANGE' and type in ('P'))
  DROP PROCEDURE GLOBAL_TABLE_CHANGE
go
--METADATA NAME:GLOBAL_TABLE_CHANGE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE PROCEDURE GLOBAL_TABLE_CHANGE
	@pTS		datetime,
	@pchange_bits	varchar(350) OUTPUT,
	@psafety_date	datetime OUTPUT,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT
WITH ENCRYPTION AS
  declare @vCnt tinyint;
  set @pret_val = -1
  exec get_safety_date  @psafety_date OUTPUT, @pret_val OUTPUT,@pret_msg OUTPUT
  set @pchange_bits = '0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
        select @vCnt=count(*) where exists (select * from ACCOUNT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,1,1,'1') 
        select @vCnt=count(*) where exists (select * from ACTVCODE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,2,1,'1') 
        select @vCnt=count(*) where exists (select * from ACTVTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,3,1,'1') 
        select @vCnt=count(*) where exists (select * from ADMIN_CONFIG where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,4,1,'1') 
        select @vCnt=count(*) where exists (select * from ASGNMNTACAT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,249,1,'1') 
        select @vCnt=count(*) where exists (select * from ASGNMNTCATTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,248,1,'1') 
        select @vCnt=count(*) where exists (select * from ASGNMNTCATVAL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,247,1,'1') 
        select @vCnt=count(*) where exists (select * from BASETYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,5,1,'1') 
        select @vCnt=count(*) where exists (select * from CALENDAR where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,8,1,'1') 
        select @vCnt=count(*) where exists (select * from COSTTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,9,1,'1') 
        select @vCnt=count(*) where exists (select * from CURRTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,10,1,'1') 
        select @vCnt=count(*) where exists (select * from DASHBOARD where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,147,1,'1') 
        select @vCnt=count(*) where exists (select * from DASHUSER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,133,1,'1') 
        select @vCnt=count(*) where exists (select * from DISCUSSION where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,215,1,'1') 
        select @vCnt=count(*) where exists (select * from DISCUSSION_READ where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,216,1,'1') 
        select @vCnt=count(*) where exists (select * from DOCCATG where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,11,1,'1') 
        select @vCnt=count(*) where exists (select * from DOCREVIEW where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,193,1,'1') 
        select @vCnt=count(*) where exists (select * from DOCREVIEWTASK where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,194,1,'1') 
        select @vCnt=count(*) where exists (select * from DOCSTAT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,12,1,'1') 
        select @vCnt=count(*) where exists (select * from EXPPROJ where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,129,1,'1') 
        select @vCnt=count(*) where exists (select * from EXTAPP where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,14,1,'1') 
        select @vCnt=count(*) where exists (select * from FACTOR where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,15,1,'1') 
        select @vCnt=count(*) where exists (select * from FACTVAL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,16,1,'1') 
        select @vCnt=count(*) where exists (select * from FILTPROP where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,17,1,'1') 
        select @vCnt=count(*) where exists (select * from FINDATES where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,115,1,'1') 
        select @vCnt=count(*) where exists (select * from FINTMPL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,246,1,'1') 
        select @vCnt=count(*) where exists (select * from FUNDSRC where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,18,1,'1') 
        select @vCnt=count(*) where exists (select * from GCHANGE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,19,1,'1') 
        select @vCnt=count(*) where exists (select * from IMAGEDATA where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,238,1,'1') 
        select @vCnt=count(*) where exists (select * from JOBLOG where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,189,1,'1') 
        select @vCnt=count(*) where exists (select * from JOBRPT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,130,1,'1') 
        select @vCnt=count(*) where exists (select * from JOBSVC where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,21,1,'1') 
        select @vCnt=count(*) where exists (select * from MEMOTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,22,1,'1') 
        select @vCnt=count(*) where exists (select * from NONWORK where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,24,1,'1') 
        select @vCnt=count(*) where exists (select * from NOTE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,156,1,'1') 
        select @vCnt=count(*) where exists (select * from OBS where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,25,1,'1') 
        select @vCnt=count(*) where exists (select * from PCATTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,26,1,'1') 
        select @vCnt=count(*) where exists (select * from PCATUSER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,27,1,'1') 
        select @vCnt=count(*) where exists (select * from PCATVAL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,28,1,'1') 
        select @vCnt=count(*) where exists (select * from PFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,29,1,'1') 
        select @vCnt=count(*) where exists (select * from PFOLIOUSER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,242,1,'1') 
        select @vCnt=count(*) where exists (select * from PHASE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,30,1,'1') 
        select @vCnt=count(*) where exists (select * from POBS where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,132,1,'1') 
        select @vCnt=count(*) where exists (select * from PREFER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,32,1,'1') 
        select @vCnt=count(*) where exists (select * from PROCGROUP where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,113,1,'1') 
        select @vCnt=count(*) where exists (select * from PROCITEM where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,114,1,'1') 
        select @vCnt=count(*) where exists (select * from PROFILE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,33,1,'1') 
        select @vCnt=count(*) where exists (select * from PROFPRIV where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,34,1,'1') 
        select @vCnt=count(*) where exists (select * from PROJECT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,36,1,'1') 
        select @vCnt=count(*) where exists (select * from PROJPCAT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,40,1,'1') 
        select @vCnt=count(*) where exists (select * from PROJWBS where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,45,1,'1') 
        select @vCnt=count(*) where exists (select * from PRPFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,46,1,'1') 
        select @vCnt=count(*) where exists (select * from RCATTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,48,1,'1') 
        select @vCnt=count(*) where exists (select * from RCATVAL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,49,1,'1') 
        select @vCnt=count(*) where exists (select * from RFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,52,1,'1') 
        select @vCnt=count(*) where exists (select * from RISKTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,54,1,'1') 
        select @vCnt=count(*) where exists (select * from RLFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,55,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLECATTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,244,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLECATVAL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,243,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLELIMIT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,57,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLERATE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,126,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLERCAT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,245,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLES where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,81,1,'1') 
        select @vCnt=count(*) where exists (select * from ROLFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,56,1,'1') 
        select @vCnt=count(*) where exists (select * from RPT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,58,1,'1') 
        select @vCnt=count(*) where exists (select * from RPTBATCH where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,59,1,'1') 
        select @vCnt=count(*) where exists (select * from RPTGROUP where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,60,1,'1') 
        select @vCnt=count(*) where exists (select * from RPTLIST where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,61,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRC where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,62,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCANDASH where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,151,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCANVIEW where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,149,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCCURV where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,63,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCRATE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,66,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCRCAT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,67,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCROLE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,68,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRCSEC where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,112,1,'1') 
        select @vCnt=count(*) where exists (select * from RSRFOLIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,69,1,'1') 
        select @vCnt=count(*) where exists (select * from SCENARIO where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,143,1,'1') 
        select @vCnt=count(*) where exists (select * from SCENPROJ where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,145,1,'1') 
        select @vCnt=count(*) where exists (select * from SCENROLE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,165,1,'1') 
        select @vCnt=count(*) where exists (select * from SCENUSER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,157,1,'1') 
	 select @vCnt=count(*) where exists ( select * from SETTINGS where namespace not like 'database%' and update_date > @pTS);
	  if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,134,1,'1')
        select @vCnt=count(*) where exists (select * from SHIFT where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,70,1,'1') 
        select @vCnt=count(*) where exists (select * from SHIFTPER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,71,1,'1') 
        select @vCnt=count(*) where exists (select * from TASKSUM where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,142,1,'1') 
        select @vCnt=count(*) where exists (select * from TASKSUMFIN where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,169,1,'1') 
        select @vCnt=count(*) where exists (select * from TRAKVIEW where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,86,1,'1') 
        select @vCnt=count(*) where exists (select * from TRSRCSUM where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,87,1,'1') 
        select @vCnt=count(*) where exists (select * from TRSRCSUMFN where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,170,1,'1') 
        select @vCnt=count(*) where exists (select * from TSDATES where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,88,1,'1') 
        select @vCnt=count(*) where exists (select * from TSDELEGATE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,171,1,'1') 
        select @vCnt=count(*) where exists (select * from UDFCODE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,111,1,'1') 
        select @vCnt=count(*) where exists (select * from UDFTYPE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,90,1,'1') 
        select @vCnt=count(*) where exists (select * from UDFVALUE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,91,1,'1') 
        select @vCnt=count(*) where exists (select * from UMEASURE where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,92,1,'1') 
        select @vCnt=count(*) where exists (select * from USERCOL where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,94,1,'1') 
        select @vCnt=count(*) where exists (select * from USERDATA where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,95,1,'1') 
        select @vCnt=count(*) where exists (select * from USERENG where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,96,1,'1') 
        select @vCnt=count(*) where exists (select * from USEROBS where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,97,1,'1') 
        select @vCnt=count(*) where exists (select * from USERS where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,98,1,'1') 
        select @vCnt=count(*) where exists (select * from VIEWPREF where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,155,1,'1') 
        select @vCnt=count(*) where exists (select * from VIEWPROP where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,101,1,'1') 
        select @vCnt=count(*) where exists (select * from VWPREFDASH where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,168,1,'1') 
        select @vCnt=count(*) where exists (select * from VWPREFDATA where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,153,1,'1') 
        select @vCnt=count(*) where exists (select * from VWPREFUSER where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,154,1,'1') 
        select @vCnt=count(*) where exists (select * from WBSBUDG where update_date > @pTS );
          if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,102,1,'1') 
  set @pret_val = 0
go
--METADATA NAME:GLOBAL_TABLE_CHANGE TYPE:GRANT TABLE_NAME:GLOBAL_TABLE_CHANGE CHANGE:CREATE
GRANT EXECUTE ON GLOBAL_TABLE_CHANGE TO ${pm.ss.privileged_user}
go
print 'Creating procedure OPEN_TABLE_CHANGE'

--METADATA  TYPE:SSCR NAME:OPEN_TABLE_CHANGE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPEN_TABLE_CHANGE' and type in ('P'))
  DROP PROCEDURE OPEN_TABLE_CHANGE
go
--METADATA NAME:OPEN_TABLE_CHANGE TYPE:PROCEDURE SET:REFRESH_UTILS CHANGE:CREATE
CREATE PROCEDURE OPEN_TABLE_CHANGE
	@pTS		datetime,
	@psession_id integer,
	@pload_status varchar(1),
	@pchange_bits	varchar(255) OUTPUT,
	@psafety_date	datetime OUTPUT,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT
WITH ENCRYPTION AS
  declare @vCnt tinyint;
  set @pret_val = -1
  exec get_safety_date  @psafety_date OUTPUT, @pret_val OUTPUT,@pret_msg OUTPUT
  set @pchange_bits = '0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	select @vCnt=count(*) where exists ( select * from ACTVCODE t, ACTVTYPE A, PROJSHAR p where t.update_date > @pTS 
			and a.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status 
			and a.actv_code_type_id = t.actv_code_type_id);
  if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,2,1,'1')
	select @vCnt=count(*) where exists ( select * from ACTVTYPE t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,3,1,'1')
	select @vCnt=count(*) where exists ( select * from BUDGCHNG t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,7,1,'1')
	select @vCnt=count(*) where exists ( select * from CALENDAR t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,8,1,'1')
	select @vCnt=count(*) where exists ( select * from DOCUMENT t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,13,1,'1')
	select @vCnt=count(*) where exists ( select * from EXPPROJ t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,129,1,'1')
	select @vCnt=count(*) where exists ( select * from EXTAPP t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,14,1,'1')
	select @vCnt=count(*) where exists ( select * from ISSUHIST t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,20,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJCOST t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,35,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJECT t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,36,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJEST t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,37,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJFUND t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,38,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJISSU t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,39,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJPROP t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,41,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJRISK t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,42,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJTHRS t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,44,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJWBS t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,45,1,'1')
	select @vCnt=count(*) where exists ( select * from PROJWSRPT t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,131,1,'1')
	select @vCnt=count(*) where exists ( select * from RISKCTRL t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,53,1,'1')
	select @vCnt=count(*) where exists ( select * from RPT t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,58,1,'1')
	select @vCnt=count(*) where exists ( select * from TASK t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,72,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKACTV t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,73,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKDOC t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,74,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKFDBK t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,75,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKFIN t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,116,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKMEMO t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,76,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKNOTE t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,77,1,'1')
	select @vCnt=count(*) where  exists ( select * from TASKPRED t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );  
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,78,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKPRED t, PROJSHAR p where update_date > @pTS 
			and t.pred_proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
  if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,78,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKPROC t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,79,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKRISK t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,178,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKRSRC t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,80,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKSUM t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,142,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKSUMFIN t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,169,1,'1')
	select @vCnt=count(*) where exists ( select * from TASKUSER t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,164,1,'1')
	select @vCnt=count(*) where exists ( select * from TRSRCFIN t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,117,1,'1')
	select @vCnt=count(*) where exists ( select * from TRSRCSUM t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,87,1,'1')
	select @vCnt=count(*) where exists ( select * from TRSRCSUMFN t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,170,1,'1')
	select @vCnt=count(*) where exists ( select * from UDFVALUE t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,91,1,'1')
	select @vCnt=count(*) where exists ( select * from WBSBUDG t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,102,1,'1')
	select @vCnt=count(*) where exists ( select * from WBSMEMO t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,103,1,'1')
	select @vCnt=count(*) where exists ( select * from WBSRSRC t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,109,1,'1')
	select @vCnt=count(*) where exists ( select * from WBSSTEP t, PROJSHAR p where update_date > @pTS 
			and t.proj_id = p.proj_id and p.session_id = @psession_id and p.load_status = @pload_status );
	if @vCnt = 1 	set @pChange_bits = stuff(@pChange_bits,104,1,'1')
         --Run delayed loading procedure if this is PM
		exec populate_delayed_loading @psession_id,@pret_val output, @pret_msg output , @pchange_bits
  
go
--METADATA NAME:OPEN_TABLE_CHANGE TYPE:GRANT TABLE_NAME:OPEN_TABLE_CHANGE CHANGE:CREATE
GRANT EXECUTE ON OPEN_TABLE_CHANGE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CHECK_LAST_SUMM'

--METADATA  TYPE:SSCR NAME:CHECK_LAST_SUMM OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHECK_LAST_SUMM' and type in ('P'))
  DROP PROCEDURE CHECK_LAST_SUMM
go
--METADATA NAME:CHECK_LAST_SUMM TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE CHECK_LAST_SUMM
(@pproj_id integer, @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS 
  set nocount on
  DECLARE @lts datetime, @cnt integer, @summ_level varchar(12)

  if (select count(*) from project where proj_id = @pproj_id ) = 0
  begin
    set @pret_val = -1
    set @pret_msg = 'Project id ' + str(@pproj_id) + ' does not exist';
    return 
  end 
  select @lts = last_tasksum_date
  from project
  where proj_id = @pproj_id;
  if @lts is null
  begin
    set @pret_val = 1;
    return
  end
  
  select @summ_level = sum_assign_level
  from project
  where proj_id = @pproj_id;
  
  set @pret_val = 0

  if (select count(*) 
	  where exists (select * from refrdel 
		where delete_date > @lts
 		and proj_id = @pproj_id 
		and table_name in ('PROJWBS','TASK','TASKRSRC','PROJECT',
					'PROJCOST','TASKFIN','TRSRCFIN','WBSRSRC', 'WBSRSRC_QTY')
			)
	)   > 0 
  begin
    set @pret_val = 1;
    return
  end
  if (select count(*) 
	  where  exists (select * from task where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from taskrsrc where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from project where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from projwbs where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from projcost where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from taskfin where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from trsrcfin where update_date > @lts
			and proj_id = @pproj_id)
	  or exists (select * from wbsrsrc where update_date > @lts
			and proj_id = @pproj_id
			and @summ_level = 'SL_Wbsrsrc')
	  or exists (select * from wbsrsrc_qty wq, wbsrsrc wr where wq.update_date > @lts
			and wr.wbsrsrc_id = wq.wbsrsrc_id
			and wr.proj_id = @pproj_id
			and @summ_level = 'SL_Wbsrsrc')
	  or exists (select * from prefer where update_date > @lts)
	)   > 0 
  begin
    set @pret_val = 1;
    return
  end
go
--METADATA NAME:CHECK_LAST_SUMM TYPE:GRANT TABLE_NAME:CHECK_LAST_SUMM CHANGE:CREATE
GRANT EXECUTE ON CHECK_LAST_SUMM TO ${pm.ss.privileged_user}
go
print 'Creating procedure REFRDEL_CLEANUP'

--METADATA  TYPE:SSCR NAME:REFRDEL_CLEANUP OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REFRDEL_CLEANUP' and type in ('P'))
  DROP PROCEDURE REFRDEL_CLEANUP
go
--METADATA NAME:REFRDEL_CLEANUP TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE REFRDEL_CLEANUP
 (@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT ) AS 

  declare @curr_time datetime
  declare @vdiff integer
  declare @vinterval_date datetime
  declare @vset varchar(20)
  declare @vsetnum integer
  declare @min_refrdel_date datetime
  declare @delete_target datetime
  declare @max_minutes_to_sweep integer  
  declare @interval_step integer 
  declare @cnt integer 
  declare @i integer
  declare @total_cleared integer 
begin try
  set @curr_time=getdate()
  set @cnt=0
  set @i=1
  set @pret_val=0
  set @total_cleared=0
  exec settings_read_number @max_minutes_to_sweep OUTPUT,'database.cleanup.Refrdel','DaysToDelete',1
  exec settings_read_number @interval_step OUTPUT,'database.cleanup.Refrdel','IntervalStep',15
  exec settings_read_string @vset OUTPUT,'database.cleanup.Refrdel','KeepInterval','5d'
  set @max_minutes_to_sweep=@max_minutes_to_sweep*1440
  exec get_interval_difference @vset, @vdiff OUTPUT
   set @vinterval_date = @curr_time-@vdiff
  print 'Keep Date: ' + convert(varchar(30),@vinterval_date)

  select @min_refrdel_date=min(delete_date)  from refrdel
  print 'Oldest Refrdel: ' + convert(varchar(30),@min_refrdel_date)
  
  set @delete_target = @min_refrdel_date
  if @min_refrdel_date is not null 
  begin 
  set @total_cleared=0
  while ( @i <= @max_minutes_to_sweep and @delete_target < @vinterval_date ) 
  begin
    set @delete_target=dateadd(mi,@interval_step,@delete_target)	
    delete from refrdel where delete_date< @delete_target
    set @total_cleared= @total_cleared +@@rowcount
	
    set @i=@i+@interval_step
  end   
 end 
 else
  print 'Nothing to Delete'
  set @pret_val =@total_cleared
  set @pret_msg='Cleared: ' + ltrim(str(@pret_val)) + ' records from ' + convert(varchar(30),@min_refrdel_date) +' to ' + convert(varchar(30),@delete_target)
  print @pret_msg
end try
Begin Catch
 set @pret_val=error_number()
 set @pret_msg=error_message()
End Catch
go
--METADATA NAME:REFRDEL_CLEANUP TYPE:GRANT TABLE_NAME:REFRDEL_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON REFRDEL_CLEANUP TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_TAB_OPTIONS'

--METADATA  TYPE:SSCR NAME:AUDIT_TAB_OPTIONS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_TAB_OPTIONS' and type in ('P'))
  DROP PROCEDURE AUDIT_TAB_OPTIONS
go
--METADATA NAME:AUDIT_TAB_OPTIONS TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_TAB_OPTIONS
(@ptable_name varchar(30), @paudit int OUTPUT
, @pins_audit int=0 OUTPUT, @pupd_audit int=0 OUTPUT, @pdel_audit int=0 OUTPUT
, @pcolumn_audit varchar(4000)='' OUTPUT)
WITH ENCRYPTION AS
  set nocount on
  declare @audit_str varchar(4), @namespace varchar(255)
  exec settings_read_bool @paudit OUTPUT,'database.audit','Enabled',0
  set @namespace = 'database.audit.' + @ptable_name
  exec settings_read_string @audit_str OUTPUT,@namespace,'Options','000'

  exec settings_read_string @pcolumn_audit OUTPUT,@namespace,'ColumnList', 'ALL'

  set @pins_audit = substring(@audit_str,1,1)
  set @pupd_audit = substring(@audit_str,2,1)
  set @pdel_audit = substring(@audit_str,3,1)
if @pins_audit=0 and @pupd_audit=0 and @pdel_audit=0 
   set @paudit=0
go
--METADATA NAME:AUDIT_TAB_OPTIONS TYPE:GRANT TABLE_NAME:AUDIT_TAB_OPTIONS CHANGE:CREATE
GRANT EXECUTE ON AUDIT_TAB_OPTIONS TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_PRM_USER'

--METADATA  TYPE:SSCR NAME:AUDIT_PRM_USER OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_PRM_USER' and type in ('P'))
  DROP PROCEDURE AUDIT_PRM_USER
go
--METADATA NAME:AUDIT_PRM_USER TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_PRM_USER
( @psession_id int OUTPUT, @pprm_user_name varchar(255) OUTPUT
, @papp_name varchar(25) OUTPUT)
WITH ENCRYPTION AS
  set nocount on
  select @psession_id=session_id, @pprm_user_name=user_name, @papp_name=app_name
  from users u , usession us
  where u.user_id = us.user_id
  and us.spid = @@spid
  and u.delete_session_id is null and us.delete_session_id is null
  if @@ROWCOUNT = 0 
  begin	
    set @psession_id = 0

    select @pprm_user_name=user_name, @papp_name=app_name
    from spidmap
    where spid=@@spid
    if @@ROWCOUNT = 0 
    BEGIN
      set @pprm_user_name = 'NotPrmUser'
      set @papp_name = ''
    END 
  end
go
--METADATA NAME:AUDIT_PRM_USER TYPE:GRANT TABLE_NAME:AUDIT_PRM_USER CHANGE:CREATE
GRANT EXECUTE ON AUDIT_PRM_USER TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_PROC_INFO'

--METADATA  TYPE:SSCR NAME:AUDIT_PROC_INFO OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_PROC_INFO' and type in ('P'))
  DROP PROCEDURE AUDIT_PROC_INFO
go
--METADATA NAME:AUDIT_PROC_INFO TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_PROC_INFO
( @pprogram varchar(255) OUTPUT, @phostname varchar(255) OUTPUT
, @pnetaddress varchar(64) OUTPUT, @prdbms_user varchar(30) OUTPUT
, @pos_user varchar(32) OUTPUT )
WITH ENCRYPTION AS
  select @pprogram=program_name , @phostname=hostname
  , @pnetaddress=net_address, @prdbms_user=u.name, @pos_user=nt_username
from master..sysprocesses sp, sysusers u
where sp.uid = u.uid  and spid = @@SPID
go
--METADATA NAME:AUDIT_PROC_INFO TYPE:GRANT TABLE_NAME:AUDIT_PROC_INFO CHANGE:CREATE
GRANT EXECUTE ON AUDIT_PROC_INFO TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_IDENTITY'

--METADATA  TYPE:SSCR NAME:AUDIT_IDENTITY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_IDENTITY' and type in ('P'))
  DROP PROCEDURE AUDIT_IDENTITY
go
--METADATA NAME:AUDIT_IDENTITY TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_IDENTITY
( @psession_id int, @puser_id int=null, @puser_name varchar(255)=null)
WITH ENCRYPTION AS
  declare @cnt smallint, @user_name varchar(255), @user_id int
  set nocount on 
  if @puser_id is not null or @puser_name is not null 
  BEGIN
    if @puser_name is not null 
    BEGIN
      set @user_name = @puser_name
      set @user_id = 0
    END
    ELSE
    BEGIN
      select @user_name=user_name 
      from users
      where user_id = @puser_id
      and delete_session_id is null
      if @@ROWCOUNT = 0 
      BEGIN
        set @user_name = 'NotPrmUser'
        set @user_id = 0
      END
      ELSE
      BEGIN
        set @user_id = @puser_id
      END
    END

    select @cnt=count(*) from spidmap where spid = @@spid
    if @cnt = 0 
      insert into spidmap (spid,user_id,user_name)
      values(@@spid,@user_id,@user_name)
    ELSE
      update spidmap 
      set user_id = @user_id, user_name = @user_name
      where spid = @@spid
  END
  ELSE
  BEGIN
    update usession set spid=@@SPID where session_id = @psession_id
  END
go
--METADATA NAME:AUDIT_IDENTITY TYPE:GRANT TABLE_NAME:AUDIT_IDENTITY CHANGE:CREATE
GRANT EXECUTE ON AUDIT_IDENTITY TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_DATA'

--METADATA  TYPE:SSCR NAME:AUDIT_DATA OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_DATA' and type in ('P'))
  DROP PROCEDURE AUDIT_DATA
go
--METADATA NAME:AUDIT_DATA TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_DATA
( @ptable_name varchar(30), @pcolumn_name varchar(30), @poper char(1)
, @ppk1 varchar(32), @ppk2 varchar(32), @ppk3 varchar(32), @ppk4 varchar(32),  @pprm_user_name varchar(255)
, @pprogram varchar(255), @phostname varchar(255), @pnetaddress varchar(24)
, @prdbms_user varchar(30), @pos_user varchar(32), @papp_name varchar(25)
, @pcolaud int, @plogical_delete varchar(1), @pprimary_record varchar(1)
, @pbefore_value varchar(2000), @pafter_value varchar(2000), @paudit_data varchar(4000) OUTPUT
)
WITH ENCRYPTION AS
  set nocount on
  if @pcolaud is null or @pcolaud = 1 
  begin
    declare @audit_data varchar(4000)
    declare @ptrval binary(16), @blen int
    set @audit_data=''
    --if @pbefore_value is not null and (@poper='U' or @poper='D')
    if (@pbefore_value is not null and @poper='D') or (@poper='U' and (@pbefore_value is not null and (@pbefore_value <> @pafter_value or @pafter_value is null)))
      set @audit_data=@audit_data+':'+'O'+@pcolumn_name+':'+substring(str(len(@pbefore_value)),7,10)+':'+@pbefore_value
    --if @pafter_value is not null and (@poper='U' or @poper='I') 
    if (@pafter_value is not null and @poper='I') or (@poper='U' and (@pafter_value is not null and (@pafter_value <> @pbefore_value or @pbefore_value is null)))
      set @audit_data=@audit_data+':'+'N'+@pcolumn_name+':'+substring(str(len(@pafter_value)),7,10)+':'+@pafter_value

    if @audit_data is not null
    BEGIN
      if @paudit_data is null
        set @paudit_data = @audit_data
      else if len(@paudit_data)+len(@audit_data) <=4000
        set @paudit_data=@paudit_data+@audit_data
      else
      begin
        SELECT @ptrval = TEXTPTR(audit_info_extended) from spidmap where spid=@@spid
        SELECt @blen=datalength(audit_info_extended) from spidmap where spid=@@spid
        UPDATETEXT spidmap.audit_info_extended  @ptrval @blen 0 @audit_data
      end
    END
/*
    insert into prmaudit (audit_name,table_name,column_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name,app_name,
                        prm_user_name,os_user_name,program,host_name,old_value,new_value,netaddress,logical_delete_flag)
    values (getDate(),@ptable_name, @pcolumn_name, @ppk1, @ppk2, @ppk3, @ppk4, @poper, @prdbms_user, @papp_name
          ,@pprm_user_name, @pos_user, @pprogram, @phostname, @pbefore_value, @pafter_value, @pnetaddress,@plogical_delete)
*/
  end

go
--METADATA NAME:AUDIT_DATA TYPE:GRANT TABLE_NAME:AUDIT_DATA CHANGE:CREATE
GRANT EXECUTE ON AUDIT_DATA TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDIT_ROW'

--METADATA  TYPE:SSCR NAME:AUDIT_ROW OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDIT_ROW' and type in ('P'))
  DROP PROCEDURE AUDIT_ROW
go
--METADATA NAME:AUDIT_ROW TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDIT_ROW
( @ptable_name varchar(30), @poper char(1)
, @ppk1 varchar(32), @ppk2 varchar(32), @ppk3 varchar(32), @ppk4 varchar(32),  @pprm_user_name varchar(255)
, @pprogram varchar(255), @phostname varchar(255), @pnetaddress varchar(24)
, @prdbms_user varchar(30), @pos_user varchar(32), @papp_name varchar(25)
, @plogical_delete varchar(1), @pprimary_record varchar(1), @paudit_data varchar(4000)=null
)
WITH ENCRYPTION AS
  set nocount on
  if @paudit_data is null or len(@paudit_data)<=4000
    insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
    values (getDate(),@ptable_name, @ppk1, @ppk2, @ppk3, @ppk4, @poper, @prdbms_user, @papp_name
          ,@pprm_user_name, @pos_user, @pprogram, @phostname, @pnetaddress,@plogical_delete, @paudit_data)
  else
    insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
    select getDate(),@ptable_name, @ppk1, @ppk2, @ppk3, @ppk4, @poper, @prdbms_user, @papp_name
          ,@pprm_user_name, @pos_user, @pprogram, @phostname, @pnetaddress,@plogical_delete, @paudit_data
          ,audit_info_extended
   from spidmap where spid = @@spid

go
--METADATA NAME:AUDIT_ROW TYPE:GRANT TABLE_NAME:AUDIT_ROW CHANGE:CREATE
GRANT EXECUTE ON AUDIT_ROW TO ${pm.ss.privileged_user}
go
print 'Creating procedure INTERNAL_AUDITING_SETTING'

--METADATA  TYPE:SSCR NAME:INTERNAL_AUDITING_SETTING OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'INTERNAL_AUDITING_SETTING' and type in ('P'))
  DROP PROCEDURE INTERNAL_AUDITING_SETTING
go
--METADATA NAME:INTERNAL_AUDITING_SETTING TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE INTERNAL_AUDITING_SETTING
( @penable int, @ptable_name varchar(30)= null, @plevel int = 1 )
WITH ENCRYPTION AS

  declare tab cursor for
  select name
  from sysobjects ut
  where type='U'
  and exists (select * 
                from syscolumns utc
                where utc.id = ut.id
                and name = 'update_date')
  and ut.name not in ('BRE_REGISTRY')
  
  if @plevel > 3 or @plevel < 0
    raiserror('internal_auditing_setting: Auditing level must be between 0 and 3 ',16,1)


  declare @vlevel varchar(3), @vnamespace varchar(255),@tname varchar(30)

  if @penable = 1
  BEGIN
    exec settings_write_bool 1,'database.audit','Enabled'

    set @vlevel = ltrim(str(@plevel))+ltrim(str(@plevel))+ltrim(str(@plevel))

    set @vnamespace = 'database.audit.' + upper(@ptable_name)
    if @ptable_name is not null
	BEGIN
      set @vnamespace = 'database.audit.' + upper(@ptable_name)
      exec settings_write_string @vlevel,@vnamespace,'Options' 
    END
    else
    begin
      open tab
      fetch tab into @tname
      while (@@fetch_status = 0 ) 
      BEGIN
        set @vnamespace = 'database.audit.' + upper(@tname)
        exec settings_write_string @vlevel, @vnamespace,'Options' 
        fetch tab into @tname
      END
      close tab
    end
    

  END
  else
  BEGIN
    if @ptable_name is null
      exec settings_write_bool 0,'database.audit','Enabled'
    else
    BEGIN
        set @vnamespace = 'database.audit.' + upper(@ptable_name)
        exec settings_write_string '000', @vnamespace,'Options' 
    END 
  END
  deallocate tab
go
--METADATA NAME:INTERNAL_AUDITING_SETTING TYPE:GRANT TABLE_NAME:INTERNAL_AUDITING_SETTING CHANGE:CREATE
GRANT EXECUTE ON INTERNAL_AUDITING_SETTING TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDITING_ENABLE'

--METADATA  TYPE:SSCR NAME:AUDITING_ENABLE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDITING_ENABLE' and type in ('P'))
  DROP PROCEDURE AUDITING_ENABLE
go
--METADATA NAME:AUDITING_ENABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDITING_ENABLE
( @ptable_name varchar(30)=null, @plevel int=1)
WITH ENCRYPTION AS
  exec internal_auditing_setting 1,@ptable_name,@plevel
go
--METADATA NAME:AUDITING_ENABLE TYPE:GRANT TABLE_NAME:AUDITING_ENABLE CHANGE:CREATE
GRANT EXECUTE ON AUDITING_ENABLE TO ${pm.ss.privileged_user}
go
print 'Creating procedure AUDITING_DISABLE'

--METADATA  TYPE:SSCR NAME:AUDITING_DISABLE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'AUDITING_DISABLE' and type in ('P'))
  DROP PROCEDURE AUDITING_DISABLE
go
--METADATA NAME:AUDITING_DISABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE AUDITING_DISABLE
( @ptable_name varchar(30)=null)
WITH ENCRYPTION AS
  exec internal_auditing_setting 0,@ptable_name
go
--METADATA NAME:AUDITING_DISABLE TYPE:GRANT TABLE_NAME:AUDITING_DISABLE CHANGE:CREATE
GRANT EXECUTE ON AUDITING_DISABLE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CLEANUP_USESSAUD'

--METADATA  TYPE:SSCR NAME:CLEANUP_USESSAUD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CLEANUP_USESSAUD' and type in ('P'))
  DROP PROCEDURE CLEANUP_USESSAUD
go
--METADATA NAME:CLEANUP_USESSAUD TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE CLEANUP_USESSAUD
(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT)
WITH ENCRYPTION AS 
  set nocount on
  declare @early_login datetime, @curr_time datetime, @keepInterval varchar(20)
  declare @diff decimal(20,6), @interval_date datetime, @set varchar(20)
  declare @delete_all bit, @delete_thresh int, @delete_pct decimal(10,2)
  declare @rowcount int, @delete_rows int, @delete_cnt int, @max_to_delete int
  exec settings_read_string @set OUTPUT,'database.cleanup.Usessaud','KeepInterval','5d'
  exec get_interval_difference @set, @diff OUTPUT
  set @curr_time = getDate()
  set @interval_date = @curr_time-@diff

  exec settings_read_bool @delete_all OUTPUT,'database.cleanup.Usessaud','DeleteAll',0
  exec settings_read_number @delete_thresh OUTPUT,'database.cleanup.Usessaud','DeleteAllThreshold',1000
  exec settings_read_number @delete_pct OUTPUT,'database.cleanup.Usessaud','DeletePercentage',10
  exec settings_read_number @max_to_delete OUTPUT,'database.cleanup.Usessaud','MaxRowsToDelete',10000
  select @rowcount=count(*) from usessaud where logout_date <= @interval_date 
  
  set @pret_val=0
  if @delete_all = 1 or @rowcount < @delete_thresh
  begin
    delete from usessaud where logout_date <= @interval_date
    set @pret_val = @@rowcount
  end     
  else
  begin
    create table #tmpusessaud(logout_date datetime)
    set @delete_rows = @rowcount * (@delete_pct*.01)
    if @delete_rows > @max_to_delete
      set @delete_rows = @max_to_delete
    else if @delete_rows < @delete_thresh
      set @delete_rows = @delete_thresh
    declare @sql nvarchar(255)
    set @sql = N'insert into #tmpusessaud select top ' + ltrim(str(@delete_rows)) 
              + N' logout_date from usessaud '
              + N' where logout_date <= ''' + convert(varchar(30),@interval_date) + ''''
    exec sp_executesql @sql
    declare @vlogout_date datetime
    declare dels cursor for select logout_date from #tmpusessaud
    open dels
    set @delete_cnt=0
    fetch dels into @vlogout_date
    while @@fetch_status >= 0
    begin
      delete from usessaud
      where logout_date = @vlogout_date
      set @delete_cnt=@delete_cnt+@@rowcount
      fetch dels into @vlogout_date
    end
    close dels
    deallocate dels
    set @pret_val = @delete_cnt
  end
  set @pret_msg = ltrim(str(@pret_val)) + ' record(s) deleted'
go
--METADATA NAME:CLEANUP_USESSAUD TYPE:GRANT TABLE_NAME:CLEANUP_USESSAUD CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_USESSAUD TO ${pm.ss.privileged_user}
go
print 'Creating procedure USESSAUD_ENABLE'

--METADATA  TYPE:SSCR NAME:USESSAUD_ENABLE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USESSAUD_ENABLE' and type in ('P'))
  DROP PROCEDURE USESSAUD_ENABLE
go
--METADATA NAME:USESSAUD_ENABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE USESSAUD_ENABLE
WITH ENCRYPTION AS
begin
      exec settings_write_bool 1, 'database.audit.LogOut', 'Enabled'
end
go
--METADATA NAME:USESSAUD_ENABLE TYPE:GRANT TABLE_NAME:USESSAUD_ENABLE CHANGE:CREATE
GRANT EXECUTE ON USESSAUD_ENABLE TO ${pm.ss.privileged_user}
go
print 'Creating procedure USESSAUD_DISABLE'

--METADATA  TYPE:SSCR NAME:USESSAUD_DISABLE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USESSAUD_DISABLE' and type in ('P'))
  DROP PROCEDURE USESSAUD_DISABLE
go
--METADATA NAME:USESSAUD_DISABLE TYPE:PROCEDURE SET:AUDITING CHANGE:CREATE
CREATE PROCEDURE USESSAUD_DISABLE
WITH ENCRYPTION AS
begin
      exec settings_write_bool 0, 'database.audit.LogOut', 'Enabled'
end
go
--METADATA NAME:USESSAUD_DISABLE TYPE:GRANT TABLE_NAME:USESSAUD_DISABLE CHANGE:CREATE
GRANT EXECUTE ON USESSAUD_DISABLE TO ${pm.ss.privileged_user}
go
print 'Creating procedure HAS_RSRC_ACCESS'

--METADATA  TYPE:SSCR NAME:HAS_RSRC_ACCESS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'HAS_RSRC_ACCESS' and type in ('P'))
  DROP PROCEDURE HAS_RSRC_ACCESS
go
--METADATA NAME:HAS_RSRC_ACCESS TYPE:PROCEDURE SET:RESOURCE_SECURITY CHANGE:CREATE
CREATE PROCEDURE HAS_RSRC_ACCESS
                        @puser_id INT,
			@prsrc_id INT,
			@pret_val INT OUTPUT,
			@pret_msg VARCHAR(2000) OUTPUT,
                        @pfirst_run INT = -1
WITH ENCRYPTION AS
  set nocount on
  declare @v_parent_rsrc_id INT, @v_rsrcsec_rsrc_id INT, @v_access char(1), @v_is_superuser char(1)
  if @pfirst_run = -1
  BEGIN
    select @v_rsrcsec_rsrc_id=rsrc_id
    from rsrc
    where rsrc_id = @prsrc_id
    and delete_session_id is null;
    if @@ROWCOUNT = 0 
    BEGIN
      set @pret_msg = 'Resource id ' + str(@prsrc_id) + ' does not exist'
      set @pret_val = -2
      return
    END

    select @v_access=ALL_RSRC_ACCESS_FLAG, @v_is_superuser=SUPERUSER_FLAG
    from users u LEFT OUTER JOIN profile p ON u.prof_id=p.prof_id
    where u.user_id = @puser_id
    and u.delete_session_id is null;
    
    
    if @@ROWCOUNT = 0 
    BEGIN
      set @pret_msg = 'User ' + str(@puser_id) + ' does not exist'
      set @pret_val = -1
      return
    END
    if @v_access = 'Y' OR @v_is_superuser = 'Y'
    BEGIN
      set @pret_val = 1
      return
    END
  END

  set @pret_val = 0

  select @v_parent_rsrc_id=r.parent_rsrc_id, @v_rsrcsec_rsrc_id=rs.rsrc_id
  from rsrc r left outer join rsrcsec rs 
              on r.rsrc_id = rs.rsrc_id and rs.user_id = @puser_id
  where r.rsrc_id = @prsrc_id
  and r.delete_session_id is null;
  if @@ROWCOUNT = 0 
  BEGIN
    set @pret_msg = 'Resource id ' + str(@prsrc_id) + ' does not exist'
    set @pret_val = -2
    return
  END

  if @v_rsrcsec_rsrc_id is not null 
  BEGIN
    set @pret_val = 1
  END
  ELSE
  BEGIN
    if @v_parent_rsrc_id is not null
    BEGIN
      exec has_rsrc_access @puser_id, @v_parent_rsrc_id, @pret_val OUTPUT , @pret_msg OUTPUT,1
    END
  END
go
--METADATA NAME:HAS_RSRC_ACCESS TYPE:GRANT TABLE_NAME:HAS_RSRC_ACCESS CHANGE:CREATE
GRANT EXECUTE ON HAS_RSRC_ACCESS TO ${pm.ss.privileged_user}
go
print 'Creating procedure UPDATE_RSRC_SECURITY'

--METADATA  TYPE:SSCR NAME:UPDATE_RSRC_SECURITY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'UPDATE_RSRC_SECURITY' and type in ('P'))
  DROP PROCEDURE UPDATE_RSRC_SECURITY
go
--METADATA NAME:UPDATE_RSRC_SECURITY TYPE:PROCEDURE SET:RESOURCE_SECURITY CHANGE:CREATE
CREATE PROCEDURE UPDATE_RSRC_SECURITY
                        @puser_id INT,
			@psession_id INT, 
			@pcontext_id INT, 
			@pret_val INT OUTPUT,
			@pret_msg VARCHAR(2000) OUTPUT,
                        @prsrc_id INT = -1
WITH ENCRYPTION AS
  set nocount on
  declare  @v_access char(1), @v_rsrc_sec_id INT, @v_child_rsrc_id INT, @v_is_superuser char(1)

  if @prsrc_id = -1
  BEGIN
    delete from upklist 
    where session_id = @psession_id and context_id = @pcontext_id;

    select @v_access=ALL_RSRC_ACCESS_FLAG, @v_is_superuser=SUPERUSER_FLAG
    from users u LEFT OUTER JOIN profile p ON u.prof_id=p.prof_id
    where u.user_id = @puser_id
    and u.delete_session_id is null;
    
    if @@ROWCOUNT = 0 
    BEGIN
      set @pret_msg = 'User ' + str(@puser_id) + ' does not exist'
      set @pret_val = -1
      return
    END
    if @v_access = 'Y' OR @v_is_superuser = 'Y'
    BEGIN
      set @pret_val = 1
      return
    END

    declare @verstr varchar(4), @vsql nvarchar(1000)
    set @verstr = substring(replace(@@version,' ',''),19,4)
    print @verstr

   IF @verstr = '2005'
   BEGIN
		set @vsql=
		N'with rsrc_rq(rsrc_id,level) as
		(select rsrc_id, 0 as level 
		from rsrcsec
		where user_id = @puser_id and delete_session_id is null
		union all
		select c.rsrc_id , p.level+1
		from rsrc c INNER JOIN rsrc_rq p ON c.parent_rsrc_id = p.rsrc_id and delete_session_id is null
		) 
		insert into upklist (session_id,context_id,pk_id)
		select @sessid,@contextid,rsrc_id from rsrc_rq'

    exec sp_executesql @vsql,N'@puser_id int,@sessid int,@contextid int',@puser_id,@psession_id,@pcontext_id
   END
   ELSE
   BEGIN
			DECLARE rsCur CURSOR LOCAL FOR 
			select rsrc_id 
			from rsrcsec
			where user_id = @puser_id
			and delete_session_id is null;

			OPEN rsCur
			FETCH NEXT FROM rsCur INTO @v_rsrc_sec_id
			WHILE (@@FETCH_STATUS = 0)
			BEGIN
				exec update_rsrc_security @puser_id, @psession_id, @pcontext_id,
																	@pret_val OUTPUT, @pret_msg OUTPUT, @v_rsrc_sec_id

				FETCH NEXT FROM rsCur INTO @v_rsrc_sec_id
			END
			CLOSE rsCur
			DEALLOCATE rsCur
    END
  END
  ELSE
  BEGIN
    insert into upklist (session_id, context_id, pk_id ) 
    values ( @psession_id, @pcontext_id, @prsrc_id);

    DECLARE rChildCur CURSOR LOCAL FOR 
    select rsrc_id 
    from rsrc
    where parent_rsrc_id = @prsrc_id
    and delete_session_id is null;

    OPEN rChildCur
    FETCH NEXT FROM rChildCur INTO @v_child_rsrc_id
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      exec update_rsrc_security @puser_id, @psession_id, @pcontext_id,
                                @pret_val OUTPUT, @pret_msg OUTPUT, @v_child_rsrc_id
      if @pret_val <> 0 
      BEGIN 
        return
      END 

      FETCH NEXT FROM rChildCur INTO @v_child_rsrc_id
    END
    CLOSE rChildCur
    DEALLOCATE rChildCur


  END

go
--METADATA NAME:UPDATE_RSRC_SECURITY TYPE:GRANT TABLE_NAME:UPDATE_RSRC_SECURITY CHANGE:CREATE
GRANT EXECUTE ON UPDATE_RSRC_SECURITY TO ${pm.ss.privileged_user}
go
print 'Creating procedure GET_PRIMARY_KEY'

--METADATA  TYPE:SSCR NAME:GET_PRIMARY_KEY OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_PRIMARY_KEY' and type in ('P'))
  DROP PROCEDURE GET_PRIMARY_KEY
go
--METADATA NAME:GET_PRIMARY_KEY TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE GET_PRIMARY_KEY
	(@tab_name nvarchar(30), @key_cnt integer OUTPUT, @pk1 varchar(30) OUTPUT , @pk2 varchar(30)=null OUTPUT
         , @pk3 varchar(30)=null OUTPUT , @pk4 varchar(30)=null OUTPUT)
WITH ENCRYPTION AS 
  declare @vkey_name nvarchar(30)

  if @tab_name != 'GCHANGE' and @tab_name != 'RLFOLIO'
    set @vkey_name = 'PK_' + @tab_name
  else
    set @vkey_name = 'PK_' + @tab_name + '_ID'

    select @pk1=index_col('dbo.' +@tab_name,i.indid,1),@pk2=index_col('dbo.' +@tab_name,i.indid,2)
          ,@pk3=index_col('dbo.' +@tab_name,i.indid,3),@pk4=index_col('dbo.' +@tab_name,i.indid,4)
    from sysindexes i
    where i.name = @vkey_name;

    set @key_cnt=1
    if LEN(@pk2)>0 
    begin
      set @key_cnt=2
      if LEN(@pk4)>0 
        set @key_cnt = 4
      ELSE
        if LEN(@pk3)>0 
          set @key_cnt = 3
    end
go
--METADATA NAME:GET_PRIMARY_KEY TYPE:GRANT TABLE_NAME:GET_PRIMARY_KEY CHANGE:CREATE
GRANT EXECUTE ON GET_PRIMARY_KEY TO ${pm.ss.privileged_user}
go
print 'Creating procedure CASCADE_DELETE_CHILD'

--METADATA  TYPE:SSCR NAME:CASCADE_DELETE_CHILD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CASCADE_DELETE_CHILD' and type in ('P'))
  DROP PROCEDURE CASCADE_DELETE_CHILD
go
--METADATA NAME:CASCADE_DELETE_CHILD TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE CASCADE_DELETE_CHILD
	(@tab_name varchar(30), @parent_tab_name varchar(30), @fk1 varchar(30), @fk2 varchar(30)
         , @subquery nvarchar(4000), @delstmt nvarchar(4000), @updstmt nvarchar(4000)
         , @errorlevel int, @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT
         , @pmax_to_delete int
         , @param1 varchar(255)=null, @param2 varchar(255)=null, @verbose bit=0)
WITH ENCRYPTION AS 
  SET NOCOUNT on
  declare @new_delstmt nvarchar(4000), @new_subquery nvarchar(4000)
  declare @sub1 nvarchar(4000), @new_updquery nvarchar(4000), @new_execstmt nvarchar(4000)
  declare @child_table_name varchar(30), @child_col1 varchar(30), @child_col2 varchar(30)
  declare @fk1_nullable int, @fk2_nullable int, @key_cnt integer
  declare @pk_col1 varchar(30), @pk_col2 varchar(30), @rc int, @err int, @cnt int
  declare @del_nullable bit, @cntquery nvarchar(4000)

  declare child_c1 cursor local for
    
    select distinct 
            po.name , sc.name, sc2.name
    from  sysobjects fo
            inner join sysobjects po on po.id = fo.parent_obj
            inner join sysforeignkeys fk on fo.id = fk.constid
            inner join sysobjects oo on oo.id = fk.rkeyid
            inner join syscolumns sc on sc.id = po.id 
            inner join sysreferences ref on ref.constid = fk.constid and sc.colid = ref.fkey1
            left outer join syscolumns sc2 on sc2.id = po.id and sc2.colid = ref.fkey2
    where fo.xtype = 'F' and oo.name = @tab_name;
    

  if @verbose = 1
    print 'Processing table ' + @tab_name + ' at ' + convert(varchar(20),getdate(),20)

  set @del_nullable=0
  if (@parent_tab_name = 'PROJECT') 
    or (@parent_tab_name = 'TASK') 
    or (@parent_tab_name = 'TASKRSRC') 
    or (@parent_tab_name = 'UDFCODE') 
    or (@parent_tab_name = 'USERS' AND @tab_name = 'USESSION') 
    or (@parent_tab_name = 'PROJWBS' AND @tab_name = 'PROJISSU') 
    or (@parent_tab_name = 'PROJWBS' AND @tab_name = 'PROJTHRS') 
    or ( (@parent_tab_name = 'RSRC' OR @parent_tab_name = 'ROLE') 
          AND @tab_name = 'TASKRSRC') 
    set @del_nullable=1

  declare @is_nullable int
  set @is_nullable = 0
  if @fk2 is null and @del_nullable = 0
  begin
    select @is_nullable=sc.isnullable
    from sysobjects so, syscolumns sc
    where so.id = sc.id and so.xtype = 'U'
    and so.name = @tab_name and sc.name = @fk1
  end
 
  if @is_nullable = 1
  begin
    exec sp_executesql @updstmt ,N'@pk1 varchar(255),@pk2 varchar(255)',@param1, @param2
    select @err=@@error, @rc=@@rowcount
    if @err <> 0 
    BEGIN
      set @pret_msg = 'Errror ' + ltrim(str(@err)) + ' occured on update to null for table ' + @tab_name
      set @pret_val = -1
      return
    END
    set @pret_val = @pret_val+@rc
    if @verbose = 1
      print str(@rc) + ' FK Rows updated to null for table ' + @tab_name
    return
  end

  open child_c1
  fetch child_c1 into @child_table_name, @child_col1, @child_col2
  while @@fetch_status >= 0
  begin
    if @child_col2 is null 
      set @sub1= @child_col1 + ' in (' + @subquery + ')'
    else
      set @sub1=+'(str(' + @child_col1 + ')+str('+@child_col2 + ')) in (' + @subquery + ')'

    set @new_delstmt='delete from dbo.' + @child_table_name  + ' where ' + @sub1;
    if @errorlevel > 0  
    begin
      select @cnt=count(*)
      from sysobjects so, syscolumns sc
      where so.id = sc.id and so.xtype = 'U'
      and so.name = @child_table_name and sc.name = 'delete_session_id'

      if @cnt = 1
        set @new_delstmt=@new_delstmt + ' and delete_session_id is not null'
    end
    set @new_updquery='update dbo.' + @child_table_name +' set ' + @child_col1 + '=null where ' + @sub1;

    exec get_primary_key @child_table_name, @key_cnt OUTPUT, @pk_col1 OUTPUT, @pk_col2 OUTPUT


    if @pk_col2 is null  
      set @new_subquery = 'select ' + @pk_col1 + ' from dbo.' + @child_table_name + ' where ' + @sub1;
    else
      set @new_subquery = 'select str(' + @pk_col1 + ')+str(' + @pk_col2+ ') from dbo.' + @child_table_name + ' where ' + @sub1;


    exec cascade_delete_child @child_table_name, @tab_name, @child_col1, @child_col2
                           ,@new_subquery, @new_delstmt, @new_updquery, @errorlevel 
                           ,@pret_val OUTPUT, @pret_msg OUTPUT, @pmax_to_delete
                           ,@param1,@param2,@verbose
    if @pret_val < 0 or @pret_val > @pmax_to_delete
      return 

    fetch child_c1 into @child_table_name, @child_col1, @child_col2
  end

  /* Handle udfvalues */
  select @cnt=count(*) from udftype where table_name = @tab_name
  if @cnt > 0 
  begin
    set @new_delstmt= 'delete from udfvalue'
    set @new_delstmt=@new_delstmt+ ' where udf_type_id in (select udf_type_id from udftype where table_name = ''' + @tab_name + ''')'
    set @new_delstmt=@new_delstmt+ ' and fk_id in (' + @subquery + ')'
    exec sp_executesql @new_delstmt,N'@pk1 varchar(255),@pk2 varchar(255)',@param1, @param2
    select @err=@@error, @rc=@@rowcount
    set @pret_val = @pret_val+@rc
    if @err <> 0 
    BEGIN
      set @pret_msg = 'Errror ' + ltrim(str(@err)) + ' occured on UDF delete for table ' + @tab_name
      set @pret_val = -1
      return
    END
  end

  exec sp_executesql @delstmt,N'@pk1 varchar(255),@pk2 varchar(255)',@param1, @param2
  select @err=@@error, @rc=@@rowcount
  if @err <> 0 
  BEGIN
    set @pret_msg = 'Errror ' + ltrim(str(@err)) + ' occured on delete for table ' + @tab_name
    set @pret_val = -1
    return
  END
  set @pret_val = @pret_val+@rc

  if @verbose=1
    print str(@rc) + ' Rows deleted for table ' + @tab_name

go
--METADATA NAME:CASCADE_DELETE_CHILD TYPE:GRANT TABLE_NAME:CASCADE_DELETE_CHILD CHANGE:CREATE
GRANT EXECUTE ON CASCADE_DELETE_CHILD TO ${pm.ss.privileged_user}
go
print 'Creating procedure CASCADE_DELETE'

--METADATA  TYPE:SSCR NAME:CASCADE_DELETE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CASCADE_DELETE' and type in ('P'))
  DROP PROCEDURE CASCADE_DELETE
go
--METADATA NAME:CASCADE_DELETE TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE CASCADE_DELETE
	(@tab_name varchar(30), @pk1 varchar(30), @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT
         , @pmax_to_delete int=999999999
         , @pk2 varchar(30)=null, @pk3 varchar(30)=null, @pk4 varchar(30)=null, @verbose bit=0 )
WITH ENCRYPTION AS 
  SET NOCOUNT on
  declare @sub1 nvarchar(255), @pk_col1 varchar(30), @pk_col2 varchar(30)
  declare @pk_col3 varchar(30), @pk_col4 varchar(30), @key_cnt integer
  declare @new_delstmt nvarchar(4000), @i integer, @del_stmt nvarchar(4000)
  declare @rc int, @err int, @subquery nvarchar(4000)

  set @pret_val = 0

  if NOT exists (SELECT name FROM sysobjects WHERE name = @tab_name AND type = 'U')
  begin  
    set @pret_msg = 'Table ' + @tab_name + ' does not exist'
    return (@pret_val)
  end

  exec get_primary_key @tab_name, @key_cnt OUTPUT, @pk_col1 OUTPUT, @pk_col2 OUTPUT, @pk_col3 OUTPUT, @pk_col4 OUTPUT

  set @sub1 =  @pk_col1 + ' = @pk1 '
  if @key_cnt = 2 
    set @sub1 = @sub1 + ' and ' + @pk_col2 + ' = @pk2 '
  else if @key_cnt = 3
    set @sub1 = @sub1 + ' and ' + @pk_col2 + ' = @pk2 and ' + @pk_col3 + ' = @pk3 '
  else if @key_cnt = 4
    set @sub1 = @sub1 + ' and ' + @pk_col2 + ' = @pk2 and ' 
                + @pk_col3 + ' = @pk3 and ' + @pk_col4 + ' = @pk4'

  set @del_stmt = 'delete from dbo.' + @tab_name + ' where ' + @sub1


  if @key_cnt <= 2 
  BEGIN
    if @key_cnt = 1  
      set @subquery = 'select ' + @pk_col1 + ' from dbo.' + @tab_name + ' where ' + @sub1;
    else
      set @subquery = 'select str(' + @pk_col1 + ')+str(' + @pk_col2+ ') from dbo.' + @tab_name + ' where ' + @sub1;

   -- bug fix 3472 
  if @tab_name  = 'USERS'
    begin 
      delete from gchange where user_id = @pk1
      delete from viewprop where user_id = @pk1 
      delete from filtprop where user_id = @pk1
    end   

    exec cascade_delete_child @tab_name, null, null, null, @subquery, @del_stmt, null, 0
                           ,@pret_val OUTPUT, @pret_msg OUTPUT,@pmax_to_delete, @pk1, @pk2, @verbose
  END
  ELSE
  BEGIN
    exec sp_executesql @del_stmt
         ,N'@pk1 varchar(255),@pk2 varchar(255),@pk3 varchar(255),@pk4 varchar(255)'
         ,@pk1, @pk2, @pk3, @pk4
    select @err=@@error, @rc=@@rowcount
    if @err <> 0 
    begin
      set @pret_msg = 'error ' + ltrim(str(@err)) + ' occured on delete for table ' + @tab_name
      set @pret_val = -1
      return
    end
    set @pret_val = @pret_val+@rc
    if @verbose=1
      print str(@rc) + ' rows deleted for table ' + @tab_name
  END

  if @verbose=1
    print 'Deleted ' + ltrim(str(@pret_val)) + ' record(s)'
go
--METADATA NAME:CASCADE_DELETE TYPE:GRANT TABLE_NAME:CASCADE_DELETE CHANGE:CREATE
GRANT EXECUTE ON CASCADE_DELETE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CLEANUP_LOGICAL_DELETES'

--METADATA  TYPE:SSCR NAME:CLEANUP_LOGICAL_DELETES OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CLEANUP_LOGICAL_DELETES' and type in ('P'))
  DROP PROCEDURE CLEANUP_LOGICAL_DELETES
go
--METADATA NAME:CLEANUP_LOGICAL_DELETES TYPE:PROCEDURE SET:TIMESTAMP_UTILS CHANGE:CREATE
CREATE PROCEDURE CLEANUP_LOGICAL_DELETES
	(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT
         , @errorlevel int=1, @days int=null)
WITH ENCRYPTION AS 
  SET NOCOUNT on
  SET DATEFORMAT mdy
  declare @tab_name varchar(30), @del_stmt nvarchar(4000), @subquery nvarchar(4000)
  declare @sub1 nvarchar(255), @pk_col1 varchar(30), @pk_col2 varchar(30)
  declare @rows_changed int, @delete_date datetime, @min_date datetime, @key_cnt int
  declare @diff decimal(20,6),  @set varchar(20), @curr_time datetime
  declare @cntquery nvarchar(4000)


  declare @delete_all bit, @delete_thresh int, @delete_pct decimal(10,2)
  declare @rowcount int, @delete_rows int, @delete_cnt int, @max_to_delete int

  set @curr_time = getDate()

  if @days is null 
  begin
    exec settings_read_string @set OUTPUT,'database.cleanup.LogicalDelete','KeepInterval','5d'
    exec get_interval_difference @set, @diff OUTPUT
    set @delete_date = @curr_time-@diff
  end
  else
    set @delete_date=@curr_time-@days

  exec settings_read_bool @delete_all OUTPUT,'database.cleanup.LogicalDelete','DeleteAll',0
  if @delete_all =1
    set @max_to_delete = 999999999
  else
    exec settings_read_number @max_to_delete OUTPUT,'database.cleanup.LogicalDelete','MaxRowsToDelete',10000

  -- bkd 28-feb-2006 -> Exclude Job Service and timesheet from delete date adjustment
  select @min_date=min(login_time) from usession where delete_session_id is null
  and app_name not in ('Job Service','Timesheets','Integration API') 

  if @min_date < @delete_date
    set @delete_date = @min_date

  print 'Delete Date is ' + convert(varchar(30),@delete_date,120)

  declare tabs_c1 cursor local for
    select o.name  from syscolumns c, sysobjects o 
    where o.type = 'U' and o.id = c.id and c.name = 'delete_session_id'
    --and o.name in ('task','rsrc','project','users')
    --and o.name = 'task'
    order by 1;

  CREATE TABLE #count_tab (cnt integer)

  set @pret_val = 0
  set @rows_changed=0
  open tabs_c1
  fetch tabs_c1 into @tab_name
  while (@@fetch_status >= 0)
  begin

    exec get_primary_key @tab_name, @key_cnt OUTPUT, @pk_col1 OUTPUT, @pk_col2 OUTPUT

    if @key_cnt <= 2 
    begin
      set @sub1 = 'delete_session_id is not null and update_date < ''' + convert(varchar(30),@delete_date,120) + ''''
               + ' and delete_session_id not in (select session_id from usession where delete_session_id is null)'
               + ' and delete_session_id >= 0'	;

      set @cntquery='insert into #count_tab select count(*) from dbo.' + @tab_name + ' where ' + @sub1; 
      delete from #count_tab
      exec sp_executesql @cntquery
      if (select * from #count_tab) > 0
      BEGIN
        if @pk_col2 is null  
          set @subquery = 'select ' + @pk_col1 + ' from dbo.' + @tab_name + ' where ' + @sub1;
        else
          set @subquery = 'select str(' + @pk_col1 + ')+str(' + @pk_col2+ ') from dbo.' + @tab_name + ' where ' + @sub1;

        set @del_stmt = 'delete from dbo.' + @tab_name + ' where ' + @sub1

        exec cascade_delete_child @tab_name,null,null, null, @subquery, @del_stmt,null, @errorlevel 
                               , @pret_val OUTPUT, @pret_msg OUTPUT,@max_to_delete

        if @pret_val < 0 
        BEGIN
          print 'Error: ' + @pret_msg
          return (@pret_val)
        END
        set @rows_changed = @rows_changed + @pret_val
        if @rows_changed >= @max_to_delete
          break
        set @pret_val = 0
      END
    END
    fetch tabs_c1 into @tab_name
  end

  print 'Total Rows Deleted/Changed: ' + str(@rows_changed)
  set @pret_val=@rows_changed
  return (@pret_val)
go
--METADATA NAME:CLEANUP_LOGICAL_DELETES TYPE:GRANT TABLE_NAME:CLEANUP_LOGICAL_DELETES CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_LOGICAL_DELETES TO ${pm.ss.privileged_user}
go
print 'Creating procedure HQUERY_PROCESS_REC'

--METADATA  TYPE:SSCR NAME:HQUERY_PROCESS_REC OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'HQUERY_PROCESS_REC' and type in ('P'))
  DROP PROCEDURE HQUERY_PROCESS_REC
go
--METADATA NAME:HQUERY_PROCESS_REC TYPE:PROCEDURE SET:POPULATE_HQUERY CHANGE:CREATE
CREATE PROCEDURE HQUERY_PROCESS_REC
@psession_id integer,
        @pcontext_id integer,
	@orig_pk integer,
        @pk integer,
        @pname varchar(255),
        @counter integer OUTPUT,
        @plevels integer,
	@pret_val INT  OUTPUT,
	@pret_msg varchar(1000)  OUTPUT,
	@ptable_name varchar(30), 
	@pkey_column varchar(30),
        @pname_column varchar(255)
WITH ENCRYPTION AS
  DECLARE @parent_id integer, @name varchar(255), @sql nvarchar(1000)

  -- print 'entering' + str(@pk) + ',' + @pname + ' ctn=' + str(@counter)  

    if not exists(select * from hqdata 
			where session_id=@psession_id
			and context_id=@pcontext_id
			and fk_id=@pk
			and value=@orig_pk)
    begin
        insert into hqdata(session_id,context_id, fk_id, value)
        values ( @psession_id,@pcontext_id, @pk, @orig_pk)
    end

  if @ptable_name = 'PROJWBS'
  BEGIN
    select @parent_id=parent_pk , @name=hname
    from #hquery
    where pk = @pk
  END
  ELSE
  BEGIN
    delete from #parent_ids

    set @sql = 'insert into #parent_ids '
    set @sql=@sql+'select parent_' + @pkey_column +','+@pname_column+ ' from ' + @ptable_name
    set @sql=@sql+' where ' + @pkey_column + ' = @wbsid'

    exec sp_executesql @sql,N'@wbsid int',@pk
    
    select @parent_id=parent_id , @name=name
    from #parent_ids
    
  END

  -- print 'select parent values: '+str(@parent_id)+','+@name
  if @parent_id is not null 
  begin
    exec hquery_process_rec @psession_id,@pcontext_id,@orig_pk,@parent_id,@name,@counter OUTPUT,@plevels,@pret_val OUTPUT,@pret_msg OUTPUT, @ptable_name, @pkey_column, @pname_column
    set @counter=@counter+1
  end
  else 
  begin
    set @counter=0
  end

-- print 'Spin out count = ' + str(@counter) + 'pname=>'+@pname +',name=>' +@name

  -- Do Insert
  if not exists (select * from hquery 
                                  where session_id = @psession_id 
                                  and context_id = @pcontext_id
                                  and fk_id = @pk)
  begin
    if @counter = 0 
    begin
      insert into hquery (session_id,context_id, fk_id, order_value, order_ids)
      values ( @psession_id,@pcontext_id, @pk,@name,@pk)
    end
    else
    begin
      insert into hquery (session_id,context_id, fk_id, order_value, order_ids)
      select session_id,context_id, @pk, order_value, order_ids
      from hquery
      where session_id = @psession_id and context_id = @pcontext_id
      and fk_id = @parent_id

      if @counter < @plevels 
      begin
        set @sql ='update hquery set order_value=order_value+char(1)+@order_value, order_ids=order_ids+char(1)+@order_id'
                  +' where session_id = @session_id and context_id = @context_id '
                  +' and fk_id = @fkid';
--        print @sql
        exec sp_executesql @sql,N'@order_value varchar(4000),@order_id varchar(4000),@session_id int,@context_id int,@fkid int'
                           ,@name,@pk,@psession_id,@pcontext_id,@pk
      end
    end
  end
go
--METADATA NAME:HQUERY_PROCESS_REC TYPE:GRANT TABLE_NAME:HQUERY_PROCESS_REC CHANGE:CREATE
GRANT EXECUTE ON HQUERY_PROCESS_REC TO ${pm.ss.privileged_user}
go
print 'Creating procedure HQUERY_POPULATE'

--METADATA  TYPE:SSCR NAME:HQUERY_POPULATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'HQUERY_POPULATE' and type in ('P'))
  DROP PROCEDURE HQUERY_POPULATE
go
--METADATA NAME:HQUERY_POPULATE TYPE:PROCEDURE SET:POPULATE_HQUERY CHANGE:CREATE
CREATE PROCEDURE HQUERY_POPULATE
        @psession_id integer,
        @pcontext_id integer,
	@ptable_name varchar(30), 
	@pkey_column varchar(30),
        @pname_column varchar(255),
        @pfilter varchar(255),
        @plevels integer,
	@pret_val INT  OUTPUT,
	@pret_msg varchar(1000)  OUTPUT
WITH ENCRYPTION AS
  create table #hquery
  (pk integer,
   hname varchar(255) COLLATE database_default,
   parent_pk integer);

  create table #parent_ids
  (parent_id integer,
   name varchar(255) COLLATE database_default )

  DECLARE @pk integer, @name varchar(255), @cnt integer, @sql nvarchar(1000)

  set @sql='insert into #hquery (pk,hname,parent_pk) '
  set @sql=@sql+'select ' + @pkey_column +','+@pname_column+ ',parent_' 
               + @pkey_column + ' from ' + @ptable_name
  set @sql=@sql+' where ' + @pfilter

--  print @sql

  exec sp_executesql @sql

  update #hquery set parent_pk = null
  from #hquery h
  where not exists ( select * from #hquery h2 where h2.pk = h.parent_pk)

    
  delete from hquery 
  where session_id = @psession_id
  and context_id = @pcontext_id

  delete from hqdata
  where session_id = @psession_id
  and context_id = @pcontext_id

  DECLARE hq_cursor CURSOR LOCAL FOR
  select pk,hname from #hquery;

  OPEN hq_cursor
  FETCH NEXT FROM hq_cursor INTO @pk, @name
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    set @cnt=0
    -- print 'Process #hquery id=' +str(@pk) +','+@name
    exec hquery_process_rec @psession_id,@pcontext_id,@pk,@pk,@name,@cnt OUTPUT,@plevels,@pret_val OUTPUT,@pret_msg OUTPUT,	@ptable_name, @pkey_column, @pname_column

    FETCH NEXT FROM hq_cursor INTO @pk, @name
  END
  CLOSE hq_cursor
  DEALLOCATE hq_cursor
go
--METADATA NAME:HQUERY_POPULATE TYPE:GRANT TABLE_NAME:HQUERY_POPULATE CHANGE:CREATE
GRANT EXECUTE ON HQUERY_POPULATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure HAS_TIMESHEETS'

--METADATA  TYPE:SSCR NAME:HAS_TIMESHEETS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'HAS_TIMESHEETS' and type in ('P'))
  DROP PROCEDURE HAS_TIMESHEETS
go
--METADATA NAME:HAS_TIMESHEETS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE PROCEDURE HAS_TIMESHEETS
	(@pwbs_id integer, @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS
  declare @proj_node_flag varchar(1), @proj_id integer, @cnt integer, @project_flag varchar(1)

  set @pret_val = 0 

  select @proj_node_flag=pw.proj_node_flag, @proj_id=p.proj_id
         ,@project_flag=p.project_flag
  from projwbs pw, project p
  where wbs_id = @pwbs_id
  and pw.proj_id = p.proj_id

  if @proj_node_flag is null 
  begin
    set @pret_val = -1
    set @pret_msg = 'WBS id ' + str(@pwbs_id) + ' does not exist'
  end
  else if @proj_node_flag = 'Y' and @project_flag = 'Y'
  begin
    select @cnt=count(*)
    from rsrchour
    where proj_id = @proj_id
    and task_ts_flag = 'N';

    if @cnt > 0 
      set @pret_val = 1
  end
  else
  begin

    select @cnt=count(*)
    from rsrchour r, taskrsrc tr, task t
    where t.wbs_id = @pwbs_id
    and tr.task_id = t.task_id
    and r.taskrsrc_id = tr.taskrsrc_id
    and r.task_ts_flag = 'N';

    if @cnt > 0 
    BEGIN
      set @pret_val = 1
      return
    END    

    declare @child_wbs_id int
    DECLARE child_wbs CURSOR LOCAL FOR
    select wbs_id
    from projwbs
    where parent_wbs_id = @pwbs_id

    OPEN child_wbs
    FETCH NEXT FROM child_wbs INTO @child_wbs_id
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      exec has_timesheets @child_wbs_id, @pret_val OUTPUT, @pret_msg OUTPUT
      if @pret_val = 1 
        return
      FETCH NEXT FROM child_wbs INTO @child_wbs_id
    END
    CLOSE child_wbs
    DEALLOCATE child_wbs
    
  end
go
--METADATA NAME:HAS_TIMESHEETS TYPE:GRANT TABLE_NAME:HAS_TIMESHEETS CHANGE:CREATE
GRANT EXECUTE ON HAS_TIMESHEETS TO ${pm.ss.privileged_user}
go
print 'Creating procedure SYNC_UDFTYPE'

--METADATA  TYPE:SSCR NAME:SYNC_UDFTYPE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SYNC_UDFTYPE' and type in ('P'))
  DROP PROCEDURE SYNC_UDFTYPE
go
--METADATA NAME:SYNC_UDFTYPE TYPE:PROCEDURE SET:SYNC_UDFTYPE CHANGE:CREATE
CREATE PROCEDURE SYNC_UDFTYPE
( @pret_val INT OUTPUT, @pret_msg VARCHAR(2000) OUTPUT )
WITH ENCRYPTION AS 
  set nocount on
  declare @keys integer, @startkey integer

  select @pret_val = count(*)
  from udftype u1
  where u1.table_name = 'TASKPROC'
  and not exists (select udf_type_id from udftype u2
                where u2.table_name = 'PROCITEM'
                and u2.udf_type_name = u1.udf_type_name
                and u2.logical_data_type = u1.logical_data_type
                and u2.udf_type_label = u1.udf_type_label
                and u2.super_flag = u1.super_flag)

  set @keys=@pret_val

  select @pret_val = @pret_val +  count(*)
  from udftype u1
  where u1.table_name = 'PROCITEM'
  and not exists (select udf_type_id from udftype u2
                where u2.table_name = 'TASKPROC'
                and u2.udf_type_name = u1.udf_type_name)

  if @pret_val = 0 
    return

  -- Get nextkeys for inserts
  exec getnextkeys 'udftype_udf_type_id', @keys, @startkey OUTPUT
 
  print @startkey

  -- start a transaction to keep locks and block other transactions

  begin transaction 

  -- Delete the extra records

  delete from udfcode
  where udf_type_id in (  select U1.udf_type_id
                          from udftype u1
                          where u1.table_name = 'PROCITEM'
                          and not exists (select udf_type_id from udftype u2
                          where u2.table_name = 'TASKPROC'
                          and u2.udf_type_name = u1.udf_type_name)
                       )

  delete from udfvalue
  where udf_type_id in (  select U1.udf_type_id
                          from udftype u1
                          where u1.table_name = 'PROCITEM'
                          and not exists (select udf_type_id from udftype u2
                          where u2.table_name = 'TASKPROC'
                          and u2.udf_type_name = u1.udf_type_name)
                       )

  delete from udftype 
  where udf_type_id in (  select U1.udf_type_id
                          from udftype u1
                          where u1.table_name = 'PROCITEM'
                          and not exists (select udf_type_id from udftype u2
                          where u2.table_name = 'TASKPROC'
                          and u2.udf_type_name = u1.udf_type_name)
                       )

  print 'Deleted ' + ltrim(str(@@rowcount)) + ' row(s)'


  declare @table_name varchar(30), @udf_type_id integer, @logical_data_type varchar(20)
  declare @udf_type_name varchar(32), @udf_type_label varchar(40), @exists smallint
  declare @super_flag varchar(1)
  declare @existing_data_type varchar(20), @existing_udf_type_id integer

  DECLARE ut CURSOR LOCAL FOR 
  select U1.table_name, U1.udf_type_id, u1.logical_data_type, u1.udf_type_name
         ,u1.udf_type_label, u1.super_flag
  from udftype u1
  where u1.table_name = 'TASKPROC'
  and not exists (select udf_type_id from udftype u2
                where u2.table_name = 'PROCITEM'
                and u2.udf_type_name = u1.udf_type_name
                and u2.logical_data_type = u1.logical_data_type
                and u2.udf_type_label = u1.udf_type_label
                and u2.super_flag = u1.super_flag)
  OPEN ut
  FETCH NEXT FROM ut INTO @table_name, @udf_type_id, @logical_data_type, @udf_type_name
                          ,@udf_type_label, @super_flag
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
      select @exists=count(*) 
      from udftype 
      where table_name = 'PROCITEM' 
      and udf_type_name = @udf_type_name;

      if @exists = 0 
      begin
        insert into udftype (udf_type_id, table_name, udf_type_name, udf_type_label,
                             logical_data_type, super_flag )
        values (@startkey, 'PROCITEM', @udf_type_name, @udf_type_label,
                             @logical_data_type, @super_flag)

        set @startkey = @startkey + 1
      end
      else if @exists > 1 
      begin
        set @pret_msg = 'Too many values for type ' + @udf_type_name
        set @pret_val = -1
        return
      end
      else
      begin
        print 'to update'
  
        select @existing_udf_type_id=udf_type_id, @existing_data_type=logical_data_type
        from udftype 
        where table_name = 'PROCITEM' 
        and udf_type_name = @udf_type_name;

        if @logical_data_type <> @existing_data_type
          delete from udfvalue where udf_type_id = @existing_udf_type_id

        update udftype
        set udf_type_label = @udf_type_label, logical_data_type = @logical_data_type
            , super_flag = @super_flag
        where udf_type_id = @existing_udf_type_id
      end

      FETCH NEXT FROM ut INTO @table_name, @udf_type_id, @logical_data_type, @udf_type_name
                          ,@udf_type_label, @super_flag
  END
  CLOSE ut
  DEALLOCATE ut

  commit transaction
go
--METADATA NAME:SYNC_UDFTYPE TYPE:GRANT TABLE_NAME:SYNC_UDFTYPE CHANGE:CREATE
GRANT EXECUTE ON SYNC_UDFTYPE TO ${pm.ss.privileged_user}
go
print 'Creating procedure USESSION_CLEANUP'

--METADATA  TYPE:SSCR NAME:USESSION_CLEANUP OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USESSION_CLEANUP' and type in ('P'))
  DROP PROCEDURE USESSION_CLEANUP
go
--METADATA NAME:USESSION_CLEANUP TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE PROCEDURE USESSION_CLEANUP
	@psession_id	int = null,
    @pwhere_clause	varchar(1000) = null,
    @pmark_delete  char(1) = 'Y',
    @pret_val int OUTPUT,
    @pret_msg varchar(1000) OUTPUT
WITH ENCRYPTION AS
  SET NOCOUNT ON	
  set @pret_val = 0
  declare @sql nvarchar(4000), @where_clause nvarchar(1000)
  if @psession_id is null and @pwhere_clause is null
  begin
    set @pret_val = -1
    set @pret_msg = 'Must specify @psession_id or @pwhere_clause'
    return
  end
  create table #session_keys (pk1 int)

  if @psession_id is not null 
    insert into #session_keys ( pk1)
    values (@psession_id)
  else
  begin
    set @where_clause = cast(@pwhere_clause as nvarchar(1000))
    set @sql = N'insert into #session_keys ( pk1) '+
						N' select session_id ' +
						N' from usession (nolock) where ' + @where_clause
    exec sp_executesql @sql
  end ;


  declare @pk int
  declare todel cursor for select pk1 from #session_keys
  open todel
  fetch todel into @pk
  while @@fetch_status >= 0
  begin
    if @pmark_delete = 'Y' 
	 begin
       declare @test int
       select @test = delete_session_id from usession where session_id = @pk
       if @test is null
       begin
		update usession set delete_session_id = 0, delete_date = GetDate() 
		where session_id = @pk
		delete from projshar where session_id = @pk
       end
     end
    else
    begin
      delete from dltacct where session_id = @pk
      delete from dltactv where session_id = @pk
      delete from dltobs where session_id = @pk
      delete from dltrole where session_id = @pk
      delete from dltrsrc where session_id = @pk
      delete from dltrsrl where session_id = @pk
      delete from dltuser where session_id = @pk
      delete from upklist where session_id = @pk
      delete from projshar where session_id = @pk
      delete from usession where session_id = @pk
    end

    fetch todel into @pk
  end
  close todel
  deallocate todel   

  --Cleanup old DLT records based on < min USESSION 
  declare @min_session_id int  
  select @min_session_id=min(session_id) from usession
  if @min_session_id is null
    select @min_session_id=key_seq_num from nextkey where key_name = 'usession_session_id'
  delete from dltacct where session_id < @min_session_id
  delete from dltactv where session_id < @min_session_id
  delete from dltobs where session_id < @min_session_id
  delete from dltrole where session_id < @min_session_id
  delete from dltrsrc where session_id < @min_session_id
  delete from dltrsrl where session_id < @min_session_id
  delete from dltuser where session_id < @min_session_id

go
--METADATA NAME:USESSION_CLEANUP TYPE:GRANT TABLE_NAME:USESSION_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEANUP TO ${pm.ss.privileged_user}
go
print 'Creating procedure USESSION_CLEAR_LOGICAL_DELETES'

--METADATA  TYPE:SSCR NAME:USESSION_CLEAR_LOGICAL_DELETES OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USESSION_CLEAR_LOGICAL_DELETES' and type in ('P'))
  DROP PROCEDURE USESSION_CLEAR_LOGICAL_DELETES
go
--METADATA NAME:USESSION_CLEAR_LOGICAL_DELETES TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE PROCEDURE USESSION_CLEAR_LOGICAL_DELETES
	(@pret_val int OUTPUT , @pret_msg varchar(4000) OUTPUT)
WITH ENCRYPTION AS
  set @pret_val = 0
  create table #session_keys (pk1 int)
  insert into #session_keys
  select session_id from usession (nolock) where delete_session_id is not null;

  declare @pk int
  declare todel_ld cursor for select pk1 from #session_keys
  open todel_ld
  fetch todel_ld into @pk
  while @@fetch_status >= 0
  begin
    delete from dltacct where session_id = @pk
    delete from dltactv where session_id = @pk
    delete from dltobs where session_id = @pk
    delete from dltrole where session_id = @pk
    delete from dltrsrc where session_id = @pk
    delete from dltrsrl where session_id = @pk
    delete from dltuser where session_id = @pk
    delete from upklist where session_id = @pk
    delete from projshar where session_id = @pk
    delete from tprojmap where session_id= @pk
    delete from usession where session_id = @pk
    set @pret_val = @pret_val + 1
    fetch todel_ld into @pk
  end
  close todel_ld
  deallocate todel_ld   

go
--METADATA NAME:USESSION_CLEAR_LOGICAL_DELETES TYPE:GRANT TABLE_NAME:USESSION_CLEAR_LOGICAL_DELETES CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEAR_LOGICAL_DELETES TO ${pm.ss.privileged_user}
go
print 'Creating procedure USESSION_CLEANUP_EXPIRED'

--METADATA  TYPE:SSCR NAME:USESSION_CLEANUP_EXPIRED OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USESSION_CLEANUP_EXPIRED' and type in ('P'))
  DROP PROCEDURE USESSION_CLEANUP_EXPIRED
go
--METADATA NAME:USESSION_CLEANUP_EXPIRED TYPE:PROCEDURE SET:USESSION_PROCS CHANGE:CREATE
CREATE PROCEDURE USESSION_CLEANUP_EXPIRED
	(@pret_val int OUTPUT , @pret_msg varchar(4000) OUTPUT)
WITH ENCRYPTION AS
  declare @set varchar(20), @diff decimal(20,6), @delete_time datetime
  declare @date_str varchar(30), @ret int, @msg varchar(2000), @where varchar(255)
  set @pret_msg = 0
  exec settings_read_string @set OUTPUT,'database.cleanup.Usession','ExpiredSessionTimeout','2h'
  exec get_interval_difference @set, @diff OUTPUT
  set @delete_time=GetDate()-@diff
  set @date_str = convert(varchar(30),@delete_time,120)
  set @where = 'last_active_time < convert(datetime,'''
			 + @date_str + ''',120)'
       + ' and IsNull(long_operation_flag,''Y'') <> ''Y'''
  exec usession_cleanup null,@where, 'Y', @pret_val OUTPUT, @pret_msg OUTPUT
  exec settings_read_string @set OUTPUT,'database.cleanup.Usession','ExpiredLongSessionTimeout','12h'
  exec get_interval_difference @set, @diff OUTPUT
  set @delete_time=GetDate()-@diff
  set @date_str = convert(varchar(30),@delete_time,120)
  set @where = 'last_active_time < convert(datetime,'''
			 + @date_str + ''',120)'
       + ' and IsNull(long_operation_flag,''Y'') = ''Y'''
  exec usession_cleanup null,@where, 'Y', @pret_val OUTPUT, @pret_msg OUTPUT
go
--METADATA NAME:USESSION_CLEANUP_EXPIRED TYPE:GRANT TABLE_NAME:USESSION_CLEANUP_EXPIRED CHANGE:CREATE
GRANT EXECUTE ON USESSION_CLEANUP_EXPIRED TO ${pm.ss.privileged_user}
go
print 'Creating procedure USER_DEFINED_BACKGROUND'

--METADATA  TYPE:SSCR NAME:USER_DEFINED_BACKGROUND OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'USER_DEFINED_BACKGROUND' and type in ('P'))
  DROP PROCEDURE USER_DEFINED_BACKGROUND
go
--METADATA NAME:USER_DEFINED_BACKGROUND TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE USER_DEFINED_BACKGROUND
WITH ENCRYPTION AS
  set nocount off
  -- THIS PROCEDURE INTENTIONALLY LEFT BLANK
  -- Procedure is called by data_monitor.  Customer 
  -- specific code can go here.
go
--METADATA NAME:USER_DEFINED_BACKGROUND TYPE:GRANT TABLE_NAME:USER_DEFINED_BACKGROUND CHANGE:CREATE
GRANT EXECUTE ON USER_DEFINED_BACKGROUND TO ${pm.ss.privileged_user}
go
print 'Creating procedure CLEANUP_OLD_DATA'

--METADATA  TYPE:SSCR NAME:CLEANUP_OLD_DATA OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CLEANUP_OLD_DATA' and type in ('P'))
  DROP PROCEDURE CLEANUP_OLD_DATA
go
--METADATA NAME:CLEANUP_OLD_DATA TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE CLEANUP_OLD_DATA
WITH ENCRYPTION AS
  set nocount off
  -- THIS PROCEDURE INTENTIONALLY LEFT BLANK
  -- Procedure is called by data_monitor.  Cleanup 
  -- of old data specific to current version would
  -- be placed here.  May be empty for any given release
go
--METADATA NAME:CLEANUP_OLD_DATA TYPE:GRANT TABLE_NAME:CLEANUP_OLD_DATA CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_OLD_DATA TO ${pm.ss.privileged_user}
go
print 'Creating procedure BGPLOG_CLEANUP'

--METADATA  TYPE:SSCR NAME:BGPLOG_CLEANUP OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'BGPLOG_CLEANUP' and type in ('P'))
  DROP PROCEDURE BGPLOG_CLEANUP
go
--METADATA NAME:BGPLOG_CLEANUP TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE BGPLOG_CLEANUP
(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS
  set nocount off
  declare @set varchar(20), @diff decimal(20,6), @delete_time datetime
  declare @delcnt int
  exec settings_read_string @set OUTPUT,'database.cleanup.BackGroundProcessLog','KeepInterval','5d'
  exec get_interval_difference @set, @diff OUTPUT
  set @delete_time=GetDate()-@diff
  delete from bgplog where log_time < @delete_time
  set @delcnt = @@ROWCOUNT
  set @pret_val=@delcnt
go
--METADATA NAME:BGPLOG_CLEANUP TYPE:GRANT TABLE_NAME:BGPLOG_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON BGPLOG_CLEANUP TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJECT_COPY_LIST'

--METADATA  TYPE:SSCR NAME:PROJECT_COPY_LIST OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_COPY_LIST' and type in ('P'))
  DROP PROCEDURE PROJECT_COPY_LIST
go
--METADATA NAME:PROJECT_COPY_LIST TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE PROCEDURE PROJECT_COPY_LIST
	@proj_list	varchar(8000),
	@dest_wbs_id	integer,
	@copy_bit	varchar(40),
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(8000) OUTPUT,
    @pscenario_id   integer = null,
	@ppfolio_id	integer = null,
	@psession_id	integer = null,
	@pservice_id	integer = null,
	@vis_project_baseline char(1)= null
WITH ENCRYPTION AS
  set nocount on
  if substring(@copy_bit,23,1)='1' and @pscenario_id is null
  begin
    set @pret_val = -1
    set @pret_msg = 'Must specify scenario_id for scenario copy'
    return
  end
 exec multi_project_copy @proj_list,@dest_wbs_id,@copy_bit,@pret_val OUTPUT,@pret_msg OUTPUT,@ppfolio_id,@@spid,null,@pscenario_id
go
--METADATA NAME:PROJECT_COPY_LIST TYPE:GRANT TABLE_NAME:PROJECT_COPY_LIST CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_LIST TO ${pm.ss.privileged_user}
go
print 'Creating procedure ADD_DATABASE_JOB'

--METADATA  TYPE:SSCR NAME:ADD_DATABASE_JOB OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ADD_DATABASE_JOB' and type in ('P'))
  DROP PROCEDURE ADD_DATABASE_JOB
go
--METADATA NAME:ADD_DATABASE_JOB TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE ADD_DATABASE_JOB
  @pjob_name		sysname, 
  @pcommand			nvarchar(255),
  @pjob_id			binary(16) OUTPUT,
  @pinterval		varchar(10),
  @precreate		bit = 0,
  @DayOfWeek 		int=64
WITH ENCRYPTION AS
SET NOCOUNT ON 
   declare @time_int int, @time_code char(1)
   declare @sub_day_type tinyint, @rc int
   declare @job_freq_type int
   declare @job_freq_interval int
   declare @job_freq_recurrence_factor int
   print 'Creating job ' + @pjob_name
   set @time_code =upper(substring(@pinterval,len(@pinterval),1))
   set @time_int = cast(substring(@pinterval,1,len(@pinterval)-1) AS integer)
   set @job_freq_interval=1
   set @job_freq_recurrence_factor=1
   if @time_code = 'S' 
     begin
     set @sub_day_type=2
     set @job_freq_type=4 
     end
   else if @time_code = 'M' 
     begin
     set @sub_day_type=4
     set @job_freq_type=4
     end
   else if @time_code = 'D'
   begin
     set @sub_day_type=0
     set @job_freq_type=4
     set @time_int=1
   end
   else if @time_code = 'W'
    begin 
     set @sub_day_type=1
     set @job_freq_type=8
     set @job_freq_interval=@DayOfWeek
     set @job_freq_recurrence_factor=@time_int   
   end
   else
     raiserror('Invalid time code ' ,16,1)
   if (not exists(select 1 from msdb.dbo.syscategories where name = N'PrimaveraJobs'))
   	exec msdb.dbo.sp_add_category  @name = N'PrimaveraJobs'
   declare @dbname sysname
   select @dbname=name from master..sysdatabases where dbid in (select dbid from master..sysprocesses where spid=@@spid)
   set @pjob_name = @pjob_name + ' for ' + @dbname
   select @pjob_id = job_id     
   from msdb.dbo.sysjobs    
   where name = @pjob_name  
   if @precreate > 0 and @pjob_id is not null
     exec msdb.dbo.sp_delete_job @job_name = @pjob_name
   else if @precreate =0 and @pjob_id is not null
     return
   set @pjob_id=null
 print 'Creating New Job'
   exec @rc = msdb.dbo.sp_add_job
 		@job_id = @pjob_id OUTPUT,
 		@job_name = @pjob_name,
 		@category_name = N'PrimaveraJobs',
 		@enabled=1,
 		@notify_level_email = 0, 
 		@notify_level_page = 0, 
 		@notify_level_netsend = 0, 
 		@notify_level_eventlog = 2

   if (@@ERROR <> 0 OR @rc <> 0)
   begin
     raiserror('add_database_job: Create new Job failed ',16,1)
     return
   end
   exec @rc = msdb.dbo.sp_add_jobstep
 		@job_id = @pjob_id, 
 		@step_id = 1, 
 		@step_name = N'Command', 
 		@command = @pcommand, 
 		@database_name = @dbname,
 		@subsystem = N'TSQL'
   if (@@ERROR <> 0 OR @rc <> 0)
   begin
     raiserror('add_database_job: Create Job step failed ',16,1)
     return
   end
   exec @rc = msdb.dbo.sp_update_job 
 		@job_id = @pjob_id, 
 		@start_step_id = 1 
   if (@@ERROR <> 0 OR @rc <> 0)
   begin
     raiserror('add_database_job: Create Job start step failed ',16,1)
     return
   end
   exec @rc = msdb.dbo.sp_add_jobschedule 
 		@job_id = @pjob_id, 
 		@name = N'Main Schedule', 
 		@enabled = 1, 
 		@freq_type = @job_freq_type, 
 		@freq_interval = @job_freq_interval, 
 		@freq_subday_type = @sub_day_type,
 		@freq_subday_interval = @time_int,
		@freq_recurrence_factor=@job_freq_recurrence_factor
   if (@@ERROR <> 0 OR @rc <> 0)
   begin
     raiserror('add_database_job: Create Job schedule failed ',16,1)
     return
   end
   exec @rc = msdb.dbo.sp_add_jobserver 
 		@job_id = @pjob_id, 
 		@server_name = N'(local)' 
   if (@@ERROR <> 0 OR @rc <> 0)
   begin
     raiserror('add_database_job: Add Job server failed ',16,1)
     return
   end
go
--METADATA NAME:ADD_DATABASE_JOB TYPE:GRANT TABLE_NAME:ADD_DATABASE_JOB CHANGE:CREATE
GRANT EXECUTE ON ADD_DATABASE_JOB TO ${pm.ss.privileged_user}
go
print 'Creating procedure DELETE_PROJECT_CODE_SCENARIOS'

--METADATA  TYPE:SSCR NAME:DELETE_PROJECT_CODE_SCENARIOS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DELETE_PROJECT_CODE_SCENARIOS' and type in ('P'))
  DROP PROCEDURE DELETE_PROJECT_CODE_SCENARIOS
go
--METADATA NAME:DELETE_PROJECT_CODE_SCENARIOS TYPE:PROCEDURE SET:SCENARIOS CHANGE:CREATE
CREATE PROCEDURE DELETE_PROJECT_CODE_SCENARIOS
	(@proj_catg_type_id integer
	,@pret_val integer OUTPUT
	,@pret_msg varchar(4000) OUTPUT )
WITH ENCRYPTION AS
  set nocount on 
  declare @delcnt int, @SQL nvarchar(255), @proj_id int
  declare @ret int, @msg varchar(4000)
  set @delcnt = 0

  create table #scenproj (scenario_id int,proj_id int);
  set @SQL = N'insert into #scenproj 
	select sp.scenario_id , sp.proj_id
	from pcatval pc, scenario s, scenproj sp
	where table_name = ''PCATVAL'' 
	and s.fk_id = pc.proj_catg_id
	and sp.scenario_id = s.scenario_id
	and pc.proj_catg_type_id = ' + str(@proj_catg_type_id) 

  exec sp_executesql @SQL
  DECLARE sp CURSOR FOR select distinct proj_id from #scenproj
  OPEN sp
  FETCH NEXT FROM sp INTO @proj_id
  WHILE @@FETCH_STATUS = 0
  BEGIN
    PRINT @proj_id
    exec cascade_delete 'PROJECT',@proj_id,@ret OUTPUT, @msg OUTPUT
    if @ret < 0 
    begin
      set @pret_val = @ret
      set @pret_msg = @msg
      return
    end
    set @delcnt=@delcnt+1
    FETCH NEXT FROM sp INTO @proj_id
  END
  CLOSE sp
  DEALLOCATE sp

  delete from scenproj where scenario_id in (select scenario_id from #scenproj)
  delete from scenuser where scenario_id in (select scenario_id from #scenproj)
  delete from scenario where scenario_id in (select scenario_id from #scenproj)

  set @pret_val = 0
  set @pret_msg = 'Deleted ' + ltrim(str(@delcnt)) + ' project(s)'  
go
--METADATA NAME:DELETE_PROJECT_CODE_SCENARIOS TYPE:GRANT TABLE_NAME:DELETE_PROJECT_CODE_SCENARIOS CHANGE:CREATE
GRANT EXECUTE ON DELETE_PROJECT_CODE_SCENARIOS TO ${pm.ss.privileged_user}
go
print 'Creating procedure INITIALIZE_BACKGROUND_PROCS'

--METADATA  TYPE:SSCR NAME:INITIALIZE_BACKGROUND_PROCS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'INITIALIZE_BACKGROUND_PROCS' and type in ('P'))
  DROP PROCEDURE INITIALIZE_BACKGROUND_PROCS
go
--METADATA NAME:INITIALIZE_BACKGROUND_PROCS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE INITIALIZE_BACKGROUND_PROCS
WITH ENCRYPTION AS
 SET NOCOUNT ON 
    declare @job_id binary(16), @rc integer, @set varchar(10), @sjob_id varchar(50)
    declare @dayofweek varchar(9),@Daynum integer
    if  patindex('%EXPRESS EDITION%',upper(@@version)) > 0 
    BEGIN
      set @set = '5m'
      exec settings_write_string @set,'database.background.Damon','Interval'
      exec settings_write_string @set,'database.background.Symon','Interval'
      return
    END
    exec settings_read_string @set OUTPUT,'database.background.Symon','Interval','XX'
    if @set = 'XX' or @set is NULL
    begin
      set @set = '1m'
      exec settings_write_string @set,'database.background.Symon','Interval'
    end
    exec @rc = add_database_job 
  		@pjob_name='System Monitor (Symon)',
  		@pcommand='exec system_monitor',
  		@pjob_id=@job_id OUTPUT,
  		@pinterval=@set,
  		@precreate=1
    if (@@ERROR <> 0 OR @rc <> 0)
    begin
      raiserror('initialize_background_procs: Creation of System Monitor process failed',16,1)
      return
    end
    set @sjob_id=convert(varchar(50),@job_id)
    exec settings_write_string @sjob_id,'database.background.Symon','JobId'
    print 'System Monitor Job ID'
    print '=================================='
    print  @job_id
    set @job_id=null
    exec settings_read_string @set OUTPUT,'database.background.Damon','Interval','XX'
    if @set = 'XX' or @set is NULL
    begin
      set @set = '1W'
      exec settings_write_string @set,'database.background.Damon','Interval'
    end
    exec settings_read_string @DayOfweek OUTPUT,'database.background.Damon','DayOfWeek','SATURDAY'
    Select  @Daynum=
 			case @DayOfweek 
 		      When 'SUNDAY' then 1
 		      When 'MONDAY' then  2
 		      When 'TUESDAY' then  4
 		      When 'WEDNESDAY' then  8
 		      When 'THURSDAY' then  16
 		      When 'FRIDAY' then  32
 		      When 'SATURDAY' then  64
 			 ELSE  
 			    64
 		   END
     exec @rc = add_database_job 
  		@pjob_name='Data Monitor (Damon)',
  		@pcommand='exec data_monitor',
  		@pjob_id=@job_id OUTPUT,
  		@pinterval=@set,
  		@precreate=1,@DayOfWeek=@Daynum
    if (@@ERROR <> 0 OR @rc <> 0)
    begin
      raiserror('initialize_background_procs: Creation of Data Monitor process failed',16,1)
      return
    end
    set @sjob_id=convert(varchar(50),@job_id)
    exec settings_write_string @sjob_id,'database.background.Damon','JobId'
    print 'Data Monitor Job ID'
    print '=================================='
   print  @job_id
go
--METADATA NAME:INITIALIZE_BACKGROUND_PROCS TYPE:GRANT TABLE_NAME:INITIALIZE_BACKGROUND_PROCS CHANGE:CREATE
GRANT EXECUTE ON INITIALIZE_BACKGROUND_PROCS TO ${pm.ss.privileged_user}
go
print 'Creating procedure DROP_BACKGROUND_PROCS'

--METADATA  TYPE:SSCR NAME:DROP_BACKGROUND_PROCS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DROP_BACKGROUND_PROCS' and type in ('P'))
  DROP PROCEDURE DROP_BACKGROUND_PROCS
go
--METADATA NAME:DROP_BACKGROUND_PROCS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE DROP_BACKGROUND_PROCS
WITH ENCRYPTION AS
  declare @dbname sysname, @job_name sysname, @cnt int
  select @dbname=name from master..sysdatabases where dbid in (select dbid from master..sysprocesses where spid=@@spid)

  --Create a unique job name
  set @job_name = 'System Monitor (Symon) for ' + @dbname
  if (select count(*) from msdb.dbo.sysjobs where name = @job_name  ) > 0
  begin
    exec msdb.dbo.sp_delete_job @job_name = @job_name
    print 'Dropped job ' + @job_name
  end
  --Create a unique job name
  set @job_name = 'Data Monitor (Damon) for ' + @dbname
  if (select count(*) from msdb.dbo.sysjobs where name = @job_name  ) > 0
  begin
    exec msdb.dbo.sp_delete_job @job_name = @job_name
    print 'Dropped job ' + @job_name
  end
go
--METADATA NAME:DROP_BACKGROUND_PROCS TYPE:GRANT TABLE_NAME:DROP_BACKGROUND_PROCS CHANGE:CREATE
GRANT EXECUTE ON DROP_BACKGROUND_PROCS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PRMAUDIT_CLEANUP'

--METADATA  TYPE:SSCR NAME:PRMAUDIT_CLEANUP OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUDIT_CLEANUP' and type in ('P'))
  DROP PROCEDURE PRMAUDIT_CLEANUP
go
--METADATA NAME:PRMAUDIT_CLEANUP TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE PRMAUDIT_CLEANUP
(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS
  set nocount off
  declare @set varchar(20), @diff decimal(20,6), @delete_time datetime
  declare @delcnt int
  declare @auditstatus bit 
  exec settings_read_bool @auditstatus OUTPUT,'database.cleanup.auditing','Enabled',1
 if @auditstatus = 1
 begin
  exec settings_read_string @set OUTPUT,'database.cleanup.auditing','KeepInterval','30d'
  exec get_interval_difference @set, @diff OUTPUT
  set @delete_time=GetDate()-@diff
   delete from prmaudit where audit_date < @delete_time
  set @delcnt = @@ROWCOUNT
  set @pret_val=@delcnt
 end
go
--METADATA NAME:PRMAUDIT_CLEANUP TYPE:GRANT TABLE_NAME:PRMAUDIT_CLEANUP CHANGE:CREATE
GRANT EXECUTE ON PRMAUDIT_CLEANUP TO ${pm.ss.privileged_user}
go
print 'Creating procedure PV_LOGIN'

--METADATA  TYPE:SSCR NAME:PV_LOGIN OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PV_LOGIN' and type in ('P'))
  DROP PROCEDURE PV_LOGIN
go
--METADATA NAME:PV_LOGIN TYPE:PROCEDURE SET:PV_LOGIN CHANGE:CREATE
CREATE PROCEDURE PV_LOGIN
@puser_id int, @wbs_list varchar(4000) OUTPUT,@pret_val int OUTPUT , @pret_msg varchar(4000) OUTPUT
WITH ENCRYPTION AS
  set nocount on 
  declare @wbs_id int
  create table #pvroot(wbs_id int)

  insert into #pvroot 
  select distinct op.wbs_id
  from obsproj op, userobs uo, projwbs pw
  where op.obs_id = uo.obs_id and uo.user_id = @puser_id
  and pw.wbs_id = op.wbs_id
  and uo.delete_session_id is null and pw.delete_session_id is null
  and not exists (
  	select op.wbs_id
    from obsproj op, userobs uo
    where op.obs_id = uo.obs_id and uo.user_id = @puser_id
    and uo.delete_session_id is null and op.wbs_id = pw.parent_wbs_id
    )

  set @wbs_list = null
  DECLARE nodes CURSOR FOR select wbs_id from #pvroot order by 1;

  OPEN nodes
  FETCH nodes INTO @wbs_id
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    if @wbs_list is null
      set @wbs_list = ltrim(Str(@wbs_id))
    else
      set @wbs_list = @wbs_list + ',' + ltrim(Str(@wbs_id))
    FETCH nodes INTO @wbs_id
  END
  CLOSE nodes
  DEALLOCATE nodes

  if len(@wbs_list)>=4000
    begin
      delete from pkxref where system_id=@@spid and context_name='ROOTS'
      insert into pkxref(system_id,context_name,pk1) select @@spid,'ROOTS',wbs_id from #pvroot
      set @pret_val=@@spid
      set @pret_msg='node list returned in pkxref table'
      set @wbs_list = null
    end
  else
  begin
    set @pret_val=0
    set @pret_msg='node list returned in variable'
  end
go
--METADATA NAME:PV_LOGIN TYPE:GRANT TABLE_NAME:PV_LOGIN CHANGE:CREATE
GRANT EXECUTE ON PV_LOGIN TO ${pm.ss.privileged_user}
go
print 'Creating procedure SQL_TRACE_START'

--METADATA  TYPE:SSCR NAME:SQL_TRACE_START OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SQL_TRACE_START' and type in ('P'))
  DROP PROCEDURE SQL_TRACE_START
go
--METADATA NAME:SQL_TRACE_START TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE PROCEDURE SQL_TRACE_START
@plocation nvarchar(245),@psessionid int,@pusername varchar(32),@poperation varchar(255) ,@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT,@ptraceid int OUTPUT
WITH ENCRYPTION AS
declare   @Outputfile nvarchar(245),@vlocation nvarchar(245),@trace_id int,@vmaxsize bigint,@eventid int,@columnid int,@on bit,@hostname nvarchar(128),@dbid int,@FileExists int,@colname varchar(50),@eventdesc varchar(50)
  begin 
  SET NOCOUNT ON
  set @vmaxsize=50
  set @on=1
  if @plocation is null
  begin
    exec settings_read_string @vlocation OUTPUT,'database.trace','Location','c:\temp'
    set @Outputfile=@vlocation+'\'+@pusername+'_'+ltrim(rtrim(str(@psessionid)))+'_'+ltrim(rtrim(str(@@spid)))+'_' +@poperation 
  end
  else
    set @Outputfile=@plocation+'\'+@pusername+'_'+ltrim(rtrim(str(@psessionid)))+'_'+ltrim(rtrim(str(@@spid)))+'_'+@poperation

  exec @pret_val=sp_trace_create  @trace_id OUTPUT ,2,  @Outputfile,  @vmaxsize
  if @pret_val <>0 
  begin
    set @pret_msg='Could not Create the trace file'
    set @pret_val=-1
    exec bgp_write_to_log 'SQL_TRACE_START',@pret_msg,'Error'
    return -1
  end 
  else
    set @ptraceid=@trace_id

  print 'trace id='+str(@trace_id)
  CREATE TABLE #Events (
   EventId smallint NOT NULL ,
   EventName varchar(50) NOT NULL )
  INSERT INTO #events values(10,'RPC:Completed')
  INSERT INTO #events values(12,'SQL:BatchCompleted')
  INSERT INTO #events values(45,'SP:StmtCompleted')
  INSERT INTO #events values(43,'SP:Completed')

  CREATE TABLE #ColumnList
  (
	ColumnID smallint NOT NULL,
	ColumnName varchar(50) NOT NULL
  )
  INSERT INTO #ColumnList VALUES(1,'TextData')
  INSERT INTO #ColumnList VALUES(3,'DatabaseID')
  INSERT INTO #ColumnList VALUES(8,'ClientHostName')
  INSERT INTO #ColumnList VALUES(10,'ApplicationName')
  INSERT INTO #ColumnList VALUES(12,'SPID')
  INSERT INTO #ColumnList VALUES(13,'Duration')
  INSERT INTO #ColumnList VALUES(14,'StartTime')
  INSERT INTO #ColumnList VALUES(15,'EndTime')
  INSERT INTO #ColumnList VALUES(16,'Reads')
  INSERT INTO #ColumnList VALUES(17,'Writes')
  INSERT INTO #ColumnList VALUES(18,'CPU')

  set  @hostname=host_name()
  set @dbid=db_id()
  SET @eventid = (SELECT MIN(eventid) FROM #Events)
  WHILE @eventid IS NOT NULL
     BEGIN
	SET @columnid = (SELECT MIN(columnid) FROM #Columnlist)
	WHILE @columnid IS NOT NULL
          BEGIN
	     EXEC @pret_val = sp_trace_setevent @trace_id,@eventid,@columnid,@on
		IF @pret_val <> 0
		BEGIN 
         	  select @eventdesc=eventname from #events where eventid=@eventid
		  select @colname=columnname from #columnlist where columnid=@columnid
		  set @pret_msg='Failed to add Event-' +@eventdesc+' with Column-'+@colname
                  set @pret_val=-1
		  exec bgp_write_to_log 'SQL_TRACE_START','Error' ,@pret_msg
		  return -1
		END

   	     SET @columnid = (SELECT MIN(columnid) FROM #Columnlist WHERE columnid > @columnid)			
	  END
	 SET @eventid = (SELECT MIN(eventid) FROM #Events WHERE eventid > @eventid)
     END

   exec @pret_val=sp_trace_setfilter  @trace_id ,3,0,0,@dbid
   if @pret_val <>0 
   begin
      set @pret_msg='Could not Set the filter on database id '
      set @pret_val=-1
      exec bgp_write_to_log 'SQL_TRACE_START','Error' ,@pret_msg
      return -1
   end 

   exec @pret_val=sp_trace_setfilter  @trace_id ,8,0,0,@hostname
   if @pret_val <>0 
   begin
      set @pret_msg='Could not Set the filter on host name '
      set @pret_val=-1
      exec bgp_write_to_log 'SQL_TRACE_START','Error' ,@pret_msg
      return -1
   end 

   exec @pret_val=sp_trace_setstatus @trace_id,1
   if @pret_val <>0 
   begin
      set @pret_msg='Could not Start the trace '
      set @pret_val=-1
      exec bgp_write_to_log 'SQL_TRACE_START','Error' ,@pret_msg
      return -1
   end 
  end
go
--METADATA NAME:SQL_TRACE_START TYPE:GRANT TABLE_NAME:SQL_TRACE_START CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_START TO ${pm.ss.privileged_user}
go
print 'Creating procedure SQL_TRACE_END'

--METADATA  TYPE:SSCR NAME:SQL_TRACE_END OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SQL_TRACE_END' and type in ('P'))
  DROP PROCEDURE SQL_TRACE_END
go
--METADATA NAME:SQL_TRACE_END TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE PROCEDURE SQL_TRACE_END
@ptrace_id int,@pret_val int OUTPUT,@pret_msg varchar(255) OUTPUT
WITH ENCRYPTION AS
  declare @retval int
  begin 
  SET NOCOUNT ON
  exec @retval=sp_trace_setstatus @ptrace_id,0
  if @retval <>0 
  begin
    set @pret_msg='Unable to stop the trace'
    set @pret_val=-1
    exec bgp_write_to_log 'SQL_TRACE_END','Error' ,@pret_msg
    return -1
  end
  exec @retval=sp_trace_setstatus @ptrace_id,2
  if @retval <>0 
  begin
    set @pret_msg='Unable to Close the trace'
    set @pret_val=-1
    exec bgp_write_to_log 'SQL_TRACE_END','Error' ,@pret_msg
    return -1
  end
end
go
--METADATA NAME:SQL_TRACE_END TYPE:GRANT TABLE_NAME:SQL_TRACE_END CHANGE:CREATE
GRANT EXECUTE ON SQL_TRACE_END TO ${pm.ss.privileged_user}
go
print 'Creating procedure PRIMAVERA_EVENT'

--METADATA  TYPE:SSCR NAME:PRIMAVERA_EVENT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRIMAVERA_EVENT' and type in ('P'))
  DROP PROCEDURE PRIMAVERA_EVENT
go
--METADATA NAME:PRIMAVERA_EVENT TYPE:PROCEDURE SET:PRIMAVERA_EVENT CHANGE:CREATE
CREATE PROCEDURE PRIMAVERA_EVENT
	@papp_name varchar(30),
	@poperation varchar(30),
	@paction varchar(30),
	@puser_id INT=null,
	@puser_name varchar(255)=null,
	@psession_id INT=null,
	@pevent_data varchar(4000)=null
WITH ENCRYPTION AS
  set nocount on 
  declare @v_long_running_flag char(1)

  if @psession_id is not null
  begin

    if    upper(@poperation) = 'SCHEDULING'
       OR upper(@poperation) = 'LEVELING'
       OR upper(@poperation) = 'APPLY ACTUALS'
       OR upper(@poperation) = 'UPDATE PROGRESS'
       --OR upper(@poperation) = 'Paste Project Stored Procedure'
       OR upper(@poperation) = 'TIME APPROVAL'
       OR upper(@poperation) = 'SUMMARIZE'
       OR upper(@poperation) = 'GLOBAL CHANGE'
       OR upper(@poperation) = 'UPDATE BASELINE'
       OR upper(@poperation) = 'TRANSFORM XML'
       OR upper(substring(@poperation,1,7)) = 'PUBLISH'
       OR upper(substring(@poperation,1,6)) = 'EXPORT'
       OR upper(substring(@poperation,1,6)) = 'IMPORT'
	   OR upper(substring(@poperation,1,5)) = 'PASTE'
      set @v_long_running_flag = 'Y'
    else
      set @v_long_running_flag = 'N'

    if @v_long_running_flag = 'Y' 
    begin
      if @paction = 'BEGIN'
        update usession 
          set operation_name = @poperation
             ,operation_start_date = getDate()
             ,long_operation_flag = 'Y'
             ,last_active_time = getDate()
        where session_id = @psession_id;
      else
        update usession 
          set operation_name = null
             ,operation_start_date = null
             ,long_operation_flag = 'N'
             ,last_active_time = getDate()
        where session_id = @psession_id;

    end
    
  end
go
--METADATA NAME:PRIMAVERA_EVENT TYPE:GRANT TABLE_NAME:PRIMAVERA_EVENT CHANGE:CREATE
GRANT EXECUTE ON PRIMAVERA_EVENT TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJECT_COPY_BASELINE'

--METADATA  TYPE:SSCR NAME:PROJECT_COPY_BASELINE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_COPY_BASELINE' and type in ('P'))
  DROP PROCEDURE PROJECT_COPY_BASELINE
go
--METADATA NAME:PROJECT_COPY_BASELINE TYPE:PROCEDURE SET:PROJECT_COPY_BASELINE CHANGE:CREATE
CREATE PROCEDURE PROJECT_COPY_BASELINE
	@src_proj_id	integer,
	@base_proj_id	integer,
	@target_proj_id integer= null,
	@copy_bit	varchar(40)=null,
	@pret_val	integer OUTPUT,
	@pret_msg	varchar(4000) OUTPUT,
	@ppfolio_id	integer = null,
	@psession_id	integer = null,
	@pservice_id	integer = null --if 1 ,Project baseline is assigned
WITH ENCRYPTION AS
set nocount on 
declare @vtarget_wbs_id integer, @vtarget_proj_id integer,@vis_project_baseline char(1),@vsum_base_proj_id integer,@bcopy_bit char(40), @vcnt integer
declare @default_copy_bit varchar(40)
set @default_copy_bit='11111111111111111110110111000001110'
set  @vis_project_baseline ='N'
 if @src_proj_id=null 
  begin
    set @pret_val = -1
    set @pret_msg = 'Must specify source project to copy baseline from'
    return
  end
if @base_proj_id=null
  begin 
    set @pret_val = -1
    set @pret_msg = 'Must specify baseline project to copy'
  return
 end

if @copy_bit is null 
 begin
    set @bcopy_bit = @default_copy_bit
 end
else
 if (len(@copy_bit) <24) 
begin
set @bcopy_bit=@copy_bit + substring(@default_copy_bit,len(@copy_bit)+1,(len(@default_copy_bit)-len(@copy_bit)))
end
else 
if substring(@copy_bit,24,1)<>'1'
begin 
set @bcopy_bit=substring(@copy_bit,1,23)+'1'+substring(@copy_bit,25,len(@copy_bit)-24)
end 
else
begin
   set @bcopy_bit = @copy_bit
end 
 select @vsum_base_proj_id=sum_base_proj_id from project where proj_id = @src_proj_id  
    if @vsum_base_proj_id = @base_proj_id 
     set  @vis_project_baseline ='Y'
if @target_proj_id is null
begin
   select @vtarget_proj_id=target_proj_id, @vtarget_wbs_id=target_wbs_id
      from tprojmap
     where source_proj_id = @src_proj_id and session_id=@psession_id
end
else
begin
 set @vtarget_proj_id = @target_proj_id
 select @vtarget_wbs_id=wbs_id from projwbs where proj_id=@target_proj_id and proj_node_flag='Y'  
   select @vcnt=count(1) from TPROJMAP where source_proj_id=@src_proj_id and session_id=@psession_id
     if @vcnt =0 
        insert into TPROJMAP values(@psession_id,1,@src_proj_id,@target_proj_id,@vtarget_wbs_id)  
     else		 	
	update TPROJMAP set target_proj_id=@target_proj_id,target_wbs_id=@vtarget_wbs_id where source_proj_id=@src_proj_id and session_id=@psession_id
end
if @vtarget_wbs_id is not null
begin
	exec project_copy @base_proj_id,@vtarget_wbs_id,@bcopy_bit,@pret_val OUTPUT, @pret_msg OUTPUT, @ppfolio_id, @psession_id, @pservice_id, @vis_project_baseline

	if @pret_val <0 
	begin 
		set @pret_msg = 'copy baseline failed|' + @pret_msg
        if @@TRANCOUNT > 0 
		rollback transaction
		return
	end 
	if @target_proj_id is not null 
          update project set orig_proj_id=@target_proj_id where proj_id=@pret_val 
 
	if @vis_project_baseline='Y'
	update project set sum_base_proj_id=@pret_val where proj_id=@vtarget_proj_id and delete_session_id is null
end
else
begin 
  set @pret_msg = 'copy baseline failed|' + @pret_msg
  if @@TRANCOUNT > 0 
  rollback transaction
  return
end
go
--METADATA NAME:PROJECT_COPY_BASELINE TYPE:GRANT TABLE_NAME:PROJECT_COPY_BASELINE CHANGE:CREATE
GRANT EXECUTE ON PROJECT_COPY_BASELINE TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJECT_DELETE_WBS'

--METADATA  TYPE:SSCR NAME:PROJECT_DELETE_WBS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_DELETE_WBS' and type in ('P'))
  DROP PROCEDURE PROJECT_DELETE_WBS
go
--METADATA NAME:PROJECT_DELETE_WBS TYPE:PROCEDURE SET:PROJECT_DELETE CHANGE:CREATE
CREATE PROCEDURE PROJECT_DELETE_WBS
(@pproj_id int,  @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT, @pnode char(1)='A' )
WITH ENCRYPTION AS
  declare @vnode char(1)
  if upper(@pnode) = 'A' or upper(@pnode) = 'N' 
    set @vnode = 'N'
  else 
    set @vnode = 'Y'

  delete from dbo.BUDGCHNG where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.PROJEST where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.ISSUHIST where issue_id in (select issue_id from dbo.PROJISSU where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.PROJISSU where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.PROJTHRS where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.PRPFOLIO where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.ITERDAYS where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.PROJCOST where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.ISSUHIST where issue_id in (select issue_id from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)))
	delete from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKACTV where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKDOC where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKFDBK where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKFIN where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKMEMO where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKNOTE where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKPRED where pred_task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKPRED where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKPROC where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.RSRCHOUR where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)))
	delete from dbo.TRSRCFIN where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)))
	delete from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKUSER where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASKWKSP where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TRSRCFIN where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
  delete from dbo.TASKRISK where task_id in (select task_id from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.TASK where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.TASKDOC where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.WBSBUDG where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.WBSMEMO where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.WBSRSRC_QTY where wbsrsrc_id in (select wbsrsrc_id from dbo.WBSRSRC where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode))
	delete from dbo.WBSRSRC where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)
	delete from dbo.WBSSTEP where wbs_id in (select wbs_id from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = @vnode)

  if upper(@pnode) = 'A'
    exec project_delete_wbs @pproj_id, @pret_val output, @pret_msg output, 'Y'

go
--METADATA NAME:PROJECT_DELETE_WBS TYPE:GRANT TABLE_NAME:PROJECT_DELETE_WBS CHANGE:CREATE
GRANT EXECUTE ON PROJECT_DELETE_WBS TO ${pm.ss.privileged_user}
go
print 'Creating procedure PROJECT_DELETE'

--METADATA  TYPE:SSCR NAME:PROJECT_DELETE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJECT_DELETE' and type in ('P'))
  DROP PROCEDURE PROJECT_DELETE
go
--METADATA NAME:PROJECT_DELETE TYPE:PROCEDURE SET:PROJECT_DELETE CHANGE:CREATE
CREATE PROCEDURE PROJECT_DELETE
(@pproj_id int, @pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT,
 @keep_root bit=0)
WITH ENCRYPTION AS
  delete from dbo.TASKRISK where proj_id = @pproj_id
  
	delete from dbo.TASKACTV where actv_code_id in (select actv_code_id from dbo.ACTVCODE where actv_code_type_id in (select actv_code_type_id from dbo.ACTVTYPE where proj_id = @pproj_id))
	delete from dbo.ACTVCODE where actv_code_type_id in (select actv_code_type_id from dbo.ACTVTYPE where proj_id = @pproj_id)
	delete from dbo.TASKACTV where actv_code_type_id in (select actv_code_type_id from dbo.ACTVTYPE where proj_id = @pproj_id)
	delete from dbo.ACTVTYPE where proj_id = @pproj_id
  delete from dbo.BUDGCHNG where proj_id = @pproj_id
  delete from RELITEMS where proj_id = @pproj_id
  -- CALENDAR
	delete from dbo.RSRCHOUR where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCPROP where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCRATE where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCRCAT where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCROLE where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCSEC where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRFOLIO where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCHOUR where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.TRSRCFIN where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.TASKRSRC where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCHOUR where (str(ts_id)+str(rsrc_id)) in (select str(ts_id)+str(rsrc_id) from dbo.TIMESHT where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.TIMESHT where rsrc_id in (select rsrc_id from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRC where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)
	delete from dbo.ITERDAYS where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.PROJCOST where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.ISSUHIST where issue_id in (select issue_id from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKACTV where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKDOC where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKFDBK where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKFIN where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKMEMO where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKNOTE where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKPRED where pred_task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKPRED where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKPROC where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.RSRCHOUR where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.TRSRCFIN where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)))
	delete from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKUSER where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASKWKSP where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TRSRCFIN where task_id in (select task_id from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id))
	delete from dbo.TASK where clndr_id in (select clndr_id from dbo.CALENDAR where proj_id = @pproj_id)
	delete from dbo.CALENDAR where proj_id = @pproj_id

	delete from dbo.TASKDOC where doc_id in (select doc_id from dbo.DOCUMENT where proj_id = @pproj_id)
  delete from dbo.DOCREVIEWTASK where doc_review_id in (select doc_review_id from dbo.DOCREVIEW where doc_id in (select doc_id from dbo.DOCUMENT where proj_id = @pproj_id)) 
  delete from dbo.DOCREVIEW where doc_id in (select doc_id from dbo.DOCUMENT where proj_id = @pproj_id)
	delete from dbo.DOCUMENT where proj_id = @pproj_id
	delete from dbo.ISSUHIST where proj_id = @pproj_id
	delete from dbo.ITERDAYS where proj_id = @pproj_id
	delete from dbo.PROJCOST where proj_id = @pproj_id
	delete from dbo.PROJEST where proj_id = @pproj_id
	delete from dbo.PROJFUND where proj_id = @pproj_id
	delete from dbo.ISSUHIST where issue_id in (select issue_id from dbo.PROJISSU where proj_id = @pproj_id)
	delete from dbo.PROJISSU where proj_id = @pproj_id
	delete from dbo.PROJPCAT where proj_id = @pproj_id
	delete from dbo.PROJPROP where proj_id = @pproj_id
	delete from dbo.PROJTHRS where proj_id = @pproj_id
	

  exec project_delete_wbs @pproj_id, @pret_val output, @pret_msg output, 'N'
	delete from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = 'N'

	delete from dbo.JOBRPT where rpt_id in (select rpt_id from dbo.RPT where proj_id = @pproj_id)
	delete from dbo.PROJWSRPT where rpt_id in (select rpt_id from dbo.RPT where proj_id = @pproj_id)
	delete from dbo.RPTLIST where rpt_id in (select rpt_id from dbo.RPT where proj_id = @pproj_id)
	delete from dbo.RPT where proj_id = @pproj_id
	delete from dbo.RPTLIST where rpt_batch_id in (select rpt_batch_id from dbo.RPTBATCH where proj_id = @pproj_id)
	delete from dbo.RPTBATCH where proj_id = @pproj_id

  --TASK
	delete from dbo.ITERDAYS where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.PROJCOST where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.ISSUHIST where issue_id in (select issue_id from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id))
	delete from dbo.PROJISSU where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKACTV where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKDOC where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKFDBK where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKFIN where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKMEMO where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKNOTE where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKPRED where pred_task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKPRED where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKPROC where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.RSRCHOUR where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id))
	delete from dbo.TRSRCFIN where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id))
	delete from dbo.TASKRSRC where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKUSER where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASKWKSP where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TRSRCFIN where task_id in (select task_id from dbo.TASK where proj_id = @pproj_id)
	delete from dbo.TASK where proj_id = @pproj_id
	delete from dbo.TASKACTV where proj_id = @pproj_id
	delete from dbo.TASKDOC where proj_id = @pproj_id
	delete from dbo.TASKFDBK where proj_id = @pproj_id
	delete from dbo.TASKFIN where proj_id = @pproj_id
	delete from dbo.TASKMEMO where proj_id = @pproj_id
	delete from dbo.TASKNOTE where proj_id = @pproj_id
	delete from dbo.TASKPRED where pred_proj_id = @pproj_id
	delete from dbo.TASKPRED where proj_id = @pproj_id
	delete from dbo.TASKPROC where proj_id = @pproj_id

  -- TASKRSRC
	delete from dbo.RSRCHOUR where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where proj_id = @pproj_id)
	delete from dbo.TRSRCFIN where taskrsrc_id in (select taskrsrc_id from dbo.TASKRSRC where proj_id = @pproj_id)
	delete from dbo.TASKRSRC where proj_id = @pproj_id

	delete from dbo.TASKUSER where proj_id = @pproj_id
	delete from dbo.TASKWKSP where proj_id = @pproj_id
	delete from dbo.TRSRCFIN where proj_id = @pproj_id
	delete from dbo.UDFVALUE where proj_id = @pproj_id
	delete from dbo.VIEWPROP where proj_id = @pproj_id
	delete from dbo.WBSBUDG where proj_id = @pproj_id
	delete from dbo.WBSMEMO where proj_id = @pproj_id
	delete from dbo.WBSRSRC_QTY where wbsrsrc_id in (select wbsrsrc_id from dbo.WBSRSRC where proj_id = @pproj_id)
	delete from dbo.WBSRSRC where proj_id = @pproj_id
	delete from dbo.WBSSTEP where proj_id = @pproj_id

  -- Handle the delete of the root
  if @keep_root = 0
  BEGIN

		exec project_delete_wbs @pproj_id, @pret_val output, @pret_msg output, 'Y'

		delete from dbo.PROJSHAR where proj_id = @pproj_id
		delete from dbo.EXPPROJ where proj_id = @pproj_id
		delete from dbo.EXTAPP where proj_id = @pproj_id
		delete from dbo.OBSPROJ where proj_id = @pproj_id
		delete from dbo.FORMPROJ where proj_id = @pproj_id
		delete from dbo.USERWKSP where proj_id = @pproj_id
		delete from dbo.UACCESS where proj_id = @pproj_id
		delete from dbo.SCENPROJ where proj_id = @pproj_id
		delete from dbo.WKFLUSER where work_flow_id in (select work_flow_id from dbo.WORKFLOW where proj_id = @pproj_id)
		delete from dbo.WORKFLOW where proj_id = @pproj_id
		delete from dbo.TASKWKSP where workspace_id in (select workspace_id from dbo.WORKSPACE where proj_id = @pproj_id)
		delete from dbo.USERWKSP where workspace_id in (select workspace_id from dbo.WORKSPACE where proj_id = @pproj_id)
		delete from dbo.WORKSPACE where proj_id = @pproj_id

    delete from dbo.PROJWBS where proj_id = @pproj_id and proj_node_flag = 'Y'
    delete from dbo.PROJECT where proj_id = @pproj_id  
  END
  
  set @pret_val = 0
go
--METADATA NAME:PROJECT_DELETE TYPE:GRANT TABLE_NAME:PROJECT_DELETE CHANGE:CREATE
GRANT EXECUTE ON PROJECT_DELETE TO ${pm.ss.privileged_user}
go
print 'Creating procedure REPLACE_REFLECTION_PROJECT'

--METADATA  TYPE:SSCR NAME:REPLACE_REFLECTION_PROJECT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'REPLACE_REFLECTION_PROJECT' and type in ('P'))
  DROP PROCEDURE REPLACE_REFLECTION_PROJECT
go
--METADATA NAME:REPLACE_REFLECTION_PROJECT TYPE:PROCEDURE SET:CPDP_COMMON CHANGE:CREATE
CREATE PROCEDURE REPLACE_REFLECTION_PROJECT
(@psession_id int,@pproj_id int, @prepl_proj_id int, @pret_val int OUTPUT, @pret_msg	varchar(4000) OUTPUT)
WITH ENCRYPTION AS
  set nocount on
  declare @root_wbs_id int, @dest_wbs_id int, @wbs_id int,@obs_id int
  select @root_wbs_id=wbs_id , @dest_wbs_id=parent_wbs_id
  from projwbs pw, project p 
  where p.proj_id = @prepl_proj_id
  and p.proj_id = pw.proj_id 
  and p.orig_proj_id is null and pw.proj_node_flag = 'Y' and p.project_flag = 'Y'
  and pw.status_code = 'WS_Whatif'
  if @@rowcount = 0
  begin
    set @pret_val = -1
    set @pret_msg = 'Project Id ' + str(@prepl_proj_id) + ' is not a valid project for merge'
    return
  end

  exec project_delete @prepl_proj_id, @pret_val output, @pret_msg output,1
  if @pret_val<>0
    return

  exec project_copy @pproj_id, @dest_wbs_id ,'11111111111111111101110010000001110',@pret_val OUTPUT,@pret_msg OUTPUT,null,@psession_id,null,null,@prepl_proj_id

  select @obs_id=obs_id from projwbs where proj_id=@prepl_proj_id  and proj_node_flag='Y'
  update projwbs set obs_id=@obs_id,status_code = 'WS_Whatif' where proj_id = @prepl_proj_id

  set @pret_val = 0
go
--METADATA NAME:REPLACE_REFLECTION_PROJECT TYPE:GRANT TABLE_NAME:REPLACE_REFLECTION_PROJECT CHANGE:CREATE
GRANT EXECUTE ON REPLACE_REFLECTION_PROJECT TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_UPDATE_PROCESS_KEYS'

--METADATA  TYPE:SSCR NAME:OBSPROJ_UPDATE_PROCESS_KEYS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_UPDATE_PROCESS_KEYS' and type in ('P'))
  DROP PROCEDURE OBSPROJ_UPDATE_PROCESS_KEYS
go
--METADATA NAME:OBSPROJ_UPDATE_PROCESS_KEYS TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_UPDATE_PROCESS_KEYS
(@pproj_id int, @pwbs_id int, @pprocess_type varchar(4)='ADD')
WITH ENCRYPTION AS 

  set nocount on
  if @pprocess_type = 'FULL' or @pprocess_type = 'ADD'
  BEGIN
    insert into obsproj (obs_id,proj_id,wbs_id)
    select distinct pk1,@pproj_id,@pwbs_id
    from #tempkeys tk
    where not exists (select * from obsproj op 
                      where op.obs_id = tk.pk1 and op.proj_id =@pproj_id);
  END

  if @pprocess_type = 'FULL' or @pprocess_type = 'REMOVE'
  BEGIN
    delete from obsproj
    where proj_id = @pproj_id
    and obs_id not in (select pk1 from #tempkeys);
  END
go
--METADATA NAME:OBSPROJ_UPDATE_PROCESS_KEYS TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_PROCESS_KEYS CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_PROCESS_KEYS TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_UPDATE_EPS'

--METADATA  TYPE:SSCR NAME:OBSPROJ_UPDATE_EPS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_UPDATE_EPS' and type in ('P'))
  DROP PROCEDURE OBSPROJ_UPDATE_EPS
go
--METADATA NAME:OBSPROJ_UPDATE_EPS TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_UPDATE_EPS
(@pwbs_id int, @pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT)
WITH ENCRYPTION AS 
  set nocount on
  declare @vproj_id int, @vparent_proj_id int, @vproject_flag char(1)
  declare @vobs_id int, @vcnt int, @vid int, @vdelete_session_id int

  select @vproj_id=pw.proj_id, @vproject_flag=p.project_flag, @vobs_id=pw.obs_id, @vdelete_session_id=pw.delete_session_id
  from projwbs pw, project p
  where pw.wbs_id = @pwbs_id and pw.proj_node_flag = 'Y'
  and p.proj_id = pw.proj_id and orig_proj_id is null
  if @@rowcount=0 return

  if @vdelete_session_id is null 
  BEGIN

    set @vparent_proj_id=null

    select @vparent_proj_id=pp.proj_id
    from projwbs pw, projwbs pp
    where pw.wbs_id = @pwbs_id
    and pp.wbs_id = pw.parent_wbs_id
    and pw.delete_session_id is null and pp.delete_session_id is null;
    if @@rowcount=0 set @vparent_proj_id=null;

    delete from #tempkeys

    if @vparent_proj_id is not null
      insert into #tempkeys (pk1)
      select obs_id from obsproj op 
      where op.proj_id = @vparent_proj_id;

    if @vproject_flag = 'N'
    BEGIN

      select @vcnt=count(*) from #tempkeys where pk1 = @vobs_id;
      if @vcnt = 0 
        insert into #tempkeys (pk1) values (@vobs_id);
    
    END
    else
    BEGIN
    
      insert into #tempkeys (pk1)
      select distinct obs_id 
      from projwbs pw
      where proj_id = @vproj_id
      and pw.delete_session_id is null
      and not exists (select * from #tempkeys tk where tk.pk1 = pw.obs_id);

    END

  END 

  exec obsproj_update_process_keys @vproj_id, @pwbs_id, 'FULL'
 
  -- Recursive through hierarchy
  delete from #rectab where context_id = @pwbs_id;

  insert into #rectab 
  select @pwbs_id,wbs_id from projwbs
  where parent_wbs_id = @pwbs_id
  and proj_node_flag = 'Y';

  select top 1 @vid=value from #rectab where context_id = @pwbs_id;
  while (select count(*) from #rectab where context_id = @pwbs_id) > 0 
  BEGIN
--    print 'parent=' +str(@pwbs_id)+',child='+str(@vid)
    exec obsproj_update_eps @vid, @pret_val OUTPUT, @pret_msg OUTPUT
    if @pret_val <> 0 
      return
    delete from #rectab where context_id = @pwbs_id and value = @vid
    select top 1 @vid=value from #rectab where context_id = @pwbs_id;
  END; 

  set @pret_val = 0
go
--METADATA NAME:OBSPROJ_UPDATE_EPS TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_EPS CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_EPS TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_UPDATE_PROJECT'

--METADATA  TYPE:SSCR NAME:OBSPROJ_UPDATE_PROJECT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_UPDATE_PROJECT' and type in ('P'))
  DROP PROCEDURE OBSPROJ_UPDATE_PROJECT
go
--METADATA NAME:OBSPROJ_UPDATE_PROJECT TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_UPDATE_PROJECT
(@pproj_id int, @pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT)
WITH ENCRYPTION AS 
  set nocount on
  declare @vparent_proj_id int, @vwbs_id int, @vcnt int
  declare @vparent_wbs_id int, @vobs_id int
  delete from #tempkeys;

  select @vparent_proj_id=pp.proj_id, @vwbs_id=pw.wbs_id
        ,@vparent_wbs_id=pp.wbs_id, @vobs_id=pp.obs_id 
  from projwbs pw, projwbs pp
  where pw.proj_id = @pproj_id and pw.proj_node_flag = 'Y'
  and pp.wbs_id = pw.parent_wbs_id;

  if @@rowcount = 0 set @vparent_proj_id = null

  set @vcnt = 0
  while ( @vparent_wbs_id is not null and @vcnt <= 100)
  BEGIN
    set @vcnt = @vcnt + 1
    if (select count(*) from #tempkeys where pk1=@vobs_id) = 0
      insert into #tempkeys (pk1) values (@vobs_id)
    select @vparent_wbs_id=parent_wbs_id from projwbs pw where pw.wbs_id = @vparent_wbs_id;
    select @vobs_id=obs_id from projwbs pw where pw.wbs_id=@vparent_wbs_id;
    if @@rowcount = 0 set @vparent_wbs_id = null
  END

  insert into #tempkeys (pk1)
  select distinct obs_id from projwbs p
  where proj_id = @pproj_id and delete_session_id is null;

  exec obsproj_update_process_keys @pproj_id, @vwbs_id, 'FULL'

  set @pret_val = 0

go
--METADATA NAME:OBSPROJ_UPDATE_PROJECT TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE_PROJECT CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE_PROJECT TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_UPDATE'

--METADATA  TYPE:SSCR NAME:OBSPROJ_UPDATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_UPDATE' and type in ('P'))
  DROP PROCEDURE OBSPROJ_UPDATE
go
--METADATA NAME:OBSPROJ_UPDATE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_UPDATE
( @pupdate_type varchar(7) = 'EPS'				-- Type of update EPS, Project, WBS, OBS
, @pkey int = null								-- Single primary key value to be maintained
, @pkey_list varchar(4000)=null					-- Comma list of primary key values
, @pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT 	-- Normal returns.  Do this way for easy translation to SQL Server 2k
)
WITH ENCRYPTION AS 
  set nocount on
  declare @v_key_type varchar(20), @v_cnt int, @v_table_name varchar(30)
  declare @v_where_clause varchar(4000), @v_msg varchar(100), @vsql nvarchar(4000)
  
  SET @pret_val = 0;
  if (@pupdate_type is null) or 
     (@pupdate_type != 'EPS' and @pupdate_type != 'PROJECT' and @pupdate_type != 'WBS' and @pupdate_type != 'OBS' ) 
  BEGIN
    set @pret_val = -1002;
    set @pret_msg = 'ERROR: Must provide a valid update_type';    
    return;
  END;

  if @pkey is not null
    set @v_key_type = 'SINGLE';
  else if @pkey_list is not null 
  BEGIN
    --Not implemented
    set @v_key_type = 'LIST';
    set @pret_val = -1003;
    set @pret_msg = 'ERROR: This function not implemented';
    return;
  END
  else
  BEGIN
    set @pret_val = -1001;
    set @pret_msg = 'ERROR: Must provide list or key value';
    return;
  END;

  create table #obsproj_update_cnt (n1 int)

  if @pupdate_type = 'PROJECT' 
  BEGIN
    set @v_table_name = 'PROJECT';
    set @v_where_clause = 'proj_id = @key and project_flag = ''Y'' and orig_proj_id is null';
    set @v_msg = 'project ID';
  END
  else if @pupdate_type = 'EPS' 
  BEGIN
    set @v_table_name = 'PROJWBS';
    set @v_where_clause = 'wbs_id = @key and proj_node_flag = ''Y''';
    set @v_msg = 'EPS Node';
  END

  set @vsql = N'insert into #obsproj_update_cnt select count(*) from ' + @v_table_name + N' where ' 
              + @v_where_clause 
                     
  exec sp_executesql @vsql, N'@key int', @key=@pkey
  if (select n1 from #obsproj_update_cnt) = 0
  BEGIN
    set @pret_val = -1004
    set @pret_msg = 'ERROR: Not a valid ' + @v_msg
    return;
  END;

  create table #tempkeys (pk1 int, pk2 int);
  create index #ndx_tempkeys_pk on #tempkeys (pk1,pk2);

  if @v_key_type = 'SINGLE' and @pupdate_type = 'PROJECT'
    exec obsproj_update_project @pkey, @pret_val OUTPUT, @pret_msg OUTPUT
  else if @v_key_type = 'SINGLE' and @pupdate_type = 'EPS' 
  BEGIN
    create table #rectab (context_id int, value int);
    create index #ndx_rectab on #rectab (context_id,value);
    exec obsproj_update_eps @pkey, @pret_val OUTPUT, @pret_msg OUTPUT
  END;
  else
  BEGIN
    set @pret_val = -1005;
    set @pret_msg = 'WARNING: Nothing to process';
    return;
  END
  
go
--METADATA NAME:OBSPROJ_UPDATE TYPE:GRANT TABLE_NAME:OBSPROJ_UPDATE CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_UPDATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_FULL_REBUILD'

--METADATA  TYPE:SSCR NAME:OBSPROJ_FULL_REBUILD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_FULL_REBUILD' and type in ('P'))
  DROP PROCEDURE OBSPROJ_FULL_REBUILD
go
--METADATA NAME:OBSPROJ_FULL_REBUILD TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_FULL_REBUILD
(@pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT )
WITH ENCRYPTION AS 
  set nocount on
  declare @vid int  
  create table #fullrebuild (wbs_id int)

  insert into #fullrebuild
  select wbs_id 
  from projwbs
  where parent_wbs_id is null
  and delete_session_id is null;

  select top 1 @vid=wbs_id from #fullrebuild
  while (select count(*) from #fullrebuild) > 0 
  BEGIN
    exec obsproj_update 'EPS', @vid, null, @pret_val OUTPUT, @pret_msg OUTPUT
    if @pret_val <> 0 
      return
    delete from #fullrebuild where wbs_id = @vid
  select top 1 @vid=wbs_id from #fullrebuild
  END; 

go
--METADATA NAME:OBSPROJ_FULL_REBUILD TYPE:GRANT TABLE_NAME:OBSPROJ_FULL_REBUILD CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_FULL_REBUILD TO ${pm.ss.privileged_user}
go
print 'Creating procedure PRMQUEUE_ADD'

--METADATA  TYPE:SSCR NAME:PRMQUEUE_ADD OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMQUEUE_ADD' and type in ('P'))
  DROP PROCEDURE PRMQUEUE_ADD
go
--METADATA NAME:PRMQUEUE_ADD TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE PRMQUEUE_ADD
(@pqueue_name varchar(255), @pmsg_type varchar(30), @pmsg_sub_type varchar(30)
, @pkey1 varchar(30)=null, @pkey2 varchar(30)=null
, @pqueue_payload varchar(4000)=null
,@ppriority int=1)
WITH ENCRYPTION AS 
  set nocount on
  declare @vuser_name varchar(255), @vsess int, @vapp_name varchar(255)
  exec audit_prm_user @vsess output, @vuser_name output, @vapp_name output
  insert into prmqueue (queue_name,msg_key,enqueue_date,enqueue_user,status_code,
                        msg_type, msg_sub_type, key1, key2,
                        priority,sender_name, queue_payload)
  values ( @pqueue_name, replace(newid(),'-',''), getDate(), @vuser_name, 'QUEUED', 
          @pmsg_type, @pmsg_sub_type, @pkey1, @pkey2,
          @ppriority, substring(@vuser_name,1,30), @pqueue_payload ); 

go
--METADATA NAME:PRMQUEUE_ADD TYPE:GRANT TABLE_NAME:PRMQUEUE_ADD CHANGE:CREATE
GRANT EXECUTE ON PRMQUEUE_ADD TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBSPROJ_PROCESS_QUEUE'

--METADATA  TYPE:SSCR NAME:OBSPROJ_PROCESS_QUEUE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBSPROJ_PROCESS_QUEUE' and type in ('P'))
  DROP PROCEDURE OBSPROJ_PROCESS_QUEUE
go
--METADATA NAME:OBSPROJ_PROCESS_QUEUE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE OBSPROJ_PROCESS_QUEUE
(@pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT )
WITH ENCRYPTION AS
  set nocount on 
  declare @vcnt int, @vmax_project_updates int, @vmax_eps_updates int, @vmsg varchar(1000)
  declare @vstatus_code varchar(10), @vmax_retries int, @vretry_count int
  declare @msg_key varchar(32), @msg_sub_type varchar(10), @key1 varchar(10), @key2 varchar(10)
  declare @retry_count int, @status_code varchar(10), @enqueue_date datetime
  declare @vprocess_cnt int

  create table #obsproj_process
  (msg_key varchar(32),msg_type varchar(7),msg_sub_type varchar(10),key1 varchar(10),key2 varchar(10),
   retry_count int, status_code varchar(10), enqueue_date datetime)

  insert into #obsproj_process
  select msg_key, msg_type, msg_sub_type, key1, key2, retry_count, status_code, enqueue_date
  from prmqueue
  where queue_name = 'PROJWBS_SECURITY'
  and status_code in  ('QUEUED','FAILED');

  exec settings_read_number @vmax_project_updates OUTPUT, 'database.obsproj.queue','MaxProjectUpdates',1000
  exec settings_read_number @vmax_retries OUTPUT, 'database.obsproj.queue','MaxRetries',50

  set @vprocess_cnt = 0
  set @vcnt=0
  select top 1 @msg_key=msg_key, @msg_sub_type=msg_sub_type, @enqueue_date=enqueue_date
       , @key1=key1, @key2=key2, @retry_count=retry_count, @status_code=status_code
  from #obsproj_process where msg_type = 'PROJECT' order by enqueue_date
  while (select count(*) from #obsproj_process where msg_type = 'PROJECT') > 0 
  BEGIN
    set @vcnt=@vcnt+1
    if @vcnt > @vmax_project_updates 
    BEGIN
      select @vcnt=count(*)
      from prmqueue  
      where queue_name = 'PROJWBS_SECURITY'
      and msg_type = 'PROJECT'
      and status_code = 'QUEUED';
      set @vmsg = 'Finish PROJECT processing after '
                      + str(@vmax_project_updates) + ' records with '
                      + str(@vcnt) + ' records remaining';
      set @pret_msg = @vmsg
      exec bgp_write_to_log 'obsproj_process_queue',@vmsg
      break;

    END

    print 'PROJECT QUEUE:' + @msg_key + ',' + convert(varchar(30),@enqueue_date) + ','+@key1+ ','+@key2

    update prmqueue set dequeue_date=getDate(), dequeue_user='background',status_code='PROCESSING'
    where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;

    exec obsproj_update 'PROJECT', @key2, null, @pret_val output, @pret_msg output

    if @pret_val < 0 and @pret_val <> -1004 -- Other Error
    BEGIN
      if @retry_count is null 
        set @vretry_count = 1
      else
        set @vretry_count = @retry_count + 1
      
      if @vretry_count > @vmax_retries
        set @vstatus_code = 'ERROR'
      else
        set @vstatus_code = 'FAILED';

      update prmqueue set status_code=@vstatus_code, retry_count=@vretry_count, err_msg = @pret_msg
      where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;
    END
    else
      update prmqueue set status_code='COMPLETE'
      where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;


    delete from #obsproj_process where msg_key = @msg_key;
    select top 1 @msg_key=msg_key, @msg_sub_type=msg_sub_type, @enqueue_date=enqueue_date
       , @key1=key1, @key2=key2, @retry_count=retry_count, @status_code=status_code
    from #obsproj_process where msg_type = 'PROJECT' order by enqueue_date
  END

  set @vprocess_cnt = @vcnt
  -- EPS Queue

  set @vcnt=0
  select top 1 @msg_key=msg_key, @msg_sub_type=msg_sub_type, @enqueue_date=enqueue_date
       , @key1=key1, @key2=key2, @retry_count=retry_count, @status_code=status_code
  from #obsproj_process where msg_type = 'EPS' order by enqueue_date
  while (select count(*) from #obsproj_process where msg_type = 'EPS') > 0 
  BEGIN
    set @vcnt=@vcnt+1
    if @vcnt > @vmax_project_updates 
    BEGIN
      select @vcnt=count(*)
      from prmqueue  
      where queue_name = 'PROJWBS_SECURITY'
      and msg_type = 'EPS'
      and status_code = 'QUEUED';
      set @vmsg = 'Finish EPS processing after '
                      + str(@vmax_project_updates) + ' records with '
                      + str(@vcnt) + ' records remaining';
      set @pret_msg = @vmsg
      exec bgp_write_to_log 'obsproj_process_queue',@vmsg
      break;

    END

    print 'EPS QUEUE:' + @msg_key + ',' + convert(varchar(30),@enqueue_date) + ','+@key1+ ','+@key2

    update prmqueue set dequeue_date=getDate(), dequeue_user='background',status_code='PROCESSING'
    where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;
    if @msg_sub_type = 'DELETE' 
      delete from obsproj where proj_id = @key2;
    else
      exec obsproj_update 'EPS', @key1, null, @pret_val output, @pret_msg output

    if @pret_val < 0 and @pret_val <> -1004 -- Other Error
    BEGIN
      if @retry_count is null 
        set @vretry_count = 1
      else
        set @vretry_count = @retry_count + 1
      
      if @vretry_count > @vmax_retries
        set @vstatus_code = 'ERROR'
      else
        set @vstatus_code = 'FAILED';

      update prmqueue set status_code=@vstatus_code, retry_count=@vretry_count, err_msg = @pret_msg
      where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;
    END
    else
      update prmqueue set status_code='COMPLETE'
      where queue_name = 'PROJWBS_SECURITY' and msg_key = @msg_key;

    delete from #obsproj_process where msg_key = @msg_key;

    select top 1 @msg_key=msg_key, @msg_sub_type=msg_sub_type, @enqueue_date=enqueue_date
       , @key1=key1, @key2=key2, @retry_count=retry_count, @status_code=status_code
    from #obsproj_process where msg_type = 'EPS' order by enqueue_date
  END

  set @vprocess_cnt = @vprocess_cnt + @vcnt

  set @pret_val = @vprocess_cnt
go
--METADATA NAME:OBSPROJ_PROCESS_QUEUE TYPE:GRANT TABLE_NAME:OBSPROJ_PROCESS_QUEUE CHANGE:CREATE
GRANT EXECUTE ON OBSPROJ_PROCESS_QUEUE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CLEANUP_PRMQUEUE'

--METADATA  TYPE:SSCR NAME:CLEANUP_PRMQUEUE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CLEANUP_PRMQUEUE' and type in ('P'))
  DROP PROCEDURE CLEANUP_PRMQUEUE
go
--METADATA NAME:CLEANUP_PRMQUEUE TYPE:PROCEDURE SET:OBSPROJ CHANGE:CREATE
CREATE PROCEDURE CLEANUP_PRMQUEUE
(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT)
WITH ENCRYPTION AS 
  set nocount on
  declare @early_login datetime, @curr_time datetime, @keepInterval varchar(20)
  declare @diff decimal(20,6), @interval_date datetime, @set varchar(20)
  declare @delete_all bit, @delete_thresh int, @delete_pct decimal(10,2)
  declare @rowcount int, @delete_rows int, @delete_cnt int, @max_to_delete int
  exec settings_read_string @set OUTPUT,'database.cleanup.Prmqueue','KeepInterval','5d'
  exec get_interval_difference @set, @diff OUTPUT
  set @curr_time = getDate()
  set @interval_date = @curr_time-@diff

  exec settings_read_bool @delete_all OUTPUT,'database.cleanup.Prmqueue','DeleteAll',0
  exec settings_read_number @delete_thresh OUTPUT,'database.cleanup.Prmqueue','DeleteAllThreshold',1000
  exec settings_read_number @delete_pct OUTPUT,'database.cleanup.Prmqueue','DeletePercentage',10
  exec settings_read_number @max_to_delete OUTPUT,'database.cleanup.Prmqueue','MaxRowsToDelete',10000
  select @rowcount=count(*) from prmqueue where enqueue_date <= @interval_date and status_code='COMPLETE'
  
  set @pret_val=0
  if @delete_all = 1 or @rowcount < @delete_thresh
  begin
    delete from prmqueue where enqueue_date <= @interval_date
    set @pret_val = @@rowcount
  end     
  else
  begin
    create table #tmprmqueue (queue_name varchar(30), msg_key varchar(32),enqueue_date datetime)
    set @delete_rows = @rowcount * (@delete_pct*.01)
    if @delete_rows > @max_to_delete
      set @delete_rows = @max_to_delete
    else if @delete_rows < @delete_thresh
      set @delete_rows = @delete_thresh
	declare @sql nvarchar(255)
    set @sql = N'insert into #tmprmqueue select top ' + ltrim(str(@delete_rows)) 
              + N' queue_name,msg_key,enqueue_date from prmqueue '
              + N' where enqueue_date <= ''' + convert(varchar(30),@interval_date) + ''''
    exec sp_executesql @sql
    declare  @vqueue_name varchar(30),@vmsg_key varchar(32), @venqueue_date datetime
    declare dels cursor for select queue_name,msg_key,enqueue_date from #tmprmqueue
    open dels
    set @delete_cnt=0
    fetch dels into @vqueue_name,@vmsg_key,@venqueue_date
    while @@fetch_status >= 0
    begin
      delete from prmqueue 
      where queue_name = @vqueue_name and msg_key = @vmsg_key
      and enqueue_date = @venqueue_date
      set @delete_cnt=@delete_cnt+@@rowcount
      fetch dels into @vqueue_name,@vmsg_key,@venqueue_date
    end
    close dels
    deallocate dels
    set @pret_val = @delete_cnt
  end
  set @pret_msg = ltrim(str(@pret_val)) + ' record(s) deleted'
go
--METADATA NAME:CLEANUP_PRMQUEUE TYPE:GRANT TABLE_NAME:CLEANUP_PRMQUEUE CHANGE:CREATE
GRANT EXECUTE ON CLEANUP_PRMQUEUE TO ${pm.ss.privileged_user}
go
print 'Creating procedure WBSRSRC_VALIDATE'

--METADATA  TYPE:SSCR NAME:WBSRSRC_VALIDATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_VALIDATE' and type in ('P'))
  DROP PROCEDURE WBSRSRC_VALIDATE
go
--METADATA NAME:WBSRSRC_VALIDATE TYPE:PROCEDURE SET:WBSRSRC_VALIDATE CHANGE:CREATE
CREATE PROCEDURE WBSRSRC_VALIDATE
(@prole_list varchar(4000),@pret_val int OUTPUT , @pret_msg varchar OUTPUT)
WITH ENCRYPTION AS
 BEGIN
  declare @vrole_id varchar(20) ,@pos int,@prole_id int,@wrwbsrsrc_id int,@wrwbs_id int,@wrrsrc_id int,@wrrole_id int, @cnt int 
  set nocount on 

  CREATE TABLE #rolelist( roleid int)
  SET @prole_list = LTRIM(RTRIM(@prole_list))+ ','
  SET @pos = CHARINDEX(',', @prole_list, 1)

  IF REPLACE(@prole_list, ',', '') <> ''
    BEGIN
      WHILE @pos > 0
 	    BEGIN
   	      SET @prole_id = LTRIM(RTRIM(LEFT(@prole_list, @pos - 1)))
	      IF @prole_id <> ''
	        BEGIN
			  INSERT INTO #rolelist (roleid) VALUES (@prole_id) 
			END
			SET @prole_list = RIGHT(@prole_list, LEN(@prole_list) - @pos)
			SET @pos = CHARINDEX(',', @prole_list, 1)
		END
	END	

  DECLARE roles CURSOR FOR select roleid from #rolelist
  OPEN roles
  FETCH roles INTO @prole_id
  WHILE (@@FETCH_STATUS = 0)
    BEGIN
      declare wr cursor for select wbsrsrc_id,wbs_id,rsrc_id,role_id from wbsrsrc  where role_id=@prole_id and delete_session_id is null
      open wr
      FETCH wr INTO @wrwbsrsrc_id,@wrwbs_id,@wrrsrc_id,@wrrole_id
      WHILE (@@FETCH_STATUS = 0)
        BEGIN
          set @cnt=0
          IF @wrrsrc_id is not null 
		    select @cnt=count(*) from wbsrsrc where wbs_id=@wrwbs_id and rsrc_id=@wrrsrc_id and role_id is null and delete_session_id is null
	      ELSE
		    select @cnt=count(*) from wbsrsrc where wbs_id=@wrwbs_id  and rsrc_id is null  and role_id is null and delete_session_id is null
        IF @cnt >=1 
	    begin	
 	     begin transaction
            update wbsrsrc set delete_date = getdate(),delete_session_id=@@SPID where wbsrsrc_id = @wrwbsrsrc_id
            update wbsrsrc_qty set delete_date = getdate(),delete_session_id=@@SPID where wbsrsrc_id = @wrwbsrsrc_id
	     commit transaction
	    end 
        ELSE
          IF @wrrsrc_id is null 
			begin 
			begin transaction
			  update wbsrsrc set delete_date = getdate(),delete_session_id=@@SPID where wbsrsrc_id = @wrwbsrsrc_id
             		  update wbsrsrc_qty set delete_date = getdate(),delete_session_id=@@SPID where wbsrsrc_id = @wrwbsrsrc_id
	       		 commit transaction
			end
          ELSE
                      begin
			begin transaction
   			  update wbsrsrc set role_id=null where wbsrsrc_id = @wrwbsrsrc_id
			  commit transaction
		       end	
         FETCH wr INTO @wrwbsrsrc_id,@wrwbs_id,@wrrsrc_id,@wrrole_id
       END
  END
  close wr
  deallocate wr
  FETCH roles INTO @prole_id
 END
  close roles
  deallocate roles
go
--METADATA NAME:WBSRSRC_VALIDATE TYPE:GRANT TABLE_NAME:WBSRSRC_VALIDATE CHANGE:CREATE
GRANT EXECUTE ON WBSRSRC_VALIDATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure SYSTEM_MONITOR'

--METADATA  TYPE:SSCR NAME:SYSTEM_MONITOR OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SYSTEM_MONITOR' and type in ('P'))
  DROP PROCEDURE SYSTEM_MONITOR
go
--METADATA NAME:SYSTEM_MONITOR TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE SYSTEM_MONITOR
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @verstr varchar(4)
  set @verstr = substring(replace(@@version,' ',''),19,4)
  if @verstr = '2000'
    set transaction isolation level read uncommitted 

  exec audit_identity null,null,'Symon(bg)'
  declare @cd datetime, @ret int, @msg varchar(4000)
  set @cd=getDate()
  exec bgp_write_to_log 'system_monitor','Starting' 
  exec settings_write_date @cd,'database.background.Symon','HeartBeatTime'

  --Cleanup Usession Records that have expired
  exec bgp_write_to_log 'system_monitor','Begin usession_cleanup_expired' 
  exec usession_cleanup_expired @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'system_monitor','Complete usession_cleanup_expired',null,@ret,@msg
  set @cd=getDate()
  exec bgp_write_to_log 'system_monitor','Begin obsproj_process_queue' 
  exec obsproj_process_queue @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'system_monitor','Complete obsproj_process_queue','ELAPSED TIME',@ret,@msg,@cd
  exec settings_write_date @cd,'database.background.Symon','HeartBeatTime'
  exec bgp_write_to_log 'system_monitor','Complete' ,'ELAPSED TIME',@ret,@msg,@cd
go
--METADATA NAME:SYSTEM_MONITOR TYPE:GRANT TABLE_NAME:SYSTEM_MONITOR CHANGE:CREATE
GRANT EXECUTE ON SYSTEM_MONITOR TO ${pm.ss.privileged_user}
go
print 'Creating procedure DATA_MONITOR'

--METADATA  TYPE:SSCR NAME:DATA_MONITOR OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'DATA_MONITOR' and type in ('P'))
  DROP PROCEDURE DATA_MONITOR
go
--METADATA NAME:DATA_MONITOR TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE DATA_MONITOR
WITH ENCRYPTION AS
  SET NOCOUNT ON 
  declare @verstr varchar(4)
  set @verstr = substring(replace(@@version,' ',''),19,4)
  if @verstr = '2000'
    set transaction isolation level read uncommitted 

  exec audit_identity null,null,'Damon(bg)'
  declare @cd datetime, @ret int, @msg varchar(4000), @error_level integer,@dmonstart datetime
  set @cd=getDate()
  set @dmonstart=@cd
  exec bgp_write_to_log 'data_monitor','Begin bgplog_cleanup' 
  exec bgplog_cleanup @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete bgplog_cleanup','ELAPSED TIME',@ret,@msg,@cd

  exec bgp_write_to_log 'data_monitor','Starting' 
  exec settings_write_date @cd,'database.background.Damon','HeartBeatTime'

  -- Cleanup REFRDEL records before anything else
  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin refrdel_cleanup' 
  exec refrdel_cleanup @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete refrdel_cleanup','ELAPSED TIME',@ret,@msg,@cd
  exec settings_write_date @cd,'database.background.Damon','HeartBeatTime'

  -- Cleanup PRMQUEUE
  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin cleanup_prmqueue' 
  exec cleanup_prmqueue @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete cleanup_prmqueue','ELAPSED TIME',@ret,@msg,@cd
 

  -- Clear usession that have been logical
  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin usession_clear_logical_deletes' 
  exec usession_clear_logical_deletes @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete usession_clear_logical_deletes','ELAPSED TIME',@ret,@msg,@cd
  exec settings_write_date @cd,'database.background.Damon','HeartBeatTime'

  -- Cleaup Logical Deletes
  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin cleanup_logical_deletes' 
  exec settings_read_number @error_level OUTPUT,'database.cleanup.LogicalDelete','ErrorLevel','0'
  exec cleanup_logical_deletes @ret output, @msg OUTPUT, @error_level
  exec bgp_write_to_log 'data_monitor','Complete cleanup_logical_deletes','ELAPSED TIME',@ret,@msg,@cd
  exec settings_write_date @cd,'database.background.Damon','HeartBeatTime'

  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin prmaudit_cleanup' 
  exec prmaudit_cleanup @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete prmaudit_cleanup','ELAPSED TIME',@ret,@msg,@cd 

  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin cleanup_usessaud' 
  exec cleanup_usessaud @ret OUTPUT, @msg OUTPUT
  exec bgp_write_to_log 'data_monitor','Complete cleanup_usessaud','ELAPSED TIME',@ret,@msg,@cd 


  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin user_defined_cleanup' 
  exec user_defined_background
  exec bgp_write_to_log 'data_monitor','Complete user_defined_cleanup','ELAPSED TIME',NULL,NULL,@cd 

  set @cd=getDate()
  exec bgp_write_to_log 'data_monitor','Begin cleanup_old_data' 
  exec cleanup_old_data
  exec bgp_write_to_log 'data_monitor','Complete cleanup_old_data','ELAPSED TIME',NULL,NULL,@cd 
  
  exec bgp_write_to_log 'data_monitor','Complete' ,'ELAPSED TIME',@ret,@msg,@dmonstart
go
--METADATA NAME:DATA_MONITOR TYPE:GRANT TABLE_NAME:DATA_MONITOR CHANGE:CREATE
GRANT EXECUTE ON DATA_MONITOR TO ${pm.ss.privileged_user}
go
print 'Creating procedure CHECK_BACKGROUND_JOBS'

--METADATA  TYPE:SSCR NAME:CHECK_BACKGROUND_JOBS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHECK_BACKGROUND_JOBS' and type in ('P'))
  DROP PROCEDURE CHECK_BACKGROUND_JOBS
go
--METADATA NAME:CHECK_BACKGROUND_JOBS TYPE:PROCEDURE SET:BACKGROUND CHANGE:CREATE
CREATE PROCEDURE CHECK_BACKGROUND_JOBS
(@pret_val integer OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS
     set nocount on
     declare @vsmonset   varchar(20),@vsmondate  datetime,@diff decimal(20,6), @vsmon_time datetime,  @curr_time   datetime,@vsmonfactor integer
     exec settings_read_date @vsmondate OUTPUT,'database.background.Symon','HeartBeatTime'
     exec settings_read_string @vsmonset OUTPUT,'database.background.Symon','Interval'
     exec settings_read_number @vsmonfactor OUTPUT,'database.background.Symon','IntervalFactor',30
     set @curr_time = getDate()
     exec get_interval_difference @vsmonset, @diff OUTPUT
     set @vsmon_time=@curr_time- (@diff*@vsmonfactor)
     set @pret_val=0
     if (@vsmondate >=@vsmon_time) 
       begin
         set @pret_val=0 
         set @pret_msg='System Monitor Running Successfully'	
       end
      else
        begin
         set @pret_val=-1
         set @pret_msg='Last System Monitor Job Run:' + convert(VARCHAR,@vsmondate,113)
      end
go
--METADATA NAME:CHECK_BACKGROUND_JOBS TYPE:GRANT TABLE_NAME:CHECK_BACKGROUND_JOBS CHANGE:CREATE
GRANT EXECUTE ON CHECK_BACKGROUND_JOBS TO ${pm.ss.privileged_user}
go
print 'Creating procedure TA_GATHER_TIMESHEETS'

--METADATA  TYPE:SSCR NAME:TA_GATHER_TIMESHEETS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TA_GATHER_TIMESHEETS' and type in ('P'))
  DROP PROCEDURE TA_GATHER_TIMESHEETS
go
--METADATA NAME:TA_GATHER_TIMESHEETS TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE PROCEDURE TA_GATHER_TIMESHEETS
(@psession_id int, @papproval_type varchar(2),  @papproval_user_id int, @pts_id int
, @pret_val int OUTPUT, @pret_msg varchar(4000) OUTPUT, @pdelegate_user_id int=null)
WITH ENCRYPTION AS
begin 
  set nocount on
  declare @context_id int, @context_id2 int, @effective_user_id int, @cnt int
  set @context_id = 11697
  set @context_id2 = 11698
  set @pret_val = @context_id  

  if upper(@papproval_type) != 'PM' and upper(@papproval_type) != 'RM' 
  begin
    set @pret_val = -100
    set @pret_msg = 'Valid approval type must be PM or RM'
    return
  end

  set @effective_user_id=@papproval_user_id

  delete from upklist 
  where session_id = @psession_id and context_id in (@context_id,@context_id2)

  select @cnt=count(*) 
  from users
  where user_id = @papproval_user_id
  and prof_id = 12;
  if @cnt = 1 --Handle Super User
  begin
    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select @psession_id, @context_id,rsrc_id,ts_id
    from timesht
    where ts_id=@pts_id;

    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select distinct @psession_id, @context_id,rsrc_id,ts_id
    from rsrchour
    where status_code in ('TS_ReSubmit','TS_ReSubmitRM')
    and ts_id != @pts_id;

    return
  end

  if upper(@papproval_type) = 'PM'
  begin

    create table #proj_list (proj_id integer)

    if @pdelegate_user_id is null 

      insert into upklist (session_id,context_id,pk_id,pk2_id)
      select @psession_id, @context_id2, proj_id
        , case(case WHEN pp.prof_id=23 THEN 'Y' else pp.allow_flag end) WHEN 'Y' THEN 1 ELSE 0 end
      from obsproj u, userobs uo, profpriv pp
      where u.obs_id = uo.obs_id and uo.user_id = @effective_user_id
      and uo.prof_id = pp.prof_id and pp.priv_num=16 
      and uo.delete_session_id is null and pp.delete_session_id is null;

    else
      insert into upklist (session_id,context_id,pk_id,pk2_id)
      select @psession_id, @context_id2, proj_id,1
      from tsdelegate
      where ts_delegate_user_id = @pdelegate_user_id
      and active_flag = 'Y'
      and user_id =@papproval_user_id
      and proj_id is not null;

    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select distinct @psession_id, @context_id, rsrc_id, @pts_id
    from rsrchour r, upklist u
    where ts_id = @pts_id 
    and u.pk_id = r.proj_id 
    and u.session_id=@psession_id and u.context_id=@context_id2 and pk2_id=1
    and task_ts_flag = 'N'
    and r.delete_session_id is null;

    --Find Resubmitted timesheets
    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select distinct @psession_id, @context_id,rsrc_id, r.ts_id
    from rsrchour r, upklist u
    where status_code = 'TS_ReSubmit'
    and r.ts_id != @pts_id
    and u.pk_id = r.proj_id 
    and u.session_id=@psession_id and u.context_id=@context_id2 and pk2_id=1
    and r.delete_session_id is null;

  end
  else
  begin

    if @pdelegate_user_id is not null 
    begin
      select @cnt=count(*) 
      from tsdelegate
      where ts_delegate_user_id = @pdelegate_user_id
      and active_flag = 'Y'
      and user_id =@papproval_user_id
      and proj_id is null;
      if @cnt = 0 
      begin
        set @pret_msg='Time approval for user ' + ltrim(str(@papproval_user_id))
                     + ' not delegated to user ' + ltrim(str(@pdelegate_user_id))
        set @pret_val = -200
        return
      end
    end

    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select @psession_id, @context_id, r.rsrc_id, @pts_id 
    from timesht ts, rsrc r
    where ts_approve_user_id = @effective_user_id
    and r.rsrc_id = ts.rsrc_id
    and ts.ts_id = @pts_id
    and ts.delete_session_id is null and r.delete_session_id is null;

    --Find Resubmitted timesheets
    insert into upklist (session_id,context_id,pk_id,pk2_id)
    select distinct @psession_id, @context_id, r.rsrc_id, rh.ts_id
    from rsrchour rh, rsrc r
    where ts_approve_user_id = @effective_user_id
    and r.rsrc_id = rh.rsrc_id
    and rh.status_code in ('TS_ReSubmit','TS_ReSubmitRM')
    and rh.ts_id != @pts_id
    and rh.delete_session_id is null and r.delete_session_id is null;
  end


end
go
--METADATA NAME:TA_GATHER_TIMESHEETS TYPE:GRANT TABLE_NAME:TA_GATHER_TIMESHEETS CHANGE:CREATE
GRANT EXECUTE ON TA_GATHER_TIMESHEETS TO ${pm.ss.privileged_user}
go
print 'Creating procedure TS_AUDIT'

--METADATA  TYPE:SSCR NAME:TS_AUDIT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TS_AUDIT' and type in ('P'))
  DROP PROCEDURE TS_AUDIT
go
--METADATA NAME:TS_AUDIT TYPE:PROCEDURE SET:TIMESHEET_UTILS CHANGE:CREATE
CREATE PROCEDURE TS_AUDIT
(@prsrc_id int, @pts_id int, @ptype varchar(30), @effective_user_id int, @psession_id int=null)
WITH ENCRYPTION AS
begin 
  set nocount on
  declare @key int, @context_id2 int,  @proj_id int, @status_code varchar(20)
  declare @reg_hrs numeric(17,6), @oh_hrs numeric(17,6), @reg_ot_hrs numeric(17,6)
  declare @pend_reg_hrs numeric(17,6), @pend_reg_ot_hrs numeric(17,6)
  declare @oh_ot_hrs numeric(17,6), @pend_oh_hrs numeric(17,6), @pend_oh_ot_hrs numeric(17,6)
  declare @user_name varchar(255), @prof_id int
  set @context_id2 = 11698
  if @ptype = 'ApproveAsPM' or @ptype ='ApproveAsPMDelegate'  
  begin
    select @user_name=user_name, @prof_id=prof_id from users where user_id = @effective_user_id

    create table #projs (proj_id int, status_code varchar(20))
    if @prof_id!=12 
      insert into #projs
      select distinct proj_id , status_code
      from rsrchour rh, upklist u
      where rh.ts_id = @pts_id and rh.rsrc_id = @prsrc_id
      and rh.proj_id = u.pk_id  
      and u.session_id=@psession_id and u.context_id=@context_id2 and pk2_id=1
      and task_ts_flag = 'N' and rh.update_user=@user_name
    else
      insert into #projs
      select distinct proj_id , status_code
      from rsrchour rh
      where rh.ts_id = @pts_id and rh.rsrc_id = @prsrc_id
      and task_ts_flag = 'N' 
      --and rh.update_user=@user_name

    select top 1 @proj_id=proj_id, @status_code=status_code from #projs
    while (select count(*) from #projs)>0
    begin
      print @proj_id
      exec getnextkeys 'tsaudit_ts_audit_id',1,@key output
      print @key

      select @reg_hrs=isnull(sum(hr_cnt),0), @reg_ot_hrs=isnull(sum(ot_hr_cnt),0)
          , @pend_reg_hrs=isnull(sum(pend_hr_cnt),0)
          , @pend_reg_ot_hrs=isnull(sum(pend_ot_hr_cnt),0)
      from rsrchour
      where ts_id = @pts_id and rsrc_id = @prsrc_id
      and nonwork_type_id is null
      and proj_id=@proj_id

      select @oh_hrs=isnull(sum(hr_cnt),0), @oh_ot_hrs=isnull(sum(ot_hr_cnt),0)
          , @pend_oh_hrs=isnull(sum(pend_hr_cnt),0)
          , @pend_oh_ot_hrs=isnull(sum(pend_ot_hr_cnt),0)
      from rsrchour
      where ts_id = @pts_id and rsrc_id = @prsrc_id
      and nonwork_type_id is not null
      and proj_id=@proj_id

      insert into tsaudit (ts_audit_id, audit_date,rsrc_id, rsrc_short_name, rsrc_name
					, reg_hrs, oh_hrs, ts_id, ts_start_date, ts_end_date, proj_id
					, proj_short_name, user_id, user_name, ts_status_code 
					, reg_ot_hrs, pend_reg_hrs, pend_reg_ot_hrs, oh_ot_hrs
					, pend_oh_hrs, pend_oh_ot_hrs, ts_task_status, approving_as)
      select @key, getDate(), @prsrc_id, r.rsrc_short_name, r.rsrc_name
	  , @reg_hrs, @oh_hrs, @pts_id, ts.start_date, ts.end_date, @proj_id
	  , p.proj_short_name, @effective_user_id, u.user_name, t.status_code
	  , @reg_ot_hrs, @pend_reg_hrs, @pend_reg_ot_hrs, @oh_ot_hrs
	  , @pend_oh_hrs, @pend_oh_ot_hrs, @status_code, @ptype
      from rsrc r, tsdates ts, users u, timesht t, project p
      where r.rsrc_id = @prsrc_id and ts.ts_id = @pts_id
      and u.user_id = @effective_user_id
      and t.ts_id = @pts_id and t.rsrc_id = @prsrc_id
      and p.proj_id = @proj_id

      delete from #projs where proj_id = @proj_id
      select top 1 @proj_id=proj_id, @status_code=status_code from #projs
    end
  end
  else
  if @ptype = 'ApproveAsRM' or @ptype ='ApproveAsRMDelegate' or @ptype = 'Submitted'
  begin
    exec getnextkeys 'tsaudit_ts_audit_id',1,@key output
    print @key

    select @reg_hrs=isnull(sum(hr_cnt),0), @reg_ot_hrs=isnull(sum(ot_hr_cnt),0)
          , @pend_reg_hrs=isnull(sum(pend_hr_cnt),0)
          , @pend_reg_ot_hrs=isnull(sum(pend_ot_hr_cnt),0)
    from rsrchour
    where ts_id = @pts_id and rsrc_id = @prsrc_id
    and nonwork_type_id is null

    select @oh_hrs=isnull(sum(hr_cnt),0), @oh_ot_hrs=isnull(sum(ot_hr_cnt),0)
          , @pend_oh_hrs=isnull(sum(pend_hr_cnt),0)
          , @pend_oh_ot_hrs=isnull(sum(pend_ot_hr_cnt),0)
    from rsrchour
    where ts_id = @pts_id and rsrc_id = @prsrc_id
    and nonwork_type_id is not null

    insert into tsaudit (ts_audit_id, audit_date,rsrc_id, rsrc_short_name, rsrc_name
                        , reg_hrs, oh_hrs, ts_id, ts_start_date, ts_end_date, proj_id
                        , proj_short_name, user_id, user_name, ts_status_code 
                        , reg_ot_hrs, pend_reg_hrs, pend_reg_ot_hrs, oh_ot_hrs
                        , pend_oh_hrs, pend_oh_ot_hrs, ts_task_status, approving_as)
    select @key, getDate(), @prsrc_id, r.rsrc_short_name, r.rsrc_name
          , @reg_hrs, @oh_hrs, @pts_id, ts.start_date, ts.end_date, null
          , null, @effective_user_id, u.user_name, t.status_code
          , @reg_ot_hrs, @pend_reg_hrs, @pend_reg_ot_hrs, @oh_ot_hrs
          , @pend_oh_hrs, @pend_oh_ot_hrs, null, @ptype
    from rsrc r, tsdates ts, users u, timesht t
    where r.rsrc_id = @prsrc_id and ts.ts_id = @pts_id
    and u.user_id = @effective_user_id
    and t.ts_id = @pts_id and t.rsrc_id = @prsrc_id

  end
end
go
--METADATA NAME:TS_AUDIT TYPE:GRANT TABLE_NAME:TS_AUDIT CHANGE:CREATE
GRANT EXECUTE ON TS_AUDIT TO ${pm.ss.privileged_user}
go
print 'Creating procedure PV_OPEN_PROJECT'

--METADATA  TYPE:SSCR NAME:PV_OPEN_PROJECT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PV_OPEN_PROJECT' and type in ('P'))
  DROP PROCEDURE PV_OPEN_PROJECT
go
--METADATA NAME:PV_OPEN_PROJECT TYPE:PROCEDURE SET:PV_OPEN_PROJECT CHANGE:CREATE
CREATE PROCEDURE PV_OPEN_PROJECT
@puser_open_id INTEGER,@psession_id INTEGER,@template_flag varchar,@pret_val INTEGER OUTPUT,@pret_msg VARCHAR(255) OUTPUT
 AS
   SET NOCOUNT ON
 BEGIN
     DECLARE  @proj_id INT,@vuser_open_id INT,@vuser_open_name VARCHAR(255),@vuser_id INT
     DECLARE  @vcontext_id INT,@vpk_id INT,@vusropn_type VARCHAR(20),@cnt INT,@vprof_id INT,@vrsrc_id INT
     DECLARE  @ErrMsg NVARCHAR(4000),@ErrSeverity INT
     CREATE TABLE #USROPN (USR_OPEN_ID INT,PK_ID INT,USROPN_TYPE VARCHAR(20))
     CREATE TABLE #PVPROJID (PROJ_ID INT)
     CREATE TABLE #PROJID (PROJ_ID INT)
	
     BEGIN TRY
       SET @vcontext_id = 21536
       DELETE FROM PROJSHAR WHERE SESSION_ID = @psession_id;
       DELETE FROM UPKLIST  WHERE SESSION_ID = @psession_id AND CONTEXT_ID = @vcontext_id;
       SELECT @vuser_open_id = USER_OPEN_ID,@vuser_open_name = USER_OPEN_NAME,@vuser_id =USER_ID
       FROM   USEROPEN
       WHERE  USER_OPEN_ID = @puser_open_id
              AND DELETE_SESSION_ID IS NULL;
       INSERT INTO #USROPN
       SELECT USER_OPEN_ID,PK_ID,USROPN_TYPE
       FROM   USROPNVAL
       WHERE  USER_OPEN_ID = @puser_open_id
              AND DELETE_SESSION_ID IS NULL;
       DECLARE UOPEN CURSOR  FOR
       SELECT PK_ID,USROPN_TYPE
       FROM   #USROPN
       OPEN UOPEN
       FETCH  UOPEN
       INTO @vpk_id,
            @vusropn_type
       WHILE (@@FETCH_STATUS = 0)
         BEGIN
           IF @vusropn_type = 'PS_Project'
             BEGIN
			if isnull(@template_flag,'N')='Y' 
 				select @proj_id=p.proj_id from project p, projwbs pw where p.project_flag = 'Y' and pw.wbs_id = @vpk_id
				 and p.proj_id = pw.proj_id and p.delete_session_id is null and pw.status_code<>'WS_Requested'
			else
		     select @proj_id=p.proj_id from project p, projwbs pw where p.project_flag = 'Y' and pw.wbs_id = @vpk_id
				 and p.proj_id = pw.proj_id and p.delete_session_id is null and pw.status_code not in ('WS_Requested','WS_Template')
					
              if @proj_id is not null	
               INSERT INTO #PVPROJID
               VALUES(@proj_id)
             END
           ELSE
             IF @vusropn_type = 'PS_EPS'
               BEGIN
				if isnull(@template_flag,'N')='Y' 
          begin
                 WITH PROJLIST(PROJ_ID,WBS_ID,PARENT_WBS_ID)
                      AS (SELECT PROJ_ID,WBS_ID,PARENT_WBS_ID
                          FROM   PROJWBS
                          WHERE  PARENT_WBS_ID = @vpk_id and projwbs.status_code<>'WS_Requested'
                          UNION ALL
                          SELECT PW.PROJ_ID,PW.WBS_ID,PW.PARENT_WBS_ID
                          FROM   PROJWBS PW 
                                 JOIN PROJLIST PL
                                   ON PL.WBS_ID = PW.PARENT_WBS_ID where pw.status_code<>'WS_Requested'
					
				 )
                 INSERT INTO #PVPROJID
                 SELECT DISTINCT PL.PROJ_ID
                 FROM   PROJLIST PL
                        JOIN PROJECT P
                          ON PL.PROJ_ID = P.PROJ_ID
                             AND P.PROJECT_FLAG = 'Y'
                             AND P.DELETE_SESSION_ID IS NULL
                             AND P.ORIG_PROJ_ID IS NULL
         end;
			else
				WITH PROJLIST(PROJ_ID,WBS_ID,PARENT_WBS_ID)
                      AS (SELECT PROJ_ID,WBS_ID,PARENT_WBS_ID
                          FROM   PROJWBS
                          WHERE  PARENT_WBS_ID = @vpk_id and projwbs.status_code not in ('WS_Requested','WS_Template')
                          UNION ALL
                          SELECT PW.PROJ_ID,PW.WBS_ID,PW.PARENT_WBS_ID
                          FROM   PROJWBS PW 
                                 JOIN PROJLIST PL
                                   ON PL.WBS_ID = PW.PARENT_WBS_ID where pw.status_code not in ('WS_Requested','WS_Template')
					
				 )
                 INSERT INTO #PVPROJID
                 SELECT DISTINCT PL.PROJ_ID
                 FROM   PROJLIST PL
                        JOIN PROJECT P
                          ON PL.PROJ_ID = P.PROJ_ID
                             AND P.PROJECT_FLAG = 'Y'
                             AND P.DELETE_SESSION_ID IS NULL
                             AND P.ORIG_PROJ_ID IS NULL
               END
             ELSE
               IF @vusropn_type = 'PS_Portfolio'
                 BEGIN
                   INSERT INTO #PVPROJID
                   SELECT PROJ_ID
                   FROM   PROJECT
                   WHERE  PROJ_ID IN (SELECT PROJ_ID
                                      FROM   PROJWBS
                                      WHERE  WBS_ID IN (SELECT WBS_ID
                                                        FROM   PRPFOLIO
                                                        WHERE  PFOLIO_ID = @vpk_id))
                          AND DELETE_SESSION_ID IS NULL;
                 END
               ELSE
                 IF @vusropn_type = 'PS_ProjectCode'
                   BEGIN
					if isnull(@template_flag,'N')='Y' 
                     INSERT INTO #PVPROJID
                     SELECT PC.PROJ_ID
                     FROM   PROJPCAT PC,PROJECT P ,PROJWBS PW
                     WHERE  PROJ_CATG_ID = @vpk_id and PC.PROJ_ID=P.PROJ_ID and PC.PROJ_ID=PW.PROJ_ID and P.ORIG_PROJ_ID is null
                            AND PC.DELETE_SESSION_ID IS NULL and pw.status_code<>'WS_Requested' ;
					else
                     INSERT INTO #PVPROJID
                     SELECT PC.PROJ_ID
                     FROM   PROJPCAT PC,PROJECT P ,PROJWBS PW
                     WHERE  PROJ_CATG_ID = @vpk_id and PC.PROJ_ID=P.PROJ_ID and PC.PROJ_ID=PW.PROJ_ID and P.ORIG_PROJ_ID is null
                            AND PC.DELETE_SESSION_ID IS NULL and pw.status_code not in ('WS_Requested','WS_Template') ;

                   END
           FETCH  UOPEN
           INTO @vpk_id,
                @vusropn_type
         END
       INSERT INTO #PROJID
       SELECT DISTINCT (PROJ_ID)
       FROM   #PVPROJID 
       INSERT INTO UPKLIST
                  (PK_ID,SESSION_ID,CONTEXT_ID)
       SELECT PROJ_ID,@psession_id,@vcontext_id
       FROM   #PROJID
       SELECT @vprof_id = PROF_ID
       FROM   USERS
       WHERE  USER_ID = @vuser_id
       IF @vprof_id <> 12
         BEGIN
 		if exists (select rsrc_id from rsrc where user_id=@vuser_id and delete_session_id is null)
 		begin
 		select @vrsrc_id=rsrc_id from rsrc where user_id=@vuser_id and delete_session_id is null
 		end;
 	       WITH projtemp (proj_id)
 		AS
 		    (SELECT PROJ_ID
         	    FROM   OBSPROJ U,USEROBS UO,UPKLIST
 	            WHERE  U.OBS_ID = UO.OBS_ID
           	    AND U.PROJ_ID = UPKLIST.PK_ID
                     AND UPKLIST.SESSION_ID = @psession_id
                     AND UO.USER_ID = @vuser_id
                     AND CONTEXT_ID = @vcontext_id
 	        union select pk_id proj_id from upklist upk,project p,taskrsrc tr,usereng u where tr.proj_id=upk.pk_id and upk.pk_id=p.proj_id and p.orig_proj_id is null and p.delete_session_id is null and tr.rsrc_id=@vrsrc_id and session_id=@psession_id and context_id=@vcontext_id and u.user_id=@vuser_id
              and u.db_engine_type = 'TS'
              and ( u.user_id not in (select user_id from usereng where db_engine_type != 'TS' and @vuser_id = user_id)
                or 
                ( u.user_id in (select user_id from usereng where db_engine_type = 'PM' and @vuser_id = user_id)
                  and u.user_id not in (select user_id from usereng where db_engine_type not in ('TS','PM') and @vuser_id = user_id)
                )
              )
 		union select pk_id proj_id from upklist upk, project p where p.proj_id = upk.pk_id and p.rsrc_id = @vrsrc_id and session_id = @psession_id and context_id = @vcontext_id and orig_proj_id is null and delete_session_id is null
 		union select pk_id proj_id  from upklist upk,project p, taskuser tu  where upk.pk_id=p.proj_id and p.orig_proj_id is null and tu.user_id=@vuser_id and tu.proj_id=upk.pk_id and session_id=@psession_id and context_id=@vcontext_id and p.delete_session_id is null) 
                INSERT INTO PROJSHAR
                       (PROJ_ID,SESSION_ID,ACCESS_LEVEL,LOAD_STATUS)
                SELECT distinct(PROJ_ID),@psession_id,0,'O' from projtemp 
 	  END
       ELSE
         BEGIN
           INSERT INTO PROJSHAR
                      (PROJ_ID,SESSION_ID,ACCESS_LEVEL,LOAD_STATUS)
           SELECT PROJ_ID,@psession_id,0,'O'
           FROM   #PROJID
         END
     set @pret_val=0	
     set @pret_msg='Success'
     END TRY
     BEGIN CATCH
       SELECT @ErrMsg = ERROR_MESSAGE(),@ErrSeverity = ERROR_SEVERITY()
       RAISERROR (@ErrMsg,@ErrSeverity,1)
     END CATCH
   END
go
--METADATA NAME:PV_OPEN_PROJECT TYPE:GRANT TABLE_NAME:PV_OPEN_PROJECT CHANGE:CREATE
GRANT EXECUTE ON PV_OPEN_PROJECT TO ${pm.ss.privileged_user}
go
print 'Creating procedure SOURCE_VERSION'

--METADATA  TYPE:SSCR NAME:SOURCE_VERSION OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SOURCE_VERSION' and type in ('P'))
  DROP PROCEDURE SOURCE_VERSION
go
--METADATA NAME:SOURCE_VERSION TYPE:PROCEDURE SET:SOURCE_VERSION CHANGE:CREATE
CREATE PROCEDURE SOURCE_VERSION
        @version varchar(30) OUTPUT
WITH ENCRYPTION AS
  set @version='30-January-2024 11:39 AM'
go
--METADATA NAME:SOURCE_VERSION TYPE:GRANT TABLE_NAME:SOURCE_VERSION CHANGE:CREATE
GRANT EXECUTE ON SOURCE_VERSION TO ${pm.ss.privileged_user}
go
print 'Creating function GET_UNIQUE_TASK_CODE'

--METADATA  TYPE:SSCR NAME:GET_UNIQUE_TASK_CODE OBJECT_TYPE:FUNCTION
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'GET_UNIQUE_TASK_CODE' and type in ('FN','TF'))
  DROP FUNCTION GET_UNIQUE_TASK_CODE
go
--METADATA NAME:GET_UNIQUE_TASK_CODE TYPE:FUNCTION SET:ACTIVITY_COPY_API CHANGE:CREATE
CREATE FUNCTION GET_UNIQUE_TASK_CODE
(@ptask_code varchar(20), @pproj_id integer) 
returns varchar(40)
WITH ENCRYPTION AS
begin 
declare 
@i int,
@vtask_code varchar(40),
@vtmp varchar(4),
@vtmp2 varchar(4),
@vtmpnum int,
@j int,
@vtask_code_base int,
@vtask_code_step int
set @vtask_code = rtrim(@ptask_code)
select @vtask_code_base = task_code_base, @vtask_code_step=task_code_step from project where proj_id = @pproj_id

if @vtask_code_base is null
  set @vtask_code_base = 1000

if @vtask_code_step is null
  set @vtask_code_step = 10

if len(@vtask_code) < 4
	set @vtask_code = @vtask_code + '1000'
set @vtmp = substring(@vtask_code, len(@vtask_code) - 3, 4)
set @vtmp2 = ''
set @i = 1
while @i <= 4
begin
if substring(@vtmp, @i, 1) >= '0' and substring(@vtmp, @i, 1) <= '9'
	set @vtmp2 = @vtmp2 + substring(@vtmp, @i, 1)
set @i = @i + 1
end 
if @vtmp2 = ''
 set @vtmpnum = @vtask_code_base
else
 set @vtmpnum = @vtmp2

set @i = 1
while @i <= 1000
begin
if (select count(1) from task where proj_id = @pproj_id and delete_session_id is null and task_code = substring(@vtask_code, 1, len(@vtask_code) - 4) + cast(@vtmpnum as varchar)) = 0
break
 set @vtmpnum = @vtmpnum + @vtask_code_step
set @i = @i + 1
end 

if @i = 1000 
select @vtmpnum = datediff(ss, cast(month(getdate()) as varchar) + '/' + cast(day(getdate()) as varchar) + '/' + cast(year(getdate()) as varchar), getdate()) 
set @vtask_code = substring(@vtask_code, 1, len(@vtask_code) - 4) + cast(@vtmpnum as varchar)
return @vtask_code
end

go
--METADATA NAME:GET_UNIQUE_TASK_CODE TYPE:GRANT TABLE_NAME:GET_UNIQUE_TASK_CODE CHANGE:CREATE
GRANT EXECUTE ON GET_UNIQUE_TASK_CODE TO ${pm.ss.privileged_user}
go
print 'Creating procedure ACTIVITY_COPY_API'

--METADATA  TYPE:SSCR NAME:ACTIVITY_COPY_API OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'ACTIVITY_COPY_API' and type in ('P'))
  DROP PROCEDURE ACTIVITY_COPY_API
go
--METADATA NAME:ACTIVITY_COPY_API TYPE:PROCEDURE SET:ACTIVITY_COPY_API CHANGE:CREATE
CREATE PROCEDURE ACTIVITY_COPY_API
	@ptask_id		integer,
	@pwbs_id		integer,
	@ptask_code		varchar(20),
	@copy_bit		varchar(30),
	@pret_val		integer OUTPUT,
	@pret_msg		varchar(4000) OUTPUT
WITH ENCRYPTION AS
  DECLARE @vproj_id_from integer, @vproj_id_to integer, @vtask_code	varchar(40), @vclndr_id_default integer
  DECLARE @v_new_task_id integer, @vcnt integer, @vid integer, @vOldId integer, @vOldDocId integer
  DECLARE @vguid varchar(22), @new_doc_id integer,@vclndr_id integer,@vclndr_type varchar(16)
  DECLARE @psession_id integer, @v_datetime datetime, @ids_count integer, @v_first_id integer 

      select @vproj_id_from = proj_id, @vtask_code = task_code ,@vclndr_id=clndr_id
        from task
       where task_id = @ptask_id
         and delete_session_id is null

      select @vproj_id_to = proj_id 
        from projwbs   
       where wbs_id = @pwbs_id
         and delete_session_id is null


      if @ptask_code is not null 
        set @vtask_code = @ptask_code
      else
        set @vtask_code = dbo.get_unique_task_code (@vtask_code, @vproj_id_to)

    exec  get_guid @vguid OUTPUT
    exec pc_get_next_key 'task_task_id', @v_new_task_id OUTPUT

      if @vproj_id_to <> @vproj_id_from
	select @vclndr_type=clndr_type from calendar where clndr_id=@vclndr_id 
         if @vclndr_type='CA_Base'
              set @vclndr_id_default= @vclndr_id
        else 
          select @vclndr_id_default = clndr_id 
          from calendar 
          where default_flag = 'Y';

    insert into task 
	(TASK_ID,PROJ_ID,WBS_ID,CLNDR_ID,EST_WT,PHYS_COMPLETE_PCT,REV_FDBK_FLAG         
	,LOCK_PLAN_FLAG,AUTO_COMPUTE_ACT_FLAG,COMPLETE_PCT_TYPE,TASK_TYPE              
	,DURATION_TYPE,REVIEW_TYPE,STATUS_CODE,TASK_CODE,TASK_NAME,RSRC_ID             
	,TOTAL_FLOAT_HR_CNT,FREE_FLOAT_HR_CNT,REMAIN_DRTN_HR_CNT,ACT_WORK_QTY          
	,REMAIN_WORK_QTY,TARGET_WORK_QTY,TARGET_DRTN_HR_CNT,TARGET_EQUIP_QTY           
	,ACT_EQUIP_QTY,REMAIN_EQUIP_QTY,CSTR_DATE,ACT_START_DATE,ACT_END_DATE          
	,LATE_START_DATE,LATE_END_DATE,EXPECT_END_DATE,EARLY_START_DATE                
	,EARLY_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE,TARGET_END_DATE      
	,REVIEW_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE,CSTR_TYPE               
	,PRIORITY_TYPE,GUID,TMPL_GUID,CSTR_DATE2,CSTR_TYPE2,FLOAT_PATH                 
	,FLOAT_PATH_ORDER,ACT_THIS_PER_WORK_QTY,ACT_THIS_PER_EQUIP_QTY                 
	,DRIVING_PATH_FLAG,SUSPEND_DATE,RESUME_DATE)
      select @v_new_task_id, 
		@vproj_id_to, 
		@pwbs_id, 
		CASE WHEN @vproj_id_to = @vproj_id_from THEN CLNDR_ID ELSE @vclndr_id_default END,	
		EST_WT,PHYS_COMPLETE_PCT,REV_FDBK_FLAG         
	,LOCK_PLAN_FLAG,AUTO_COMPUTE_ACT_FLAG,COMPLETE_PCT_TYPE,TASK_TYPE              
	,DURATION_TYPE,REVIEW_TYPE,STATUS_CODE
    ,@vtask_code
    ,TASK_NAME,RSRC_ID             
	,TOTAL_FLOAT_HR_CNT,FREE_FLOAT_HR_CNT,REMAIN_DRTN_HR_CNT,ACT_WORK_QTY          
	,REMAIN_WORK_QTY,TARGET_WORK_QTY,TARGET_DRTN_HR_CNT,TARGET_EQUIP_QTY           
	,ACT_EQUIP_QTY,REMAIN_EQUIP_QTY,CSTR_DATE,ACT_START_DATE,ACT_END_DATE          
	,LATE_START_DATE,LATE_END_DATE,EXPECT_END_DATE,EARLY_START_DATE                
	,EARLY_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE,TARGET_END_DATE      
	,REVIEW_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE,CSTR_TYPE               
	,PRIORITY_TYPE
	,@vguid	
	,TMPL_GUID,CSTR_DATE2,CSTR_TYPE2,FLOAT_PATH                 
	,FLOAT_PATH_ORDER,ACT_THIS_PER_WORK_QTY,ACT_THIS_PER_EQUIP_QTY                 
	,DRIVING_PATH_FLAG,SUSPEND_DATE,RESUME_DATE                                                       
   from task
   where task_id = @ptask_id;

   --bug fix 6919
	if @vproj_id_to = @vproj_id_from  -- within same project only
	 insert into taskuser
        (TASK_ID, USER_ID,PROJ_ID)
        select @v_new_task_id, user_id,@vproj_id_to
          from taskuser
         where task_id = @ptask_id;

      if substring(@copy_bit,11,1)='0'
         update task 
         set rsrc_id = null
         where task_id = @v_new_task_id
         and rsrc_id is not null;

    -- TASKPRED
--    if substring(@copy_bit,2,1)='1'
--    BEGIN
--      insert into pkxref (system_id, context_name, pk1,pk2,old_pk1,old_pk2 ,add_date)
--      select @pwork_id, 'T', @pproj_id, @v_new_task_id, t.proj_id,t.task_id , getDate()
--      from task t
--      where task_id = @ptask_id
--      and delete_session_id is null ;
--    END

    -- TASKACTV
    if substring(@copy_bit,3,1)='1' and @vproj_id_to = @vproj_id_from
    BEGIN
      insert into taskactv
       (TASK_ID,ACTV_CODE_TYPE_ID,ACTV_CODE_ID,PROJ_ID)
       select @v_new_task_id , t.ACTV_CODE_TYPE_ID, t.ACTV_CODE_ID,
	        @vproj_id_to 
      from actvtype a, taskactv t
      where t.task_id = @ptask_id
      and a.actv_code_type_id = t.actv_code_type_id
      and super_flag = 'N'
      and t.delete_session_id is null ;
    END	
     else if substring(@copy_bit,3,1)='1'
    BEGIN
      insert into taskactv
       (TASK_ID,ACTV_CODE_TYPE_ID,ACTV_CODE_ID,PROJ_ID)
       select @v_new_task_id , t.ACTV_CODE_TYPE_ID, t.ACTV_CODE_ID,
         @vproj_id_to
      from actvtype a, taskactv t
      where t.task_id = @ptask_id
      and a.actv_code_type_id = t.actv_code_type_id
      and super_flag = 'N'
      and a.Actv_code_type_scope = 'AS_Global'
      and t.delete_session_id is null ;
    END

    -- TASKFIN (PPA)
    if substring(@copy_bit,11,1)='1'
    BEGIN
      insert into taskfin
      (FIN_DATES_ID,TASK_ID,PROJ_ID,ACT_WORK_QTY,ACT_WORK_COST,ACT_EQUIP_QTY
          ,ACT_EQUIP_COST,ACT_MAT_COST,ACT_EXPENSE_COST,BCWP,SCHED_WORK_QTY,BCWS,PERFM_WORK_QTY)
      select FIN_DATES_ID,@v_new_task_id,@vproj_id_to,ACT_WORK_QTY,ACT_WORK_COST,ACT_EQUIP_QTY
          ,ACT_EQUIP_COST,ACT_MAT_COST,ACT_EXPENSE_COST,BCWP,SCHED_WORK_QTY,BCWS,PERFM_WORK_QTY
      from taskfin
      where task_id = @ptask_id;
    END

    -- TASKRSRC
    if substring(@copy_bit,1,1)='1'
    BEGIN
     DECLARE tr CURSOR FOR select taskrsrc_id from taskrsrc where task_id = @ptask_id and delete_session_id is null order by taskrsrc_id
     OPEN tr
     FETCH NEXT FROM tr INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec  get_guid @vguid OUTPUT
       exec pc_get_next_key 'taskrsrc_taskrsrc_id', @vid OUTPUT
       insert into taskrsrc 
	(TASKRSRC_ID,TASK_ID,PROJ_ID,RSRC_TYPE,COST_QTY_LINK_FLAG,ROLE_ID               
	,ACCT_ID,RSRC_ID,SKILL_LEVEL,PEND_COMPLETE_PCT,REMAIN_QTY,PEND_REMAIN_QTY      
	,TARGET_QTY,REMAIN_QTY_PER_HR,PEND_ACT_REG_QTY,TARGET_LAG_DRTN_HR_CNT          
	,TARGET_QTY_PER_HR,ACT_OT_QTY,PEND_ACT_OT_QTY,ACT_REG_QTY,RELAG_DRTN_HR_CNT    
	,OT_FACTOR,COST_PER_QTY,TARGET_COST,ACT_REG_COST,ACT_OT_COST,REMAIN_COST       
	,ACT_START_DATE,ACT_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE         
	,TARGET_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE,GUID,RATE_TYPE          
	,ACT_THIS_PER_COST,ACT_THIS_PER_QTY,CURV_ID,ROLLUP_DATES_FLAG                  
	,COST_PER_QTY_SOURCE_TYPE,RSRC_REQUEST_DATA,TARGET_CRV,REMAIN_CRV,ACTUAL_CRV)
       select @vid, @v_new_task_id, @vproj_id_to
	,RSRC_TYPE,COST_QTY_LINK_FLAG,ROLE_ID               
	,ACCT_ID,RSRC_ID,SKILL_LEVEL,PEND_COMPLETE_PCT,REMAIN_QTY,PEND_REMAIN_QTY      
	,TARGET_QTY,REMAIN_QTY_PER_HR,PEND_ACT_REG_QTY,TARGET_LAG_DRTN_HR_CNT          
	,TARGET_QTY_PER_HR,ACT_OT_QTY,PEND_ACT_OT_QTY,ACT_REG_QTY,RELAG_DRTN_HR_CNT    
	,OT_FACTOR,COST_PER_QTY,TARGET_COST,ACT_REG_COST,ACT_OT_COST,REMAIN_COST       
	,ACT_START_DATE,ACT_END_DATE,RESTART_DATE,REEND_DATE,TARGET_START_DATE         
	,TARGET_END_DATE,REM_LATE_START_DATE,REM_LATE_END_DATE
	,@vguid
	,RATE_TYPE          
	,ACT_THIS_PER_COST,ACT_THIS_PER_QTY,CURV_ID,ROLLUP_DATES_FLAG                  
	,COST_PER_QTY_SOURCE_TYPE,RSRC_REQUEST_DATA,TARGET_CRV,REMAIN_CRV,ACTUAL_CRV
            from taskrsrc
            where taskrsrc_id = @vOldId;

       exec pc_insert_udf 'taskrsrc', @vOldId,  @vid, @vproj_id_to

       -- todo: taskfin 
       if substring(@copy_bit,11,1)='1'
       begin
         insert into trsrcfin
         (fin_dates_id,taskrsrc_id,task_id,proj_id,act_qty,act_cost)
         select fin_dates_id,@vid,@v_new_task_id,@vproj_id_to,act_qty,act_cost
         from trsrcfin
         where taskrsrc_id = @vOldId;
       end
	
       FETCH NEXT FROM tr INTO @vOldId
     END 
     CLOSE tr
     DEALLOCATE tr
    END

    -- TASKMEMO
    if substring(@copy_bit,4,1)='1'
    BEGIN
     DECLARE tm CURSOR FOR select memo_id from taskmemo where task_id = @ptask_id and delete_session_id is null order by memo_id
     OPEN tm
     FETCH NEXT FROM tm INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'taskmemo_memo_id', @vid OUTPUT
       insert into taskmemo 
	(memo_id, task_id, memo_type_id, proj_id, task_memo )
       select @vid , @v_new_task_id, memo_type_id, @vproj_id_to, task_memo
 	from taskmemo
	where memo_id = @vOldId

       FETCH NEXT FROM tm INTO @vOldId
     END 
     CLOSE tm
     DEALLOCATE tm
    END

    -- taskdoc
    if substring(@copy_bit,7,1)='1' and @vproj_id_to = @vproj_id_from 
    BEGIN
     DECLARE td CURSOR FOR select taskdoc_id,doc_id from taskdoc where task_id = @ptask_id and delete_session_id is null order by taskdoc_id
     OPEN td
     FETCH NEXT FROM td INTO @vOldId, @vOldDocId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
	   exec  get_guid @vguid OUTPUT
       exec pc_get_next_key 'taskdoc_taskdoc_id', @vid OUTPUT
	   exec pc_get_next_key 'document_doc_id', @new_doc_id OUTPUT

        insert into document
          (DOC_ID,
           DOC_SEQ_NUM,
           DELIV_FLAG,
           DOC_NAME,
           PARENT_DOC_ID,
           PROJ_ID,
           DOC_STATUS_ID,
           DOC_CATG_ID,
           DOC_DATE,
           VERSION_NAME,
           GUID,
           TMPL_GUID,
           DOC_SHORT_NAME,
           AUTHOR_NAME,
           PRIVATE_LOC,
           PUBLIC_LOC,
           DOC_CONTENT,
           RSRC_ID,
           DOC_MGMT_TYPE,
           EXTERNAL_DOC_KEY)
          select @new_doc_id,
                 DOC_SEQ_NUM,
                 DELIV_FLAG,
                 DOC_NAME,
                 PARENT_DOC_ID,
                 @vproj_id_to,
                 DOC_STATUS_ID,
                 DOC_CATG_ID,
                 DOC_DATE,
                 VERSION_NAME,
                 @vguid,
                 null,
                 DOC_SHORT_NAME,
                 AUTHOR_NAME,
                 PRIVATE_LOC,
                 PUBLIC_LOC,
                 DOC_CONTENT,
                 RSRC_ID,
                 DOC_MGMT_TYPE,
                 EXTERNAL_DOC_KEY
            from document
           where doc_id = @vOldDocId

           exec pc_insert_udf 'document', @vOldDocId,  @new_doc_id, @vproj_id_to

          insert into taskdoc 
		( TASKDOC_ID,DOC_ID,PROJ_ID,WBS_ID,WP_FLAG,TASK_ID )
          select @vid, @new_doc_id, @vproj_id_to, @pwbs_id, 		
		wp_flag, @v_new_task_id
	  from taskdoc
	  where taskdoc_id = @vOldId

       FETCH NEXT FROM td INTO @vOldId, @vOldDocId
     END 
     DEALLOCATE td
   END

    -- TASKPROC
    if substring(@copy_bit,6,1)='1'
    BEGIN
     DECLARE tp CURSOR FOR select proc_id from taskproc where task_id = @ptask_id and delete_session_id is null order by proc_id
     OPEN tp
     FETCH NEXT FROM tp INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'taskproc_proc_id', @vid OUTPUT
       insert into taskproc 
		( proc_id, task_id, seq_num, proj_id, complete_flag
		,proc_name, proc_wt , proc_descr         
		,COMPLETE_PCT) 
       select   @vid, @v_new_task_id, seq_num, @vproj_id_to,
		complete_flag, proc_name, proc_wt, proc_descr
		,COMPLETE_PCT
	from taskproc
 	where proc_id = @vOldId

       exec pc_insert_udf 'taskproc', @vOldId,  @vid, @vproj_id_to

       FETCH NEXT FROM tp INTO @vOldId
     END 
     CLOSE tp
     DEALLOCATE tp
    END

    -- PROJCOST
    if substring(@copy_bit,5,1)='1'
    BEGIN
     DECLARE pc CURSOR FOR select cost_item_id from projcost where task_id = @ptask_id and delete_session_id is null order by cost_item_id
     OPEN pc
     FETCH NEXT FROM pc INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'projcost_cost_item_id', @vid OUTPUT
       insert into projcost
	( COST_ITEM_ID,PROJ_ID,TASK_ID,AUTO_COMPUTE_ACT_FLAG,COST_LOAD_TYPE              
	,ACCT_ID,COST_TYPE_ID,TARGET_COST,ACT_COST,REMAIN_COST,QTY_NAME                
	,TARGET_QTY,COST_PER_QTY,PO_NUMBER,VENDOR_NAME,COST_NAME,COST_DESCR) 
       select @vid, @vproj_id_to, @v_new_task_id
	,AUTO_COMPUTE_ACT_FLAG,COST_LOAD_TYPE              
	,ACCT_ID,COST_TYPE_ID,TARGET_COST,ACT_COST,REMAIN_COST,QTY_NAME                
	,TARGET_QTY,COST_PER_QTY,PO_NUMBER,VENDOR_NAME,COST_NAME,COST_DESCR
       from projcost
       where cost_item_id = @vOldId

       exec pc_insert_udf 'projcost', @vOldId,  @vid, @vproj_id_to

       FETCH NEXT FROM pc INTO @vOldId
     END 
     CLOSE pc
     DEALLOCATE pc
    END

  -- projISSU
  if substring(@copy_bit,9,1)='1'
  BEGIN
     DECLARE cpi CURSOR FOR select issue_id from projissu where task_id = @ptask_id and delete_session_id is null order by issue_id
     OPEN cpi
     FETCH NEXT FROM cpi INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'projissu_issue_id', @vid OUTPUT
        insert into projissu
		(ISSUE_ID,PROJ_ID,OBS_ID,PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
		,TRACK_VIEW_ID,WBS_ID,TASK_ID,RSRC_ID,THRESH_PARM_ID,BASE_PROJ_ID              
		,WORKSPACE_ID,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES) 
        select @vid, @vproj_id_to
		,OBS_ID,PRIORITY_TYPE,STATUS_CODE,ISSUE_NAME,THRESH_ID         
		,TRACK_VIEW_ID
		,@pwbs_id,@v_new_task_id
		,RSRC_ID
		,CASE WHEN @vproj_id_to = @vproj_id_from THEN THRESH_PARM_ID ELSE null END
		,CASE WHEN @vproj_id_to = @vproj_id_from THEN BASE_PROJ_ID ELSE null END
		,CASE WHEN @vproj_id_to = @vproj_id_from THEN WORKSPACE_ID ELSE null END
		,ISSUE_VALUE,LO_PARM_VALUE,HI_PARM_VALUE,ADD_BY_NAME              
		,RESOLV_DATE,ADD_DATE,ISSUE_NOTES
	from projissu
        where issue_id = @vOldId;

        insert into issuhist (issue_id,proj_id,issue_history)
        select @vid,@vproj_id_to, issue_history
        from issuhist
        where issue_id = @vOldId
        and delete_session_id is null ;

        exec pc_insert_udf 'projissu', @vOldId, @vid, @vproj_id_to 

       FETCH NEXT FROM cpi INTO @vOldId
     END 
     DEALLOCATE cpi
   END

-- taskpred copy
    if substring(@copy_bit,2,1)='1'
    BEGIN
     DECLARE tpred CURSOR FOR select task_pred_id from taskpred where task_id = @ptask_id and delete_session_id is null order by task_pred_id
     OPEN tpred
     FETCH NEXT FROM tpred INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'taskpred_task_pred_id', @vid OUTPUT

          insert into taskpred
            (task_pred_id,
             task_id,
             pred_task_id,
             proj_id,
             pred_proj_id,
             pred_type,
             lag_hr_cnt,
			 comments)
          select
             @vid,
             @v_new_task_id,
             pred_task_id,
             @vproj_id_to,
             pred_proj_id,
             pred_type,
             lag_hr_cnt,
			 comments
		  from taskpred
		  where task_pred_id = @vOldId

       FETCH NEXT FROM tpred INTO @vOldId
     END 
     CLOSE tpred
     DEALLOCATE tpred

     DECLARE tsucc CURSOR FOR select task_pred_id from taskpred where pred_task_id = @ptask_id and delete_session_id is null order by task_pred_id
     OPEN tsucc
     FETCH NEXT FROM tsucc INTO @vOldId
     WHILE (@@FETCH_STATUS = 0)
     BEGIN
       exec pc_get_next_key 'taskpred_task_pred_id', @vid OUTPUT

          insert into taskpred
            (task_pred_id,
             task_id,
             pred_task_id,
             proj_id,
             pred_proj_id,
             pred_type,
             lag_hr_cnt,
			 comments)
          select
             @vid,
             task_id,
             @v_new_task_id,
             proj_id,
             @vproj_id_to,
             pred_type,
             lag_hr_cnt,
			 comments
		  from taskpred
		  where task_pred_id = @vOldId

       FETCH NEXT FROM tsucc INTO @vOldId
     END 
     CLOSE tsucc
     DEALLOCATE tsucc
    END

    if substring(@copy_bit,15,1)='1' and @vproj_id_to = @vproj_id_from 
    begin
     select @psession_id =@@SPID
		 set @v_datetime = getDate()

     insert into taskrisk (task_id, risk_id, proj_id)
     select @v_new_task_ID, risk_id, proj_id
     from taskrisk
     where task_id = @ptask_id;


     select @ids_count = count(*) FROM riskmit where proj_id = @vproj_id_to and task_id = @ptask_id;
     if @ids_count > 0 
     begin
		  exec getnextkeys 'riskmit_mitigation_id', @ids_count, @v_first_id OUTPUT

      insert into pkxref (system_id, context_name, pk1, old_pk1, add_date)
      select @psession_id, 'RISKMIT', ROW_NUMBER() OVER(ORDER BY create_date DESC) + @v_first_id - 1, mitigation_id, @v_datetime
      from riskmit
      where proj_id = @vproj_id_to and task_id = @ptask_id;

      insert into riskmit (MITIGATION_ID, ID, RESPONSE_ID, PROJ_ID, TASK_ID, NAME, START_DATE, FINISH_DATE,
        BASE_START_DATE, BASE_FINISH_DATE, REMAINING_COST, ACTUAL_COST, BUDGET_COST, STATUS)
      select  x.pk1, id, response_id, proj_id, @v_new_task_id, name, start_date, finish_date,
        base_start_date, base_finish_date, remaining_cost, actual_cost, budget_cost, status
      from riskmit m, pkxref x
      where m.mitigation_id = x.old_pk1 and m.proj_id = @vproj_id_to and x.system_id = @psession_id and x.context_name = 'RISKMIT';

      insert into riskmitimp ( MITIGATION_ID, SCORETYPE_ID, PROJ_ID, THRESHOLD_ID)
      select x.pk1, i.scoretype_id, i.proj_id, i.threshold_id 
      from riskmitimp i, pkxref x
      where i.mitigation_id = x.old_pk1 and i.proj_id = @vproj_id_to and x.system_id = @psession_id and x.context_name = 'RISKMIT';
    
      delete from pkxref where system_id = @psession_id and (context_name='RISK' or context_name='RISKMIT' or context_name='RISKRSPPLN');                   
     end
    end

-- Copy UDF
    exec pc_insert_udf 'task', @ptask_id,  @v_new_task_id, @vproj_id_to
       
    set @pret_val =  @v_new_task_id
go
--METADATA NAME:ACTIVITY_COPY_API TYPE:GRANT TABLE_NAME:ACTIVITY_COPY_API CHANGE:CREATE
GRANT EXECUTE ON ACTIVITY_COPY_API TO ${pm.ss.privileged_user}
go
print 'Creating procedure SYNC_BASELINE_TASKS'

--METADATA  TYPE:SSCR NAME:SYNC_BASELINE_TASKS OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'SYNC_BASELINE_TASKS' and type in ('P'))
  DROP PROCEDURE SYNC_BASELINE_TASKS
go
--METADATA NAME:SYNC_BASELINE_TASKS TYPE:PROCEDURE SET:SYNC_BASELINE_TASKS CHANGE:CREATE
CREATE PROCEDURE SYNC_BASELINE_TASKS
(@psession_id INTEGER,@pproj_id  INTEGER,@pret_val INTEGER  OUTPUT,@pret_msg  VARCHAR(4000)  OUTPUT)
WITH ENCRYPTION AS
  DECLARE  @baseproj_id INT
  DECLARE  @old_str VARCHAR(40)
  DECLARE  @new_str VARCHAR(40)
  DECLARE  @rowcnt INT
  DECLARE basecur CURSOR  FOR
  SELECT proj_id
  FROM   project
  WHERE  orig_proj_id = @pproj_id;

  OPEN basecur
  FETCH  basecur
  INTO @baseproj_id
  WHILE (@@FETCH_STATUS = 0)
    BEGIN
      PRINT @baseproj_id
      SELECT @rowcnt = Count(* )
      FROM   pkxref
      WHERE  new_str IN (SELECT task_code
                         FROM   task
                         WHERE  proj_id = @baseproj_id
                         EXCEPT 
                         SELECT old_str
                         FROM   pkxref
                         WHERE  system_id = @psession_id
                                AND pk1 = @pproj_id
                                AND context_name = 'syncbaselines')
             AND system_id = @psession_id
             AND pk1 = @pproj_id;
 
     
      IF @rowcnt = 0
        BEGIN
          DECLARE taskcur CURSOR  FOR
          SELECT old_str,
                 new_str
          FROM   pkxref
          WHERE  pk1 = @pproj_id
                 AND system_id = @psession_id
                 AND context_name = 'syncbaselines' order by new_str desc;
          
          BEGIN TRANSACTION
          OPEN taskcur
          FETCH  taskcur
          INTO @old_str,
               @new_str
    
          WHILE (@@FETCH_STATUS = 0)
            BEGIN
              UPDATE task
              SET    task_code = @new_str
              WHERE  proj_id = @baseproj_id
                     AND task_code = @old_str
              FETCH  taskcur
              INTO @old_str,
                   @new_str
            END
           CLOSE taskcur
          DEALLOCATE taskcur
           COMMIT TRANSACTION
        END
      ELSE
        BEGIN
          IF @pret_msg IS NULL
            SET @pret_msg = Ltrim(Str(@baseproj_id))
          ELSE
            SET @pret_msg = @pret_msg + ',' + Ltrim(Str(@baseproj_id))
        END
      
      FETCH  basecur
      INTO @baseproj_id
    END
  
  CLOSE basecur
  DEALLOCATE basecur
  
  IF (Len(@pret_msg) > 0)
    BEGIN
      SET @pret_val = -1;
       RETURN;
    END
  
  SET @pret_val = 0
  SET @pret_msg = 'Task Codes updated successfully'
go
--METADATA NAME:SYNC_BASELINE_TASKS TYPE:GRANT TABLE_NAME:SYNC_BASELINE_TASKS CHANGE:CREATE
GRANT EXECUTE ON SYNC_BASELINE_TASKS TO ${pm.ss.privileged_user}
go
print 'Creating procedure OBS_MERGE_DELETE'

--METADATA  TYPE:SSCR NAME:OBS_MERGE_DELETE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OBS_MERGE_DELETE' and type in ('P'))
  DROP PROCEDURE OBS_MERGE_DELETE
go
--METADATA NAME:OBS_MERGE_DELETE TYPE:PROCEDURE SET:OBS_MERGE_DELETE CHANGE:CREATE
CREATE PROCEDURE OBS_MERGE_DELETE
(@obs_id int, @pret_val int OUTPUT, @pret_msg varchar(1000) OUTPUT )
WITH ENCRYPTION AS 
   SET NOCOUNT on
   declare @parent_obs_id int, @i int, @cid int
   declare @obs_hierarchy TABLE (pid int, cid int, hl int)
   set @pret_val = 0
   set @pret_msg = ''
   if NOT exists (select 1 from obs where obs_id = @obs_id)
   begin  
     --set @pret_msg = 'obs_id ' + cast(@obs_id as varchar(10))+ ' does not exist'
     set @pret_msg = 'fail_not_found'
     return (@pret_val)
   end
   if NOT exists (select 1 from obs where obs_id = @obs_id and parent_obs_id is not null)
   begin  
     --set @pret_msg = 'cannot delete the root obs_id ' + cast(@obs_id as varchar(10))
     set @pret_msg = 'fail_root_obs'
     return (@pret_val)
   end
   select @parent_obs_id = parent_obs_id from obs where obs_id = @obs_id
   insert into @obs_hierarchy (pid, cid, hl) values (@parent_obs_id, @obs_id, 0) 
   set @i = 1
   while (@i > 0)
 begin
  insert into @obs_hierarchy (pid, cid, hl)
  select o.parent_obs_id, o.obs_id, @i
  from obs o inner join @obs_hierarchy h on o.parent_obs_id = h.cid
  where hl = @i - 1
  if @@rowcount > 0
   set @i = @i + 1
  else
   set @i = -1
  if @i > 1000
  begin  
   --set @pret_msg = 'circular relation may exist in obs hierarchy'
      set @pret_msg = 'fail_circular_relation'
   return (@pret_val)
  end
 end
-- check if any project is checked out
   if exists (select 1 from project p inner join projwbs w on p.proj_id = w.proj_id inner join @obs_hierarchy o on o.cid = w.obs_id where p.checkout_flag = 'Y')
   begin   
     --set @pret_msg = 'cannot delete obs_id ' + cast(@obs_id as varchar(10)) + ', because there''s project(s) checked out'
     set @pret_msg = 'fail_checked_out'
     return (@pret_val) 
   end
-- check if any project is open in exclusive mode
   if exists (select 1 from projshar p inner join projwbs w on p.proj_id = w.proj_id inner join @obs_hierarchy o on o.cid = w.obs_id where p.access_level = 2)
   begin   
     --set @pret_msg = 'cannot delete obs_id ' + cast(@obs_id as varchar(10)) + ', because there''s project(s) open in exclusive mode'
     set @pret_msg = 'fail_exclusive_open'
     return (@pret_val) 
   end
 UPDATE PROJISSU SET obs_id = @parent_obs_id WHERE obs_id in (select cid from @obs_hierarchy)
 UPDATE PROJTHRS SET obs_id = @parent_obs_id WHERE obs_id in (select cid from @obs_hierarchy)
 UPDATE PROJWBS SET obs_id = @parent_obs_id WHERE obs_id in (select cid from @obs_hierarchy)
-- cursor to delete every obs
 declare cur_obs_id cursor for select cid from @obs_hierarchy order by hl desc
 open cur_obs_id
 FETCH NEXT FROM cur_obs_id INTO @cid
 WHILE @@FETCH_STATUS = 0
 BEGIN
  -- PRINT @cid
  exec CASCADE_DELETE 'OBS', @cid, @pret_val output, @pret_msg output, NULL, NULL, NULL
  FETCH NEXT FROM cur_obs_id INTO @cid
 END
 CLOSE cur_obs_id
 DEALLOCATE cur_obs_id
go
--METADATA NAME:OBS_MERGE_DELETE TYPE:GRANT TABLE_NAME:OBS_MERGE_DELETE CHANGE:CREATE
GRANT EXECUTE ON OBS_MERGE_DELETE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CREATE_PROJECT_TEMPLATE'

--METADATA  TYPE:SSCR NAME:CREATE_PROJECT_TEMPLATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CREATE_PROJECT_TEMPLATE' and type in ('P'))
  DROP PROCEDURE CREATE_PROJECT_TEMPLATE
go
--METADATA NAME:CREATE_PROJECT_TEMPLATE TYPE:PROCEDURE SET:PROJECT_TEMPLATE CHANGE:CREATE
CREATE PROCEDURE CREATE_PROJECT_TEMPLATE
 	@pproj_id	integer,
 	@dest_wbs_id	integer,
 	@copy_bit	varchar(40),
 	@pret_val	integer OUTPUT,
 	@pret_msg	varchar(4000) OUTPUT,
 	@psession_id	integer = null
WITH ENCRYPTION AS
 declare  @vcopy_bit        varchar(40),@default_copy_bit varchar(28),@proj_list varchar(2000) 
set @vcopy_bit=0
set @default_copy_bit= '1011011111111111110011000010'
if @pproj_id is NULL 
  begin
     set @pret_val = -1;
     set @pret_msg = 'Must specify source project to copy'
     return;
   end
  if @copy_bit is null 
       set @vcopy_bit = @default_copy_bit
  else
   begin
     set @vcopy_bit = substring(@copy_bit,1,28) + '0' + '0';
     if substring(@vcopy_bit, 27, 1) <> '1'
     begin
       set @pret_val = -1;
       set @pret_msg = 'Can not Create Project Template'
       return	
     end 
    if substring(@vcopy_bit, 19, 1) = '1' or substring(@vcopy_bit,23,1)='1' or substring(@vcopy_bit,24,1)= '1'
     begin
       set @pret_val = -1;
       set @pret_msg = 'Can not Create Project Template when baseline option is selected';
       return
     end 	
   end  
   set @proj_list=str(@pproj_id)
   exec multi_project_copy @proj_list,@dest_wbs_id,@vcopy_bit,@pret_val output ,@pret_msg output,null,@psession_id,null
   if @pret_val <= 0
   begin
    set @pret_msg = 'Error in Creating project template'
     return
   end  
   else
    select @pret_val=wbs_id from projwbs where proj_id=@pret_val and proj_node_flag='Y'
    set @pret_msg = 'Success'
go
--METADATA NAME:CREATE_PROJECT_TEMPLATE TYPE:GRANT TABLE_NAME:CREATE_PROJECT_TEMPLATE CHANGE:CREATE
GRANT EXECUTE ON CREATE_PROJECT_TEMPLATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CREATE_PROJECT_FROM_TEMPLATE'

--METADATA  TYPE:SSCR NAME:CREATE_PROJECT_FROM_TEMPLATE OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CREATE_PROJECT_FROM_TEMPLATE' and type in ('P'))
  DROP PROCEDURE CREATE_PROJECT_FROM_TEMPLATE
go
--METADATA NAME:CREATE_PROJECT_FROM_TEMPLATE TYPE:PROCEDURE SET:PROJECT_TEMPLATE CHANGE:CREATE
CREATE PROCEDURE CREATE_PROJECT_FROM_TEMPLATE
 	@pproj_id	integer,
  	@dest_wbs_id	integer,
 	@iswbs	 	varchar(1),
  	@copy_bit	varchar(40),
  	@pret_val	integer OUTPUT,
  	@pret_msg	varchar(4000) OUTPUT,
  	@psession_id	integer = null
 as
  declare  @vcopy_bit        varchar(40),@default_copy_bit varchar(30),@proj_list varchar(2000),@max_wbs_id integer,@vret integer,@vwbs_status varchar(20) 
 set @vcopy_bit=0
 set @default_copy_bit= '1111111111111111110011000000'

 if @pproj_id is NULL 
   begin
      set @pret_val = -1;
      set @pret_msg = 'Must Specify Source Project To Copy'
      return;
    end
   if @copy_bit is null 
        set @vcopy_bit = @default_copy_bit
   else
    begin
      set @vcopy_bit = @copy_bit;
      if substring(@vcopy_bit, 27, 1) <> '0'
      begin
        set @pret_val = -1;
        set @pret_msg = 'Can not Create Project From Template'
        return
      end 
      if substring(@vcopy_bit, 19, 1) = '1' or substring(@vcopy_bit,23,1)='1' or substring(@vcopy_bit,24,1)= '1'
      begin
        set @pret_val = -1;
        set @pret_msg = 'Can not Create Project From Template when baseline option is selected';
        return
      end
    end  
    set @proj_list=str(@pproj_id)
      if isnull(@iswbs,'N')='N'
      begin
      	set @vcopy_bit=substring(@vcopy_bit,1,28)+ '0' + '1'
        exec multi_project_copy @proj_list,@dest_wbs_id,@vcopy_bit,@pret_val output ,@pret_msg output,null,@psession_id,null

        update project set batch_sum_flag='Y' where proj_id=@pret_val	
      end
    else  
      begin
 	set @vcopy_bit=@vcopy_bit  + '1' + '1'
    select @vwbs_status=status_code  from projwbs where wbs_id=@pproj_id
    if @pproj_id = @dest_wbs_id
    begin
       return
    end 
    
    if (@vwbs_status='WS_Template') 
    begin 
 	if exists (SELECT name FROM tempdb..sysobjects  WHERE name = '##DocID' AND type = 'U')
 		delete from ##DocId   where system_id = @@spid
 	else
 		create table ##DocID ( system_id integer,old_doc_id int, new_doc_id int ) 
 	if exists (SELECT name FROM tempdb..sysobjects  WHERE name = '##ProjthrsID' AND type = 'U')
 		delete from ##ProjthrsId   where system_id = @@spid
 	else
 		 create table ##ProjthrsID ( system_id integer,old_thresh_id int, new_thresh_id int )
         select @max_wbs_id= max(wbs_id)  from projwbs   where delete_session_id is null 
         select @pproj_id=proj_id from projwbs where wbs_id=@dest_wbs_id
         begin transaction
          exec pc_process_level @proj_list, @dest_wbs_id, 0,@dest_wbs_id, @pproj_id, @vcopy_bit,@max_wbs_id,@pret_val output, @pret_msg output, null ,null,@psession_id,null,@iswbs
          delete from pkxref
          where system_id = @psession_id
            and (context_name = 'RISK' or context_name = 'RISKRSPPLN' or context_name = 'RISKMIT')
         if substring(@vcopy_bit,18,1)='1'  
 				 exec pc_taskpred_copy @@SPID, @vcopy_bit, @vret output, @pret_msg output
 	    if @vret <> 0 
 		 begin
 			set @pret_msg = 'pc_taskpred copy failed|' + @pret_msg
 			rollback transaction
 	      	return
 		 end
 	       delete from pkxref where system_id=@@SPID and context_name = 'T'
         commit transaction  
     end
    else
     begin 
	   set @pret_val=-1
       set @pret_msg = 'Selected WBS is not a template'
      return
	end 
  end   
    if @pret_val <= 0
    begin
     set @pret_msg = 'Error in Creating Project From Template'
      return
    end  
    else
     begin
      set @pret_msg = 'Success'
      select  @pret_val=pk1 from pkxref where system_id=@psession_id and context_name='PWBSID' and pk2=0
     end
go
--METADATA NAME:CREATE_PROJECT_FROM_TEMPLATE TYPE:GRANT TABLE_NAME:CREATE_PROJECT_FROM_TEMPLATE CHANGE:CREATE
GRANT EXECUTE ON CREATE_PROJECT_FROM_TEMPLATE TO ${pm.ss.privileged_user}
go
print 'Creating procedure CHECK_DB_SIZE_LIMIT'

--METADATA  TYPE:SSCR NAME:CHECK_DB_SIZE_LIMIT OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'CHECK_DB_SIZE_LIMIT' and type in ('P'))
  DROP PROCEDURE CHECK_DB_SIZE_LIMIT
go
--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:PROCEDURE SET:CHECKDB_SIZE CHANGE:CREATE
CREATE PROCEDURE CHECK_DB_SIZE_LIMIT
@pret_val integer OUTPUT,@pret_msg VARCHAR(2000) OUTPUT , @Percent_Reached decimal(10,2) OUTPUT 
WITH ENCRYPTION AS
  declare @SQL_Server_Version varchar(50);
  --declare @SQL_Server_Edition varchar(50);
 -- declare @SQL_Server_Name varchar(50);
  declare @Maximum_Database_Size_MB integer;
  declare @Data_Size_MB decimal(10,2);
  declare @Engine_edition varchar(50);
 -- declare @edition varchar(50)
begin  
    SELECT @pret_val = 0;
    SELECT @Percent_Reached = -1;
     
	SELECT  @Engine_edition =CONVERT(varchar, SERVERPROPERTY('EngineEdition'));
	 
	if @Engine_edition <> 4  
	  return; -- Exit if not  express edition
	  
	 SELECT @SQL_Server_Version =SUBSTRING(@@VERSION, 0, CHARINDEX('-', @@VERSION) - 1),
		-- @SQL_Server_Edition = CONVERT(VARCHAR , serverproperty('Edition')),
		-- @Engine_edition =CONVERT(varchar, SERVERPROPERTY('EngineEdition')),
		 --@edition = CONVERT(varchar,SERVERPROPERTY('Edition')),
	   --@SQL_Server_Name =CONVERT(VARCHAR ,serverproperty('ServerName')),
		 @Maximum_Database_Size_MB = CASE WHEN @SQL_Server_Version LIKE '%2012%' THEN 10*1024
										  WHEN @SQL_Server_Version LIKE '%2008 R2%' THEN 10*1024
										  WHEN @SQL_Server_Version LIKE '%2008%' THEN 4*1024
										  WHEN @SQL_Server_Version LIKE '%2005%' THEN 4*1024
										  ELSE -1
									 END,
		 @Data_Size_MB = convert(decimal(12,2),round(fileproperty(a.name,'SpaceUsed')/128.000,2))
						FROM  sys.sysfiles a WHERE  a.name not like '%_log';	 

    SELECT @Percent_Reached = (@Data_Size_MB/@Maximum_Database_Size_MB)*100;
    if @Percent_Reached > 80 
       SELECT @pret_val = 1

 end
 go

GRANT EXECUTE ON CHECK_DB_SIZE_LIMIT TO ${pm.ss.privileged_user}
go
--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:GRANT TABLE_NAME:CHECK_DB_SIZE_LIMIT CHANGE:CREATE
GRANT EXECUTE ON CHECK_DB_SIZE_LIMIT TO ${pm.ss.privileged_user}
go
print 'Creating view PROJRSRC_VIEW'

--METADATA  TYPE:SSCR NAME:PROJRSRC_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJRSRC_VIEW' and type in ('V'))
  DROP VIEW PROJRSRC_VIEW
go
--METADATA NAME:PROJRSRC_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJRSRC_VIEW
( rsrc_id, proj_id ) as
SELECT tk.rsrc_id, tk.proj_id
FROM task tk
WHERE tk.rsrc_ID IS NOT NULL
UNION 
SELECT tr.rsrc_id, tr.proj_id
FROM taskrsrc tr
WHERE tr.rsrc_ID IS NOT NULL 
UNION
SELECT pe.rsrc_id, pe.proj_id
FROM projest pe
WHERE pe.rsrc_ID IS NOT NULL 
UNION
SELECT ps.rsrc_id, ps.proj_id
FROM projissu ps
WHERE ps.rsrc_ID IS NOT NULL 
UNION
SELECT wr.rsrc_id, wr.proj_id
FROM wbsrsrc wr
WHERE wr.rsrc_ID IS NOT NULL 

go
--METADATA NAME:PROJRSRC_VIEW TYPE:GRANT TABLE_NAME:PROJRSRC_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRC_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJROLE_VIEW'

--METADATA  TYPE:SSCR NAME:PROJROLE_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJROLE_VIEW' and type in ('V'))
  DROP VIEW PROJROLE_VIEW
go
--METADATA NAME:PROJROLE_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJROLE_VIEW
( role_id, proj_id ) as
SELECT tr.role_id, tr.proj_id
FROM taskrsrc tr
WHERE tr.role_id IS NOT NULL
UNION 
SELECT r.role_id, pr.proj_id
FROM projrsrc_view  pr, rsrc r
WHERE r.role_id IS NOT NULL 
AND r.rsrc_id = pr.rsrc_id
UNION
SELECT  r.role_id, pr.proj_id
FROM projrsrc_view pr,  rsrcrole r
WHERE r.role_id IS NOT NULL 
AND r.rsrc_id = pr.rsrc_id
go
--METADATA NAME:PROJROLE_VIEW TYPE:GRANT TABLE_NAME:PROJROLE_VIEW CHANGE:CREATE
GRANT SELECT ON PROJROLE_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJRSRCROLE_VIEW'

--METADATA  TYPE:SSCR NAME:PROJRSRCROLE_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJRSRCROLE_VIEW' and type in ('V'))
  DROP VIEW PROJRSRCROLE_VIEW
go
--METADATA NAME:PROJRSRCROLE_VIEW TYPE:VIEW SET:DL_BASE_VIEWS CHANGE:CREATE
CREATE VIEW PROJRSRCROLE_VIEW
( rsrc_id, role_id, proj_id ) as
SELECT rr.rsrc_id, rr.role_id, pro.proj_id
FROM projrole_view pro,  rsrcrole rr
WHERE  rr.role_id = pro.role_id
UNION 
SELECT  rr.rsrc_id, rr.role_id, pr.proj_id
FROM projrsrc_view pr, rsrcrole rr
WHERE rr.rsrc_id = pr.rsrc_id
go
--METADATA NAME:PROJRSRCROLE_VIEW TYPE:GRANT TABLE_NAME:PROJRSRCROLE_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRCROLE_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJSHAR_BL_VIEW'

--METADATA  TYPE:SSCR NAME:PROJSHAR_BL_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJSHAR_BL_VIEW' and type in ('V'))
  DROP VIEW PROJSHAR_BL_VIEW
go
--METADATA NAME:PROJSHAR_BL_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE VIEW PROJSHAR_BL_VIEW
as
select ps.proj_id, session_id, access_level, load_status
from  project p, projshar ps
where ps.proj_id = p.proj_id
union
select p.proj_id, session_id, access_level, load_status
from  project p, projshar ps
where ps.proj_id = p.orig_proj_id

go
--METADATA NAME:PROJSHAR_BL_VIEW TYPE:GRANT TABLE_NAME:PROJSHAR_BL_VIEW CHANGE:CREATE
GRANT SELECT ON PROJSHAR_BL_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJRSRC_PS_VIEW'

--METADATA  TYPE:SSCR NAME:PROJRSRC_PS_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJRSRC_PS_VIEW' and type in ('V'))
  DROP VIEW PROJRSRC_PS_VIEW
go
--METADATA NAME:PROJRSRC_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE VIEW PROJRSRC_PS_VIEW
as
SELECT rsrc_id, ps.proj_id, ps.session_id, ps.load_status
FROM task tk, projshar ps
WHERE tk.rsrc_ID IS NOT NULL
and ps.proj_id = tk.proj_id
UNION
SELECT rsrc_id, ps.proj_id, ps.session_id, ps.load_status
FROM taskrsrc tr, projshar ps
WHERE tr.rsrc_id IS NOT NULL
and ps.proj_id = tr.proj_id
UNION
SELECT rsrc_id, ps.proj_id, ps.session_id, ps.load_status
FROM projest pe, projshar ps
WHERE ps.proj_id = pe.proj_id
UNION
SELECT rsrc_id, ps.proj_id, ps.session_id, ps.load_status
FROM projissu pi, projshar ps
WHERE ps.proj_id = pi.proj_id
UNION
SELECT rsrc_id, ps.proj_id, ps.session_id, ps.load_status
FROM wbsrsrc wr, projshar ps
WHERE ps.proj_id = wr.proj_id
go
--METADATA NAME:PROJRSRC_PS_VIEW TYPE:GRANT TABLE_NAME:PROJRSRC_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRC_PS_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJROLE_PS_VIEW'

--METADATA  TYPE:SSCR NAME:PROJROLE_PS_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJROLE_PS_VIEW' and type in ('V'))
  DROP VIEW PROJROLE_PS_VIEW
go
--METADATA NAME:PROJROLE_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE VIEW PROJROLE_PS_VIEW
AS
SELECT tr.role_id, tr.proj_id, ps.session_id, ps.load_status
FROM taskrsrc tr, projshar ps
WHERE tr.role_id IS NOT NULL 
and ps.proj_id = tr.proj_id
UNION 
SELECT r.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM projrsrc_ps_view pr,rsrc r
WHERE r.role_id IS NOT NULL
AND r.rsrc_id = pr.rsrc_id
UNION
SELECT rs.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM rsrcrole rs,  PROJRSRC_PS_VIEW pr
WHERE rs.role_id IS NOT NULL
and rs.rsrc_id = pr.rsrc_id
UNION
SELECT wr.role_id, ps.proj_id, ps.session_id, ps.load_status
FROM wbsrsrc wr, PROJSHAR ps
WHERE wr.role_id is NOT NULL
and ps.proj_id = wr.proj_id
go
--METADATA NAME:PROJROLE_PS_VIEW TYPE:GRANT TABLE_NAME:PROJROLE_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJROLE_PS_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PROJRSRCROLE_PS_VIEW'

--METADATA  TYPE:SSCR NAME:PROJRSRCROLE_PS_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PROJRSRCROLE_PS_VIEW' and type in ('V'))
  DROP VIEW PROJRSRCROLE_PS_VIEW
go
--METADATA NAME:PROJRSRCROLE_PS_VIEW TYPE:VIEW SET:DL_PS_VIEWS CHANGE:CREATE
CREATE VIEW PROJRSRCROLE_PS_VIEW
AS
SELECT rr.rsrc_id, rr.role_id, pro.proj_id, pro.session_id, pro.load_status
FROM projrole_ps_view pro, rsrcrole rr
WHERE rr.role_id = pro.role_id
UNION 
SELECT rr.rsrc_id, rr.role_id, pr.proj_id, pr.session_id, pr.load_status
FROM projrsrc_ps_view pr, rsrcrole rr
WHERE rr.rsrc_id = pr.rsrc_id
go
--METADATA NAME:PROJRSRCROLE_PS_VIEW TYPE:GRANT TABLE_NAME:PROJRSRCROLE_PS_VIEW CHANGE:CREATE
GRANT SELECT ON PROJRSRCROLE_PS_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PFLOAD_VIEW'

--METADATA  TYPE:SSCR NAME:PFLOAD_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PFLOAD_VIEW' and type in ('V'))
  DROP VIEW PFLOAD_VIEW
go
--METADATA NAME:PFLOAD_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE VIEW PFLOAD_VIEW
as
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from prpfolio prf, projwbs pw
where prf.wbs_id = pw.wbs_id
union
select 0, pw.wbs_id, pw.proj_id
from projwbs pw, project p
where pw.proj_node_flag = 'Y'
and pw.proj_id = p.proj_id
and p.project_flag ='N'
go
--METADATA NAME:PFLOAD_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PFLOAD_IP_VIEW'

--METADATA  TYPE:SSCR NAME:PFLOAD_IP_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PFLOAD_IP_VIEW' and type in ('V'))
  DROP VIEW PFLOAD_IP_VIEW
go
--METADATA NAME:PFLOAD_IP_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE VIEW PFLOAD_IP_VIEW
as
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from projwbs pw, prpfolio prf
where prf.wbs_id = pw.wbs_id
union
select prf.pfolio_id, pw.wbs_id, pw.proj_id
from projwbs pw, projwbs pw2, prpfolio prf
where pw2.wbs_id = prf.wbs_id
and pw.wbs_id = pw2.parent_wbs_id
go
--METADATA NAME:PFLOAD_IP_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_IP_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_IP_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PFLOAD_UACCESS_VIEW'

--METADATA  TYPE:SSCR NAME:PFLOAD_UACCESS_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PFLOAD_UACCESS_VIEW' and type in ('V'))
  DROP VIEW PFLOAD_UACCESS_VIEW
go
--METADATA NAME:PFLOAD_UACCESS_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE VIEW PFLOAD_UACCESS_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from prpfolio prf, projwbs pw, uaccess ua
where prf.wbs_id = pw.wbs_id
and pw.proj_id = ua.proj_id
union
select 0, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from projwbs pw, project p, uaccess ua
where pw.proj_node_flag = 'Y'
and pw.proj_id = p.proj_id
and p.project_flag ='N'
and pw.proj_id = ua.proj_id
go
--METADATA NAME:PFLOAD_UACCESS_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_UACCESS_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_UACCESS_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view PFLOAD_IP_UACCESS_VIEW'

--METADATA  TYPE:SSCR NAME:PFLOAD_IP_UACCESS_VIEW OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PFLOAD_IP_UACCESS_VIEW' and type in ('V'))
  DROP VIEW PFLOAD_IP_UACCESS_VIEW
go
--METADATA NAME:PFLOAD_IP_UACCESS_VIEW TYPE:VIEW SET:PFLOAD_VIEWS CHANGE:CREATE
CREATE VIEW PFLOAD_IP_UACCESS_VIEW
AS
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from projwbs pw, prpfolio prf, uaccess ua
where prf.wbs_id = pw.wbs_id
and pw.proj_id = ua.proj_id
union
select prf.pfolio_id, pw.wbs_id, pw.proj_id, ua.user_id, ua.access_flag
from 
projwbs pw, projwbs pw2, prpfolio prf, uaccess ua
where pw2.wbs_id = prf.wbs_id
and pw.wbs_id = pw2.parent_wbs_id
and pw.proj_id = ua.proj_id
go
--METADATA NAME:PFLOAD_IP_UACCESS_VIEW TYPE:GRANT TABLE_NAME:PFLOAD_IP_UACCESS_VIEW CHANGE:CREATE
GRANT SELECT ON PFLOAD_IP_UACCESS_VIEW TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_OBS'

--METADATA  TYPE:SSCR NAME:OPENING_OBS OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_OBS' and type in ('V'))
  DROP VIEW OPENING_OBS
go
--METADATA NAME:OPENING_OBS TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_OBS
AS
SELECT obs_id FROM dltobs WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_OBS TYPE:GRANT TABLE_NAME:OPENING_OBS CHANGE:CREATE
GRANT SELECT ON OPENING_OBS TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_ROLE'

--METADATA  TYPE:SSCR NAME:OPENING_ROLE OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_ROLE' and type in ('V'))
  DROP VIEW OPENING_ROLE
go
--METADATA NAME:OPENING_ROLE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_ROLE
AS
SELECT role_id FROM dltrole WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_ROLE TYPE:GRANT TABLE_NAME:OPENING_ROLE CHANGE:CREATE
GRANT SELECT ON OPENING_ROLE TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_ACCOUNT'

--METADATA  TYPE:SSCR NAME:OPENING_ACCOUNT OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_ACCOUNT' and type in ('V'))
  DROP VIEW OPENING_ACCOUNT
go
--METADATA NAME:OPENING_ACCOUNT TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_ACCOUNT
AS
SELECT acct_id FROM dltacct WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_ACCOUNT TYPE:GRANT TABLE_NAME:OPENING_ACCOUNT CHANGE:CREATE
GRANT SELECT ON OPENING_ACCOUNT TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_USERS'

--METADATA  TYPE:SSCR NAME:OPENING_USERS OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_USERS' and type in ('V'))
  DROP VIEW OPENING_USERS
go
--METADATA NAME:OPENING_USERS TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_USERS
AS
SELECT user_id FROM dltuser WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_USERS TYPE:GRANT TABLE_NAME:OPENING_USERS CHANGE:CREATE
GRANT SELECT ON OPENING_USERS TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_RSRC'

--METADATA  TYPE:SSCR NAME:OPENING_RSRC OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_RSRC' and type in ('V'))
  DROP VIEW OPENING_RSRC
go
--METADATA NAME:OPENING_RSRC TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_RSRC
AS
SELECT rsrc_id FROM dltrsrc WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_RSRC TYPE:GRANT TABLE_NAME:OPENING_RSRC CHANGE:CREATE
GRANT SELECT ON OPENING_RSRC TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_ACTVCODE'

--METADATA  TYPE:SSCR NAME:OPENING_ACTVCODE OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_ACTVCODE' and type in ('V'))
  DROP VIEW OPENING_ACTVCODE
go
--METADATA NAME:OPENING_ACTVCODE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_ACTVCODE
AS
SELECT actv_code_id, parent_actv_code_id FROM dltactv WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_ACTVCODE TYPE:GRANT TABLE_NAME:OPENING_ACTVCODE CHANGE:CREATE
GRANT SELECT ON OPENING_ACTVCODE TO ${pm.ss.privileged_user}
go
print 'Creating view OPENING_RSRCROLE'

--METADATA  TYPE:SSCR NAME:OPENING_RSRCROLE OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'OPENING_RSRCROLE' and type in ('V'))
  DROP VIEW OPENING_RSRCROLE
go
--METADATA NAME:OPENING_RSRCROLE TYPE:VIEW SET:DL_VIEWS CHANGE:CREATE
CREATE VIEW OPENING_RSRCROLE
AS
SELECT rsrc_id,role_id FROM dltrsrl WHERE session_id = dbo.current_session('SESSIONID')
go
--METADATA NAME:OPENING_RSRCROLE TYPE:GRANT TABLE_NAME:OPENING_RSRCROLE CHANGE:CREATE
GRANT SELECT ON OPENING_RSRCROLE TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJ_BY_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJ_BY_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJ_BY_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_WEEK
as 
select a.proj_id, b.week_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, b.week_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJ_BY_MONTH'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJ_BY_MONTH' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJ_BY_MONTH
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_MONTH
as 
select a.proj_id, b.month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null 
group by a.proj_id, b.month_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_MONTH TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJ_BY_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJ_BY_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJ_BY_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_QTR
as 
select a.proj_id, dbo.get_first_day_of_quarter(month_start) qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id,dbo.get_first_day_of_quarter(month_start) 
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJ_BY_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJ_BY_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJ_BY_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJ_BY_YEAR
as 
select a.proj_id, 
cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))   ) as datetime) year , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJ_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJ_BY_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_RSRC_BY_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_RSRC_BY_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_RSRC_BY_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_WEEK
as 
select a.rsrc_id, b.week_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null 
group by a.rsrc_id, b.week_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_RSRC_BY_MONTH'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_RSRC_BY_MONTH' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_RSRC_BY_MONTH
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_MONTH
as 
select a.rsrc_id, b.month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null 
group by a.rsrc_id, b.month_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_MONTH TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_RSRC_BY_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_RSRC_BY_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_RSRC_BY_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_QTR
as 
select a.rsrc_id, dbo.get_first_day_of_quarter(month_start) qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.rsrc_id,dbo.get_first_day_of_quarter(month_start) 
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_RSRC_BY_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_RSRC_BY_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_RSRC_BY_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_RSRC_BY_YEAR
as 
select a.rsrc_id, 
cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))   ) as datetime) year , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.rsrc_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_RSRC_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_RSRC_BY_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_ROLE_BY_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_ROLE_BY_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_ROLE_BY_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_WEEK
as 
select a.role_id, b.week_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.role_id, b.week_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_ROLE_BY_MONTH'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_ROLE_BY_MONTH' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_ROLE_BY_MONTH
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_MONTH
as 
select a.role_id, b.month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.role_id, b.month_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_MONTH CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_MONTH TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_ROLE_BY_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_ROLE_BY_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_ROLE_BY_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_QTR
as 
select a.role_id, dbo.get_first_day_of_quarter(month_start) qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.role_id,dbo.get_first_day_of_quarter(month_start) 
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_ROLE_BY_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_ROLE_BY_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_ROLE_BY_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_ROLE_BY_YEAR
as 
select a.role_id, 
cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))   ) as datetime) year , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.role_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_ROLE_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_ROLE_BY_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJRSRC_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJRSRC_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJRSRC_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_WEEK
(PROJ_ID, RSRC_ID, WEEK_START, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.rsrc_id, b.week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id,  a.rsrc_id, b.week_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJRSRC_MON'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJRSRC_MON' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJRSRC_MON
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_MON
(PROJ_ID, RSRC_ID, MONTH_START, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.rsrc_id, b.month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, a.rsrc_id, b.month_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_MON TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJRSRC_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJRSRC_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJRSRC_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_QTR
(PROJ_ID, RSRC_ID,QTR, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.rsrc_id, dbo.get_first_day_of_quarter(month_start) 
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id,  a.rsrc_id, dbo.get_first_day_of_quarter(month_start)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJRSRC_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJRSRC_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJRSRC_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJRSRC_YEAR
(PROJ_ID, RSRC_ID, YEAR, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.rsrc_id,cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime) year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  proj_id,  rsrc_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJRSRC_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJRSRC_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJROLE_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJROLE_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJROLE_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJROLE_WEEK
(PROJ_ID, ROLE_ID, WEEK_START, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.role_id, b.week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id,  a.role_id, b.week_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJROLE_MON'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJROLE_MON' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJROLE_MON
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJROLE_MON
(PROJ_ID, ROLE_ID, MONTH_START, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.role_id, b.month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, a.role_id, b.month_start
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_MON TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJROLE_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJROLE_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJROLE_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJROLE_QTR
(PROJ_ID, ROLE_ID, QTR, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.role_id, dbo.get_first_day_of_quarter(month_start) 
qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, a.role_id, dbo.get_first_day_of_quarter(month_start)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_BY_PROJROLE_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_BY_PROJROLE_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_BY_PROJROLE_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_BY_PROJROLE_YEAR
(PROJ_ID, ROLE_ID, YEAR, PROJECT_SUMM_QTY)
AS 
select a.proj_id, a.role_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime) Year,
sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by  a.proj_id,  a.role_id, cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_BY_PROJROLE_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_BY_PROJROLE_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_SUMMARY_BY_MON'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_SUMMARY_BY_MON' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_SUMMARY_BY_MON
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_SUMMARY_BY_MON
as 
select proj_id, rsrc_id, role_id,  month_start, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id, role_id, month_start
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_MON CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_MON TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_SUMMARY_BY_QTR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_SUMMARY_BY_QTR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_SUMMARY_BY_QTR
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_SUMMARY_BY_QTR
as 
select a.proj_id, rsrc_id, role_id, dbo.get_first_day_of_quarter(month_start) qtr, sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, rsrc_id, role_id, dbo.get_first_day_of_quarter(month_start)
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_QTR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_QTR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_SUMMARY_BY_WEEK'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_SUMMARY_BY_WEEK' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_SUMMARY_BY_WEEK
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_SUMMARY_BY_WEEK
as 
select proj_id, rsrc_id, role_id,  week_start , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b 
where a.wbsrsrc_id = b.wbsrsrc_id
and a.delete_session_id is null and b.delete_session_id is null
group by proj_id, rsrc_id,  role_id, week_start
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_WEEK CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_WEEK TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSGN_SUMMARY_BY_YEAR'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSGN_SUMMARY_BY_YEAR' and type in ('V'))
  DROP VIEW WBSRSRC_ASSGN_SUMMARY_BY_YEAR
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR TYPE:VIEW SET:WBSRSRC_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSGN_SUMMARY_BY_YEAR
as 
select a.proj_id, rsrc_id, role_id,
cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))   ) as datetime) year , sum(qty) project_summ_qty
from wbsrsrc a, wbsrsrc_qty b where a.wbsrsrc_id = b.wbsrsrc_id 
and a.delete_session_id is null and b.delete_session_id is null
group by a.proj_id, rsrc_id, role_id,  cast(('01-01-' + cast(DATEPART (yy, month_start) as varchar(4))) as datetime)
go
--METADATA NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR TYPE:GRANT TABLE_NAME:WBSRSRC_ASSGN_SUMMARY_BY_YEAR CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSGN_SUMMARY_BY_YEAR TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSN_BY_PROJ_BY_FP'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSN_BY_PROJ_BY_FP' and type in ('V'))
  DROP VIEW WBSRSRC_ASSN_BY_PROJ_BY_FP
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSN_BY_PROJ_BY_FP
as 
SELECT proj_id, fin_dates_id, SUM(proj_summ_qty) AS proj_summ_qty
FROM  (SELECT r.proj_id, q.fin_dates_id1 AS fin_dates_id, q.fin_qty1 AS proj_summ_qty
       FROM WBSRSRC_QTY AS q INNER JOIN
            WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            PROJECT AS p ON r.proj_id = p.proj_id
       WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
       UNION ALL
       SELECT r.proj_id, q.fin_dates_id2 AS fin_dates_id, q.fin_qty2 AS proj_summ_qty
       FROM WBSRSRC_QTY AS q INNER JOIN
            WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            PROJECT AS p ON r.proj_id = p.proj_id
       WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
       UNION ALL
       SELECT r.proj_id, f.fin_dates_id, q.qty AS proj_summ_qty
       FROM WBSRSRC_QTY AS q INNER JOIN
            WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            FINDATES AS f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
            PROJECT AS p ON r.proj_id = p.proj_id
       WHERE (MONTH(q.month_start) = MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)
       UNION ALL       
       SELECT r.proj_id, f.fin_dates_id, q.qty AS proj_summ_qty
       FROM WBSRSRC_QTY AS q INNER JOIN
            WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
            FINDATES AS f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
            PROJECT AS p ON r.proj_id = p.proj_id
       WHERE (MONTH(q.month_start) <> MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) AS X
GROUP BY proj_id, fin_dates_id
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJ_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJ_BY_FP TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSN_BY_PROJROLE_BY_FP'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSN_BY_PROJROLE_BY_FP' and type in ('V'))
  DROP VIEW WBSRSRC_ASSN_BY_PROJROLE_BY_FP
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSN_BY_PROJROLE_BY_FP
as 
SELECT proj_id, role_id, fin_dates_id, SUM(proj_summ_qty) AS proj_summ_qty
FROM (SELECT r.proj_id, r.role_id, q.fin_dates_id1 AS fin_dates_id, q.fin_qty1 AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, q.fin_dates_id2 AS fin_dates_id, q.fin_qty2 AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) = MONTH(q.week_start)) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL) 
      UNION ALL
      SELECT r.proj_id, r.role_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) <> MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) AS X
GROUP BY proj_id, role_id, fin_dates_id
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJROLE_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJROLE_BY_FP TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSN_BY_PROJRSRC_BY_FP'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSN_BY_PROJRSRC_BY_FP' and type in ('V'))
  DROP VIEW WBSRSRC_ASSN_BY_PROJRSRC_BY_FP
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSN_BY_PROJRSRC_BY_FP
as 
SELECT proj_id, rsrc_id, fin_dates_id, SUM(proj_summ_qty) AS proj_summ_qty
FROM (SELECT r.proj_id, r.rsrc_id, q.fin_dates_id1 AS fin_dates_id, q.fin_qty1 AS proj_summ_qty
      FROM WBSRSRC AS r INNER JOIN
           WBSRSRC_QTY AS q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, q.fin_dates_id2 AS fin_dates_id, q.fin_qty2 AS proj_summ_qty
      FROM WBSRSRC AS r INNER JOIN
           WBSRSRC_QTY AS q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC AS r INNER JOIN
           WBSRSRC_QTY AS q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) = MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL) 
      UNION ALL
      SELECT r.proj_id, r.rsrc_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC AS r INNER JOIN
           WBSRSRC_QTY AS q ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) <> MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) AS X
GROUP BY proj_id, rsrc_id, fin_dates_id
go
--METADATA NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_BY_PROJRSRC_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_BY_PROJRSRC_BY_FP TO ${pm.ss.privileged_user}
go
print 'Creating view WBSRSRC_ASSN_SUMMARY_BY_FP'

--METADATA  TYPE:SSCR NAME:WBSRSRC_ASSN_SUMMARY_BY_FP OBJECT_TYPE:VIEW
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'WBSRSRC_ASSN_SUMMARY_BY_FP' and type in ('V'))
  DROP VIEW WBSRSRC_ASSN_SUMMARY_BY_FP
go
--METADATA NAME:WBSRSRC_ASSN_SUMMARY_BY_FP TYPE:VIEW SET:WBSRSRC_FIN_ROLLUP CHANGE:CREATE
CREATE VIEW WBSRSRC_ASSN_SUMMARY_BY_FP
as 
SELECT proj_id, role_id, rsrc_id, fin_dates_id, SUM(proj_summ_qty) AS proj_summ_qty
FROM (SELECT r.proj_id, r.role_id, r.rsrc_id, q.fin_dates_id1 AS fin_dates_id, q.fin_qty1 AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id1 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, q.fin_dates_id2 AS fin_dates_id, q.fin_qty2 AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (q.fin_dates_id2 IS NOT NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL)
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.week_start >= f.start_date AND q.week_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) = MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL) 
      UNION ALL
      SELECT r.proj_id, r.role_id, r.rsrc_id, f.fin_dates_id, q.qty AS proj_summ_qty
      FROM WBSRSRC_QTY AS q INNER JOIN
           WBSRSRC AS r ON q.wbsrsrc_id = r.wbsrsrc_id INNER JOIN
           FINDATES AS f ON q.month_start >= f.start_date AND q.month_start <= f.end_date INNER JOIN
           PROJECT AS p ON r.proj_id = p.proj_id
      WHERE (MONTH(q.month_start) <> MONTH(q.week_start)) AND (q.fin_dates_id1 IS NULL) AND (q.fin_dates_id2 IS NULL) AND (p.orig_proj_id IS NULL) AND (r.delete_session_id IS NULL) AND (q.delete_session_id IS NULL) AND (p.delete_session_id IS NULL) AND (f.delete_session_id IS NULL)) AS X
GROUP BY proj_id, role_id, rsrc_id, fin_dates_id
go
--METADATA NAME:WBSRSRC_ASSN_SUMMARY_BY_FP TYPE:GRANT TABLE_NAME:WBSRSRC_ASSN_SUMMARY_BY_FP CHANGE:CREATE
GRANT SELECT ON WBSRSRC_ASSN_SUMMARY_BY_FP TO ${pm.ss.privileged_user}
go
print 'Creating trigger PRMAUD_ACCOUNT'

--METADATA  TYPE:SSCR NAME:PRMAUD_ACCOUNT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ACCOUNT' and type in ('TR'))
  DROP TRIGGER PRMAUD_ACCOUNT
go
--METADATA NAME:PRMAUD_ACCOUNT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ACCOUNT
on ACCOUNT
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iacct_id varchar(255),@iacct_seq_num varchar(255),@iacct_short_name varchar(255),@iacct_name varchar(255),@iparent_acct_id varchar(255)
  declare @dacct_id varchar(255),@dacct_seq_num varchar(255),@dacct_short_name varchar(255),@dacct_name varchar(255),@dparent_acct_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(acct_id) and
			not update(acct_seq_num) and
			not update(acct_short_name) and
			not update(acct_name) and
			not update(parent_acct_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ACCOUNT', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACCOUNT',acct_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACCOUNT', acct_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select acct_id,acct_seq_num,acct_short_name,acct_name,parent_acct_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select acct_id,acct_seq_num,acct_short_name,acct_name,parent_acct_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iacct_id,@iacct_seq_num,@iacct_short_name,@iacct_name,@iparent_acct_id, @idelete_session_id
  else
    fetch deleted_c into @dacct_id,@dacct_seq_num,@dacct_short_name,@dacct_name,@dparent_acct_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dacct_id;
				

    end else begin
    	set @pk1 = @iacct_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dacct_id,@dacct_seq_num,@dacct_short_name,@dacct_name,@dparent_acct_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(acct_id)) exec audit_data 'ACCOUNT','acct_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dacct_id,@iacct_id,@audit_data OUTPUT
   if (@loper='D' or  update(acct_seq_num)) exec audit_data 'ACCOUNT','acct_seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dacct_seq_num,@iacct_seq_num,@audit_data OUTPUT
   if (@loper='D' or  update(acct_short_name)) exec audit_data 'ACCOUNT','acct_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dacct_short_name,@iacct_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(acct_name)) exec audit_data 'ACCOUNT','acct_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dacct_name,@iacct_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_acct_id)) exec audit_data 'ACCOUNT','parent_acct_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_acct_id,@iparent_acct_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ACCOUNT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ACCOUNT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iacct_id,@iacct_seq_num,@iacct_short_name,@iacct_name,@iparent_acct_id, @idelete_session_id;
    else
     fetch deleted_c into @dacct_id,@dacct_seq_num,@dacct_short_name,@dacct_name,@dparent_acct_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ACCOUNT_DEL'

--METADATA  TYPE:SSCR NAME:RT_ACCOUNT_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACCOUNT_DEL' and type in ('TR'))
  DROP TRIGGER RT_ACCOUNT_DEL
go
--METADATA NAME:RT_ACCOUNT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACCOUNT_DEL
on ACCOUNT
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ACCOUNT',acct_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ACCOUNT'

--METADATA  TYPE:SSCR NAME:RT_ACCOUNT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACCOUNT' and type in ('TR'))
  DROP TRIGGER RT_ACCOUNT
go
--METADATA NAME:RT_ACCOUNT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACCOUNT
on ACCOUNT
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ACCOUNT
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ACCOUNT.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ACCOUNT.create_date end
from ACCOUNT WITH (INDEX(pk_account)) join inserted 
on ACCOUNT.acct_id = inserted.acct_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ACCOUNT',acct_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select acct_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ACCOUNT'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ACTVCODE'

--METADATA  TYPE:SSCR NAME:PRMAUD_ACTVCODE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ACTVCODE' and type in ('TR'))
  DROP TRIGGER PRMAUD_ACTVCODE
go
--METADATA NAME:PRMAUD_ACTVCODE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ACTVCODE
on ACTVCODE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iactv_code_id varchar(255),@iactv_code_type_id varchar(255),@iseq_num varchar(255),@ishort_name varchar(255),@iparent_actv_code_id varchar(255),@iactv_code_name varchar(255),@icolor varchar(255)
  declare @dactv_code_id varchar(255),@dactv_code_type_id varchar(255),@dseq_num varchar(255),@dshort_name varchar(255),@dparent_actv_code_id varchar(255),@dactv_code_name varchar(255),@dcolor varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(actv_code_id) and
			not update(actv_code_type_id) and
			not update(seq_num) and
			not update(short_name) and
			not update(parent_actv_code_id) and
			not update(actv_code_name) and
			not update(color) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ACTVCODE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACTVCODE',actv_code_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACTVCODE', actv_code_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select actv_code_id,actv_code_type_id,seq_num,short_name,parent_actv_code_id,actv_code_name,color
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select actv_code_id,actv_code_type_id,seq_num,short_name,parent_actv_code_id,actv_code_name,color
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iactv_code_id,@iactv_code_type_id,@iseq_num,@ishort_name,@iparent_actv_code_id,@iactv_code_name,@icolor, @idelete_session_id
  else
    fetch deleted_c into @dactv_code_id,@dactv_code_type_id,@dseq_num,@dshort_name,@dparent_actv_code_id,@dactv_code_name,@dcolor, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dactv_code_id;
				

    end else begin
    	set @pk1 = @iactv_code_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dactv_code_id,@dactv_code_type_id,@dseq_num,@dshort_name,@dparent_actv_code_id,@dactv_code_name,@dcolor, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(actv_code_id)) exec audit_data 'ACTVCODE','actv_code_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_id,@iactv_code_id,@audit_data OUTPUT
   if (@loper='D' or  update(actv_code_type_id)) exec audit_data 'ACTVCODE','actv_code_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_type_id,@iactv_code_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'ACTVCODE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(short_name)) exec audit_data 'ACTVCODE','short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dshort_name,@ishort_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_actv_code_id)) exec audit_data 'ACTVCODE','parent_actv_code_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_actv_code_id,@iparent_actv_code_id,@audit_data OUTPUT
   if (@loper='D' or  update(actv_code_name)) exec audit_data 'ACTVCODE','actv_code_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_name,@iactv_code_name,@audit_data OUTPUT
   if (@loper='D' or  update(color)) exec audit_data 'ACTVCODE','color',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcolor,@icolor,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ACTVCODE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ACTVCODE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iactv_code_id,@iactv_code_type_id,@iseq_num,@ishort_name,@iparent_actv_code_id,@iactv_code_name,@icolor, @idelete_session_id;
    else
     fetch deleted_c into @dactv_code_id,@dactv_code_type_id,@dseq_num,@dshort_name,@dparent_actv_code_id,@dactv_code_name,@dcolor, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ACTVCODE_DEL'

--METADATA  TYPE:SSCR NAME:RT_ACTVCODE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACTVCODE_DEL' and type in ('TR'))
  DROP TRIGGER RT_ACTVCODE_DEL
go
--METADATA NAME:RT_ACTVCODE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACTVCODE_DEL
on ACTVCODE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ACTVCODE',actv_code_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ACTVCODE'

--METADATA  TYPE:SSCR NAME:RT_ACTVCODE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACTVCODE' and type in ('TR'))
  DROP TRIGGER RT_ACTVCODE
go
--METADATA NAME:RT_ACTVCODE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACTVCODE
on ACTVCODE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ACTVCODE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ACTVCODE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ACTVCODE.create_date end
from ACTVCODE WITH (INDEX(pk_actvcode)) join inserted 
on ACTVCODE.actv_code_id = inserted.actv_code_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ACTVCODE',actv_code_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select actv_code_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ACTVCODE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ACTVTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_ACTVTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ACTVTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_ACTVTYPE
go
--METADATA NAME:PRMAUD_ACTVTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ACTVTYPE
on ACTVTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iactv_code_type_id varchar(255),@iactv_short_len varchar(255),@iseq_num varchar(255),@iactv_code_type varchar(255),@iactv_code_type_scope varchar(255),@iproj_id varchar(255),@isuper_flag varchar(255)
  declare @dactv_code_type_id varchar(255),@dactv_short_len varchar(255),@dseq_num varchar(255),@dactv_code_type varchar(255),@dactv_code_type_scope varchar(255),@dproj_id varchar(255),@dsuper_flag varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(actv_code_type_id) and
			not update(actv_short_len) and
			not update(seq_num) and
			not update(actv_code_type) and
			not update(actv_code_type_scope) and
			not update(proj_id) and
			not update(super_flag) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ACTVTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACTVTYPE',actv_code_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ACTVTYPE', actv_code_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select actv_code_type_id,actv_short_len,seq_num,actv_code_type,actv_code_type_scope,proj_id,super_flag
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select actv_code_type_id,actv_short_len,seq_num,actv_code_type,actv_code_type_scope,proj_id,super_flag
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iactv_code_type_id,@iactv_short_len,@iseq_num,@iactv_code_type,@iactv_code_type_scope,@iproj_id,@isuper_flag, @idelete_session_id
  else
    fetch deleted_c into @dactv_code_type_id,@dactv_short_len,@dseq_num,@dactv_code_type,@dactv_code_type_scope,@dproj_id,@dsuper_flag, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dactv_code_type_id;
				

    end else begin
    	set @pk1 = @iactv_code_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dactv_code_type_id,@dactv_short_len,@dseq_num,@dactv_code_type,@dactv_code_type_scope,@dproj_id,@dsuper_flag, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(actv_code_type_id)) exec audit_data 'ACTVTYPE','actv_code_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_type_id,@iactv_code_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(actv_short_len)) exec audit_data 'ACTVTYPE','actv_short_len',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_short_len,@iactv_short_len,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'ACTVTYPE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(actv_code_type)) exec audit_data 'ACTVTYPE','actv_code_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_type,@iactv_code_type,@audit_data OUTPUT
   if (@loper='D' or  update(actv_code_type_scope)) exec audit_data 'ACTVTYPE','actv_code_type_scope',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dactv_code_type_scope,@iactv_code_type_scope,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'ACTVTYPE','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(super_flag)) exec audit_data 'ACTVTYPE','super_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dsuper_flag,@isuper_flag,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ACTVTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ACTVTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iactv_code_type_id,@iactv_short_len,@iseq_num,@iactv_code_type,@iactv_code_type_scope,@iproj_id,@isuper_flag, @idelete_session_id;
    else
     fetch deleted_c into @dactv_code_type_id,@dactv_short_len,@dseq_num,@dactv_code_type,@dactv_code_type_scope,@dproj_id,@dsuper_flag, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ACTVTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_ACTVTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACTVTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_ACTVTYPE_DEL
go
--METADATA NAME:RT_ACTVTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACTVTYPE_DEL
on ACTVTYPE
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ACTVTYPE',actv_code_type_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_ACTVTYPE'

--METADATA  TYPE:SSCR NAME:RT_ACTVTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ACTVTYPE' and type in ('TR'))
  DROP TRIGGER RT_ACTVTYPE
go
--METADATA NAME:RT_ACTVTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ACTVTYPE
on ACTVTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ACTVTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ACTVTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ACTVTYPE.create_date end
from ACTVTYPE WITH (INDEX(pk_actvtype)) join inserted 
on ACTVTYPE.actv_code_type_id = inserted.actv_code_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ACTVTYPE',actv_code_type_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select actv_code_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ACTVTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ADMIN_CONFIG'

--METADATA  TYPE:SSCR NAME:PRMAUD_ADMIN_CONFIG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ADMIN_CONFIG' and type in ('TR'))
  DROP TRIGGER PRMAUD_ADMIN_CONFIG
go
--METADATA NAME:PRMAUD_ADMIN_CONFIG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ADMIN_CONFIG
on ADMIN_CONFIG
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iconfig_name varchar(255),@iconfig_type varchar(255),@ifactory_version varchar(255),@ilast_change_date varchar(255),@iconfig_value varchar(255)
  declare @dconfig_name varchar(255),@dconfig_type varchar(255),@dfactory_version varchar(255),@dlast_change_date varchar(255),@dconfig_value varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(config_name) and
			not update(config_type) and
			not update(factory_version) and
			not update(last_change_date) and
			not update(config_value) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ADMIN_CONFIG', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ADMIN_CONFIG',config_name,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ADMIN_CONFIG', config_name,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select config_name,config_type,factory_version,last_change_date,config_value
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select config_name,config_type,factory_version,last_change_date,config_value
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iconfig_name,@iconfig_type,@ifactory_version,@ilast_change_date,@iconfig_value, @idelete_session_id
  else
    fetch deleted_c into @dconfig_name,@dconfig_type,@dfactory_version,@dlast_change_date,@dconfig_value, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dconfig_name;
				

    end else begin
    	set @pk1 = @iconfig_name;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dconfig_name,@dconfig_type,@dfactory_version,@dlast_change_date,@dconfig_value, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(config_name)) exec audit_data 'ADMIN_CONFIG','config_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dconfig_name,@iconfig_name,@audit_data OUTPUT
   if (@loper='D' or  update(config_type)) exec audit_data 'ADMIN_CONFIG','config_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dconfig_type,@iconfig_type,@audit_data OUTPUT
   if (@loper='D' or  update(factory_version)) exec audit_data 'ADMIN_CONFIG','factory_version',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfactory_version,@ifactory_version,@audit_data OUTPUT
   if (@loper='D' or  update(last_change_date)) exec audit_data 'ADMIN_CONFIG','last_change_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlast_change_date,@ilast_change_date,@audit_data OUTPUT
   if (@loper='D' or  update(config_value)) exec audit_data 'ADMIN_CONFIG','config_value',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dconfig_value,@iconfig_value,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ADMIN_CONFIG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ADMIN_CONFIG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iconfig_name,@iconfig_type,@ifactory_version,@ilast_change_date,@iconfig_value, @idelete_session_id;
    else
     fetch deleted_c into @dconfig_name,@dconfig_type,@dfactory_version,@dlast_change_date,@dconfig_value, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ADMIN_CONFIG_DEL'

--METADATA  TYPE:SSCR NAME:RT_ADMIN_CONFIG_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ADMIN_CONFIG_DEL' and type in ('TR'))
  DROP TRIGGER RT_ADMIN_CONFIG_DEL
go
--METADATA NAME:RT_ADMIN_CONFIG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ADMIN_CONFIG_DEL
on ADMIN_CONFIG
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ADMIN_CONFIG',config_name,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ADMIN_CONFIG'

--METADATA  TYPE:SSCR NAME:RT_ADMIN_CONFIG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ADMIN_CONFIG' and type in ('TR'))
  DROP TRIGGER RT_ADMIN_CONFIG
go
--METADATA NAME:RT_ADMIN_CONFIG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ADMIN_CONFIG
on ADMIN_CONFIG
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ADMIN_CONFIG
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ADMIN_CONFIG.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ADMIN_CONFIG.create_date end
from ADMIN_CONFIG WITH (INDEX(pk_admin_config)) join inserted 
on ADMIN_CONFIG.config_name = inserted.config_name

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ADMIN_CONFIG',config_name,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select config_name,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ADMIN_CONFIG'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ASGNMNTACAT'

--METADATA  TYPE:SSCR NAME:PRMAUD_ASGNMNTACAT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ASGNMNTACAT' and type in ('TR'))
  DROP TRIGGER PRMAUD_ASGNMNTACAT
go
--METADATA NAME:PRMAUD_ASGNMNTACAT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ASGNMNTACAT
on ASGNMNTACAT
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @itaskrsrc_id varchar(255),@iasgnmnt_catg_type_id varchar(255),@iasgnmnt_catg_id varchar(255),@iproj_id varchar(255)
  declare @dtaskrsrc_id varchar(255),@dasgnmnt_catg_type_id varchar(255),@dasgnmnt_catg_id varchar(255),@dproj_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(taskrsrc_id) and
			not update(asgnmnt_catg_type_id) and
			not update(asgnmnt_catg_id) and
			not update(proj_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ASGNMNTACAT', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTACAT',taskrsrc_id,asgnmnt_catg_type_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTACAT', taskrsrc_id,asgnmnt_catg_type_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select taskrsrc_id,asgnmnt_catg_type_id,asgnmnt_catg_id,proj_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select taskrsrc_id,asgnmnt_catg_type_id,asgnmnt_catg_id,proj_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @itaskrsrc_id,@iasgnmnt_catg_type_id,@iasgnmnt_catg_id,@iproj_id, @idelete_session_id
  else
    fetch deleted_c into @dtaskrsrc_id,@dasgnmnt_catg_type_id,@dasgnmnt_catg_id,@dproj_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dtaskrsrc_id;
				
set @pk2 = @dasgnmnt_catg_type_id;
				

    end else begin
    	set @pk1 = @itaskrsrc_id;
				
set @pk2 = @iasgnmnt_catg_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dtaskrsrc_id,@dasgnmnt_catg_type_id,@dasgnmnt_catg_id,@dproj_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(taskrsrc_id)) exec audit_data 'ASGNMNTACAT','taskrsrc_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtaskrsrc_id,@itaskrsrc_id,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_type_id)) exec audit_data 'ASGNMNTACAT','asgnmnt_catg_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_type_id,@iasgnmnt_catg_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_id)) exec audit_data 'ASGNMNTACAT','asgnmnt_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_id,@iasgnmnt_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'ASGNMNTACAT','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ASGNMNTACAT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ASGNMNTACAT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @itaskrsrc_id,@iasgnmnt_catg_type_id,@iasgnmnt_catg_id,@iproj_id, @idelete_session_id;
    else
     fetch deleted_c into @dtaskrsrc_id,@dasgnmnt_catg_type_id,@dasgnmnt_catg_id,@dproj_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ASGNMNTACAT_DEL'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTACAT_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTACAT_DEL' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTACAT_DEL
go
--METADATA NAME:RT_ASGNMNTACAT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTACAT_DEL
on ASGNMNTACAT
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ASGNMNTACAT',taskrsrc_id,asgnmnt_catg_type_id,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_ASGNMNTACAT'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTACAT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTACAT' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTACAT
go
--METADATA NAME:RT_ASGNMNTACAT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTACAT
on ASGNMNTACAT
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ASGNMNTACAT
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ASGNMNTACAT.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ASGNMNTACAT.create_date end
from ASGNMNTACAT WITH (INDEX(pk_asgnmntacat)) join inserted 
on ASGNMNTACAT.taskrsrc_id = inserted.taskrsrc_id
and ASGNMNTACAT.asgnmnt_catg_type_id = inserted.asgnmnt_catg_type_id
begin
  declare ins cursor  for select taskrsrc_id,asgnmnt_catg_type_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'ASGNMNTACAT'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ASGNMNTACAT',taskrsrc_id,asgnmnt_catg_type_id,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select taskrsrc_id,asgnmnt_catg_type_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ASGNMNTACAT'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ASGNMNTCATTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_ASGNMNTCATTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ASGNMNTCATTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_ASGNMNTCATTYPE
go
--METADATA NAME:PRMAUD_ASGNMNTCATTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ASGNMNTCATTYPE
on ASGNMNTCATTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iasgnmnt_catg_type_id varchar(255),@iseq_num varchar(255),@iasgnmnt_catg_short_len varchar(255),@iasgnmnt_catg_type varchar(255),@isuper_flag varchar(255)
  declare @dasgnmnt_catg_type_id varchar(255),@dseq_num varchar(255),@dasgnmnt_catg_short_len varchar(255),@dasgnmnt_catg_type varchar(255),@dsuper_flag varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(asgnmnt_catg_type_id) and
			not update(seq_num) and
			not update(asgnmnt_catg_short_len) and
			not update(asgnmnt_catg_type) and
			not update(super_flag) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ASGNMNTCATTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTCATTYPE',asgnmnt_catg_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTCATTYPE', asgnmnt_catg_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select asgnmnt_catg_type_id,seq_num,asgnmnt_catg_short_len,asgnmnt_catg_type,super_flag
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select asgnmnt_catg_type_id,seq_num,asgnmnt_catg_short_len,asgnmnt_catg_type,super_flag
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iasgnmnt_catg_type_id,@iseq_num,@iasgnmnt_catg_short_len,@iasgnmnt_catg_type,@isuper_flag, @idelete_session_id
  else
    fetch deleted_c into @dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_len,@dasgnmnt_catg_type,@dsuper_flag, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dasgnmnt_catg_type_id;
				

    end else begin
    	set @pk1 = @iasgnmnt_catg_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_len,@dasgnmnt_catg_type,@dsuper_flag, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(asgnmnt_catg_type_id)) exec audit_data 'ASGNMNTCATTYPE','asgnmnt_catg_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_type_id,@iasgnmnt_catg_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'ASGNMNTCATTYPE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_short_len)) exec audit_data 'ASGNMNTCATTYPE','asgnmnt_catg_short_len',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_short_len,@iasgnmnt_catg_short_len,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_type)) exec audit_data 'ASGNMNTCATTYPE','asgnmnt_catg_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_type,@iasgnmnt_catg_type,@audit_data OUTPUT
   if (@loper='D' or  update(super_flag)) exec audit_data 'ASGNMNTCATTYPE','super_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dsuper_flag,@isuper_flag,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ASGNMNTCATTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ASGNMNTCATTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iasgnmnt_catg_type_id,@iseq_num,@iasgnmnt_catg_short_len,@iasgnmnt_catg_type,@isuper_flag, @idelete_session_id;
    else
     fetch deleted_c into @dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_len,@dasgnmnt_catg_type,@dsuper_flag, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ASGNMNTCATTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTCATTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTCATTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTCATTYPE_DEL
go
--METADATA NAME:RT_ASGNMNTCATTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTCATTYPE_DEL
on ASGNMNTCATTYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ASGNMNTCATTYPE',asgnmnt_catg_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ASGNMNTCATTYPE'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTCATTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTCATTYPE' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTCATTYPE
go
--METADATA NAME:RT_ASGNMNTCATTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTCATTYPE
on ASGNMNTCATTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ASGNMNTCATTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ASGNMNTCATTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ASGNMNTCATTYPE.create_date end
from ASGNMNTCATTYPE WITH (INDEX(pk_asgnmntcattype)) join inserted 
on ASGNMNTCATTYPE.asgnmnt_catg_type_id = inserted.asgnmnt_catg_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ASGNMNTCATTYPE',asgnmnt_catg_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select asgnmnt_catg_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ASGNMNTCATTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ASGNMNTCATVAL'

--METADATA  TYPE:SSCR NAME:PRMAUD_ASGNMNTCATVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ASGNMNTCATVAL' and type in ('TR'))
  DROP TRIGGER PRMAUD_ASGNMNTCATVAL
go
--METADATA NAME:PRMAUD_ASGNMNTCATVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ASGNMNTCATVAL
on ASGNMNTCATVAL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iasgnmnt_catg_id varchar(255),@iasgnmnt_catg_type_id varchar(255),@iseq_num varchar(255),@iasgnmnt_catg_short_name varchar(255),@iasgnmnt_catg_name varchar(255),@iparent_asgnmnt_catg_id varchar(255)
  declare @dasgnmnt_catg_id varchar(255),@dasgnmnt_catg_type_id varchar(255),@dseq_num varchar(255),@dasgnmnt_catg_short_name varchar(255),@dasgnmnt_catg_name varchar(255),@dparent_asgnmnt_catg_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(asgnmnt_catg_id) and
			not update(asgnmnt_catg_type_id) and
			not update(seq_num) and
			not update(asgnmnt_catg_short_name) and
			not update(asgnmnt_catg_name) and
			not update(parent_asgnmnt_catg_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ASGNMNTCATVAL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTCATVAL',asgnmnt_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ASGNMNTCATVAL', asgnmnt_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select asgnmnt_catg_id,asgnmnt_catg_type_id,seq_num,asgnmnt_catg_short_name,asgnmnt_catg_name,parent_asgnmnt_catg_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select asgnmnt_catg_id,asgnmnt_catg_type_id,seq_num,asgnmnt_catg_short_name,asgnmnt_catg_name,parent_asgnmnt_catg_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iasgnmnt_catg_id,@iasgnmnt_catg_type_id,@iseq_num,@iasgnmnt_catg_short_name,@iasgnmnt_catg_name,@iparent_asgnmnt_catg_id, @idelete_session_id
  else
    fetch deleted_c into @dasgnmnt_catg_id,@dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_name,@dasgnmnt_catg_name,@dparent_asgnmnt_catg_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dasgnmnt_catg_id;
				

    end else begin
    	set @pk1 = @iasgnmnt_catg_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dasgnmnt_catg_id,@dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_name,@dasgnmnt_catg_name,@dparent_asgnmnt_catg_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(asgnmnt_catg_id)) exec audit_data 'ASGNMNTCATVAL','asgnmnt_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_id,@iasgnmnt_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_type_id)) exec audit_data 'ASGNMNTCATVAL','asgnmnt_catg_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_type_id,@iasgnmnt_catg_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'ASGNMNTCATVAL','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_short_name)) exec audit_data 'ASGNMNTCATVAL','asgnmnt_catg_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_short_name,@iasgnmnt_catg_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(asgnmnt_catg_name)) exec audit_data 'ASGNMNTCATVAL','asgnmnt_catg_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dasgnmnt_catg_name,@iasgnmnt_catg_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_asgnmnt_catg_id)) exec audit_data 'ASGNMNTCATVAL','parent_asgnmnt_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_asgnmnt_catg_id,@iparent_asgnmnt_catg_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ASGNMNTCATVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ASGNMNTCATVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iasgnmnt_catg_id,@iasgnmnt_catg_type_id,@iseq_num,@iasgnmnt_catg_short_name,@iasgnmnt_catg_name,@iparent_asgnmnt_catg_id, @idelete_session_id;
    else
     fetch deleted_c into @dasgnmnt_catg_id,@dasgnmnt_catg_type_id,@dseq_num,@dasgnmnt_catg_short_name,@dasgnmnt_catg_name,@dparent_asgnmnt_catg_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ASGNMNTCATVAL_DEL'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTCATVAL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTCATVAL_DEL' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTCATVAL_DEL
go
--METADATA NAME:RT_ASGNMNTCATVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTCATVAL_DEL
on ASGNMNTCATVAL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ASGNMNTCATVAL',asgnmnt_catg_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ASGNMNTCATVAL'

--METADATA  TYPE:SSCR NAME:RT_ASGNMNTCATVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ASGNMNTCATVAL' and type in ('TR'))
  DROP TRIGGER RT_ASGNMNTCATVAL
go
--METADATA NAME:RT_ASGNMNTCATVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ASGNMNTCATVAL
on ASGNMNTCATVAL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ASGNMNTCATVAL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ASGNMNTCATVAL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ASGNMNTCATVAL.create_date end
from ASGNMNTCATVAL WITH (INDEX(pk_asgnmntcatval)) join inserted 
on ASGNMNTCATVAL.asgnmnt_catg_id = inserted.asgnmnt_catg_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ASGNMNTCATVAL',asgnmnt_catg_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select asgnmnt_catg_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ASGNMNTCATVAL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_BASETYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_BASETYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_BASETYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_BASETYPE
go
--METADATA NAME:PRMAUD_BASETYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_BASETYPE
on BASETYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ibase_type_id varchar(255),@ibase_type_seq_num varchar(255),@ibase_type varchar(255)
  declare @dbase_type_id varchar(255),@dbase_type_seq_num varchar(255),@dbase_type varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(base_type_id) and
			not update(base_type_seq_num) and
			not update(base_type) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'BASETYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BASETYPE',base_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BASETYPE', base_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select base_type_id,base_type_seq_num,base_type
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select base_type_id,base_type_seq_num,base_type
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ibase_type_id,@ibase_type_seq_num,@ibase_type, @idelete_session_id
  else
    fetch deleted_c into @dbase_type_id,@dbase_type_seq_num,@dbase_type, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dbase_type_id;
				

    end else begin
    	set @pk1 = @ibase_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dbase_type_id,@dbase_type_seq_num,@dbase_type, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(base_type_id)) exec audit_data 'BASETYPE','base_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbase_type_id,@ibase_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(base_type_seq_num)) exec audit_data 'BASETYPE','base_type_seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbase_type_seq_num,@ibase_type_seq_num,@audit_data OUTPUT
   if (@loper='D' or  update(base_type)) exec audit_data 'BASETYPE','base_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbase_type,@ibase_type,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'BASETYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'BASETYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ibase_type_id,@ibase_type_seq_num,@ibase_type, @idelete_session_id;
    else
     fetch deleted_c into @dbase_type_id,@dbase_type_seq_num,@dbase_type, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_BASETYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_BASETYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BASETYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_BASETYPE_DEL
go
--METADATA NAME:RT_BASETYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BASETYPE_DEL
on BASETYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'BASETYPE',base_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_BASETYPE'

--METADATA  TYPE:SSCR NAME:RT_BASETYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BASETYPE' and type in ('TR'))
  DROP TRIGGER RT_BASETYPE
go
--METADATA NAME:RT_BASETYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BASETYPE
on BASETYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update BASETYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else BASETYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else BASETYPE.create_date end
from BASETYPE WITH (INDEX(pk_basetype)) join inserted 
on BASETYPE.base_type_id = inserted.base_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'BASETYPE',base_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select base_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'BASETYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_BRE_REGISTRY'

--METADATA  TYPE:SSCR NAME:PRMAUD_BRE_REGISTRY OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_BRE_REGISTRY' and type in ('TR'))
  DROP TRIGGER PRMAUD_BRE_REGISTRY
go
--METADATA NAME:PRMAUD_BRE_REGISTRY TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_BRE_REGISTRY
on BRE_REGISTRY
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ibre_registry_id varchar(255),@iip_address varchar(255),@istart_time varchar(255),@istatus_code varchar(255),@itorched_time varchar(255),@iconfig_name varchar(255),@iconfig_changed_flag varchar(255)
  declare @dbre_registry_id varchar(255),@dip_address varchar(255),@dstart_time varchar(255),@dstatus_code varchar(255),@dtorched_time varchar(255),@dconfig_name varchar(255),@dconfig_changed_flag varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(bre_registry_id) and
			not update(ip_address) and
			not update(start_time) and
			not update(status_code) and
			not update(torched_time) and
			not update(config_name) and
			not update(config_changed_flag) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'BRE_REGISTRY', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BRE_REGISTRY',bre_registry_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BRE_REGISTRY', bre_registry_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select bre_registry_id,ip_address,start_time,status_code,torched_time,config_name,config_changed_flag
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select bre_registry_id,ip_address,start_time,status_code,torched_time,config_name,config_changed_flag
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ibre_registry_id,@iip_address,@istart_time,@istatus_code,@itorched_time,@iconfig_name,@iconfig_changed_flag, @idelete_session_id
  else
    fetch deleted_c into @dbre_registry_id,@dip_address,@dstart_time,@dstatus_code,@dtorched_time,@dconfig_name,@dconfig_changed_flag, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dbre_registry_id;
				

    end else begin
    	set @pk1 = @ibre_registry_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dbre_registry_id,@dip_address,@dstart_time,@dstatus_code,@dtorched_time,@dconfig_name,@dconfig_changed_flag, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(bre_registry_id)) exec audit_data 'BRE_REGISTRY','bre_registry_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbre_registry_id,@ibre_registry_id,@audit_data OUTPUT
   if (@loper='D' or  update(ip_address)) exec audit_data 'BRE_REGISTRY','ip_address',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dip_address,@iip_address,@audit_data OUTPUT
   if (@loper='D' or  update(start_time)) exec audit_data 'BRE_REGISTRY','start_time',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstart_time,@istart_time,@audit_data OUTPUT
   if (@loper='D' or  update(status_code)) exec audit_data 'BRE_REGISTRY','status_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus_code,@istatus_code,@audit_data OUTPUT
   if (@loper='D' or  update(torched_time)) exec audit_data 'BRE_REGISTRY','torched_time',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtorched_time,@itorched_time,@audit_data OUTPUT
   if (@loper='D' or  update(config_name)) exec audit_data 'BRE_REGISTRY','config_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dconfig_name,@iconfig_name,@audit_data OUTPUT
   if (@loper='D' or  update(config_changed_flag)) exec audit_data 'BRE_REGISTRY','config_changed_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dconfig_changed_flag,@iconfig_changed_flag,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'BRE_REGISTRY', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'BRE_REGISTRY', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ibre_registry_id,@iip_address,@istart_time,@istatus_code,@itorched_time,@iconfig_name,@iconfig_changed_flag, @idelete_session_id;
    else
     fetch deleted_c into @dbre_registry_id,@dip_address,@dstart_time,@dstatus_code,@dtorched_time,@dconfig_name,@dconfig_changed_flag, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_BRE_REGISTRY_DEL'

--METADATA  TYPE:SSCR NAME:RT_BRE_REGISTRY_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BRE_REGISTRY_DEL' and type in ('TR'))
  DROP TRIGGER RT_BRE_REGISTRY_DEL
go
--METADATA NAME:RT_BRE_REGISTRY_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BRE_REGISTRY_DEL
on BRE_REGISTRY
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'BRE_REGISTRY',bre_registry_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_BRE_REGISTRY'

--METADATA  TYPE:SSCR NAME:RT_BRE_REGISTRY OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BRE_REGISTRY' and type in ('TR'))
  DROP TRIGGER RT_BRE_REGISTRY
go
--METADATA NAME:RT_BRE_REGISTRY TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BRE_REGISTRY
on BRE_REGISTRY
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update BRE_REGISTRY
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else BRE_REGISTRY.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else BRE_REGISTRY.create_date end
from BRE_REGISTRY WITH (INDEX(pk_bre_registry)) join inserted 
on BRE_REGISTRY.bre_registry_id = inserted.bre_registry_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'BRE_REGISTRY',bre_registry_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select bre_registry_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'BRE_REGISTRY'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_BUDGCHNG'

--METADATA  TYPE:SSCR NAME:PRMAUD_BUDGCHNG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_BUDGCHNG' and type in ('TR'))
  DROP TRIGGER PRMAUD_BUDGCHNG
go
--METADATA NAME:PRMAUD_BUDGCHNG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_BUDGCHNG
on BUDGCHNG
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ibudg_chng_id varchar(255),@iproj_id varchar(255),@iwbs_id varchar(255),@ichng_date varchar(255),@ichng_short_name varchar(255),@ichng_cost varchar(255),@ichng_by_name varchar(255),@istatus_code varchar(255),@ichng_descr varchar(255)
  declare @dbudg_chng_id varchar(255),@dproj_id varchar(255),@dwbs_id varchar(255),@dchng_date varchar(255),@dchng_short_name varchar(255),@dchng_cost varchar(255),@dchng_by_name varchar(255),@dstatus_code varchar(255),@dchng_descr varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(budg_chng_id) and
			not update(proj_id) and
			not update(wbs_id) and
			not update(chng_date) and
			not update(chng_short_name) and
			not update(chng_cost) and
			not update(chng_by_name) and
			not update(status_code) and
			not update(chng_descr) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'BUDGCHNG', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BUDGCHNG',budg_chng_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'BUDGCHNG', budg_chng_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select budg_chng_id,proj_id,wbs_id,chng_date,chng_short_name,chng_cost,chng_by_name,status_code,chng_descr
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select budg_chng_id,proj_id,wbs_id,chng_date,chng_short_name,chng_cost,chng_by_name,status_code,chng_descr
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ibudg_chng_id,@iproj_id,@iwbs_id,@ichng_date,@ichng_short_name,@ichng_cost,@ichng_by_name,@istatus_code,@ichng_descr, @idelete_session_id
  else
    fetch deleted_c into @dbudg_chng_id,@dproj_id,@dwbs_id,@dchng_date,@dchng_short_name,@dchng_cost,@dchng_by_name,@dstatus_code,@dchng_descr, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dbudg_chng_id;
				

    end else begin
    	set @pk1 = @ibudg_chng_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dbudg_chng_id,@dproj_id,@dwbs_id,@dchng_date,@dchng_short_name,@dchng_cost,@dchng_by_name,@dstatus_code,@dchng_descr, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(budg_chng_id)) exec audit_data 'BUDGCHNG','budg_chng_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbudg_chng_id,@ibudg_chng_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'BUDGCHNG','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(wbs_id)) exec audit_data 'BUDGCHNG','wbs_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dwbs_id,@iwbs_id,@audit_data OUTPUT
   if (@loper='D' or  update(chng_date)) exec audit_data 'BUDGCHNG','chng_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dchng_date,@ichng_date,@audit_data OUTPUT
   if (@loper='D' or  update(chng_short_name)) exec audit_data 'BUDGCHNG','chng_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dchng_short_name,@ichng_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(chng_cost)) exec audit_data 'BUDGCHNG','chng_cost',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dchng_cost,@ichng_cost,@audit_data OUTPUT
   if (@loper='D' or  update(chng_by_name)) exec audit_data 'BUDGCHNG','chng_by_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dchng_by_name,@ichng_by_name,@audit_data OUTPUT
   if (@loper='D' or  update(status_code)) exec audit_data 'BUDGCHNG','status_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus_code,@istatus_code,@audit_data OUTPUT
   if (@loper='D' or  update(chng_descr)) exec audit_data 'BUDGCHNG','chng_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dchng_descr,@ichng_descr,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'BUDGCHNG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'BUDGCHNG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ibudg_chng_id,@iproj_id,@iwbs_id,@ichng_date,@ichng_short_name,@ichng_cost,@ichng_by_name,@istatus_code,@ichng_descr, @idelete_session_id;
    else
     fetch deleted_c into @dbudg_chng_id,@dproj_id,@dwbs_id,@dchng_date,@dchng_short_name,@dchng_cost,@dchng_by_name,@dstatus_code,@dchng_descr, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_BUDGCHNG_DEL'

--METADATA  TYPE:SSCR NAME:RT_BUDGCHNG_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BUDGCHNG_DEL' and type in ('TR'))
  DROP TRIGGER RT_BUDGCHNG_DEL
go
--METADATA NAME:RT_BUDGCHNG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BUDGCHNG_DEL
on BUDGCHNG
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'BUDGCHNG',budg_chng_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_BUDGCHNG'

--METADATA  TYPE:SSCR NAME:RT_BUDGCHNG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_BUDGCHNG' and type in ('TR'))
  DROP TRIGGER RT_BUDGCHNG
go
--METADATA NAME:RT_BUDGCHNG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_BUDGCHNG
on BUDGCHNG
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update BUDGCHNG
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else BUDGCHNG.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else BUDGCHNG.create_date end
from BUDGCHNG WITH (INDEX(pk_budgchng)) join inserted 
on BUDGCHNG.budg_chng_id = inserted.budg_chng_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'BUDGCHNG',budg_chng_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select budg_chng_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'BUDGCHNG'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_CALENDAR'

--METADATA  TYPE:SSCR NAME:PRMAUD_CALENDAR OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_CALENDAR' and type in ('TR'))
  DROP TRIGGER PRMAUD_CALENDAR
go
--METADATA NAME:PRMAUD_CALENDAR TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_CALENDAR
on CALENDAR
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iclndr_id varchar(255),@idefault_flag varchar(255),@irsrc_private varchar(255),@iclndr_name varchar(255),@iproj_id varchar(255),@ibase_clndr_id varchar(255),@ilast_chng_date varchar(255),@iclndr_type varchar(255),@iday_hr_cnt varchar(255),@iweek_hr_cnt varchar(255),@iyear_hr_cnt varchar(255),@imonth_hr_cnt varchar(255)
  declare @dclndr_id varchar(255),@ddefault_flag varchar(255),@drsrc_private varchar(255),@dclndr_name varchar(255),@dproj_id varchar(255),@dbase_clndr_id varchar(255),@dlast_chng_date varchar(255),@dclndr_type varchar(255),@dday_hr_cnt varchar(255),@dweek_hr_cnt varchar(255),@dyear_hr_cnt varchar(255),@dmonth_hr_cnt varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(clndr_id) and
			not update(default_flag) and
			not update(rsrc_private) and
			not update(clndr_name) and
			not update(proj_id) and
			not update(base_clndr_id) and
			not update(last_chng_date) and
			not update(clndr_type) and
			not update(day_hr_cnt) and
			not update(week_hr_cnt) and
			not update(year_hr_cnt) and
			not update(month_hr_cnt) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'CALENDAR', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'CALENDAR',clndr_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'CALENDAR', clndr_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select clndr_id,default_flag,rsrc_private,clndr_name,proj_id,base_clndr_id,last_chng_date,clndr_type,day_hr_cnt,week_hr_cnt,year_hr_cnt,month_hr_cnt
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select clndr_id,default_flag,rsrc_private,clndr_name,proj_id,base_clndr_id,last_chng_date,clndr_type,day_hr_cnt,week_hr_cnt,year_hr_cnt,month_hr_cnt
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iclndr_id,@idefault_flag,@irsrc_private,@iclndr_name,@iproj_id,@ibase_clndr_id,@ilast_chng_date,@iclndr_type,@iday_hr_cnt,@iweek_hr_cnt,@iyear_hr_cnt,@imonth_hr_cnt, @idelete_session_id
  else
    fetch deleted_c into @dclndr_id,@ddefault_flag,@drsrc_private,@dclndr_name,@dproj_id,@dbase_clndr_id,@dlast_chng_date,@dclndr_type,@dday_hr_cnt,@dweek_hr_cnt,@dyear_hr_cnt,@dmonth_hr_cnt, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dclndr_id;
				

    end else begin
    	set @pk1 = @iclndr_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dclndr_id,@ddefault_flag,@drsrc_private,@dclndr_name,@dproj_id,@dbase_clndr_id,@dlast_chng_date,@dclndr_type,@dday_hr_cnt,@dweek_hr_cnt,@dyear_hr_cnt,@dmonth_hr_cnt, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(clndr_id)) exec audit_data 'CALENDAR','clndr_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dclndr_id,@iclndr_id,@audit_data OUTPUT
   if (@loper='D' or  update(default_flag)) exec audit_data 'CALENDAR','default_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddefault_flag,@idefault_flag,@audit_data OUTPUT
   if (@loper='D' or  update(rsrc_private)) exec audit_data 'CALENDAR','rsrc_private',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drsrc_private,@irsrc_private,@audit_data OUTPUT
   if (@loper='D' or  update(clndr_name)) exec audit_data 'CALENDAR','clndr_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dclndr_name,@iclndr_name,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'CALENDAR','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(base_clndr_id)) exec audit_data 'CALENDAR','base_clndr_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbase_clndr_id,@ibase_clndr_id,@audit_data OUTPUT
   if (@loper='D' or  update(last_chng_date)) exec audit_data 'CALENDAR','last_chng_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlast_chng_date,@ilast_chng_date,@audit_data OUTPUT
   if (@loper='D' or  update(clndr_type)) exec audit_data 'CALENDAR','clndr_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dclndr_type,@iclndr_type,@audit_data OUTPUT
   if (@loper='D' or  update(day_hr_cnt)) exec audit_data 'CALENDAR','day_hr_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dday_hr_cnt,@iday_hr_cnt,@audit_data OUTPUT
   if (@loper='D' or  update(week_hr_cnt)) exec audit_data 'CALENDAR','week_hr_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dweek_hr_cnt,@iweek_hr_cnt,@audit_data OUTPUT
   if (@loper='D' or  update(year_hr_cnt)) exec audit_data 'CALENDAR','year_hr_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dyear_hr_cnt,@iyear_hr_cnt,@audit_data OUTPUT
   if (@loper='D' or  update(month_hr_cnt)) exec audit_data 'CALENDAR','month_hr_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmonth_hr_cnt,@imonth_hr_cnt,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'CALENDAR', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'CALENDAR', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iclndr_id,@idefault_flag,@irsrc_private,@iclndr_name,@iproj_id,@ibase_clndr_id,@ilast_chng_date,@iclndr_type,@iday_hr_cnt,@iweek_hr_cnt,@iyear_hr_cnt,@imonth_hr_cnt, @idelete_session_id;
    else
     fetch deleted_c into @dclndr_id,@ddefault_flag,@drsrc_private,@dclndr_name,@dproj_id,@dbase_clndr_id,@dlast_chng_date,@dclndr_type,@dday_hr_cnt,@dweek_hr_cnt,@dyear_hr_cnt,@dmonth_hr_cnt, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_CALENDAR_DEL'

--METADATA  TYPE:SSCR NAME:RT_CALENDAR_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_CALENDAR_DEL' and type in ('TR'))
  DROP TRIGGER RT_CALENDAR_DEL
go
--METADATA NAME:RT_CALENDAR_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_CALENDAR_DEL
on CALENDAR
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'CALENDAR',clndr_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_CALENDAR'

--METADATA  TYPE:SSCR NAME:RT_CALENDAR OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_CALENDAR' and type in ('TR'))
  DROP TRIGGER RT_CALENDAR
go
--METADATA NAME:RT_CALENDAR TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_CALENDAR
on CALENDAR
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update CALENDAR
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else CALENDAR.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else CALENDAR.create_date end
from CALENDAR WITH (INDEX(pk_calendar)) join inserted 
on CALENDAR.clndr_id = inserted.clndr_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'CALENDAR',clndr_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select clndr_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'CALENDAR'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_COSTTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_COSTTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_COSTTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_COSTTYPE
go
--METADATA NAME:PRMAUD_COSTTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_COSTTYPE
on COSTTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @icost_type_id varchar(255),@iseq_num varchar(255),@icost_type varchar(255)
  declare @dcost_type_id varchar(255),@dseq_num varchar(255),@dcost_type varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(cost_type_id) and
			not update(seq_num) and
			not update(cost_type) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'COSTTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'COSTTYPE',cost_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'COSTTYPE', cost_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select cost_type_id,seq_num,cost_type
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select cost_type_id,seq_num,cost_type
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @icost_type_id,@iseq_num,@icost_type, @idelete_session_id
  else
    fetch deleted_c into @dcost_type_id,@dseq_num,@dcost_type, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dcost_type_id;
				

    end else begin
    	set @pk1 = @icost_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dcost_type_id,@dseq_num,@dcost_type, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(cost_type_id)) exec audit_data 'COSTTYPE','cost_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcost_type_id,@icost_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'COSTTYPE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(cost_type)) exec audit_data 'COSTTYPE','cost_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcost_type,@icost_type,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'COSTTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'COSTTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @icost_type_id,@iseq_num,@icost_type, @idelete_session_id;
    else
     fetch deleted_c into @dcost_type_id,@dseq_num,@dcost_type, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_COSTTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_COSTTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_COSTTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_COSTTYPE_DEL
go
--METADATA NAME:RT_COSTTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_COSTTYPE_DEL
on COSTTYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'COSTTYPE',cost_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_COSTTYPE'

--METADATA  TYPE:SSCR NAME:RT_COSTTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_COSTTYPE' and type in ('TR'))
  DROP TRIGGER RT_COSTTYPE
go
--METADATA NAME:RT_COSTTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_COSTTYPE
on COSTTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update COSTTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else COSTTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else COSTTYPE.create_date end
from COSTTYPE WITH (INDEX(pk_costtype)) join inserted 
on COSTTYPE.cost_type_id = inserted.cost_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'COSTTYPE',cost_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select cost_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'COSTTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_CURRTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_CURRTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_CURRTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_CURRTYPE
go
--METADATA NAME:PRMAUD_CURRTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_CURRTYPE
on CURRTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @icurr_id varchar(255),@idecimal_digit_cnt varchar(255),@icurr_symbol varchar(255),@idecimal_symbol varchar(255),@idigit_group_symbol varchar(255),@ipos_curr_fmt_type varchar(255),@ineg_curr_fmt_type varchar(255),@icurr_type varchar(255),@icurr_short_name varchar(255),@igroup_digit_cnt varchar(255),@ibase_exch_rate varchar(255)
  declare @dcurr_id varchar(255),@ddecimal_digit_cnt varchar(255),@dcurr_symbol varchar(255),@ddecimal_symbol varchar(255),@ddigit_group_symbol varchar(255),@dpos_curr_fmt_type varchar(255),@dneg_curr_fmt_type varchar(255),@dcurr_type varchar(255),@dcurr_short_name varchar(255),@dgroup_digit_cnt varchar(255),@dbase_exch_rate varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(curr_id) and
			not update(decimal_digit_cnt) and
			not update(curr_symbol) and
			not update(decimal_symbol) and
			not update(digit_group_symbol) and
			not update(pos_curr_fmt_type) and
			not update(neg_curr_fmt_type) and
			not update(curr_type) and
			not update(curr_short_name) and
			not update(group_digit_cnt) and
			not update(base_exch_rate) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'CURRTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'CURRTYPE',curr_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'CURRTYPE', curr_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select curr_id,decimal_digit_cnt,curr_symbol,decimal_symbol,digit_group_symbol,pos_curr_fmt_type,neg_curr_fmt_type,curr_type,curr_short_name,group_digit_cnt,base_exch_rate
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select curr_id,decimal_digit_cnt,curr_symbol,decimal_symbol,digit_group_symbol,pos_curr_fmt_type,neg_curr_fmt_type,curr_type,curr_short_name,group_digit_cnt,base_exch_rate
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @icurr_id,@idecimal_digit_cnt,@icurr_symbol,@idecimal_symbol,@idigit_group_symbol,@ipos_curr_fmt_type,@ineg_curr_fmt_type,@icurr_type,@icurr_short_name,@igroup_digit_cnt,@ibase_exch_rate, @idelete_session_id
  else
    fetch deleted_c into @dcurr_id,@ddecimal_digit_cnt,@dcurr_symbol,@ddecimal_symbol,@ddigit_group_symbol,@dpos_curr_fmt_type,@dneg_curr_fmt_type,@dcurr_type,@dcurr_short_name,@dgroup_digit_cnt,@dbase_exch_rate, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dcurr_id;
				

    end else begin
    	set @pk1 = @icurr_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dcurr_id,@ddecimal_digit_cnt,@dcurr_symbol,@ddecimal_symbol,@ddigit_group_symbol,@dpos_curr_fmt_type,@dneg_curr_fmt_type,@dcurr_type,@dcurr_short_name,@dgroup_digit_cnt,@dbase_exch_rate, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(curr_id)) exec audit_data 'CURRTYPE','curr_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcurr_id,@icurr_id,@audit_data OUTPUT
   if (@loper='D' or  update(decimal_digit_cnt)) exec audit_data 'CURRTYPE','decimal_digit_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddecimal_digit_cnt,@idecimal_digit_cnt,@audit_data OUTPUT
   if (@loper='D' or  update(curr_symbol)) exec audit_data 'CURRTYPE','curr_symbol',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcurr_symbol,@icurr_symbol,@audit_data OUTPUT
   if (@loper='D' or  update(decimal_symbol)) exec audit_data 'CURRTYPE','decimal_symbol',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddecimal_symbol,@idecimal_symbol,@audit_data OUTPUT
   if (@loper='D' or  update(digit_group_symbol)) exec audit_data 'CURRTYPE','digit_group_symbol',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddigit_group_symbol,@idigit_group_symbol,@audit_data OUTPUT
   if (@loper='D' or  update(pos_curr_fmt_type)) exec audit_data 'CURRTYPE','pos_curr_fmt_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpos_curr_fmt_type,@ipos_curr_fmt_type,@audit_data OUTPUT
   if (@loper='D' or  update(neg_curr_fmt_type)) exec audit_data 'CURRTYPE','neg_curr_fmt_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dneg_curr_fmt_type,@ineg_curr_fmt_type,@audit_data OUTPUT
   if (@loper='D' or  update(curr_type)) exec audit_data 'CURRTYPE','curr_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcurr_type,@icurr_type,@audit_data OUTPUT
   if (@loper='D' or  update(curr_short_name)) exec audit_data 'CURRTYPE','curr_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcurr_short_name,@icurr_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(group_digit_cnt)) exec audit_data 'CURRTYPE','group_digit_cnt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dgroup_digit_cnt,@igroup_digit_cnt,@audit_data OUTPUT
   if (@loper='D' or  update(base_exch_rate)) exec audit_data 'CURRTYPE','base_exch_rate',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dbase_exch_rate,@ibase_exch_rate,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'CURRTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'CURRTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @icurr_id,@idecimal_digit_cnt,@icurr_symbol,@idecimal_symbol,@idigit_group_symbol,@ipos_curr_fmt_type,@ineg_curr_fmt_type,@icurr_type,@icurr_short_name,@igroup_digit_cnt,@ibase_exch_rate, @idelete_session_id;
    else
     fetch deleted_c into @dcurr_id,@ddecimal_digit_cnt,@dcurr_symbol,@ddecimal_symbol,@ddigit_group_symbol,@dpos_curr_fmt_type,@dneg_curr_fmt_type,@dcurr_type,@dcurr_short_name,@dgroup_digit_cnt,@dbase_exch_rate, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_CURRTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_CURRTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_CURRTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_CURRTYPE_DEL
go
--METADATA NAME:RT_CURRTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_CURRTYPE_DEL
on CURRTYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'CURRTYPE',curr_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_CURRTYPE'

--METADATA  TYPE:SSCR NAME:RT_CURRTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_CURRTYPE' and type in ('TR'))
  DROP TRIGGER RT_CURRTYPE
go
--METADATA NAME:RT_CURRTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_CURRTYPE
on CURRTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update CURRTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else CURRTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else CURRTYPE.create_date end
from CURRTYPE WITH (INDEX(pk_currtype)) join inserted 
on CURRTYPE.curr_id = inserted.curr_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'CURRTYPE',curr_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select curr_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'CURRTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DASHBOARD'

--METADATA  TYPE:SSCR NAME:PRMAUD_DASHBOARD OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DASHBOARD' and type in ('TR'))
  DROP TRIGGER PRMAUD_DASHBOARD
go
--METADATA NAME:PRMAUD_DASHBOARD TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DASHBOARD
on DASHBOARD
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idashboard_id varchar(255),@idashboard_name varchar(255),@iuser_id varchar(255),@itable_name varchar(255),@ifk_id varchar(255),@ilock_filter_flag varchar(255),@imax_rows_per_portlet varchar(255),@idashboard_layout_data varchar(4000)
  declare @ddashboard_id varchar(255),@ddashboard_name varchar(255),@duser_id varchar(255),@dtable_name varchar(255),@dfk_id varchar(255),@dlock_filter_flag varchar(255),@dmax_rows_per_portlet varchar(255),@ddashboard_layout_data varchar(4000)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(dashboard_id) and
			not update(dashboard_name) and
			not update(user_id) and
			not update(table_name) and
			not update(fk_id) and
			not update(lock_filter_flag) and
			not update(max_rows_per_portlet) and
			not update(dashboard_layout_data) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DASHBOARD', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DASHBOARD',dashboard_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DASHBOARD', dashboard_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select dashboard_id,dashboard_name,user_id,table_name,fk_id,lock_filter_flag,max_rows_per_portlet,dashboard_layout_data
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select dashboard_id,dashboard_name,user_id,table_name,fk_id,lock_filter_flag,max_rows_per_portlet,dashboard_layout_data
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idashboard_id,@idashboard_name,@iuser_id,@itable_name,@ifk_id,@ilock_filter_flag,@imax_rows_per_portlet,@idashboard_layout_data, @idelete_session_id
  else
    fetch deleted_c into @ddashboard_id,@ddashboard_name,@duser_id,@dtable_name,@dfk_id,@dlock_filter_flag,@dmax_rows_per_portlet,@ddashboard_layout_data, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddashboard_id;
				

    end else begin
    	set @pk1 = @idashboard_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddashboard_id,@ddashboard_name,@duser_id,@dtable_name,@dfk_id,@dlock_filter_flag,@dmax_rows_per_portlet,@ddashboard_layout_data, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(dashboard_id)) exec audit_data 'DASHBOARD','dashboard_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddashboard_id,@idashboard_id,@audit_data OUTPUT
   if (@loper='D' or  update(dashboard_name)) exec audit_data 'DASHBOARD','dashboard_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddashboard_name,@idashboard_name,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DASHBOARD','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(table_name)) exec audit_data 'DASHBOARD','table_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtable_name,@itable_name,@audit_data OUTPUT
   if (@loper='D' or  update(fk_id)) exec audit_data 'DASHBOARD','fk_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfk_id,@ifk_id,@audit_data OUTPUT
   if (@loper='D' or  update(lock_filter_flag)) exec audit_data 'DASHBOARD','lock_filter_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlock_filter_flag,@ilock_filter_flag,@audit_data OUTPUT
   if (@loper='D' or  update(max_rows_per_portlet)) exec audit_data 'DASHBOARD','max_rows_per_portlet',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmax_rows_per_portlet,@imax_rows_per_portlet,@audit_data OUTPUT
   if (@loper='D' or  update(dashboard_layout_data)) exec audit_data 'DASHBOARD','dashboard_layout_data',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddashboard_layout_data,@idashboard_layout_data,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DASHBOARD', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DASHBOARD', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idashboard_id,@idashboard_name,@iuser_id,@itable_name,@ifk_id,@ilock_filter_flag,@imax_rows_per_portlet,@idashboard_layout_data, @idelete_session_id;
    else
     fetch deleted_c into @ddashboard_id,@ddashboard_name,@duser_id,@dtable_name,@dfk_id,@dlock_filter_flag,@dmax_rows_per_portlet,@ddashboard_layout_data, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DASHBOARD_DEL'

--METADATA  TYPE:SSCR NAME:RT_DASHBOARD_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DASHBOARD_DEL' and type in ('TR'))
  DROP TRIGGER RT_DASHBOARD_DEL
go
--METADATA NAME:RT_DASHBOARD_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DASHBOARD_DEL
on DASHBOARD
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DASHBOARD',dashboard_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DASHBOARD'

--METADATA  TYPE:SSCR NAME:RT_DASHBOARD OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DASHBOARD' and type in ('TR'))
  DROP TRIGGER RT_DASHBOARD
go
--METADATA NAME:RT_DASHBOARD TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DASHBOARD
on DASHBOARD
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DASHBOARD
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DASHBOARD.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DASHBOARD.create_date end
from DASHBOARD WITH (INDEX(pk_dashboard)) join inserted 
on DASHBOARD.dashboard_id = inserted.dashboard_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DASHBOARD',dashboard_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select dashboard_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DASHBOARD'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DASHUSER'

--METADATA  TYPE:SSCR NAME:PRMAUD_DASHUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DASHUSER' and type in ('TR'))
  DROP TRIGGER PRMAUD_DASHUSER
go
--METADATA NAME:PRMAUD_DASHUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DASHUSER
on DASHUSER
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idashboard_id varchar(255),@iuser_id varchar(255)
  declare @ddashboard_id varchar(255),@duser_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(dashboard_id) and
			not update(user_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DASHUSER', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DASHUSER',dashboard_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DASHUSER', dashboard_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select dashboard_id,user_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select dashboard_id,user_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idashboard_id,@iuser_id, @idelete_session_id
  else
    fetch deleted_c into @ddashboard_id,@duser_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddashboard_id;
				
set @pk2 = @duser_id;
				

    end else begin
    	set @pk1 = @idashboard_id;
				
set @pk2 = @iuser_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddashboard_id,@duser_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(dashboard_id)) exec audit_data 'DASHUSER','dashboard_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddashboard_id,@idashboard_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DASHUSER','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DASHUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DASHUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idashboard_id,@iuser_id, @idelete_session_id;
    else
     fetch deleted_c into @ddashboard_id,@duser_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DASHUSER'

--METADATA  TYPE:SSCR NAME:RT_DASHUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DASHUSER' and type in ('TR'))
  DROP TRIGGER RT_DASHUSER
go
--METADATA NAME:RT_DASHUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DASHUSER
on DASHUSER
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DASHUSER
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DASHUSER.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DASHUSER.create_date end
from DASHUSER WITH (INDEX(pk_dashuser)) join inserted 
on DASHUSER.dashboard_id = inserted.dashboard_id
and DASHUSER.user_id = inserted.user_id
begin
  declare ins cursor  for select dashboard_id,user_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'DASHUSER'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DASHUSER',dashboard_id,user_id,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select dashboard_id,user_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DASHUSER'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger RT_DASHUSER_DEL'

--METADATA  TYPE:SSCR NAME:RT_DASHUSER_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DASHUSER_DEL' and type in ('TR'))
  DROP TRIGGER RT_DASHUSER_DEL
go
--METADATA NAME:RT_DASHUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DASHUSER_DEL
on DASHUSER
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DASHUSER',dashboard_id,user_id,null,null
      from deleted
  	


END
go
print 'Creating trigger PRMAUD_DISCUSSION'

--METADATA  TYPE:SSCR NAME:PRMAUD_DISCUSSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DISCUSSION' and type in ('TR'))
  DROP TRIGGER PRMAUD_DISCUSSION
go
--METADATA NAME:PRMAUD_DISCUSSION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DISCUSSION
on DISCUSSION
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idiscussion_id varchar(255),@itask_id varchar(255),@idiscussion_value varchar(4000),@idiscussion_date varchar(255),@iuser_id varchar(255)
  declare @ddiscussion_id varchar(255),@dtask_id varchar(255),@ddiscussion_value varchar(4000),@ddiscussion_date varchar(255),@duser_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(discussion_id) and
			not update(task_id) and
			not update(discussion_value) and
			not update(discussion_date) and
			not update(user_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DISCUSSION', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DISCUSSION',discussion_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DISCUSSION', discussion_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select discussion_id,task_id,discussion_value,discussion_date,user_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select discussion_id,task_id,discussion_value,discussion_date,user_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idiscussion_id,@itask_id,@idiscussion_value,@idiscussion_date,@iuser_id, @idelete_session_id
  else
    fetch deleted_c into @ddiscussion_id,@dtask_id,@ddiscussion_value,@ddiscussion_date,@duser_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddiscussion_id;
				

    end else begin
    	set @pk1 = @idiscussion_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddiscussion_id,@dtask_id,@ddiscussion_value,@ddiscussion_date,@duser_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(discussion_id)) exec audit_data 'DISCUSSION','discussion_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddiscussion_id,@idiscussion_id,@audit_data OUTPUT
   if (@loper='D' or  update(task_id)) exec audit_data 'DISCUSSION','task_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtask_id,@itask_id,@audit_data OUTPUT
   if (@loper='D' or  update(discussion_value)) exec audit_data 'DISCUSSION','discussion_value',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddiscussion_value,@idiscussion_value,@audit_data OUTPUT
   if (@loper='D' or  update(discussion_date)) exec audit_data 'DISCUSSION','discussion_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddiscussion_date,@idiscussion_date,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DISCUSSION','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DISCUSSION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DISCUSSION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idiscussion_id,@itask_id,@idiscussion_value,@idiscussion_date,@iuser_id, @idelete_session_id;
    else
     fetch deleted_c into @ddiscussion_id,@dtask_id,@ddiscussion_value,@ddiscussion_date,@duser_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DISCUSSION_DEL'

--METADATA  TYPE:SSCR NAME:RT_DISCUSSION_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DISCUSSION_DEL' and type in ('TR'))
  DROP TRIGGER RT_DISCUSSION_DEL
go
--METADATA NAME:RT_DISCUSSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DISCUSSION_DEL
on DISCUSSION
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DISCUSSION',discussion_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DISCUSSION'

--METADATA  TYPE:SSCR NAME:RT_DISCUSSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DISCUSSION' and type in ('TR'))
  DROP TRIGGER RT_DISCUSSION
go
--METADATA NAME:RT_DISCUSSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DISCUSSION
on DISCUSSION
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DISCUSSION
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DISCUSSION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DISCUSSION.create_date end
from DISCUSSION WITH (INDEX(pk_discussion)) join inserted 
on DISCUSSION.discussion_id = inserted.discussion_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DISCUSSION',discussion_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select discussion_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DISCUSSION'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DISCUSSION_READ'

--METADATA  TYPE:SSCR NAME:PRMAUD_DISCUSSION_READ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DISCUSSION_READ' and type in ('TR'))
  DROP TRIGGER PRMAUD_DISCUSSION_READ
go
--METADATA NAME:PRMAUD_DISCUSSION_READ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DISCUSSION_READ
on DISCUSSION_READ
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idiscussion_id varchar(255),@iuser_id varchar(255)
  declare @ddiscussion_id varchar(255),@duser_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(discussion_id) and
			not update(user_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DISCUSSION_READ', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DISCUSSION_READ',discussion_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DISCUSSION_READ', discussion_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select discussion_id,user_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select discussion_id,user_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idiscussion_id,@iuser_id, @idelete_session_id
  else
    fetch deleted_c into @ddiscussion_id,@duser_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddiscussion_id;
				
set @pk2 = @duser_id;
				

    end else begin
    	set @pk1 = @idiscussion_id;
				
set @pk2 = @iuser_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddiscussion_id,@duser_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(discussion_id)) exec audit_data 'DISCUSSION_READ','discussion_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddiscussion_id,@idiscussion_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DISCUSSION_READ','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DISCUSSION_READ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DISCUSSION_READ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idiscussion_id,@iuser_id, @idelete_session_id;
    else
     fetch deleted_c into @ddiscussion_id,@duser_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DISCUSSION_READ_DEL'

--METADATA  TYPE:SSCR NAME:RT_DISCUSSION_READ_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DISCUSSION_READ_DEL' and type in ('TR'))
  DROP TRIGGER RT_DISCUSSION_READ_DEL
go
--METADATA NAME:RT_DISCUSSION_READ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DISCUSSION_READ_DEL
on DISCUSSION_READ
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DISCUSSION_READ',discussion_id,user_id,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DISCUSSION_READ'

--METADATA  TYPE:SSCR NAME:RT_DISCUSSION_READ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DISCUSSION_READ' and type in ('TR'))
  DROP TRIGGER RT_DISCUSSION_READ
go
--METADATA NAME:RT_DISCUSSION_READ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DISCUSSION_READ
on DISCUSSION_READ
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DISCUSSION_READ
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DISCUSSION_READ.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DISCUSSION_READ.create_date end
from DISCUSSION_READ WITH (INDEX(pk_discussion_read)) join inserted 
on DISCUSSION_READ.discussion_id = inserted.discussion_id
and DISCUSSION_READ.user_id = inserted.user_id
begin
  declare ins cursor  for select discussion_id,user_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'DISCUSSION_READ'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DISCUSSION_READ',discussion_id,user_id,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select discussion_id,user_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DISCUSSION_READ'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DOCCATG'

--METADATA  TYPE:SSCR NAME:PRMAUD_DOCCATG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DOCCATG' and type in ('TR'))
  DROP TRIGGER PRMAUD_DOCCATG
go
--METADATA NAME:PRMAUD_DOCCATG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DOCCATG
on DOCCATG
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idoc_catg_id varchar(255),@iseq_num varchar(255),@idoc_catg_name varchar(255)
  declare @ddoc_catg_id varchar(255),@dseq_num varchar(255),@ddoc_catg_name varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(doc_catg_id) and
			not update(seq_num) and
			not update(doc_catg_name) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DOCCATG', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCCATG',doc_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCCATG', doc_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select doc_catg_id,seq_num,doc_catg_name
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select doc_catg_id,seq_num,doc_catg_name
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idoc_catg_id,@iseq_num,@idoc_catg_name, @idelete_session_id
  else
    fetch deleted_c into @ddoc_catg_id,@dseq_num,@ddoc_catg_name, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddoc_catg_id;
				

    end else begin
    	set @pk1 = @idoc_catg_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddoc_catg_id,@dseq_num,@ddoc_catg_name, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(doc_catg_id)) exec audit_data 'DOCCATG','doc_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_catg_id,@idoc_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'DOCCATG','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(doc_catg_name)) exec audit_data 'DOCCATG','doc_catg_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_catg_name,@idoc_catg_name,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DOCCATG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DOCCATG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idoc_catg_id,@iseq_num,@idoc_catg_name, @idelete_session_id;
    else
     fetch deleted_c into @ddoc_catg_id,@dseq_num,@ddoc_catg_name, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DOCCATG_DEL'

--METADATA  TYPE:SSCR NAME:RT_DOCCATG_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCCATG_DEL' and type in ('TR'))
  DROP TRIGGER RT_DOCCATG_DEL
go
--METADATA NAME:RT_DOCCATG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCCATG_DEL
on DOCCATG
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCCATG',doc_catg_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DOCCATG'

--METADATA  TYPE:SSCR NAME:RT_DOCCATG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCCATG' and type in ('TR'))
  DROP TRIGGER RT_DOCCATG
go
--METADATA NAME:RT_DOCCATG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCCATG
on DOCCATG
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DOCCATG
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DOCCATG.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DOCCATG.create_date end
from DOCCATG WITH (INDEX(pk_doccatg)) join inserted 
on DOCCATG.doc_catg_id = inserted.doc_catg_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCCATG',doc_catg_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select doc_catg_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DOCCATG'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DOCREVIEW'

--METADATA  TYPE:SSCR NAME:PRMAUD_DOCREVIEW OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DOCREVIEW' and type in ('TR'))
  DROP TRIGGER PRMAUD_DOCREVIEW
go
--METADATA NAME:PRMAUD_DOCREVIEW TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DOCREVIEW
on DOCREVIEW
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idoc_review_id varchar(255),@idoc_id varchar(255),@iuser_id varchar(255),@ireview_name varchar(255),@ireview_descr varchar(255),@ireview_type varchar(255),@idue_date varchar(255),@istatus varchar(255)
  declare @ddoc_review_id varchar(255),@ddoc_id varchar(255),@duser_id varchar(255),@dreview_name varchar(255),@dreview_descr varchar(255),@dreview_type varchar(255),@ddue_date varchar(255),@dstatus varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(doc_review_id) and
			not update(doc_id) and
			not update(user_id) and
			not update(review_name) and
			not update(review_descr) and
			not update(review_type) and
			not update(due_date) and
			not update(status) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DOCREVIEW', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCREVIEW',doc_review_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCREVIEW', doc_review_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select doc_review_id,doc_id,user_id,review_name,review_descr,review_type,due_date,status
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select doc_review_id,doc_id,user_id,review_name,review_descr,review_type,due_date,status
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idoc_review_id,@idoc_id,@iuser_id,@ireview_name,@ireview_descr,@ireview_type,@idue_date,@istatus, @idelete_session_id
  else
    fetch deleted_c into @ddoc_review_id,@ddoc_id,@duser_id,@dreview_name,@dreview_descr,@dreview_type,@ddue_date,@dstatus, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddoc_review_id;
				

    end else begin
    	set @pk1 = @idoc_review_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddoc_review_id,@ddoc_id,@duser_id,@dreview_name,@dreview_descr,@dreview_type,@ddue_date,@dstatus, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(doc_review_id)) exec audit_data 'DOCREVIEW','doc_review_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_review_id,@idoc_review_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_id)) exec audit_data 'DOCREVIEW','doc_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_id,@idoc_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DOCREVIEW','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(review_name)) exec audit_data 'DOCREVIEW','review_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dreview_name,@ireview_name,@audit_data OUTPUT
   if (@loper='D' or  update(review_descr)) exec audit_data 'DOCREVIEW','review_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dreview_descr,@ireview_descr,@audit_data OUTPUT
   if (@loper='D' or  update(review_type)) exec audit_data 'DOCREVIEW','review_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dreview_type,@ireview_type,@audit_data OUTPUT
   if (@loper='D' or  update(due_date)) exec audit_data 'DOCREVIEW','due_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddue_date,@idue_date,@audit_data OUTPUT
   if (@loper='D' or  update(status)) exec audit_data 'DOCREVIEW','status',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus,@istatus,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DOCREVIEW', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DOCREVIEW', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idoc_review_id,@idoc_id,@iuser_id,@ireview_name,@ireview_descr,@ireview_type,@idue_date,@istatus, @idelete_session_id;
    else
     fetch deleted_c into @ddoc_review_id,@ddoc_id,@duser_id,@dreview_name,@dreview_descr,@dreview_type,@ddue_date,@dstatus, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DOCREVIEW_DEL'

--METADATA  TYPE:SSCR NAME:RT_DOCREVIEW_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCREVIEW_DEL' and type in ('TR'))
  DROP TRIGGER RT_DOCREVIEW_DEL
go
--METADATA NAME:RT_DOCREVIEW_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCREVIEW_DEL
on DOCREVIEW
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCREVIEW',doc_review_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DOCREVIEW'

--METADATA  TYPE:SSCR NAME:RT_DOCREVIEW OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCREVIEW' and type in ('TR'))
  DROP TRIGGER RT_DOCREVIEW
go
--METADATA NAME:RT_DOCREVIEW TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCREVIEW
on DOCREVIEW
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DOCREVIEW
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DOCREVIEW.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DOCREVIEW.create_date end
from DOCREVIEW WITH (INDEX(pk_docreview)) join inserted 
on DOCREVIEW.doc_review_id = inserted.doc_review_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCREVIEW',doc_review_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select doc_review_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DOCREVIEW'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DOCREVIEWTASK'

--METADATA  TYPE:SSCR NAME:PRMAUD_DOCREVIEWTASK OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DOCREVIEWTASK' and type in ('TR'))
  DROP TRIGGER PRMAUD_DOCREVIEWTASK
go
--METADATA NAME:PRMAUD_DOCREVIEWTASK TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DOCREVIEWTASK
on DOCREVIEWTASK
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ireview_task_id varchar(255),@idoc_review_id varchar(255),@iuser_id varchar(255),@ireview_date varchar(255),@icomments varchar(4000),@ipriority varchar(255),@istatus varchar(255),@iattachment_uuid varchar(4000)
  declare @dreview_task_id varchar(255),@ddoc_review_id varchar(255),@duser_id varchar(255),@dreview_date varchar(255),@dcomments varchar(4000),@dpriority varchar(255),@dstatus varchar(255),@dattachment_uuid varchar(4000)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(review_task_id) and
			not update(doc_review_id) and
			not update(user_id) and
			not update(review_date) and
			not update(comments) and
			not update(priority) and
			not update(status) and
			not update(attachment_uuid) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DOCREVIEWTASK', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCREVIEWTASK',review_task_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCREVIEWTASK', review_task_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select review_task_id,doc_review_id,user_id,review_date,comments,priority,status,attachment_uuid
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select review_task_id,doc_review_id,user_id,review_date,comments,priority,status,attachment_uuid
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ireview_task_id,@idoc_review_id,@iuser_id,@ireview_date,@icomments,@ipriority,@istatus,@iattachment_uuid, @idelete_session_id
  else
    fetch deleted_c into @dreview_task_id,@ddoc_review_id,@duser_id,@dreview_date,@dcomments,@dpriority,@dstatus,@dattachment_uuid, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dreview_task_id;
				

    end else begin
    	set @pk1 = @ireview_task_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dreview_task_id,@ddoc_review_id,@duser_id,@dreview_date,@dcomments,@dpriority,@dstatus,@dattachment_uuid, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(review_task_id)) exec audit_data 'DOCREVIEWTASK','review_task_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dreview_task_id,@ireview_task_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_review_id)) exec audit_data 'DOCREVIEWTASK','doc_review_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_review_id,@idoc_review_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'DOCREVIEWTASK','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(review_date)) exec audit_data 'DOCREVIEWTASK','review_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dreview_date,@ireview_date,@audit_data OUTPUT
   if (@loper='D' or  update(comments)) exec audit_data 'DOCREVIEWTASK','comments',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcomments,@icomments,@audit_data OUTPUT
   if (@loper='D' or  update(priority)) exec audit_data 'DOCREVIEWTASK','priority',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpriority,@ipriority,@audit_data OUTPUT
   if (@loper='D' or  update(status)) exec audit_data 'DOCREVIEWTASK','status',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus,@istatus,@audit_data OUTPUT
   if (@loper='D' or  update(attachment_uuid)) exec audit_data 'DOCREVIEWTASK','attachment_uuid',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dattachment_uuid,@iattachment_uuid,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DOCREVIEWTASK', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DOCREVIEWTASK', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ireview_task_id,@idoc_review_id,@iuser_id,@ireview_date,@icomments,@ipriority,@istatus,@iattachment_uuid, @idelete_session_id;
    else
     fetch deleted_c into @dreview_task_id,@ddoc_review_id,@duser_id,@dreview_date,@dcomments,@dpriority,@dstatus,@dattachment_uuid, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DOCREVIEWTASK_DEL'

--METADATA  TYPE:SSCR NAME:RT_DOCREVIEWTASK_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCREVIEWTASK_DEL' and type in ('TR'))
  DROP TRIGGER RT_DOCREVIEWTASK_DEL
go
--METADATA NAME:RT_DOCREVIEWTASK_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCREVIEWTASK_DEL
on DOCREVIEWTASK
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCREVIEWTASK',review_task_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DOCREVIEWTASK'

--METADATA  TYPE:SSCR NAME:RT_DOCREVIEWTASK OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCREVIEWTASK' and type in ('TR'))
  DROP TRIGGER RT_DOCREVIEWTASK
go
--METADATA NAME:RT_DOCREVIEWTASK TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCREVIEWTASK
on DOCREVIEWTASK
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DOCREVIEWTASK
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DOCREVIEWTASK.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DOCREVIEWTASK.create_date end
from DOCREVIEWTASK WITH (INDEX(pk_docreviewtask)) join inserted 
on DOCREVIEWTASK.review_task_id = inserted.review_task_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCREVIEWTASK',review_task_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select review_task_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DOCREVIEWTASK'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DOCSTAT'

--METADATA  TYPE:SSCR NAME:PRMAUD_DOCSTAT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DOCSTAT' and type in ('TR'))
  DROP TRIGGER PRMAUD_DOCSTAT
go
--METADATA NAME:PRMAUD_DOCSTAT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DOCSTAT
on DOCSTAT
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idoc_status_id varchar(255),@iseq_num varchar(255),@idoc_status_code varchar(255)
  declare @ddoc_status_id varchar(255),@dseq_num varchar(255),@ddoc_status_code varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(doc_status_id) and
			not update(seq_num) and
			not update(doc_status_code) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DOCSTAT', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCSTAT',doc_status_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCSTAT', doc_status_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select doc_status_id,seq_num,doc_status_code
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select doc_status_id,seq_num,doc_status_code
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idoc_status_id,@iseq_num,@idoc_status_code, @idelete_session_id
  else
    fetch deleted_c into @ddoc_status_id,@dseq_num,@ddoc_status_code, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddoc_status_id;
				

    end else begin
    	set @pk1 = @idoc_status_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddoc_status_id,@dseq_num,@ddoc_status_code, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(doc_status_id)) exec audit_data 'DOCSTAT','doc_status_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_status_id,@idoc_status_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'DOCSTAT','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(doc_status_code)) exec audit_data 'DOCSTAT','doc_status_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_status_code,@idoc_status_code,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DOCSTAT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DOCSTAT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idoc_status_id,@iseq_num,@idoc_status_code, @idelete_session_id;
    else
     fetch deleted_c into @ddoc_status_id,@dseq_num,@ddoc_status_code, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DOCSTAT_DEL'

--METADATA  TYPE:SSCR NAME:RT_DOCSTAT_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCSTAT_DEL' and type in ('TR'))
  DROP TRIGGER RT_DOCSTAT_DEL
go
--METADATA NAME:RT_DOCSTAT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCSTAT_DEL
on DOCSTAT
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCSTAT',doc_status_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_DOCSTAT'

--METADATA  TYPE:SSCR NAME:RT_DOCSTAT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCSTAT' and type in ('TR'))
  DROP TRIGGER RT_DOCSTAT
go
--METADATA NAME:RT_DOCSTAT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCSTAT
on DOCSTAT
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DOCSTAT
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DOCSTAT.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DOCSTAT.create_date end
from DOCSTAT WITH (INDEX(pk_docstat)) join inserted 
on DOCSTAT.doc_status_id = inserted.doc_status_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'DOCSTAT',doc_status_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select doc_status_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DOCSTAT'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_DOCUMENT'

--METADATA  TYPE:SSCR NAME:PRMAUD_DOCUMENT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_DOCUMENT' and type in ('TR'))
  DROP TRIGGER PRMAUD_DOCUMENT
go
--METADATA NAME:PRMAUD_DOCUMENT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_DOCUMENT
on DOCUMENT
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @idoc_id varchar(255),@idoc_seq_num varchar(255),@ideliv_flag varchar(255),@idoc_name varchar(255),@iparent_doc_id varchar(255),@iproj_id varchar(255),@idoc_status_id varchar(255),@idoc_catg_id varchar(255),@idoc_date varchar(255),@iversion_name varchar(255),@iguid varchar(255),@itmpl_guid varchar(255),@idoc_short_name varchar(255),@iauthor_name varchar(255),@iprivate_loc varchar(4000),@ipublic_loc varchar(4000),@irsrc_id varchar(255),@idoc_mgmt_type varchar(255),@iexternal_doc_key varchar(4000),@icr_external_doc_key varchar(4000)
  declare @ddoc_id varchar(255),@ddoc_seq_num varchar(255),@ddeliv_flag varchar(255),@ddoc_name varchar(255),@dparent_doc_id varchar(255),@dproj_id varchar(255),@ddoc_status_id varchar(255),@ddoc_catg_id varchar(255),@ddoc_date varchar(255),@dversion_name varchar(255),@dguid varchar(255),@dtmpl_guid varchar(255),@ddoc_short_name varchar(255),@dauthor_name varchar(255),@dprivate_loc varchar(4000),@dpublic_loc varchar(4000),@drsrc_id varchar(255),@ddoc_mgmt_type varchar(255),@dexternal_doc_key varchar(4000),@dcr_external_doc_key varchar(4000)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(doc_id) and
			not update(doc_seq_num) and
			not update(deliv_flag) and
			not update(doc_name) and
			not update(parent_doc_id) and
			not update(proj_id) and
			not update(doc_status_id) and
			not update(doc_catg_id) and
			not update(doc_date) and
			not update(version_name) and
			not update(guid) and
			not update(tmpl_guid) and
			not update(doc_short_name) and
			not update(author_name) and
			not update(private_loc) and
			not update(public_loc) and
			not update(rsrc_id) and
			not update(doc_mgmt_type) and
			not update(external_doc_key) and
			not update(cr_external_doc_key) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'DOCUMENT', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCUMENT',doc_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'DOCUMENT', doc_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select doc_id,doc_seq_num,deliv_flag,doc_name,parent_doc_id,proj_id,doc_status_id,doc_catg_id,doc_date,version_name,guid,tmpl_guid,doc_short_name,author_name,private_loc,public_loc,rsrc_id,doc_mgmt_type,external_doc_key,cr_external_doc_key
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select doc_id,doc_seq_num,deliv_flag,doc_name,parent_doc_id,proj_id,doc_status_id,doc_catg_id,doc_date,version_name,guid,tmpl_guid,doc_short_name,author_name,private_loc,public_loc,rsrc_id,doc_mgmt_type,external_doc_key,cr_external_doc_key
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @idoc_id,@idoc_seq_num,@ideliv_flag,@idoc_name,@iparent_doc_id,@iproj_id,@idoc_status_id,@idoc_catg_id,@idoc_date,@iversion_name,@iguid,@itmpl_guid,@idoc_short_name,@iauthor_name,@iprivate_loc,@ipublic_loc,@irsrc_id,@idoc_mgmt_type,@iexternal_doc_key,@icr_external_doc_key, @idelete_session_id
  else
    fetch deleted_c into @ddoc_id,@ddoc_seq_num,@ddeliv_flag,@ddoc_name,@dparent_doc_id,@dproj_id,@ddoc_status_id,@ddoc_catg_id,@ddoc_date,@dversion_name,@dguid,@dtmpl_guid,@ddoc_short_name,@dauthor_name,@dprivate_loc,@dpublic_loc,@drsrc_id,@ddoc_mgmt_type,@dexternal_doc_key,@dcr_external_doc_key, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @ddoc_id;
				

    end else begin
    	set @pk1 = @idoc_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @ddoc_id,@ddoc_seq_num,@ddeliv_flag,@ddoc_name,@dparent_doc_id,@dproj_id,@ddoc_status_id,@ddoc_catg_id,@ddoc_date,@dversion_name,@dguid,@dtmpl_guid,@ddoc_short_name,@dauthor_name,@dprivate_loc,@dpublic_loc,@drsrc_id,@ddoc_mgmt_type,@dexternal_doc_key,@dcr_external_doc_key, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(doc_id)) exec audit_data 'DOCUMENT','doc_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_id,@idoc_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_seq_num)) exec audit_data 'DOCUMENT','doc_seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_seq_num,@idoc_seq_num,@audit_data OUTPUT
   if (@loper='D' or  update(deliv_flag)) exec audit_data 'DOCUMENT','deliv_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddeliv_flag,@ideliv_flag,@audit_data OUTPUT
   if (@loper='D' or  update(doc_name)) exec audit_data 'DOCUMENT','doc_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_name,@idoc_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_doc_id)) exec audit_data 'DOCUMENT','parent_doc_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_doc_id,@iparent_doc_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'DOCUMENT','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_status_id)) exec audit_data 'DOCUMENT','doc_status_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_status_id,@idoc_status_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_catg_id)) exec audit_data 'DOCUMENT','doc_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_catg_id,@idoc_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_date)) exec audit_data 'DOCUMENT','doc_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_date,@idoc_date,@audit_data OUTPUT
   if (@loper='D' or  update(version_name)) exec audit_data 'DOCUMENT','version_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dversion_name,@iversion_name,@audit_data OUTPUT
   if (@loper='D' or  update(guid)) exec audit_data 'DOCUMENT','guid',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dguid,@iguid,@audit_data OUTPUT
   if (@loper='D' or  update(tmpl_guid)) exec audit_data 'DOCUMENT','tmpl_guid',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtmpl_guid,@itmpl_guid,@audit_data OUTPUT
   if (@loper='D' or  update(doc_short_name)) exec audit_data 'DOCUMENT','doc_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_short_name,@idoc_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(author_name)) exec audit_data 'DOCUMENT','author_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dauthor_name,@iauthor_name,@audit_data OUTPUT
   if (@loper='D' or  update(private_loc)) exec audit_data 'DOCUMENT','private_loc',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dprivate_loc,@iprivate_loc,@audit_data OUTPUT
   if (@loper='D' or  update(public_loc)) exec audit_data 'DOCUMENT','public_loc',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpublic_loc,@ipublic_loc,@audit_data OUTPUT
   if (@loper='D' or  update(rsrc_id)) exec audit_data 'DOCUMENT','rsrc_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drsrc_id,@irsrc_id,@audit_data OUTPUT
   if (@loper='D' or  update(doc_mgmt_type)) exec audit_data 'DOCUMENT','doc_mgmt_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddoc_mgmt_type,@idoc_mgmt_type,@audit_data OUTPUT
   if (@loper='D' or  update(external_doc_key)) exec audit_data 'DOCUMENT','external_doc_key',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dexternal_doc_key,@iexternal_doc_key,@audit_data OUTPUT
   if (@loper='D' or  update(cr_external_doc_key)) exec audit_data 'DOCUMENT','cr_external_doc_key',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcr_external_doc_key,@icr_external_doc_key,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'DOCUMENT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'DOCUMENT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @idoc_id,@idoc_seq_num,@ideliv_flag,@idoc_name,@iparent_doc_id,@iproj_id,@idoc_status_id,@idoc_catg_id,@idoc_date,@iversion_name,@iguid,@itmpl_guid,@idoc_short_name,@iauthor_name,@iprivate_loc,@ipublic_loc,@irsrc_id,@idoc_mgmt_type,@iexternal_doc_key,@icr_external_doc_key, @idelete_session_id;
    else
     fetch deleted_c into @ddoc_id,@ddoc_seq_num,@ddeliv_flag,@ddoc_name,@dparent_doc_id,@dproj_id,@ddoc_status_id,@ddoc_catg_id,@ddoc_date,@dversion_name,@dguid,@dtmpl_guid,@ddoc_short_name,@dauthor_name,@dprivate_loc,@dpublic_loc,@drsrc_id,@ddoc_mgmt_type,@dexternal_doc_key,@dcr_external_doc_key, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_DOCUMENT_DEL'

--METADATA  TYPE:SSCR NAME:RT_DOCUMENT_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCUMENT_DEL' and type in ('TR'))
  DROP TRIGGER RT_DOCUMENT_DEL
go
--METADATA NAME:RT_DOCUMENT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCUMENT_DEL
on DOCUMENT
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'DOCUMENT',doc_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_DOCUMENT'

--METADATA  TYPE:SSCR NAME:RT_DOCUMENT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_DOCUMENT' and type in ('TR'))
  DROP TRIGGER RT_DOCUMENT
go
--METADATA NAME:RT_DOCUMENT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_DOCUMENT
on DOCUMENT
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update DOCUMENT
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else DOCUMENT.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else DOCUMENT.create_date end
from DOCUMENT WITH (INDEX(pk_document)) join inserted 
on DOCUMENT.doc_id = inserted.doc_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'DOCUMENT',doc_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select doc_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'DOCUMENT'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_EXPPROJ'

--METADATA  TYPE:SSCR NAME:PRMAUD_EXPPROJ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_EXPPROJ' and type in ('TR'))
  DROP TRIGGER PRMAUD_EXPPROJ
go
--METADATA NAME:PRMAUD_EXPPROJ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_EXPPROJ
on EXPPROJ
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iproj_id varchar(255),@iexp_group varchar(255),@iexp_proj_name varchar(255),@ilogin_supplied_flag varchar(255),@iexp_user_name varchar(255),@iexp_passwd varchar(255)
  declare @dproj_id varchar(255),@dexp_group varchar(255),@dexp_proj_name varchar(255),@dlogin_supplied_flag varchar(255),@dexp_user_name varchar(255),@dexp_passwd varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(proj_id) and
			not update(exp_group) and
			not update(exp_proj_name) and
			not update(login_supplied_flag) and
			not update(exp_user_name) and
			not update(exp_passwd) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'EXPPROJ', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'EXPPROJ',proj_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'EXPPROJ', proj_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select proj_id,exp_group,exp_proj_name,login_supplied_flag,exp_user_name,exp_passwd
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select proj_id,exp_group,exp_proj_name,login_supplied_flag,exp_user_name,exp_passwd
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iproj_id,@iexp_group,@iexp_proj_name,@ilogin_supplied_flag,@iexp_user_name,@iexp_passwd, @idelete_session_id
  else
    fetch deleted_c into @dproj_id,@dexp_group,@dexp_proj_name,@dlogin_supplied_flag,@dexp_user_name,@dexp_passwd, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dproj_id;
				

    end else begin
    	set @pk1 = @iproj_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dproj_id,@dexp_group,@dexp_proj_name,@dlogin_supplied_flag,@dexp_user_name,@dexp_passwd, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(proj_id)) exec audit_data 'EXPPROJ','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(exp_group)) exec audit_data 'EXPPROJ','exp_group',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dexp_group,@iexp_group,@audit_data OUTPUT
   if (@loper='D' or  update(exp_proj_name)) exec audit_data 'EXPPROJ','exp_proj_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dexp_proj_name,@iexp_proj_name,@audit_data OUTPUT
   if (@loper='D' or  update(login_supplied_flag)) exec audit_data 'EXPPROJ','login_supplied_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlogin_supplied_flag,@ilogin_supplied_flag,@audit_data OUTPUT
   if (@loper='D' or  update(exp_user_name)) exec audit_data 'EXPPROJ','exp_user_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dexp_user_name,@iexp_user_name,@audit_data OUTPUT
   if (@loper='D' or  update(exp_passwd)) exec audit_data 'EXPPROJ','exp_passwd',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dexp_passwd,@iexp_passwd,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'EXPPROJ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'EXPPROJ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iproj_id,@iexp_group,@iexp_proj_name,@ilogin_supplied_flag,@iexp_user_name,@iexp_passwd, @idelete_session_id;
    else
     fetch deleted_c into @dproj_id,@dexp_group,@dexp_proj_name,@dlogin_supplied_flag,@dexp_user_name,@dexp_passwd, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_EXPPROJ_DEL'

--METADATA  TYPE:SSCR NAME:RT_EXPPROJ_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_EXPPROJ_DEL' and type in ('TR'))
  DROP TRIGGER RT_EXPPROJ_DEL
go
--METADATA NAME:RT_EXPPROJ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_EXPPROJ_DEL
on EXPPROJ
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'EXPPROJ',proj_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_EXPPROJ'

--METADATA  TYPE:SSCR NAME:RT_EXPPROJ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_EXPPROJ' and type in ('TR'))
  DROP TRIGGER RT_EXPPROJ
go
--METADATA NAME:RT_EXPPROJ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_EXPPROJ
on EXPPROJ
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update EXPPROJ
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else EXPPROJ.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else EXPPROJ.create_date end
from EXPPROJ WITH (INDEX(pk_expproj)) join inserted 
on EXPPROJ.proj_id = inserted.proj_id
begin
  declare ins cursor  for select proj_id,null,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'EXPPROJ'
    and  @pk1 = refrdel.pk1
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'EXPPROJ',proj_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select proj_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'EXPPROJ'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_EXTAPP'

--METADATA  TYPE:SSCR NAME:PRMAUD_EXTAPP OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_EXTAPP' and type in ('TR'))
  DROP TRIGGER PRMAUD_EXTAPP
go
--METADATA NAME:PRMAUD_EXTAPP TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_EXTAPP
on EXTAPP
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iapp_id varchar(255),@ilogin_supply_flag varchar(255),@iapp_name varchar(255),@iapp_exe_name varchar(255),@iproj_id varchar(255),@iapp_user_name varchar(255),@iapp_passwd varchar(255),@iapp_data_name varchar(255),@iapp_parm_string varchar(255),@iapp_data_loc varchar(255)
  declare @dapp_id varchar(255),@dlogin_supply_flag varchar(255),@dapp_name varchar(255),@dapp_exe_name varchar(255),@dproj_id varchar(255),@dapp_user_name varchar(255),@dapp_passwd varchar(255),@dapp_data_name varchar(255),@dapp_parm_string varchar(255),@dapp_data_loc varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(app_id) and
			not update(login_supply_flag) and
			not update(app_name) and
			not update(app_exe_name) and
			not update(proj_id) and
			not update(app_user_name) and
			not update(app_passwd) and
			not update(app_data_name) and
			not update(app_parm_string) and
			not update(app_data_loc) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'EXTAPP', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'EXTAPP',app_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'EXTAPP', app_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select app_id,login_supply_flag,app_name,app_exe_name,proj_id,app_user_name,app_passwd,app_data_name,app_parm_string,app_data_loc
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select app_id,login_supply_flag,app_name,app_exe_name,proj_id,app_user_name,app_passwd,app_data_name,app_parm_string,app_data_loc
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iapp_id,@ilogin_supply_flag,@iapp_name,@iapp_exe_name,@iproj_id,@iapp_user_name,@iapp_passwd,@iapp_data_name,@iapp_parm_string,@iapp_data_loc, @idelete_session_id
  else
    fetch deleted_c into @dapp_id,@dlogin_supply_flag,@dapp_name,@dapp_exe_name,@dproj_id,@dapp_user_name,@dapp_passwd,@dapp_data_name,@dapp_parm_string,@dapp_data_loc, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dapp_id;
				

    end else begin
    	set @pk1 = @iapp_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dapp_id,@dlogin_supply_flag,@dapp_name,@dapp_exe_name,@dproj_id,@dapp_user_name,@dapp_passwd,@dapp_data_name,@dapp_parm_string,@dapp_data_loc, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(app_id)) exec audit_data 'EXTAPP','app_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_id,@iapp_id,@audit_data OUTPUT
   if (@loper='D' or  update(login_supply_flag)) exec audit_data 'EXTAPP','login_supply_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlogin_supply_flag,@ilogin_supply_flag,@audit_data OUTPUT
   if (@loper='D' or  update(app_name)) exec audit_data 'EXTAPP','app_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_name,@iapp_name,@audit_data OUTPUT
   if (@loper='D' or  update(app_exe_name)) exec audit_data 'EXTAPP','app_exe_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_exe_name,@iapp_exe_name,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'EXTAPP','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(app_user_name)) exec audit_data 'EXTAPP','app_user_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_user_name,@iapp_user_name,@audit_data OUTPUT
   if (@loper='D' or  update(app_passwd)) exec audit_data 'EXTAPP','app_passwd',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_passwd,@iapp_passwd,@audit_data OUTPUT
   if (@loper='D' or  update(app_data_name)) exec audit_data 'EXTAPP','app_data_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_data_name,@iapp_data_name,@audit_data OUTPUT
   if (@loper='D' or  update(app_parm_string)) exec audit_data 'EXTAPP','app_parm_string',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_parm_string,@iapp_parm_string,@audit_data OUTPUT
   if (@loper='D' or  update(app_data_loc)) exec audit_data 'EXTAPP','app_data_loc',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dapp_data_loc,@iapp_data_loc,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'EXTAPP', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'EXTAPP', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iapp_id,@ilogin_supply_flag,@iapp_name,@iapp_exe_name,@iproj_id,@iapp_user_name,@iapp_passwd,@iapp_data_name,@iapp_parm_string,@iapp_data_loc, @idelete_session_id;
    else
     fetch deleted_c into @dapp_id,@dlogin_supply_flag,@dapp_name,@dapp_exe_name,@dproj_id,@dapp_user_name,@dapp_passwd,@dapp_data_name,@dapp_parm_string,@dapp_data_loc, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_EXTAPP_DEL'

--METADATA  TYPE:SSCR NAME:RT_EXTAPP_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_EXTAPP_DEL' and type in ('TR'))
  DROP TRIGGER RT_EXTAPP_DEL
go
--METADATA NAME:RT_EXTAPP_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_EXTAPP_DEL
on EXTAPP
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'EXTAPP',app_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_EXTAPP'

--METADATA  TYPE:SSCR NAME:RT_EXTAPP OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_EXTAPP' and type in ('TR'))
  DROP TRIGGER RT_EXTAPP
go
--METADATA NAME:RT_EXTAPP TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_EXTAPP
on EXTAPP
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update EXTAPP
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else EXTAPP.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else EXTAPP.create_date end
from EXTAPP WITH (INDEX(pk_extapp)) join inserted 
on EXTAPP.app_id = inserted.app_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'EXTAPP',app_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select app_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'EXTAPP'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FACTOR'

--METADATA  TYPE:SSCR NAME:PRMAUD_FACTOR OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FACTOR' and type in ('TR'))
  DROP TRIGGER PRMAUD_FACTOR
go
--METADATA NAME:PRMAUD_FACTOR TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FACTOR
on FACTOR
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifact_id varchar(255),@ifact_seq_num varchar(255),@ifact_type varchar(255),@ifact_name varchar(255),@idef_fact_val_id varchar(255)
  declare @dfact_id varchar(255),@dfact_seq_num varchar(255),@dfact_type varchar(255),@dfact_name varchar(255),@ddef_fact_val_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(fact_id) and
			not update(fact_seq_num) and
			not update(fact_type) and
			not update(fact_name) and
			not update(def_fact_val_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FACTOR', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FACTOR',fact_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FACTOR', fact_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select fact_id,fact_seq_num,fact_type,fact_name,def_fact_val_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select fact_id,fact_seq_num,fact_type,fact_name,def_fact_val_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifact_id,@ifact_seq_num,@ifact_type,@ifact_name,@idef_fact_val_id, @idelete_session_id
  else
    fetch deleted_c into @dfact_id,@dfact_seq_num,@dfact_type,@dfact_name,@ddef_fact_val_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfact_id;
				

    end else begin
    	set @pk1 = @ifact_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfact_id,@dfact_seq_num,@dfact_type,@dfact_name,@ddef_fact_val_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(fact_id)) exec audit_data 'FACTOR','fact_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_id,@ifact_id,@audit_data OUTPUT
   if (@loper='D' or  update(fact_seq_num)) exec audit_data 'FACTOR','fact_seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_seq_num,@ifact_seq_num,@audit_data OUTPUT
   if (@loper='D' or  update(fact_type)) exec audit_data 'FACTOR','fact_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_type,@ifact_type,@audit_data OUTPUT
   if (@loper='D' or  update(fact_name)) exec audit_data 'FACTOR','fact_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_name,@ifact_name,@audit_data OUTPUT
   if (@loper='D' or  update(def_fact_val_id)) exec audit_data 'FACTOR','def_fact_val_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddef_fact_val_id,@idef_fact_val_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FACTOR', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FACTOR', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifact_id,@ifact_seq_num,@ifact_type,@ifact_name,@idef_fact_val_id, @idelete_session_id;
    else
     fetch deleted_c into @dfact_id,@dfact_seq_num,@dfact_type,@dfact_name,@ddef_fact_val_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FACTOR_DEL'

--METADATA  TYPE:SSCR NAME:RT_FACTOR_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FACTOR_DEL' and type in ('TR'))
  DROP TRIGGER RT_FACTOR_DEL
go
--METADATA NAME:RT_FACTOR_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FACTOR_DEL
on FACTOR
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FACTOR',fact_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FACTOR'

--METADATA  TYPE:SSCR NAME:RT_FACTOR OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FACTOR' and type in ('TR'))
  DROP TRIGGER RT_FACTOR
go
--METADATA NAME:RT_FACTOR TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FACTOR
on FACTOR
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FACTOR
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FACTOR.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FACTOR.create_date end
from FACTOR WITH (INDEX(pk_factor)) join inserted 
on FACTOR.fact_id = inserted.fact_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FACTOR',fact_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select fact_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FACTOR'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FACTVAL'

--METADATA  TYPE:SSCR NAME:PRMAUD_FACTVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FACTVAL' and type in ('TR'))
  DROP TRIGGER PRMAUD_FACTVAL
go
--METADATA NAME:PRMAUD_FACTVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FACTVAL
on FACTVAL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifact_val_id varchar(255),@ifact_id varchar(255),@ifact_value varchar(255),@ifact_value_descr varchar(255)
  declare @dfact_val_id varchar(255),@dfact_id varchar(255),@dfact_value varchar(255),@dfact_value_descr varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(fact_val_id) and
			not update(fact_id) and
			not update(fact_value) and
			not update(fact_value_descr) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FACTVAL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FACTVAL',fact_val_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FACTVAL', fact_val_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select fact_val_id,fact_id,fact_value,fact_value_descr
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select fact_val_id,fact_id,fact_value,fact_value_descr
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifact_val_id,@ifact_id,@ifact_value,@ifact_value_descr, @idelete_session_id
  else
    fetch deleted_c into @dfact_val_id,@dfact_id,@dfact_value,@dfact_value_descr, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfact_val_id;
				

    end else begin
    	set @pk1 = @ifact_val_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfact_val_id,@dfact_id,@dfact_value,@dfact_value_descr, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(fact_val_id)) exec audit_data 'FACTVAL','fact_val_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_val_id,@ifact_val_id,@audit_data OUTPUT
   if (@loper='D' or  update(fact_id)) exec audit_data 'FACTVAL','fact_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_id,@ifact_id,@audit_data OUTPUT
   if (@loper='D' or  update(fact_value)) exec audit_data 'FACTVAL','fact_value',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_value,@ifact_value,@audit_data OUTPUT
   if (@loper='D' or  update(fact_value_descr)) exec audit_data 'FACTVAL','fact_value_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfact_value_descr,@ifact_value_descr,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FACTVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FACTVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifact_val_id,@ifact_id,@ifact_value,@ifact_value_descr, @idelete_session_id;
    else
     fetch deleted_c into @dfact_val_id,@dfact_id,@dfact_value,@dfact_value_descr, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FACTVAL_DEL'

--METADATA  TYPE:SSCR NAME:RT_FACTVAL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FACTVAL_DEL' and type in ('TR'))
  DROP TRIGGER RT_FACTVAL_DEL
go
--METADATA NAME:RT_FACTVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FACTVAL_DEL
on FACTVAL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FACTVAL',fact_val_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FACTVAL'

--METADATA  TYPE:SSCR NAME:RT_FACTVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FACTVAL' and type in ('TR'))
  DROP TRIGGER RT_FACTVAL
go
--METADATA NAME:RT_FACTVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FACTVAL
on FACTVAL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FACTVAL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FACTVAL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FACTVAL.create_date end
from FACTVAL WITH (INDEX(pk_factval)) join inserted 
on FACTVAL.fact_val_id = inserted.fact_val_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FACTVAL',fact_val_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select fact_val_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FACTVAL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FILTPROP'

--METADATA  TYPE:SSCR NAME:PRMAUD_FILTPROP OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FILTPROP' and type in ('TR'))
  DROP TRIGGER PRMAUD_FILTPROP
go
--METADATA NAME:PRMAUD_FILTPROP TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FILTPROP
on FILTPROP
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifilter_id varchar(255),@itable_name varchar(255),@ifilter_type varchar(255),@ifilter_name varchar(255),@iuser_id varchar(255),@irpt_id varchar(255)
  declare @dfilter_id varchar(255),@dtable_name varchar(255),@dfilter_type varchar(255),@dfilter_name varchar(255),@duser_id varchar(255),@drpt_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(filter_id) and
			not update(table_name) and
			not update(filter_type) and
			not update(filter_name) and
			not update(user_id) and
			not update(rpt_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FILTPROP', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FILTPROP',filter_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FILTPROP', filter_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select filter_id,table_name,filter_type,filter_name,user_id,rpt_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select filter_id,table_name,filter_type,filter_name,user_id,rpt_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifilter_id,@itable_name,@ifilter_type,@ifilter_name,@iuser_id,@irpt_id, @idelete_session_id
  else
    fetch deleted_c into @dfilter_id,@dtable_name,@dfilter_type,@dfilter_name,@duser_id,@drpt_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfilter_id;
				

    end else begin
    	set @pk1 = @ifilter_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfilter_id,@dtable_name,@dfilter_type,@dfilter_name,@duser_id,@drpt_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(filter_id)) exec audit_data 'FILTPROP','filter_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfilter_id,@ifilter_id,@audit_data OUTPUT
   if (@loper='D' or  update(table_name)) exec audit_data 'FILTPROP','table_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtable_name,@itable_name,@audit_data OUTPUT
   if (@loper='D' or  update(filter_type)) exec audit_data 'FILTPROP','filter_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfilter_type,@ifilter_type,@audit_data OUTPUT
   if (@loper='D' or  update(filter_name)) exec audit_data 'FILTPROP','filter_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfilter_name,@ifilter_name,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'FILTPROP','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(rpt_id)) exec audit_data 'FILTPROP','rpt_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drpt_id,@irpt_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FILTPROP', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FILTPROP', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifilter_id,@itable_name,@ifilter_type,@ifilter_name,@iuser_id,@irpt_id, @idelete_session_id;
    else
     fetch deleted_c into @dfilter_id,@dtable_name,@dfilter_type,@dfilter_name,@duser_id,@drpt_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FILTPROP_DEL'

--METADATA  TYPE:SSCR NAME:RT_FILTPROP_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FILTPROP_DEL' and type in ('TR'))
  DROP TRIGGER RT_FILTPROP_DEL
go
--METADATA NAME:RT_FILTPROP_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FILTPROP_DEL
on FILTPROP
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FILTPROP',filter_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FILTPROP'

--METADATA  TYPE:SSCR NAME:RT_FILTPROP OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FILTPROP' and type in ('TR'))
  DROP TRIGGER RT_FILTPROP
go
--METADATA NAME:RT_FILTPROP TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FILTPROP
on FILTPROP
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FILTPROP
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FILTPROP.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FILTPROP.create_date end
from FILTPROP WITH (INDEX(pk_filtprop)) join inserted 
on FILTPROP.filter_id = inserted.filter_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FILTPROP',filter_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select filter_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FILTPROP'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FINDATES'

--METADATA  TYPE:SSCR NAME:PRMAUD_FINDATES OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FINDATES' and type in ('TR'))
  DROP TRIGGER PRMAUD_FINDATES
go
--METADATA NAME:PRMAUD_FINDATES TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FINDATES
on FINDATES
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifin_dates_id varchar(255),@ifin_dates_name varchar(255),@istart_date varchar(255),@iend_date varchar(255),@ifintmpl_id varchar(255)
  declare @dfin_dates_id varchar(255),@dfin_dates_name varchar(255),@dstart_date varchar(255),@dend_date varchar(255),@dfintmpl_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(fin_dates_id) and
			not update(fin_dates_name) and
			not update(start_date) and
			not update(end_date) and
			not update(fintmpl_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FINDATES', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FINDATES',fin_dates_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FINDATES', fin_dates_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select fin_dates_id,fin_dates_name,start_date,end_date,fintmpl_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select fin_dates_id,fin_dates_name,start_date,end_date,fintmpl_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifin_dates_id,@ifin_dates_name,@istart_date,@iend_date,@ifintmpl_id, @idelete_session_id
  else
    fetch deleted_c into @dfin_dates_id,@dfin_dates_name,@dstart_date,@dend_date,@dfintmpl_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfin_dates_id;
				

    end else begin
    	set @pk1 = @ifin_dates_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfin_dates_id,@dfin_dates_name,@dstart_date,@dend_date,@dfintmpl_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(fin_dates_id)) exec audit_data 'FINDATES','fin_dates_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfin_dates_id,@ifin_dates_id,@audit_data OUTPUT
   if (@loper='D' or  update(fin_dates_name)) exec audit_data 'FINDATES','fin_dates_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfin_dates_name,@ifin_dates_name,@audit_data OUTPUT
   if (@loper='D' or  update(start_date)) exec audit_data 'FINDATES','start_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstart_date,@istart_date,@audit_data OUTPUT
   if (@loper='D' or  update(end_date)) exec audit_data 'FINDATES','end_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dend_date,@iend_date,@audit_data OUTPUT
   if (@loper='D' or  update(fintmpl_id)) exec audit_data 'FINDATES','fintmpl_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfintmpl_id,@ifintmpl_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FINDATES', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FINDATES', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifin_dates_id,@ifin_dates_name,@istart_date,@iend_date,@ifintmpl_id, @idelete_session_id;
    else
     fetch deleted_c into @dfin_dates_id,@dfin_dates_name,@dstart_date,@dend_date,@dfintmpl_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FINDATES_DEL'

--METADATA  TYPE:SSCR NAME:RT_FINDATES_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FINDATES_DEL' and type in ('TR'))
  DROP TRIGGER RT_FINDATES_DEL
go
--METADATA NAME:RT_FINDATES_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FINDATES_DEL
on FINDATES
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FINDATES',fin_dates_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FINDATES'

--METADATA  TYPE:SSCR NAME:RT_FINDATES OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FINDATES' and type in ('TR'))
  DROP TRIGGER RT_FINDATES
go
--METADATA NAME:RT_FINDATES TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FINDATES
on FINDATES
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FINDATES
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FINDATES.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FINDATES.create_date end
from FINDATES WITH (INDEX(pk_findates)) join inserted 
on FINDATES.fin_dates_id = inserted.fin_dates_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FINDATES',fin_dates_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select fin_dates_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FINDATES'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FINTMPL'

--METADATA  TYPE:SSCR NAME:PRMAUD_FINTMPL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FINTMPL' and type in ('TR'))
  DROP TRIGGER PRMAUD_FINTMPL
go
--METADATA NAME:PRMAUD_FINTMPL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FINTMPL
on FINTMPL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifintmpl_id varchar(255),@ifintmpl_name varchar(255),@idefault_flag varchar(255)
  declare @dfintmpl_id varchar(255),@dfintmpl_name varchar(255),@ddefault_flag varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(fintmpl_id) and
			not update(fintmpl_name) and
			not update(default_flag) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FINTMPL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FINTMPL',fintmpl_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FINTMPL', fintmpl_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select fintmpl_id,fintmpl_name,default_flag
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select fintmpl_id,fintmpl_name,default_flag
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifintmpl_id,@ifintmpl_name,@idefault_flag, @idelete_session_id
  else
    fetch deleted_c into @dfintmpl_id,@dfintmpl_name,@ddefault_flag, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfintmpl_id;
				

    end else begin
    	set @pk1 = @ifintmpl_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfintmpl_id,@dfintmpl_name,@ddefault_flag, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(fintmpl_id)) exec audit_data 'FINTMPL','fintmpl_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfintmpl_id,@ifintmpl_id,@audit_data OUTPUT
   if (@loper='D' or  update(fintmpl_name)) exec audit_data 'FINTMPL','fintmpl_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfintmpl_name,@ifintmpl_name,@audit_data OUTPUT
   if (@loper='D' or  update(default_flag)) exec audit_data 'FINTMPL','default_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddefault_flag,@idefault_flag,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FINTMPL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FINTMPL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifintmpl_id,@ifintmpl_name,@idefault_flag, @idelete_session_id;
    else
     fetch deleted_c into @dfintmpl_id,@dfintmpl_name,@ddefault_flag, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FINTMPL_DEL'

--METADATA  TYPE:SSCR NAME:RT_FINTMPL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FINTMPL_DEL' and type in ('TR'))
  DROP TRIGGER RT_FINTMPL_DEL
go
--METADATA NAME:RT_FINTMPL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FINTMPL_DEL
on FINTMPL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FINTMPL',fintmpl_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FINTMPL'

--METADATA  TYPE:SSCR NAME:RT_FINTMPL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FINTMPL' and type in ('TR'))
  DROP TRIGGER RT_FINTMPL
go
--METADATA NAME:RT_FINTMPL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FINTMPL
on FINTMPL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FINTMPL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FINTMPL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FINTMPL.create_date end
from FINTMPL WITH (INDEX(pk_fintmpl)) join inserted 
on FINTMPL.fintmpl_id = inserted.fintmpl_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FINTMPL',fintmpl_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select fintmpl_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FINTMPL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FORMCATG'

--METADATA  TYPE:SSCR NAME:PRMAUD_FORMCATG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FORMCATG' and type in ('TR'))
  DROP TRIGGER PRMAUD_FORMCATG
go
--METADATA NAME:PRMAUD_FORMCATG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FORMCATG
on FORMCATG
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iform_catg_id varchar(255),@iform_catg_name varchar(255)
  declare @dform_catg_id varchar(255),@dform_catg_name varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(form_catg_id) and
			not update(form_catg_name) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FORMCATG', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMCATG',form_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMCATG', form_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select form_catg_id,form_catg_name
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select form_catg_id,form_catg_name
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iform_catg_id,@iform_catg_name, @idelete_session_id
  else
    fetch deleted_c into @dform_catg_id,@dform_catg_name, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dform_catg_id;
				

    end else begin
    	set @pk1 = @iform_catg_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dform_catg_id,@dform_catg_name, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(form_catg_id)) exec audit_data 'FORMCATG','form_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_catg_id,@iform_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(form_catg_name)) exec audit_data 'FORMCATG','form_catg_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_catg_name,@iform_catg_name,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FORMCATG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FORMCATG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iform_catg_id,@iform_catg_name, @idelete_session_id;
    else
     fetch deleted_c into @dform_catg_id,@dform_catg_name, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FORMCATG_DEL'

--METADATA  TYPE:SSCR NAME:RT_FORMCATG_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMCATG_DEL' and type in ('TR'))
  DROP TRIGGER RT_FORMCATG_DEL
go
--METADATA NAME:RT_FORMCATG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMCATG_DEL
on FORMCATG
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FORMCATG',form_catg_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FORMCATG'

--METADATA  TYPE:SSCR NAME:RT_FORMCATG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMCATG' and type in ('TR'))
  DROP TRIGGER RT_FORMCATG
go
--METADATA NAME:RT_FORMCATG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMCATG
on FORMCATG
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FORMCATG
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FORMCATG.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FORMCATG.create_date end
from FORMCATG WITH (INDEX(pk_formcatg)) join inserted 
on FORMCATG.form_catg_id = inserted.form_catg_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FORMCATG',form_catg_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select form_catg_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FORMCATG'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FORMPROJ'

--METADATA  TYPE:SSCR NAME:PRMAUD_FORMPROJ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FORMPROJ' and type in ('TR'))
  DROP TRIGGER PRMAUD_FORMPROJ
go
--METADATA NAME:PRMAUD_FORMPROJ TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FORMPROJ
on FORMPROJ
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iform_tmpl_id varchar(255),@iproj_id varchar(255)
  declare @dform_tmpl_id varchar(255),@dproj_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(form_tmpl_id) and
			not update(proj_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FORMPROJ', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMPROJ',form_tmpl_id,proj_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMPROJ', form_tmpl_id,proj_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select form_tmpl_id,proj_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select form_tmpl_id,proj_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iform_tmpl_id,@iproj_id, @idelete_session_id
  else
    fetch deleted_c into @dform_tmpl_id,@dproj_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dform_tmpl_id;
				
set @pk2 = @dproj_id;
				

    end else begin
    	set @pk1 = @iform_tmpl_id;
				
set @pk2 = @iproj_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dform_tmpl_id,@dproj_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(form_tmpl_id)) exec audit_data 'FORMPROJ','form_tmpl_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_tmpl_id,@iform_tmpl_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'FORMPROJ','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FORMPROJ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FORMPROJ', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iform_tmpl_id,@iproj_id, @idelete_session_id;
    else
     fetch deleted_c into @dform_tmpl_id,@dproj_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FORMPROJ_DEL'

--METADATA  TYPE:SSCR NAME:RT_FORMPROJ_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMPROJ_DEL' and type in ('TR'))
  DROP TRIGGER RT_FORMPROJ_DEL
go
--METADATA NAME:RT_FORMPROJ_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMPROJ_DEL
on FORMPROJ
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'FORMPROJ',form_tmpl_id,proj_id,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_FORMPROJ'

--METADATA  TYPE:SSCR NAME:RT_FORMPROJ OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMPROJ' and type in ('TR'))
  DROP TRIGGER RT_FORMPROJ
go
--METADATA NAME:RT_FORMPROJ TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMPROJ
on FORMPROJ
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FORMPROJ
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FORMPROJ.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FORMPROJ.create_date end
from FORMPROJ WITH (INDEX(pk_formproj)) join inserted 
on FORMPROJ.form_tmpl_id = inserted.form_tmpl_id
and FORMPROJ.proj_id = inserted.proj_id
begin
  declare ins cursor  for select form_tmpl_id,proj_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'FORMPROJ'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'FORMPROJ',form_tmpl_id,proj_id,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select form_tmpl_id,proj_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FORMPROJ'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FORMTMPL'

--METADATA  TYPE:SSCR NAME:PRMAUD_FORMTMPL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FORMTMPL' and type in ('TR'))
  DROP TRIGGER PRMAUD_FORMTMPL
go
--METADATA NAME:PRMAUD_FORMTMPL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FORMTMPL
on FORMTMPL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iform_tmpl_id varchar(255),@iform_tmpl_name varchar(255),@iform_tmpl_desc varchar(4000),@iform_catg_id varchar(255)
  declare @dform_tmpl_id varchar(255),@dform_tmpl_name varchar(255),@dform_tmpl_desc varchar(4000),@dform_catg_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(form_tmpl_id) and
			not update(form_tmpl_name) and
			not update(form_tmpl_desc) and
			not update(form_catg_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FORMTMPL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMTMPL',form_tmpl_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FORMTMPL', form_tmpl_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select form_tmpl_id,form_tmpl_name,form_tmpl_desc,form_catg_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select form_tmpl_id,form_tmpl_name,form_tmpl_desc,form_catg_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iform_tmpl_id,@iform_tmpl_name,@iform_tmpl_desc,@iform_catg_id, @idelete_session_id
  else
    fetch deleted_c into @dform_tmpl_id,@dform_tmpl_name,@dform_tmpl_desc,@dform_catg_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dform_tmpl_id;
				

    end else begin
    	set @pk1 = @iform_tmpl_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dform_tmpl_id,@dform_tmpl_name,@dform_tmpl_desc,@dform_catg_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(form_tmpl_id)) exec audit_data 'FORMTMPL','form_tmpl_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_tmpl_id,@iform_tmpl_id,@audit_data OUTPUT
   if (@loper='D' or  update(form_tmpl_name)) exec audit_data 'FORMTMPL','form_tmpl_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_tmpl_name,@iform_tmpl_name,@audit_data OUTPUT
   if (@loper='D' or  update(form_tmpl_desc)) exec audit_data 'FORMTMPL','form_tmpl_desc',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_tmpl_desc,@iform_tmpl_desc,@audit_data OUTPUT
   if (@loper='D' or  update(form_catg_id)) exec audit_data 'FORMTMPL','form_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dform_catg_id,@iform_catg_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FORMTMPL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FORMTMPL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iform_tmpl_id,@iform_tmpl_name,@iform_tmpl_desc,@iform_catg_id, @idelete_session_id;
    else
     fetch deleted_c into @dform_tmpl_id,@dform_tmpl_name,@dform_tmpl_desc,@dform_catg_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FORMTMPL_DEL'

--METADATA  TYPE:SSCR NAME:RT_FORMTMPL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMTMPL_DEL' and type in ('TR'))
  DROP TRIGGER RT_FORMTMPL_DEL
go
--METADATA NAME:RT_FORMTMPL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMTMPL_DEL
on FORMTMPL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FORMTMPL',form_tmpl_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FORMTMPL'

--METADATA  TYPE:SSCR NAME:RT_FORMTMPL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FORMTMPL' and type in ('TR'))
  DROP TRIGGER RT_FORMTMPL
go
--METADATA NAME:RT_FORMTMPL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FORMTMPL
on FORMTMPL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FORMTMPL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FORMTMPL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FORMTMPL.create_date end
from FORMTMPL WITH (INDEX(pk_formtmpl)) join inserted 
on FORMTMPL.form_tmpl_id = inserted.form_tmpl_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FORMTMPL',form_tmpl_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select form_tmpl_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FORMTMPL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_FUNDSRC'

--METADATA  TYPE:SSCR NAME:PRMAUD_FUNDSRC OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_FUNDSRC' and type in ('TR'))
  DROP TRIGGER PRMAUD_FUNDSRC
go
--METADATA NAME:PRMAUD_FUNDSRC TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_FUNDSRC
on FUNDSRC
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ifund_id varchar(255),@iseq_num varchar(255),@ifund_name varchar(255),@iparent_fund_id varchar(255)
  declare @dfund_id varchar(255),@dseq_num varchar(255),@dfund_name varchar(255),@dparent_fund_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(fund_id) and
			not update(seq_num) and
			not update(fund_name) and
			not update(parent_fund_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'FUNDSRC', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FUNDSRC',fund_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'FUNDSRC', fund_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select fund_id,seq_num,fund_name,parent_fund_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select fund_id,seq_num,fund_name,parent_fund_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ifund_id,@iseq_num,@ifund_name,@iparent_fund_id, @idelete_session_id
  else
    fetch deleted_c into @dfund_id,@dseq_num,@dfund_name,@dparent_fund_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dfund_id;
				

    end else begin
    	set @pk1 = @ifund_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dfund_id,@dseq_num,@dfund_name,@dparent_fund_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(fund_id)) exec audit_data 'FUNDSRC','fund_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfund_id,@ifund_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'FUNDSRC','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(fund_name)) exec audit_data 'FUNDSRC','fund_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfund_name,@ifund_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_fund_id)) exec audit_data 'FUNDSRC','parent_fund_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_fund_id,@iparent_fund_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'FUNDSRC', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'FUNDSRC', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ifund_id,@iseq_num,@ifund_name,@iparent_fund_id, @idelete_session_id;
    else
     fetch deleted_c into @dfund_id,@dseq_num,@dfund_name,@dparent_fund_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_FUNDSRC_DEL'

--METADATA  TYPE:SSCR NAME:RT_FUNDSRC_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FUNDSRC_DEL' and type in ('TR'))
  DROP TRIGGER RT_FUNDSRC_DEL
go
--METADATA NAME:RT_FUNDSRC_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FUNDSRC_DEL
on FUNDSRC
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FUNDSRC',fund_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_FUNDSRC'

--METADATA  TYPE:SSCR NAME:RT_FUNDSRC OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_FUNDSRC' and type in ('TR'))
  DROP TRIGGER RT_FUNDSRC
go
--METADATA NAME:RT_FUNDSRC TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_FUNDSRC
on FUNDSRC
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update FUNDSRC
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else FUNDSRC.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else FUNDSRC.create_date end
from FUNDSRC WITH (INDEX(pk_fundsrc)) join inserted 
on FUNDSRC.fund_id = inserted.fund_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'FUNDSRC',fund_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select fund_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'FUNDSRC'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_GCHANGE'

--METADATA  TYPE:SSCR NAME:PRMAUD_GCHANGE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_GCHANGE' and type in ('TR'))
  DROP TRIGGER PRMAUD_GCHANGE
go
--METADATA NAME:PRMAUD_GCHANGE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_GCHANGE
on GCHANGE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @igchange_id varchar(255),@igchange_name varchar(255),@iuser_id varchar(255),@itable_name varchar(255)
  declare @dgchange_id varchar(255),@dgchange_name varchar(255),@duser_id varchar(255),@dtable_name varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(gchange_id) and
			not update(gchange_name) and
			not update(user_id) and
			not update(table_name) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'GCHANGE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'GCHANGE',gchange_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'GCHANGE', gchange_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select gchange_id,gchange_name,user_id,table_name
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select gchange_id,gchange_name,user_id,table_name
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @igchange_id,@igchange_name,@iuser_id,@itable_name, @idelete_session_id
  else
    fetch deleted_c into @dgchange_id,@dgchange_name,@duser_id,@dtable_name, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dgchange_id;
				

    end else begin
    	set @pk1 = @igchange_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dgchange_id,@dgchange_name,@duser_id,@dtable_name, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(gchange_id)) exec audit_data 'GCHANGE','gchange_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dgchange_id,@igchange_id,@audit_data OUTPUT
   if (@loper='D' or  update(gchange_name)) exec audit_data 'GCHANGE','gchange_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dgchange_name,@igchange_name,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'GCHANGE','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(table_name)) exec audit_data 'GCHANGE','table_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtable_name,@itable_name,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'GCHANGE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'GCHANGE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @igchange_id,@igchange_name,@iuser_id,@itable_name, @idelete_session_id;
    else
     fetch deleted_c into @dgchange_id,@dgchange_name,@duser_id,@dtable_name, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_GCHANGE_DEL'

--METADATA  TYPE:SSCR NAME:RT_GCHANGE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_GCHANGE_DEL' and type in ('TR'))
  DROP TRIGGER RT_GCHANGE_DEL
go
--METADATA NAME:RT_GCHANGE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_GCHANGE_DEL
on GCHANGE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'GCHANGE',gchange_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_GCHANGE'

--METADATA  TYPE:SSCR NAME:RT_GCHANGE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_GCHANGE' and type in ('TR'))
  DROP TRIGGER RT_GCHANGE
go
--METADATA NAME:RT_GCHANGE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_GCHANGE
on GCHANGE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update GCHANGE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else GCHANGE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else GCHANGE.create_date end
from GCHANGE WITH (INDEX(pk_gchange_id)) join inserted 
on GCHANGE.gchange_id = inserted.gchange_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'GCHANGE',gchange_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select gchange_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'GCHANGE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_IMAGEDATA'

--METADATA  TYPE:SSCR NAME:PRMAUD_IMAGEDATA OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_IMAGEDATA' and type in ('TR'))
  DROP TRIGGER PRMAUD_IMAGEDATA
go
--METADATA NAME:PRMAUD_IMAGEDATA TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_IMAGEDATA
on IMAGEDATA
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iimage_id varchar(255),@iimage_name varchar(255),@iimage_data varchar(255),@iimage_thumbnail varchar(255),@iimage_extension varchar(255),@idefault_flag varchar(255),@iimage_purpose varchar(255),@iimage_description varchar(255)
  declare @dimage_id varchar(255),@dimage_name varchar(255),@dimage_data varchar(255),@dimage_thumbnail varchar(255),@dimage_extension varchar(255),@ddefault_flag varchar(255),@dimage_purpose varchar(255),@dimage_description varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(image_id) and
			not update(image_name) and
			not update(image_data) and
			not update(image_thumbnail) and
			not update(image_extension) and
			not update(default_flag) and
			not update(image_purpose) and
			not update(image_description) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'IMAGEDATA', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'IMAGEDATA',image_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'IMAGEDATA', image_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select image_id,image_name,image_data,image_thumbnail,image_extension,default_flag,image_purpose,image_description
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select image_id,image_name,image_data,image_thumbnail,image_extension,default_flag,image_purpose,image_description
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iimage_id,@iimage_name,@iimage_data,@iimage_thumbnail,@iimage_extension,@idefault_flag,@iimage_purpose,@iimage_description, @idelete_session_id
  else
    fetch deleted_c into @dimage_id,@dimage_name,@dimage_data,@dimage_thumbnail,@dimage_extension,@ddefault_flag,@dimage_purpose,@dimage_description, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dimage_id;
				

    end else begin
    	set @pk1 = @iimage_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dimage_id,@dimage_name,@dimage_data,@dimage_thumbnail,@dimage_extension,@ddefault_flag,@dimage_purpose,@dimage_description, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(image_id)) exec audit_data 'IMAGEDATA','image_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_id,@iimage_id,@audit_data OUTPUT
   if (@loper='D' or  update(image_name)) exec audit_data 'IMAGEDATA','image_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_name,@iimage_name,@audit_data OUTPUT
   if (@loper='D' or  update(image_data)) exec audit_data 'IMAGEDATA','image_data',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_data,@iimage_data,@audit_data OUTPUT
   if (@loper='D' or  update(image_thumbnail)) exec audit_data 'IMAGEDATA','image_thumbnail',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_thumbnail,@iimage_thumbnail,@audit_data OUTPUT
   if (@loper='D' or  update(image_extension)) exec audit_data 'IMAGEDATA','image_extension',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_extension,@iimage_extension,@audit_data OUTPUT
   if (@loper='D' or  update(default_flag)) exec audit_data 'IMAGEDATA','default_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@ddefault_flag,@idefault_flag,@audit_data OUTPUT
   if (@loper='D' or  update(image_purpose)) exec audit_data 'IMAGEDATA','image_purpose',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_purpose,@iimage_purpose,@audit_data OUTPUT
   if (@loper='D' or  update(image_description)) exec audit_data 'IMAGEDATA','image_description',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dimage_description,@iimage_description,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'IMAGEDATA', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'IMAGEDATA', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iimage_id,@iimage_name,@iimage_data,@iimage_thumbnail,@iimage_extension,@idefault_flag,@iimage_purpose,@iimage_description, @idelete_session_id;
    else
     fetch deleted_c into @dimage_id,@dimage_name,@dimage_data,@dimage_thumbnail,@dimage_extension,@ddefault_flag,@dimage_purpose,@dimage_description, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_IMAGEDATA_DEL'

--METADATA  TYPE:SSCR NAME:RT_IMAGEDATA_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_IMAGEDATA_DEL' and type in ('TR'))
  DROP TRIGGER RT_IMAGEDATA_DEL
go
--METADATA NAME:RT_IMAGEDATA_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_IMAGEDATA_DEL
on IMAGEDATA
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'IMAGEDATA',image_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_IMAGEDATA'

--METADATA  TYPE:SSCR NAME:RT_IMAGEDATA OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_IMAGEDATA' and type in ('TR'))
  DROP TRIGGER RT_IMAGEDATA
go
--METADATA NAME:RT_IMAGEDATA TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_IMAGEDATA
on IMAGEDATA
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update IMAGEDATA
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else IMAGEDATA.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else IMAGEDATA.create_date end
from IMAGEDATA WITH (INDEX(pk_imagedata)) join inserted 
on IMAGEDATA.image_id = inserted.image_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'IMAGEDATA',image_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select image_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'IMAGEDATA'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ISSUHIST'

--METADATA  TYPE:SSCR NAME:PRMAUD_ISSUHIST OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ISSUHIST' and type in ('TR'))
  DROP TRIGGER PRMAUD_ISSUHIST
go
--METADATA NAME:PRMAUD_ISSUHIST TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ISSUHIST
on ISSUHIST
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iissue_id varchar(255),@iproj_id varchar(255)
  declare @dissue_id varchar(255),@dproj_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(issue_id) and
			not update(proj_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ISSUHIST', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ISSUHIST',issue_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ISSUHIST', issue_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select issue_id,proj_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select issue_id,proj_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iissue_id,@iproj_id, @idelete_session_id
  else
    fetch deleted_c into @dissue_id,@dproj_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dissue_id;
				

    end else begin
    	set @pk1 = @iissue_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dissue_id,@dproj_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(issue_id)) exec audit_data 'ISSUHIST','issue_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dissue_id,@iissue_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'ISSUHIST','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ISSUHIST', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ISSUHIST', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iissue_id,@iproj_id, @idelete_session_id;
    else
     fetch deleted_c into @dissue_id,@dproj_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ISSUHIST_DEL'

--METADATA  TYPE:SSCR NAME:RT_ISSUHIST_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ISSUHIST_DEL' and type in ('TR'))
  DROP TRIGGER RT_ISSUHIST_DEL
go
--METADATA NAME:RT_ISSUHIST_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ISSUHIST_DEL
on ISSUHIST
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ISSUHIST',issue_id,null,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_ISSUHIST'

--METADATA  TYPE:SSCR NAME:RT_ISSUHIST OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ISSUHIST' and type in ('TR'))
  DROP TRIGGER RT_ISSUHIST
go
--METADATA NAME:RT_ISSUHIST TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ISSUHIST
on ISSUHIST
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ISSUHIST
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ISSUHIST.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ISSUHIST.create_date end
from ISSUHIST WITH (INDEX(pk_issuhist)) join inserted 
on ISSUHIST.issue_id = inserted.issue_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ISSUHIST',issue_id,null,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select issue_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ISSUHIST'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ITERATION'

--METADATA  TYPE:SSCR NAME:PRMAUD_ITERATION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ITERATION' and type in ('TR'))
  DROP TRIGGER PRMAUD_ITERATION
go
--METADATA NAME:PRMAUD_ITERATION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ITERATION
on ITERATION
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iiteration_id varchar(255),@irelease_id varchar(255),@iiteration_name varchar(255),@istart_date varchar(255),@iend_date varchar(255),@itermination_date varchar(255),@icapacity_pct varchar(255),@iremain_qty varchar(255)
  declare @diteration_id varchar(255),@drelease_id varchar(255),@diteration_name varchar(255),@dstart_date varchar(255),@dend_date varchar(255),@dtermination_date varchar(255),@dcapacity_pct varchar(255),@dremain_qty varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(iteration_id) and
			not update(release_id) and
			not update(iteration_name) and
			not update(start_date) and
			not update(end_date) and
			not update(termination_date) and
			not update(capacity_pct) and
			not update(remain_qty) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ITERATION', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERATION',iteration_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERATION', iteration_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select iteration_id,release_id,iteration_name,start_date,end_date,termination_date,capacity_pct,remain_qty
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select iteration_id,release_id,iteration_name,start_date,end_date,termination_date,capacity_pct,remain_qty
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iiteration_id,@irelease_id,@iiteration_name,@istart_date,@iend_date,@itermination_date,@icapacity_pct,@iremain_qty, @idelete_session_id
  else
    fetch deleted_c into @diteration_id,@drelease_id,@diteration_name,@dstart_date,@dend_date,@dtermination_date,@dcapacity_pct,@dremain_qty, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @diteration_id;
				

    end else begin
    	set @pk1 = @iiteration_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @diteration_id,@drelease_id,@diteration_name,@dstart_date,@dend_date,@dtermination_date,@dcapacity_pct,@dremain_qty, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(iteration_id)) exec audit_data 'ITERATION','iteration_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@diteration_id,@iiteration_id,@audit_data OUTPUT
   if (@loper='D' or  update(release_id)) exec audit_data 'ITERATION','release_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drelease_id,@irelease_id,@audit_data OUTPUT
   if (@loper='D' or  update(iteration_name)) exec audit_data 'ITERATION','iteration_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@diteration_name,@iiteration_name,@audit_data OUTPUT
   if (@loper='D' or  update(start_date)) exec audit_data 'ITERATION','start_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstart_date,@istart_date,@audit_data OUTPUT
   if (@loper='D' or  update(end_date)) exec audit_data 'ITERATION','end_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dend_date,@iend_date,@audit_data OUTPUT
   if (@loper='D' or  update(termination_date)) exec audit_data 'ITERATION','termination_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtermination_date,@itermination_date,@audit_data OUTPUT
   if (@loper='D' or  update(capacity_pct)) exec audit_data 'ITERATION','capacity_pct',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcapacity_pct,@icapacity_pct,@audit_data OUTPUT
   if (@loper='D' or  update(remain_qty)) exec audit_data 'ITERATION','remain_qty',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dremain_qty,@iremain_qty,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ITERATION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ITERATION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iiteration_id,@irelease_id,@iiteration_name,@istart_date,@iend_date,@itermination_date,@icapacity_pct,@iremain_qty, @idelete_session_id;
    else
     fetch deleted_c into @diteration_id,@drelease_id,@diteration_name,@dstart_date,@dend_date,@dtermination_date,@dcapacity_pct,@dremain_qty, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ITERATION_DEL'

--METADATA  TYPE:SSCR NAME:RT_ITERATION_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERATION_DEL' and type in ('TR'))
  DROP TRIGGER RT_ITERATION_DEL
go
--METADATA NAME:RT_ITERATION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERATION_DEL
on ITERATION
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ITERATION',iteration_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ITERATION'

--METADATA  TYPE:SSCR NAME:RT_ITERATION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERATION' and type in ('TR'))
  DROP TRIGGER RT_ITERATION
go
--METADATA NAME:RT_ITERATION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERATION
on ITERATION
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ITERATION
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ITERATION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ITERATION.create_date end
from ITERATION WITH (INDEX(pk_iteration)) join inserted 
on ITERATION.iteration_id = inserted.iteration_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ITERATION',iteration_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select iteration_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ITERATION'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ITERDAYS'

--METADATA  TYPE:SSCR NAME:PRMAUD_ITERDAYS OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ITERDAYS' and type in ('TR'))
  DROP TRIGGER PRMAUD_ITERDAYS
go
--METADATA NAME:PRMAUD_ITERDAYS TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ITERDAYS
on ITERDAYS
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @itask_id varchar(255),@iday_number varchar(255),@iproj_id varchar(255),@iiteration_id varchar(255),@iact_work_qty varchar(255),@iremain_work_qty varchar(255)
  declare @dtask_id varchar(255),@dday_number varchar(255),@dproj_id varchar(255),@diteration_id varchar(255),@dact_work_qty varchar(255),@dremain_work_qty varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(task_id) and
			not update(day_number) and
			not update(proj_id) and
			not update(iteration_id) and
			not update(act_work_qty) and
			not update(remain_work_qty) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ITERDAYS', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERDAYS',task_id,day_number,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERDAYS', task_id,day_number,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select task_id,day_number,proj_id,iteration_id,act_work_qty,remain_work_qty
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select task_id,day_number,proj_id,iteration_id,act_work_qty,remain_work_qty
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @itask_id,@iday_number,@iproj_id,@iiteration_id,@iact_work_qty,@iremain_work_qty, @idelete_session_id
  else
    fetch deleted_c into @dtask_id,@dday_number,@dproj_id,@diteration_id,@dact_work_qty,@dremain_work_qty, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dtask_id;
				
set @pk2 = @dday_number;
				

    end else begin
    	set @pk1 = @itask_id;
				
set @pk2 = @iday_number;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dtask_id,@dday_number,@dproj_id,@diteration_id,@dact_work_qty,@dremain_work_qty, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(task_id)) exec audit_data 'ITERDAYS','task_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtask_id,@itask_id,@audit_data OUTPUT
   if (@loper='D' or  update(day_number)) exec audit_data 'ITERDAYS','day_number',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dday_number,@iday_number,@audit_data OUTPUT
   if (@loper='D' or  update(proj_id)) exec audit_data 'ITERDAYS','proj_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_id,@iproj_id,@audit_data OUTPUT
   if (@loper='D' or  update(iteration_id)) exec audit_data 'ITERDAYS','iteration_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@diteration_id,@iiteration_id,@audit_data OUTPUT
   if (@loper='D' or  update(act_work_qty)) exec audit_data 'ITERDAYS','act_work_qty',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dact_work_qty,@iact_work_qty,@audit_data OUTPUT
   if (@loper='D' or  update(remain_work_qty)) exec audit_data 'ITERDAYS','remain_work_qty',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dremain_work_qty,@iremain_work_qty,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ITERDAYS', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ITERDAYS', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @itask_id,@iday_number,@iproj_id,@iiteration_id,@iact_work_qty,@iremain_work_qty, @idelete_session_id;
    else
     fetch deleted_c into @dtask_id,@dday_number,@dproj_id,@diteration_id,@dact_work_qty,@dremain_work_qty, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ITERDAYS_DEL'

--METADATA  TYPE:SSCR NAME:RT_ITERDAYS_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERDAYS_DEL' and type in ('TR'))
  DROP TRIGGER RT_ITERDAYS_DEL
go
--METADATA NAME:RT_ITERDAYS_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERDAYS_DEL
on ITERDAYS
for delete
as   
set nocount on

  declare @bypass_cnt int

select @bypass_cnt=count(*) from spidmap
where spid=@@spid
and refrdel_project_bypass=1;
if @bypass_cnt=0
BEGIN
    
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ITERDAYS',task_id,day_number,null,null
  	,proj_id
      from deleted
  	
  END
  


END
go
print 'Creating trigger RT_ITERDAYS'

--METADATA  TYPE:SSCR NAME:RT_ITERDAYS OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERDAYS' and type in ('TR'))
  DROP TRIGGER RT_ITERDAYS
go
--METADATA NAME:RT_ITERDAYS TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERDAYS
on ITERDAYS
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ITERDAYS
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ITERDAYS.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ITERDAYS.create_date end
from ITERDAYS WITH (INDEX(pk_iterdays)) join inserted 
on ITERDAYS.task_id = inserted.task_id
and ITERDAYS.day_number = inserted.day_number
begin
  declare ins cursor  for select task_id,day_number,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'ITERDAYS'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4,proj_id)
      select getDate(),'ITERDAYS',task_id,day_number,null,null
  	,proj_id
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select task_id,day_number,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ITERDAYS'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_ITERGOAL'

--METADATA  TYPE:SSCR NAME:PRMAUD_ITERGOAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_ITERGOAL' and type in ('TR'))
  DROP TRIGGER PRMAUD_ITERGOAL
go
--METADATA NAME:PRMAUD_ITERGOAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_ITERGOAL
on ITERGOAL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iiter_goal_id varchar(255),@iiteration_id varchar(255),@igoal_name varchar(255),@igoal_descr varchar(4000),@istatus_code varchar(255),@irfolio_id varchar(255)
  declare @diter_goal_id varchar(255),@diteration_id varchar(255),@dgoal_name varchar(255),@dgoal_descr varchar(4000),@dstatus_code varchar(255),@drfolio_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(iter_goal_id) and
			not update(iteration_id) and
			not update(goal_name) and
			not update(goal_descr) and
			not update(status_code) and
			not update(rfolio_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'ITERGOAL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERGOAL',iter_goal_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'ITERGOAL', iter_goal_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select iter_goal_id,iteration_id,goal_name,goal_descr,status_code,rfolio_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select iter_goal_id,iteration_id,goal_name,goal_descr,status_code,rfolio_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iiter_goal_id,@iiteration_id,@igoal_name,@igoal_descr,@istatus_code,@irfolio_id, @idelete_session_id
  else
    fetch deleted_c into @diter_goal_id,@diteration_id,@dgoal_name,@dgoal_descr,@dstatus_code,@drfolio_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @diter_goal_id;
				

    end else begin
    	set @pk1 = @iiter_goal_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @diter_goal_id,@diteration_id,@dgoal_name,@dgoal_descr,@dstatus_code,@drfolio_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(iter_goal_id)) exec audit_data 'ITERGOAL','iter_goal_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@diter_goal_id,@iiter_goal_id,@audit_data OUTPUT
   if (@loper='D' or  update(iteration_id)) exec audit_data 'ITERGOAL','iteration_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@diteration_id,@iiteration_id,@audit_data OUTPUT
   if (@loper='D' or  update(goal_name)) exec audit_data 'ITERGOAL','goal_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dgoal_name,@igoal_name,@audit_data OUTPUT
   if (@loper='D' or  update(goal_descr)) exec audit_data 'ITERGOAL','goal_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dgoal_descr,@igoal_descr,@audit_data OUTPUT
   if (@loper='D' or  update(status_code)) exec audit_data 'ITERGOAL','status_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus_code,@istatus_code,@audit_data OUTPUT
   if (@loper='D' or  update(rfolio_id)) exec audit_data 'ITERGOAL','rfolio_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drfolio_id,@irfolio_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'ITERGOAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'ITERGOAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iiter_goal_id,@iiteration_id,@igoal_name,@igoal_descr,@istatus_code,@irfolio_id, @idelete_session_id;
    else
     fetch deleted_c into @diter_goal_id,@diteration_id,@dgoal_name,@dgoal_descr,@dstatus_code,@drfolio_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_ITERGOAL_DEL'

--METADATA  TYPE:SSCR NAME:RT_ITERGOAL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERGOAL_DEL' and type in ('TR'))
  DROP TRIGGER RT_ITERGOAL_DEL
go
--METADATA NAME:RT_ITERGOAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERGOAL_DEL
on ITERGOAL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ITERGOAL',iter_goal_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_ITERGOAL'

--METADATA  TYPE:SSCR NAME:RT_ITERGOAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_ITERGOAL' and type in ('TR'))
  DROP TRIGGER RT_ITERGOAL
go
--METADATA NAME:RT_ITERGOAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_ITERGOAL
on ITERGOAL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update ITERGOAL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else ITERGOAL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else ITERGOAL.create_date end
from ITERGOAL WITH (INDEX(pk_itergoal)) join inserted 
on ITERGOAL.iter_goal_id = inserted.iter_goal_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'ITERGOAL',iter_goal_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select iter_goal_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'ITERGOAL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_JOBLOG'

--METADATA  TYPE:SSCR NAME:PRMAUD_JOBLOG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_JOBLOG' and type in ('TR'))
  DROP TRIGGER PRMAUD_JOBLOG
go
--METADATA NAME:PRMAUD_JOBLOG TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_JOBLOG
on JOBLOG
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ijob_id varchar(255)
  declare @djob_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(job_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'JOBLOG', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBLOG',job_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBLOG', job_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select job_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select job_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ijob_id, @idelete_session_id
  else
    fetch deleted_c into @djob_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @djob_id;
				

    end else begin
    	set @pk1 = @ijob_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @djob_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(job_id)) exec audit_data 'JOBLOG','job_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@djob_id,@ijob_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'JOBLOG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'JOBLOG', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ijob_id, @idelete_session_id;
    else
     fetch deleted_c into @djob_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_JOBLOG_DEL'

--METADATA  TYPE:SSCR NAME:RT_JOBLOG_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBLOG_DEL' and type in ('TR'))
  DROP TRIGGER RT_JOBLOG_DEL
go
--METADATA NAME:RT_JOBLOG_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBLOG_DEL
on JOBLOG
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBLOG',job_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_JOBLOG'

--METADATA  TYPE:SSCR NAME:RT_JOBLOG OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBLOG' and type in ('TR'))
  DROP TRIGGER RT_JOBLOG
go
--METADATA NAME:RT_JOBLOG TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBLOG
on JOBLOG
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update JOBLOG
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else JOBLOG.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else JOBLOG.create_date end
from JOBLOG WITH (INDEX(pk_joblog)) join inserted 
on JOBLOG.job_id = inserted.job_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBLOG',job_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select job_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'JOBLOG'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_JOBRPT'

--METADATA  TYPE:SSCR NAME:PRMAUD_JOBRPT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_JOBRPT' and type in ('TR'))
  DROP TRIGGER PRMAUD_JOBRPT
go
--METADATA NAME:PRMAUD_JOBRPT TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_JOBRPT
on JOBRPT
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ijob_id varchar(255),@irpt_id varchar(255),@itable_name varchar(255),@ifk_id varchar(255),@ipersonal_portal_flag varchar(255)
  declare @djob_id varchar(255),@drpt_id varchar(255),@dtable_name varchar(255),@dfk_id varchar(255),@dpersonal_portal_flag varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(job_id) and
			not update(rpt_id) and
			not update(table_name) and
			not update(fk_id) and
			not update(personal_portal_flag) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'JOBRPT', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBRPT',job_id,rpt_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBRPT', job_id,rpt_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select job_id,rpt_id,table_name,fk_id,personal_portal_flag
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select job_id,rpt_id,table_name,fk_id,personal_portal_flag
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ijob_id,@irpt_id,@itable_name,@ifk_id,@ipersonal_portal_flag, @idelete_session_id
  else
    fetch deleted_c into @djob_id,@drpt_id,@dtable_name,@dfk_id,@dpersonal_portal_flag, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @djob_id;
				
set @pk2 = @drpt_id;
				

    end else begin
    	set @pk1 = @ijob_id;
				
set @pk2 = @irpt_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @djob_id,@drpt_id,@dtable_name,@dfk_id,@dpersonal_portal_flag, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(job_id)) exec audit_data 'JOBRPT','job_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@djob_id,@ijob_id,@audit_data OUTPUT
   if (@loper='D' or  update(rpt_id)) exec audit_data 'JOBRPT','rpt_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drpt_id,@irpt_id,@audit_data OUTPUT
   if (@loper='D' or  update(table_name)) exec audit_data 'JOBRPT','table_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtable_name,@itable_name,@audit_data OUTPUT
   if (@loper='D' or  update(fk_id)) exec audit_data 'JOBRPT','fk_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfk_id,@ifk_id,@audit_data OUTPUT
   if (@loper='D' or  update(personal_portal_flag)) exec audit_data 'JOBRPT','personal_portal_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpersonal_portal_flag,@ipersonal_portal_flag,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'JOBRPT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'JOBRPT', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ijob_id,@irpt_id,@itable_name,@ifk_id,@ipersonal_portal_flag, @idelete_session_id;
    else
     fetch deleted_c into @djob_id,@drpt_id,@dtable_name,@dfk_id,@dpersonal_portal_flag, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_JOBRPT_DEL'

--METADATA  TYPE:SSCR NAME:RT_JOBRPT_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBRPT_DEL' and type in ('TR'))
  DROP TRIGGER RT_JOBRPT_DEL
go
--METADATA NAME:RT_JOBRPT_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBRPT_DEL
on JOBRPT
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBRPT',job_id,rpt_id,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_JOBRPT'

--METADATA  TYPE:SSCR NAME:RT_JOBRPT OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBRPT' and type in ('TR'))
  DROP TRIGGER RT_JOBRPT
go
--METADATA NAME:RT_JOBRPT TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBRPT
on JOBRPT
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update JOBRPT
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else JOBRPT.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else JOBRPT.create_date end
from JOBRPT WITH (INDEX(pk_jobrpt)) join inserted 
on JOBRPT.job_id = inserted.job_id
and JOBRPT.rpt_id = inserted.rpt_id
begin
  declare ins cursor  for select job_id,rpt_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'JOBRPT'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBRPT',job_id,rpt_id,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select job_id,rpt_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'JOBRPT'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_JOBSVC'

--METADATA  TYPE:SSCR NAME:PRMAUD_JOBSVC OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_JOBSVC' and type in ('TR'))
  DROP TRIGGER PRMAUD_JOBSVC
go
--METADATA NAME:PRMAUD_JOBSVC TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_JOBSVC
on JOBSVC
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ijob_id varchar(255),@iparent_job_id varchar(255),@iseq_num varchar(255),@iaudit_flag varchar(255),@ijob_type varchar(255),@ijob_name varchar(255),@iuser_id varchar(255),@ilast_run_date varchar(255),@istatus_code varchar(255),@irecur_data varchar(255),@irecur_type varchar(255),@isubmitted_date varchar(255),@ilast_error_descr varchar(255),@iaudit_file_path varchar(255)
  declare @djob_id varchar(255),@dparent_job_id varchar(255),@dseq_num varchar(255),@daudit_flag varchar(255),@djob_type varchar(255),@djob_name varchar(255),@duser_id varchar(255),@dlast_run_date varchar(255),@dstatus_code varchar(255),@drecur_data varchar(255),@drecur_type varchar(255),@dsubmitted_date varchar(255),@dlast_error_descr varchar(255),@daudit_file_path varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(job_id) and
			not update(parent_job_id) and
			not update(seq_num) and
			not update(audit_flag) and
			not update(job_type) and
			not update(job_name) and
			not update(user_id) and
			not update(last_run_date) and
			not update(status_code) and
			not update(recur_data) and
			not update(recur_type) and
			not update(submitted_date) and
			not update(last_error_descr) and
			not update(audit_file_path) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'JOBSVC', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBSVC',job_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'JOBSVC', job_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select job_id,parent_job_id,seq_num,audit_flag,job_type,job_name,user_id,last_run_date,status_code,recur_data,recur_type,submitted_date,last_error_descr,audit_file_path
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select job_id,parent_job_id,seq_num,audit_flag,job_type,job_name,user_id,last_run_date,status_code,recur_data,recur_type,submitted_date,last_error_descr,audit_file_path
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ijob_id,@iparent_job_id,@iseq_num,@iaudit_flag,@ijob_type,@ijob_name,@iuser_id,@ilast_run_date,@istatus_code,@irecur_data,@irecur_type,@isubmitted_date,@ilast_error_descr,@iaudit_file_path, @idelete_session_id
  else
    fetch deleted_c into @djob_id,@dparent_job_id,@dseq_num,@daudit_flag,@djob_type,@djob_name,@duser_id,@dlast_run_date,@dstatus_code,@drecur_data,@drecur_type,@dsubmitted_date,@dlast_error_descr,@daudit_file_path, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @djob_id;
				

    end else begin
    	set @pk1 = @ijob_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @djob_id,@dparent_job_id,@dseq_num,@daudit_flag,@djob_type,@djob_name,@duser_id,@dlast_run_date,@dstatus_code,@drecur_data,@drecur_type,@dsubmitted_date,@dlast_error_descr,@daudit_file_path, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(job_id)) exec audit_data 'JOBSVC','job_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@djob_id,@ijob_id,@audit_data OUTPUT
   if (@loper='D' or  update(parent_job_id)) exec audit_data 'JOBSVC','parent_job_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_job_id,@iparent_job_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'JOBSVC','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(audit_flag)) exec audit_data 'JOBSVC','audit_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@daudit_flag,@iaudit_flag,@audit_data OUTPUT
   if (@loper='D' or  update(job_type)) exec audit_data 'JOBSVC','job_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@djob_type,@ijob_type,@audit_data OUTPUT
   if (@loper='D' or  update(job_name)) exec audit_data 'JOBSVC','job_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@djob_name,@ijob_name,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'JOBSVC','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(last_run_date)) exec audit_data 'JOBSVC','last_run_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlast_run_date,@ilast_run_date,@audit_data OUTPUT
   if (@loper='D' or  update(status_code)) exec audit_data 'JOBSVC','status_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstatus_code,@istatus_code,@audit_data OUTPUT
   if (@loper='D' or  update(recur_data)) exec audit_data 'JOBSVC','recur_data',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drecur_data,@irecur_data,@audit_data OUTPUT
   if (@loper='D' or  update(recur_type)) exec audit_data 'JOBSVC','recur_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@drecur_type,@irecur_type,@audit_data OUTPUT
   if (@loper='D' or  update(submitted_date)) exec audit_data 'JOBSVC','submitted_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dsubmitted_date,@isubmitted_date,@audit_data OUTPUT
   if (@loper='D' or  update(last_error_descr)) exec audit_data 'JOBSVC','last_error_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlast_error_descr,@ilast_error_descr,@audit_data OUTPUT
   if (@loper='D' or  update(audit_file_path)) exec audit_data 'JOBSVC','audit_file_path',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@daudit_file_path,@iaudit_file_path,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'JOBSVC', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'JOBSVC', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ijob_id,@iparent_job_id,@iseq_num,@iaudit_flag,@ijob_type,@ijob_name,@iuser_id,@ilast_run_date,@istatus_code,@irecur_data,@irecur_type,@isubmitted_date,@ilast_error_descr,@iaudit_file_path, @idelete_session_id;
    else
     fetch deleted_c into @djob_id,@dparent_job_id,@dseq_num,@daudit_flag,@djob_type,@djob_name,@duser_id,@dlast_run_date,@dstatus_code,@drecur_data,@drecur_type,@dsubmitted_date,@dlast_error_descr,@daudit_file_path, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_JOBSVC_DEL'

--METADATA  TYPE:SSCR NAME:RT_JOBSVC_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBSVC_DEL' and type in ('TR'))
  DROP TRIGGER RT_JOBSVC_DEL
go
--METADATA NAME:RT_JOBSVC_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBSVC_DEL
on JOBSVC
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBSVC',job_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_JOBSVC'

--METADATA  TYPE:SSCR NAME:RT_JOBSVC OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_JOBSVC' and type in ('TR'))
  DROP TRIGGER RT_JOBSVC
go
--METADATA NAME:RT_JOBSVC TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_JOBSVC
on JOBSVC
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update JOBSVC
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else JOBSVC.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else JOBSVC.create_date end
from JOBSVC WITH (INDEX(pk_jobsvc)) join inserted 
on JOBSVC.job_id = inserted.job_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'JOBSVC',job_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select job_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'JOBSVC'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_LOCATION'

--METADATA  TYPE:SSCR NAME:PRMAUD_LOCATION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_LOCATION' and type in ('TR'))
  DROP TRIGGER PRMAUD_LOCATION
go
--METADATA NAME:PRMAUD_LOCATION TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_LOCATION
on LOCATION
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ilocation_id varchar(255),@ilocation_name varchar(255),@ilocation_type varchar(255),@iaddress_line1 varchar(255),@iaddress_line2 varchar(255),@iaddress_line3 varchar(255),@icity_name varchar(255),@imunicipality_name varchar(255),@istate_name varchar(255),@istate_code varchar(255),@icountry_name varchar(255),@icountry_code varchar(255),@ipostal_code varchar(255),@ilongitude varchar(255),@ilatitude varchar(255)
  declare @dlocation_id varchar(255),@dlocation_name varchar(255),@dlocation_type varchar(255),@daddress_line1 varchar(255),@daddress_line2 varchar(255),@daddress_line3 varchar(255),@dcity_name varchar(255),@dmunicipality_name varchar(255),@dstate_name varchar(255),@dstate_code varchar(255),@dcountry_name varchar(255),@dcountry_code varchar(255),@dpostal_code varchar(255),@dlongitude varchar(255),@dlatitude varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(location_id) and
			not update(location_name) and
			not update(location_type) and
			not update(address_line1) and
			not update(address_line2) and
			not update(address_line3) and
			not update(city_name) and
			not update(municipality_name) and
			not update(state_name) and
			not update(state_code) and
			not update(country_name) and
			not update(country_code) and
			not update(postal_code) and
			not update(longitude) and
			not update(latitude) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'LOCATION', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'LOCATION',location_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'LOCATION', location_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select location_id,location_name,location_type,address_line1,address_line2,address_line3,city_name,municipality_name,state_name,state_code,country_name,country_code,postal_code,longitude,latitude
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select location_id,location_name,location_type,address_line1,address_line2,address_line3,city_name,municipality_name,state_name,state_code,country_name,country_code,postal_code,longitude,latitude
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ilocation_id,@ilocation_name,@ilocation_type,@iaddress_line1,@iaddress_line2,@iaddress_line3,@icity_name,@imunicipality_name,@istate_name,@istate_code,@icountry_name,@icountry_code,@ipostal_code,@ilongitude,@ilatitude, @idelete_session_id
  else
    fetch deleted_c into @dlocation_id,@dlocation_name,@dlocation_type,@daddress_line1,@daddress_line2,@daddress_line3,@dcity_name,@dmunicipality_name,@dstate_name,@dstate_code,@dcountry_name,@dcountry_code,@dpostal_code,@dlongitude,@dlatitude, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dlocation_id;
				

    end else begin
    	set @pk1 = @ilocation_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dlocation_id,@dlocation_name,@dlocation_type,@daddress_line1,@daddress_line2,@daddress_line3,@dcity_name,@dmunicipality_name,@dstate_name,@dstate_code,@dcountry_name,@dcountry_code,@dpostal_code,@dlongitude,@dlatitude, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(location_id)) exec audit_data 'LOCATION','location_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlocation_id,@ilocation_id,@audit_data OUTPUT
   if (@loper='D' or  update(location_name)) exec audit_data 'LOCATION','location_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlocation_name,@ilocation_name,@audit_data OUTPUT
   if (@loper='D' or  update(location_type)) exec audit_data 'LOCATION','location_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlocation_type,@ilocation_type,@audit_data OUTPUT
   if (@loper='D' or  update(address_line1)) exec audit_data 'LOCATION','address_line1',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@daddress_line1,@iaddress_line1,@audit_data OUTPUT
   if (@loper='D' or  update(address_line2)) exec audit_data 'LOCATION','address_line2',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@daddress_line2,@iaddress_line2,@audit_data OUTPUT
   if (@loper='D' or  update(address_line3)) exec audit_data 'LOCATION','address_line3',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@daddress_line3,@iaddress_line3,@audit_data OUTPUT
   if (@loper='D' or  update(city_name)) exec audit_data 'LOCATION','city_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcity_name,@icity_name,@audit_data OUTPUT
   if (@loper='D' or  update(municipality_name)) exec audit_data 'LOCATION','municipality_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmunicipality_name,@imunicipality_name,@audit_data OUTPUT
   if (@loper='D' or  update(state_name)) exec audit_data 'LOCATION','state_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstate_name,@istate_name,@audit_data OUTPUT
   if (@loper='D' or  update(state_code)) exec audit_data 'LOCATION','state_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dstate_code,@istate_code,@audit_data OUTPUT
   if (@loper='D' or  update(country_name)) exec audit_data 'LOCATION','country_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcountry_name,@icountry_name,@audit_data OUTPUT
   if (@loper='D' or  update(country_code)) exec audit_data 'LOCATION','country_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dcountry_code,@icountry_code,@audit_data OUTPUT
   if (@loper='D' or  update(postal_code)) exec audit_data 'LOCATION','postal_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpostal_code,@ipostal_code,@audit_data OUTPUT
   if (@loper='D' or  update(longitude)) exec audit_data 'LOCATION','longitude',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlongitude,@ilongitude,@audit_data OUTPUT
   if (@loper='D' or  update(latitude)) exec audit_data 'LOCATION','latitude',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlatitude,@ilatitude,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'LOCATION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'LOCATION', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ilocation_id,@ilocation_name,@ilocation_type,@iaddress_line1,@iaddress_line2,@iaddress_line3,@icity_name,@imunicipality_name,@istate_name,@istate_code,@icountry_name,@icountry_code,@ipostal_code,@ilongitude,@ilatitude, @idelete_session_id;
    else
     fetch deleted_c into @dlocation_id,@dlocation_name,@dlocation_type,@daddress_line1,@daddress_line2,@daddress_line3,@dcity_name,@dmunicipality_name,@dstate_name,@dstate_code,@dcountry_name,@dcountry_code,@dpostal_code,@dlongitude,@dlatitude, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_LOCATION_DEL'

--METADATA  TYPE:SSCR NAME:RT_LOCATION_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_LOCATION_DEL' and type in ('TR'))
  DROP TRIGGER RT_LOCATION_DEL
go
--METADATA NAME:RT_LOCATION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_LOCATION_DEL
on LOCATION
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'LOCATION',location_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_LOCATION'

--METADATA  TYPE:SSCR NAME:RT_LOCATION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_LOCATION' and type in ('TR'))
  DROP TRIGGER RT_LOCATION
go
--METADATA NAME:RT_LOCATION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_LOCATION
on LOCATION
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update LOCATION
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else LOCATION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else LOCATION.create_date end
from LOCATION WITH (INDEX(pk_location)) join inserted 
on LOCATION.location_id = inserted.location_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'LOCATION',location_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select location_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'LOCATION'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_MEMOTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_MEMOTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_MEMOTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_MEMOTYPE
go
--METADATA NAME:PRMAUD_MEMOTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_MEMOTYPE
on MEMOTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @imemo_type_id varchar(255),@iseq_num varchar(255),@ieps_flag varchar(255),@iproj_flag varchar(255),@iwbs_flag varchar(255),@itask_flag varchar(255),@imemo_type varchar(255)
  declare @dmemo_type_id varchar(255),@dseq_num varchar(255),@deps_flag varchar(255),@dproj_flag varchar(255),@dwbs_flag varchar(255),@dtask_flag varchar(255),@dmemo_type varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(memo_type_id) and
			not update(seq_num) and
			not update(eps_flag) and
			not update(proj_flag) and
			not update(wbs_flag) and
			not update(task_flag) and
			not update(memo_type) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'MEMOTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'MEMOTYPE',memo_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'MEMOTYPE', memo_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select memo_type_id,seq_num,eps_flag,proj_flag,wbs_flag,task_flag,memo_type
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select memo_type_id,seq_num,eps_flag,proj_flag,wbs_flag,task_flag,memo_type
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @imemo_type_id,@iseq_num,@ieps_flag,@iproj_flag,@iwbs_flag,@itask_flag,@imemo_type, @idelete_session_id
  else
    fetch deleted_c into @dmemo_type_id,@dseq_num,@deps_flag,@dproj_flag,@dwbs_flag,@dtask_flag,@dmemo_type, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dmemo_type_id;
				

    end else begin
    	set @pk1 = @imemo_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dmemo_type_id,@dseq_num,@deps_flag,@dproj_flag,@dwbs_flag,@dtask_flag,@dmemo_type, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(memo_type_id)) exec audit_data 'MEMOTYPE','memo_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmemo_type_id,@imemo_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'MEMOTYPE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(eps_flag)) exec audit_data 'MEMOTYPE','eps_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@deps_flag,@ieps_flag,@audit_data OUTPUT
   if (@loper='D' or  update(proj_flag)) exec audit_data 'MEMOTYPE','proj_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_flag,@iproj_flag,@audit_data OUTPUT
   if (@loper='D' or  update(wbs_flag)) exec audit_data 'MEMOTYPE','wbs_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dwbs_flag,@iwbs_flag,@audit_data OUTPUT
   if (@loper='D' or  update(task_flag)) exec audit_data 'MEMOTYPE','task_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtask_flag,@itask_flag,@audit_data OUTPUT
   if (@loper='D' or  update(memo_type)) exec audit_data 'MEMOTYPE','memo_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmemo_type,@imemo_type,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'MEMOTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'MEMOTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @imemo_type_id,@iseq_num,@ieps_flag,@iproj_flag,@iwbs_flag,@itask_flag,@imemo_type, @idelete_session_id;
    else
     fetch deleted_c into @dmemo_type_id,@dseq_num,@deps_flag,@dproj_flag,@dwbs_flag,@dtask_flag,@dmemo_type, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_MEMOTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_MEMOTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_MEMOTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_MEMOTYPE_DEL
go
--METADATA NAME:RT_MEMOTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_MEMOTYPE_DEL
on MEMOTYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'MEMOTYPE',memo_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_MEMOTYPE'

--METADATA  TYPE:SSCR NAME:RT_MEMOTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_MEMOTYPE' and type in ('TR'))
  DROP TRIGGER RT_MEMOTYPE
go
--METADATA NAME:RT_MEMOTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_MEMOTYPE
on MEMOTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update MEMOTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else MEMOTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else MEMOTYPE.create_date end
from MEMOTYPE WITH (INDEX(pk_memotype)) join inserted 
on MEMOTYPE.memo_type_id = inserted.memo_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'MEMOTYPE',memo_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select memo_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'MEMOTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_NONWORK'

--METADATA  TYPE:SSCR NAME:PRMAUD_NONWORK OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_NONWORK' and type in ('TR'))
  DROP TRIGGER PRMAUD_NONWORK
go
--METADATA NAME:PRMAUD_NONWORK TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_NONWORK
on NONWORK
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @inonwork_type_id varchar(255),@iseq_num varchar(255),@inonwork_code varchar(255),@inonwork_type varchar(255)
  declare @dnonwork_type_id varchar(255),@dseq_num varchar(255),@dnonwork_code varchar(255),@dnonwork_type varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(nonwork_type_id) and
			not update(seq_num) and
			not update(nonwork_code) and
			not update(nonwork_type) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'NONWORK', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'NONWORK',nonwork_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'NONWORK', nonwork_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select nonwork_type_id,seq_num,nonwork_code,nonwork_type
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select nonwork_type_id,seq_num,nonwork_code,nonwork_type
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @inonwork_type_id,@iseq_num,@inonwork_code,@inonwork_type, @idelete_session_id
  else
    fetch deleted_c into @dnonwork_type_id,@dseq_num,@dnonwork_code,@dnonwork_type, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dnonwork_type_id;
				

    end else begin
    	set @pk1 = @inonwork_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dnonwork_type_id,@dseq_num,@dnonwork_code,@dnonwork_type, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(nonwork_type_id)) exec audit_data 'NONWORK','nonwork_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnonwork_type_id,@inonwork_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'NONWORK','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(nonwork_code)) exec audit_data 'NONWORK','nonwork_code',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnonwork_code,@inonwork_code,@audit_data OUTPUT
   if (@loper='D' or  update(nonwork_type)) exec audit_data 'NONWORK','nonwork_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnonwork_type,@inonwork_type,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'NONWORK', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'NONWORK', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @inonwork_type_id,@iseq_num,@inonwork_code,@inonwork_type, @idelete_session_id;
    else
     fetch deleted_c into @dnonwork_type_id,@dseq_num,@dnonwork_code,@dnonwork_type, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_NONWORK_DEL'

--METADATA  TYPE:SSCR NAME:RT_NONWORK_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_NONWORK_DEL' and type in ('TR'))
  DROP TRIGGER RT_NONWORK_DEL
go
--METADATA NAME:RT_NONWORK_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_NONWORK_DEL
on NONWORK
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'NONWORK',nonwork_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_NONWORK'

--METADATA  TYPE:SSCR NAME:RT_NONWORK OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_NONWORK' and type in ('TR'))
  DROP TRIGGER RT_NONWORK
go
--METADATA NAME:RT_NONWORK TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_NONWORK
on NONWORK
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update NONWORK
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else NONWORK.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else NONWORK.create_date end
from NONWORK WITH (INDEX(pk_nonwork)) join inserted 
on NONWORK.nonwork_type_id = inserted.nonwork_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'NONWORK',nonwork_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select nonwork_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'NONWORK'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger TR_NOTE_FK'

--METADATA  TYPE:SSCR NAME:TR_NOTE_FK OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'TR_NOTE_FK' and type in ('TR'))
  DROP TRIGGER TR_NOTE_FK
go
--METADATA NAME:TR_NOTE_FK TYPE:TRIGGER SET:INTEGRITY CHANGE:CREATE
CREATE TRIGGER TR_NOTE_FK
 on note
FOR UPDATE, INSERT 
as
BEGIN
  declare @dist_cnt int, @parent_cnt int
  select @dist_cnt=count(distinct fk_id) from inserted where upper(table_name) = 'SCENARIO'
  select @parent_cnt=count(*) from scenario 
  where scenario_id in (select distinct fk_id from inserted where upper(table_name) = 'SCENARIO')
  if @dist_cnt<>@parent_cnt
  begin
    raiserror ('Integrity Error. FK_ID value does not exist in SCENARIO table',16,1)
    rollback transaction
  end
END
go
print 'Creating trigger PRMAUD_NOTE'

--METADATA  TYPE:SSCR NAME:PRMAUD_NOTE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_NOTE' and type in ('TR'))
  DROP TRIGGER PRMAUD_NOTE
go
--METADATA NAME:PRMAUD_NOTE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_NOTE
on NOTE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @inote_id varchar(255),@itable_name varchar(255),@itype_name varchar(255),@ifk_id varchar(255),@inote_date varchar(255),@inote_value varchar(4000),@iuser_name varchar(255)
  declare @dnote_id varchar(255),@dtable_name varchar(255),@dtype_name varchar(255),@dfk_id varchar(255),@dnote_date varchar(255),@dnote_value varchar(4000),@duser_name varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(note_id) and
			not update(table_name) and
			not update(type_name) and
			not update(fk_id) and
			not update(note_date) and
			not update(note_value) and
			not update(user_name) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'NOTE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'NOTE',note_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'NOTE', note_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select note_id,table_name,type_name,fk_id,note_date,note_value,user_name
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select note_id,table_name,type_name,fk_id,note_date,note_value,user_name
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @inote_id,@itable_name,@itype_name,@ifk_id,@inote_date,@inote_value,@iuser_name, @idelete_session_id
  else
    fetch deleted_c into @dnote_id,@dtable_name,@dtype_name,@dfk_id,@dnote_date,@dnote_value,@duser_name, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dnote_id;
				

    end else begin
    	set @pk1 = @inote_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dnote_id,@dtable_name,@dtype_name,@dfk_id,@dnote_date,@dnote_value,@duser_name, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(note_id)) exec audit_data 'NOTE','note_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnote_id,@inote_id,@audit_data OUTPUT
   if (@loper='D' or  update(table_name)) exec audit_data 'NOTE','table_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtable_name,@itable_name,@audit_data OUTPUT
   if (@loper='D' or  update(type_name)) exec audit_data 'NOTE','type_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dtype_name,@itype_name,@audit_data OUTPUT
   if (@loper='D' or  update(fk_id)) exec audit_data 'NOTE','fk_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dfk_id,@ifk_id,@audit_data OUTPUT
   if (@loper='D' or  update(note_date)) exec audit_data 'NOTE','note_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnote_date,@inote_date,@audit_data OUTPUT
   if (@loper='D' or  update(note_value)) exec audit_data 'NOTE','note_value',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dnote_value,@inote_value,@audit_data OUTPUT
   if (@loper='D' or  update(user_name)) exec audit_data 'NOTE','user_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_name,@iuser_name,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'NOTE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'NOTE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @inote_id,@itable_name,@itype_name,@ifk_id,@inote_date,@inote_value,@iuser_name, @idelete_session_id;
    else
     fetch deleted_c into @dnote_id,@dtable_name,@dtype_name,@dfk_id,@dnote_date,@dnote_value,@duser_name, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_NOTE_DEL'

--METADATA  TYPE:SSCR NAME:RT_NOTE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_NOTE_DEL' and type in ('TR'))
  DROP TRIGGER RT_NOTE_DEL
go
--METADATA NAME:RT_NOTE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_NOTE_DEL
on NOTE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'NOTE',note_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_NOTE'

--METADATA  TYPE:SSCR NAME:RT_NOTE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_NOTE' and type in ('TR'))
  DROP TRIGGER RT_NOTE
go
--METADATA NAME:RT_NOTE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_NOTE
on NOTE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update NOTE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else NOTE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else NOTE.create_date end
from NOTE WITH (INDEX(pk_note)) join inserted 
on NOTE.note_id = inserted.note_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'NOTE',note_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select note_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'NOTE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_OBS'

--METADATA  TYPE:SSCR NAME:PRMAUD_OBS OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_OBS' and type in ('TR'))
  DROP TRIGGER PRMAUD_OBS
go
--METADATA NAME:PRMAUD_OBS TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_OBS
on OBS
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iobs_id varchar(255),@iseq_num varchar(255),@iobs_name varchar(255),@iparent_obs_id varchar(255),@iguid varchar(255)
  declare @dobs_id varchar(255),@dseq_num varchar(255),@dobs_name varchar(255),@dparent_obs_id varchar(255),@dguid varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(obs_id) and
			not update(seq_num) and
			not update(obs_name) and
			not update(parent_obs_id) and
			not update(guid) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'OBS', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'OBS',obs_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'OBS', obs_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select obs_id,seq_num,obs_name,parent_obs_id,guid
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select obs_id,seq_num,obs_name,parent_obs_id,guid
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iobs_id,@iseq_num,@iobs_name,@iparent_obs_id,@iguid, @idelete_session_id
  else
    fetch deleted_c into @dobs_id,@dseq_num,@dobs_name,@dparent_obs_id,@dguid, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dobs_id;
				

    end else begin
    	set @pk1 = @iobs_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dobs_id,@dseq_num,@dobs_name,@dparent_obs_id,@dguid, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(obs_id)) exec audit_data 'OBS','obs_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dobs_id,@iobs_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'OBS','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(obs_name)) exec audit_data 'OBS','obs_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dobs_name,@iobs_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_obs_id)) exec audit_data 'OBS','parent_obs_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_obs_id,@iparent_obs_id,@audit_data OUTPUT
   if (@loper='D' or  update(guid)) exec audit_data 'OBS','guid',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dguid,@iguid,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'OBS', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'OBS', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iobs_id,@iseq_num,@iobs_name,@iparent_obs_id,@iguid, @idelete_session_id;
    else
     fetch deleted_c into @dobs_id,@dseq_num,@dobs_name,@dparent_obs_id,@dguid, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_OBS_DEL'

--METADATA  TYPE:SSCR NAME:RT_OBS_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_OBS_DEL' and type in ('TR'))
  DROP TRIGGER RT_OBS_DEL
go
--METADATA NAME:RT_OBS_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_OBS_DEL
on OBS
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'OBS',obs_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_OBS'

--METADATA  TYPE:SSCR NAME:RT_OBS OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_OBS' and type in ('TR'))
  DROP TRIGGER RT_OBS
go
--METADATA NAME:RT_OBS TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_OBS
on OBS
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update OBS
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else OBS.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else OBS.create_date end
from OBS WITH (INDEX(pk_obs)) join inserted 
on OBS.obs_id = inserted.obs_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'OBS',obs_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select obs_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'OBS'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PCATTYPE'

--METADATA  TYPE:SSCR NAME:PRMAUD_PCATTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PCATTYPE' and type in ('TR'))
  DROP TRIGGER PRMAUD_PCATTYPE
go
--METADATA NAME:PRMAUD_PCATTYPE TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_PCATTYPE
on PCATTYPE
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iproj_catg_type_id varchar(255),@iseq_num varchar(255),@iproj_catg_short_len varchar(255),@iproj_catg_type varchar(255),@isuper_flag varchar(255),@iproj_catg_type_wt varchar(255),@imax_proj_catg_wt varchar(255)
  declare @dproj_catg_type_id varchar(255),@dseq_num varchar(255),@dproj_catg_short_len varchar(255),@dproj_catg_type varchar(255),@dsuper_flag varchar(255),@dproj_catg_type_wt varchar(255),@dmax_proj_catg_wt varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(proj_catg_type_id) and
			not update(seq_num) and
			not update(proj_catg_short_len) and
			not update(proj_catg_type) and
			not update(super_flag) and
			not update(proj_catg_type_wt) and
			not update(max_proj_catg_wt) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'PCATTYPE', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATTYPE',proj_catg_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATTYPE', proj_catg_type_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select proj_catg_type_id,seq_num,proj_catg_short_len,proj_catg_type,super_flag,proj_catg_type_wt,max_proj_catg_wt
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select proj_catg_type_id,seq_num,proj_catg_short_len,proj_catg_type,super_flag,proj_catg_type_wt,max_proj_catg_wt
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iproj_catg_type_id,@iseq_num,@iproj_catg_short_len,@iproj_catg_type,@isuper_flag,@iproj_catg_type_wt,@imax_proj_catg_wt, @idelete_session_id
  else
    fetch deleted_c into @dproj_catg_type_id,@dseq_num,@dproj_catg_short_len,@dproj_catg_type,@dsuper_flag,@dproj_catg_type_wt,@dmax_proj_catg_wt, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dproj_catg_type_id;
				

    end else begin
    	set @pk1 = @iproj_catg_type_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dproj_catg_type_id,@dseq_num,@dproj_catg_short_len,@dproj_catg_type,@dsuper_flag,@dproj_catg_type_wt,@dmax_proj_catg_wt, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(proj_catg_type_id)) exec audit_data 'PCATTYPE','proj_catg_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_type_id,@iproj_catg_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'PCATTYPE','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_short_len)) exec audit_data 'PCATTYPE','proj_catg_short_len',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_short_len,@iproj_catg_short_len,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_type)) exec audit_data 'PCATTYPE','proj_catg_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_type,@iproj_catg_type,@audit_data OUTPUT
   if (@loper='D' or  update(super_flag)) exec audit_data 'PCATTYPE','super_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dsuper_flag,@isuper_flag,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_type_wt)) exec audit_data 'PCATTYPE','proj_catg_type_wt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_type_wt,@iproj_catg_type_wt,@audit_data OUTPUT
   if (@loper='D' or  update(max_proj_catg_wt)) exec audit_data 'PCATTYPE','max_proj_catg_wt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dmax_proj_catg_wt,@imax_proj_catg_wt,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'PCATTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'PCATTYPE', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iproj_catg_type_id,@iseq_num,@iproj_catg_short_len,@iproj_catg_type,@isuper_flag,@iproj_catg_type_wt,@imax_proj_catg_wt, @idelete_session_id;
    else
     fetch deleted_c into @dproj_catg_type_id,@dseq_num,@dproj_catg_short_len,@dproj_catg_type,@dsuper_flag,@dproj_catg_type_wt,@dmax_proj_catg_wt, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_PCATTYPE_DEL'

--METADATA  TYPE:SSCR NAME:RT_PCATTYPE_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATTYPE_DEL' and type in ('TR'))
  DROP TRIGGER RT_PCATTYPE_DEL
go
--METADATA NAME:RT_PCATTYPE_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATTYPE_DEL
on PCATTYPE
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATTYPE',proj_catg_type_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_PCATTYPE'

--METADATA  TYPE:SSCR NAME:RT_PCATTYPE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATTYPE' and type in ('TR'))
  DROP TRIGGER RT_PCATTYPE
go
--METADATA NAME:RT_PCATTYPE TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATTYPE
on PCATTYPE
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update PCATTYPE
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else PCATTYPE.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else PCATTYPE.create_date end
from PCATTYPE WITH (INDEX(pk_pcattype)) join inserted 
on PCATTYPE.proj_catg_type_id = inserted.proj_catg_type_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATTYPE',proj_catg_type_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select proj_catg_type_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'PCATTYPE'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PCATUSER'

--METADATA  TYPE:SSCR NAME:PRMAUD_PCATUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PCATUSER' and type in ('TR'))
  DROP TRIGGER PRMAUD_PCATUSER
go
--METADATA NAME:PRMAUD_PCATUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_PCATUSER
on PCATUSER
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iproj_catg_id varchar(255),@iuser_id varchar(255)
  declare @dproj_catg_id varchar(255),@duser_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(proj_catg_id) and
			not update(user_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'PCATUSER', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATUSER',proj_catg_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATUSER', proj_catg_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select proj_catg_id,user_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select proj_catg_id,user_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iproj_catg_id,@iuser_id, @idelete_session_id
  else
    fetch deleted_c into @dproj_catg_id,@duser_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dproj_catg_id;
				
set @pk2 = @duser_id;
				

    end else begin
    	set @pk1 = @iproj_catg_id;
				
set @pk2 = @iuser_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dproj_catg_id,@duser_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(proj_catg_id)) exec audit_data 'PCATUSER','proj_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_id,@iproj_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'PCATUSER','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'PCATUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'PCATUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iproj_catg_id,@iuser_id, @idelete_session_id;
    else
     fetch deleted_c into @dproj_catg_id,@duser_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_PCATUSER_DEL'

--METADATA  TYPE:SSCR NAME:RT_PCATUSER_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATUSER_DEL' and type in ('TR'))
  DROP TRIGGER RT_PCATUSER_DEL
go
--METADATA NAME:RT_PCATUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATUSER_DEL
on PCATUSER
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATUSER',proj_catg_id,user_id,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_PCATUSER'

--METADATA  TYPE:SSCR NAME:RT_PCATUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATUSER' and type in ('TR'))
  DROP TRIGGER RT_PCATUSER
go
--METADATA NAME:RT_PCATUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATUSER
on PCATUSER
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update PCATUSER
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else PCATUSER.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else PCATUSER.create_date end
from PCATUSER WITH (INDEX(pk_pcatuser)) join inserted 
on PCATUSER.proj_catg_id = inserted.proj_catg_id
and PCATUSER.user_id = inserted.user_id
begin
  declare ins cursor  for select proj_catg_id,user_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'PCATUSER'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATUSER',proj_catg_id,user_id,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select proj_catg_id,user_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'PCATUSER'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PCATVAL'

--METADATA  TYPE:SSCR NAME:PRMAUD_PCATVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PCATVAL' and type in ('TR'))
  DROP TRIGGER PRMAUD_PCATVAL
go
--METADATA NAME:PRMAUD_PCATVAL TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_PCATVAL
on PCATVAL
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @iproj_catg_id varchar(255),@iproj_catg_type_id varchar(255),@iseq_num varchar(255),@iproj_catg_short_name varchar(255),@iparent_proj_catg_id varchar(255),@iproj_catg_name varchar(255),@iproj_catg_wt varchar(255)
  declare @dproj_catg_id varchar(255),@dproj_catg_type_id varchar(255),@dseq_num varchar(255),@dproj_catg_short_name varchar(255),@dparent_proj_catg_id varchar(255),@dproj_catg_name varchar(255),@dproj_catg_wt varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(proj_catg_id) and
			not update(proj_catg_type_id) and
			not update(seq_num) and
			not update(proj_catg_short_name) and
			not update(parent_proj_catg_id) and
			not update(proj_catg_name) and
			not update(proj_catg_wt) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'PCATVAL', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATVAL',proj_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PCATVAL', proj_catg_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select proj_catg_id,proj_catg_type_id,seq_num,proj_catg_short_name,parent_proj_catg_id,proj_catg_name,proj_catg_wt
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select proj_catg_id,proj_catg_type_id,seq_num,proj_catg_short_name,parent_proj_catg_id,proj_catg_name,proj_catg_wt
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @iproj_catg_id,@iproj_catg_type_id,@iseq_num,@iproj_catg_short_name,@iparent_proj_catg_id,@iproj_catg_name,@iproj_catg_wt, @idelete_session_id
  else
    fetch deleted_c into @dproj_catg_id,@dproj_catg_type_id,@dseq_num,@dproj_catg_short_name,@dparent_proj_catg_id,@dproj_catg_name,@dproj_catg_wt, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dproj_catg_id;
				

    end else begin
    	set @pk1 = @iproj_catg_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dproj_catg_id,@dproj_catg_type_id,@dseq_num,@dproj_catg_short_name,@dparent_proj_catg_id,@dproj_catg_name,@dproj_catg_wt, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(proj_catg_id)) exec audit_data 'PCATVAL','proj_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_id,@iproj_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_type_id)) exec audit_data 'PCATVAL','proj_catg_type_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_type_id,@iproj_catg_type_id,@audit_data OUTPUT
   if (@loper='D' or  update(seq_num)) exec audit_data 'PCATVAL','seq_num',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dseq_num,@iseq_num,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_short_name)) exec audit_data 'PCATVAL','proj_catg_short_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_short_name,@iproj_catg_short_name,@audit_data OUTPUT
   if (@loper='D' or  update(parent_proj_catg_id)) exec audit_data 'PCATVAL','parent_proj_catg_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dparent_proj_catg_id,@iparent_proj_catg_id,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_name)) exec audit_data 'PCATVAL','proj_catg_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_name,@iproj_catg_name,@audit_data OUTPUT
   if (@loper='D' or  update(proj_catg_wt)) exec audit_data 'PCATVAL','proj_catg_wt',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dproj_catg_wt,@iproj_catg_wt,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'PCATVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'PCATVAL', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @iproj_catg_id,@iproj_catg_type_id,@iseq_num,@iproj_catg_short_name,@iparent_proj_catg_id,@iproj_catg_name,@iproj_catg_wt, @idelete_session_id;
    else
     fetch deleted_c into @dproj_catg_id,@dproj_catg_type_id,@dseq_num,@dproj_catg_short_name,@dparent_proj_catg_id,@dproj_catg_name,@dproj_catg_wt, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_PCATVAL_DEL'

--METADATA  TYPE:SSCR NAME:RT_PCATVAL_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATVAL_DEL' and type in ('TR'))
  DROP TRIGGER RT_PCATVAL_DEL
go
--METADATA NAME:RT_PCATVAL_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATVAL_DEL
on PCATVAL
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATVAL',proj_catg_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_PCATVAL'

--METADATA  TYPE:SSCR NAME:RT_PCATVAL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PCATVAL' and type in ('TR'))
  DROP TRIGGER RT_PCATVAL
go
--METADATA NAME:RT_PCATVAL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PCATVAL
on PCATVAL
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update PCATVAL
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else PCATVAL.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else PCATVAL.create_date end
from PCATVAL WITH (INDEX(pk_pcatval)) join inserted 
on PCATVAL.proj_catg_id = inserted.proj_catg_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PCATVAL',proj_catg_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select proj_catg_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'PCATVAL'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PFOLIO'

--METADATA  TYPE:SSCR NAME:PRMAUD_PFOLIO OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PFOLIO' and type in ('TR'))
  DROP TRIGGER PRMAUD_PFOLIO
go
--METADATA NAME:PRMAUD_PFOLIO TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_PFOLIO
on PFOLIO
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ipfolio_id varchar(255),@iclosed_proj_flag varchar(255),@iwhatif_proj_flag varchar(255),@ipfolio_type varchar(255),@ipfolio_name varchar(255),@iuser_id varchar(255),@ipfolio_descr varchar(255),@ilast_refresh_date varchar(255)
  declare @dpfolio_id varchar(255),@dclosed_proj_flag varchar(255),@dwhatif_proj_flag varchar(255),@dpfolio_type varchar(255),@dpfolio_name varchar(255),@duser_id varchar(255),@dpfolio_descr varchar(255),@dlast_refresh_date varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(pfolio_id) and
			not update(closed_proj_flag) and
			not update(whatif_proj_flag) and
			not update(pfolio_type) and
			not update(pfolio_name) and
			not update(user_id) and
			not update(pfolio_descr) and
			not update(last_refresh_date) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'PFOLIO', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PFOLIO',pfolio_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PFOLIO', pfolio_id,null,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select pfolio_id,closed_proj_flag,whatif_proj_flag,pfolio_type,pfolio_name,user_id,pfolio_descr,last_refresh_date
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select pfolio_id,closed_proj_flag,whatif_proj_flag,pfolio_type,pfolio_name,user_id,pfolio_descr,last_refresh_date
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ipfolio_id,@iclosed_proj_flag,@iwhatif_proj_flag,@ipfolio_type,@ipfolio_name,@iuser_id,@ipfolio_descr,@ilast_refresh_date, @idelete_session_id
  else
    fetch deleted_c into @dpfolio_id,@dclosed_proj_flag,@dwhatif_proj_flag,@dpfolio_type,@dpfolio_name,@duser_id,@dpfolio_descr,@dlast_refresh_date, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dpfolio_id;
				

    end else begin
    	set @pk1 = @ipfolio_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dpfolio_id,@dclosed_proj_flag,@dwhatif_proj_flag,@dpfolio_type,@dpfolio_name,@duser_id,@dpfolio_descr,@dlast_refresh_date, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(pfolio_id)) exec audit_data 'PFOLIO','pfolio_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpfolio_id,@ipfolio_id,@audit_data OUTPUT
   if (@loper='D' or  update(closed_proj_flag)) exec audit_data 'PFOLIO','closed_proj_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dclosed_proj_flag,@iclosed_proj_flag,@audit_data OUTPUT
   if (@loper='D' or  update(whatif_proj_flag)) exec audit_data 'PFOLIO','whatif_proj_flag',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dwhatif_proj_flag,@iwhatif_proj_flag,@audit_data OUTPUT
   if (@loper='D' or  update(pfolio_type)) exec audit_data 'PFOLIO','pfolio_type',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpfolio_type,@ipfolio_type,@audit_data OUTPUT
   if (@loper='D' or  update(pfolio_name)) exec audit_data 'PFOLIO','pfolio_name',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpfolio_name,@ipfolio_name,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'PFOLIO','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
   if (@loper='D' or  update(pfolio_descr)) exec audit_data 'PFOLIO','pfolio_descr',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpfolio_descr,@ipfolio_descr,@audit_data OUTPUT
   if (@loper='D' or  update(last_refresh_date)) exec audit_data 'PFOLIO','last_refresh_date',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dlast_refresh_date,@ilast_refresh_date,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'PFOLIO', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'PFOLIO', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ipfolio_id,@iclosed_proj_flag,@iwhatif_proj_flag,@ipfolio_type,@ipfolio_name,@iuser_id,@ipfolio_descr,@ilast_refresh_date, @idelete_session_id;
    else
     fetch deleted_c into @dpfolio_id,@dclosed_proj_flag,@dwhatif_proj_flag,@dpfolio_type,@dpfolio_name,@duser_id,@dpfolio_descr,@dlast_refresh_date, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_PFOLIO_DEL'

--METADATA  TYPE:SSCR NAME:RT_PFOLIO_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PFOLIO_DEL' and type in ('TR'))
  DROP TRIGGER RT_PFOLIO_DEL
go
--METADATA NAME:RT_PFOLIO_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PFOLIO_DEL
on PFOLIO
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PFOLIO',pfolio_id,null,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_PFOLIO'

--METADATA  TYPE:SSCR NAME:RT_PFOLIO OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PFOLIO' and type in ('TR'))
  DROP TRIGGER RT_PFOLIO
go
--METADATA NAME:RT_PFOLIO TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PFOLIO
on PFOLIO
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update PFOLIO
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else PFOLIO.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else PFOLIO.create_date end
from PFOLIO WITH (INDEX(pk_pfolio)) join inserted 
on PFOLIO.pfolio_id = inserted.pfolio_id

if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PFOLIO',pfolio_id,null,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select pfolio_id,null,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'PFOLIO'
      and  @pk1 = refrdel.pk1
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PFOLIOUSER'

--METADATA  TYPE:SSCR NAME:PRMAUD_PFOLIOUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PFOLIOUSER' and type in ('TR'))
  DROP TRIGGER PRMAUD_PFOLIOUSER
go
--METADATA NAME:PRMAUD_PFOLIOUSER TYPE:TRIGGER SET:AUDIT CHANGE:CREATE
CREATE TRIGGER PRMAUD_PFOLIOUSER
on PFOLIOUSER
for update, insert, delete
as     
  declare @oper char(1), @ins_cnt int, @del_cnt int, @logical_delete varchar(1), @sess_id int, @prm_user_name varchar(255), @app_name varchar(25)
  declare @program varchar(255), @hostname varchar(255), @netaddress varchar(24), @rdbms_user varchar(30), @os_user varchar(255)
  declare @pk1 varchar(255), @pk2 varchar(255), @pk3 varchar(255), @pk4 varchar(255)
  declare @audit int, @insert_level int, @update_level int, @delete_level int, @col_audit varchar(4000)
  	 
  declare @ipfolio_id varchar(255),@iuser_id varchar(255)
  declare @dpfolio_id varchar(255),@duser_id varchar(255)
  declare @idelete_session_id int, @ddelete_session_id int,@audit_old varchar(4000),@audit_new varchar(4000), @loper char(1)
     
  declare @audit_data varchar(4000)
     
  select @ins_cnt=count(*) from inserted; select @del_cnt=count(*) from deleted;
  if @ins_cnt = @del_cnt set @oper = 'U'  ELSE IF @ins_cnt > 0 set @oper = 'I'  ELSE  set @oper = 'D';

   
	if @oper = 'U' and not update(pfolio_id) and
			not update(user_id) and
			 not update(delete_session_id)
     return
         
		 
  exec audit_tab_options 'PFOLIOUSER', @audit OUTPUT, @insert_level OUTPUT, @update_level OUTPUT, @delete_level OUTPUT, @col_audit OUTPUT

  if @audit < 1 RETURN

  exec audit_prm_user @sess_id OUTPUT, @prm_user_name OUTPUT, @app_name OUTPUT
  exec audit_proc_info @program OUTPUT, @hostname OUTPUT, @netaddress OUTPUT, @rdbms_user OUTPUT, @os_user OUTPUT

  set @loper = @oper;
  set @logical_delete = 'N'
  
    /* Handle ROW-level only */
  if (@oper = 'U' and @update_level = 1 ) or ( @oper = 'I' and @insert_level = 1 ) or (@oper = 'D' and @delete_level = 1 )
  begin 
    select top 1 @ddelete_session_id=delete_session_id from deleted
    select top 1 @idelete_session_id=delete_session_id from inserted

    if @ddelete_session_id is null and @idelete_session_id is not null 
    begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    if ( @oper = 'U' ) or ( @oper = 'I') 
      
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PFOLIOUSER',pfolio_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from inserted
    else
      insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag)
      select getDate(),'PFOLIOUSER', pfolio_id,user_id,null,null , @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete
      from deleted
    return
  end 
  
  if (select count(*) from spidmap where spid=@@spid)=0
    insert into spidmap (spid,audit_info_extended) values(@@spid,'')
  else
    update spidmap set audit_info_extended='' where spid=@@spid
  
  declare deleted_c cursor for 
  select pfolio_id,user_id
		,delete_session_id
  from deleted;
  declare inserted_c cursor for 
  select pfolio_id,user_id
		,delete_session_id
  from inserted;

  open inserted_c  open deleted_c
  
  if @oper = 'I' or @oper = 'U'
    fetch inserted_c into @ipfolio_id,@iuser_id, @idelete_session_id
  else
    fetch deleted_c into @dpfolio_id,@duser_id, @idelete_session_id

  while @@fetch_status = 0 
  begin
      
	set @audit_data=''
  	
	set @audit_old=''
	set @audit_new=''

    if @oper = 'D' begin
    set @pk1 = @dpfolio_id;
				
set @pk2 = @duser_id;
				

    end else begin
    	set @pk1 = @ipfolio_id;
				
set @pk2 = @iuser_id;
				

    end

    if @oper = 'U' 
    begin
      fetch deleted_c into @dpfolio_id,@duser_id, @ddelete_session_id
      if @ddelete_session_id is null and @idelete_session_id is not null 
      begin  set @logical_delete = 'Y' set @loper = 'D' end else set @logical_delete = 'N'
    end


    if (@loper = 'U' and @update_level >= 2 ) or ( @loper = 'I' and @insert_level >= 2) or (@loper = 'D' and @delete_level >= 2)
    begin
    
   if (@loper='D' or  update(pfolio_id)) exec audit_data 'PFOLIOUSER','pfolio_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@dpfolio_id,@ipfolio_id,@audit_data OUTPUT
   if (@loper='D' or  update(user_id)) exec audit_data 'PFOLIOUSER','user_id',@loper,@pk1,@pk2,@pk3,@pk4,@prm_user_name
       ,@program,@hostname,@netaddress,@rdbms_user,@os_user,@app_name,1,@logical_delete,'Y'
       ,@duser_id,@iuser_id,@audit_data OUTPUT
		
      if @audit_data is null or len(@audit_data)<=4000
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info)
        values (getDate(),'PFOLIOUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data)
      else
        insert into prmaudit (audit_date,table_name,pk1,pk2,pk3,pk4,oper,rdbms_user_name, app_name,
                        prm_user_name,os_user_name,program,host_name,netaddress,logical_delete_flag,audit_info,audit_info_extended)
        select getDate(),'PFOLIOUSER', @pk1, @pk2, @pk3, @pk4, @loper, @rdbms_user, @app_name
          ,@prm_user_name, @os_user, @program, @hostname, @netaddress,@logical_delete, @audit_data
          ,audit_info_extended
       from spidmap where spid = @@spid
 
       end
    
	
    if @loper = 'I' or @loper = 'U'
    fetch inserted_c into @ipfolio_id,@iuser_id, @idelete_session_id;
    else
     fetch deleted_c into @dpfolio_id,@duser_id, @ddelete_session_id;
  end
  close deleted_c  close inserted_c  deallocate deleted_c  deallocate inserted_c

    
go
print 'Creating trigger RT_PFOLIOUSER_DEL'

--METADATA  TYPE:SSCR NAME:RT_PFOLIOUSER_DEL OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PFOLIOUSER_DEL' and type in ('TR'))
  DROP TRIGGER RT_PFOLIOUSER_DEL
go
--METADATA NAME:RT_PFOLIOUSER_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PFOLIOUSER_DEL
on PFOLIOUSER
for delete
as   
set nocount on
  
if (select count(*) from inserted) = 0
BEGIN
	  
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PFOLIOUSER',pfolio_id,user_id,null,null
      from deleted
  	


END
go
print 'Creating trigger RT_PFOLIOUSER'

--METADATA  TYPE:SSCR NAME:RT_PFOLIOUSER OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_PFOLIOUSER' and type in ('TR'))
  DROP TRIGGER RT_PFOLIOUSER
go
--METADATA NAME:RT_PFOLIOUSER TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_PFOLIOUSER
on PFOLIOUSER
for update,insert
  
as     
set nocount on
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;


update PFOLIOUSER
set update_date = getdate()    
, update_user = @user_name

, create_user =  case @del_cnt WHEN 0 then @user_name else PFOLIOUSER.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else PFOLIOUSER.create_date end
from PFOLIOUSER WITH (INDEX(pk_pfoliouser)) join inserted 
on PFOLIOUSER.pfolio_id = inserted.pfolio_id
and PFOLIOUSER.user_id = inserted.user_id
begin
  declare ins cursor  for select pfolio_id,user_id,null,null from inserted
  open ins
  fetch next from ins into @pk1,@pk2,@pk3,@pk4
  while  @@fetch_status = 0
  begin
    DELETE FROM REFRDEL WHERE table_name = 'PFOLIOUSER'
    and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
  end
  close ins deallocate ins
                 
end 


if @del_cnt > 0 and update(delete_session_id)
BEGIN
      INSERT INTO REFRDEL ( delete_date,table_name, pk1,pk2,pk3,pk4)
      select getDate(),'PFOLIOUSER',pfolio_id,user_id,null,null
      from inserted
      where delete_session_id is not null
  	
  	
    declare ins cursor  for select pfolio_id,user_id,null,null from inserted where delete_session_id is null
    open ins
    fetch next from ins into @pk1,@pk2,@pk3,@pk4
    while  @@fetch_status = 0
    begin
      DELETE FROM REFRDEL WHERE table_name = 'PFOLIOUSER'
      and  @pk1 = refrdel.pk1
and @pk2 = refrdel.pk2
      fetch next from ins into @pk1,@pk2,@pk3,@pk4
    end
    close ins deallocate ins                  

END

go
print 'Creating trigger PRMAUD_PHASE'

--METADATA  TYPE:SSCR NAME:PRMAUD_PHASE OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'PRMAUD_PHASE' and type in ('TR'))
  DROP TRIGGER PRMAUD_PHASE
go
--METADATA NAME:PRMAUD_P