
SET QUOTED_IDENTIFIER ON

print 'Dropping constraint fk_prefer_users2 on table PREFER'


--METADATA NAME:fk_prefer_users2 TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_prefer_users2';
if @cons_cnt > 0  
ALTER TABLE PREFER DROP CONSTRAINT fk_prefer_users2;
go

print 'Dropping index ndx_projrisk_obs on table PROJRISK'

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DROP INDEX PROJRISK.ndx_projrisk_obs;
      go

print 'Dropping index ndx_projrisk_projwbs on table PROJRISK'

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DROP INDEX PROJRISK.ndx_projrisk_projwbs;
      go

print 'Dropping constraint fk_projrisk_obs on table PROJRISK'


--METADATA NAME:fk_projrisk_obs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_obs';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_obs;
go

print 'Dropping constraint fk_projrisk_project on table PROJRISK'


--METADATA NAME:fk_projrisk_project TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_project';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_project;
go

print 'Dropping constraint fk_projrisk_risktype on table PROJRISK'


--METADATA NAME:fk_projrisk_risktype TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_risktype';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_risktype;
go

print 'Dropping constraint fk_projrisk_rsrc on table PROJRISK'


--METADATA NAME:fk_projrisk_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_rsrc';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_rsrc;
go

print 'Dropping constraint fk_projrisk_projwbs on table PROJRISK'


--METADATA NAME:fk_projrisk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_projwbs';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_projwbs;
go

print 'Dropping constraint fk_riskctrl_project on table RISKCTRL'


--METADATA NAME:fk_riskctrl_project TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_riskctrl_project';
if @cons_cnt > 0  
ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_project;
go

print 'Dropping constraint fk_riskctrl_projrisk on table RISKCTRL'


--METADATA NAME:fk_riskctrl_projrisk TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_riskctrl_projrisk';
if @cons_cnt > 0  
ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_projrisk;
go

print 'Dropping constraint fk_tasksum_project on table TASKSUM'


--METADATA NAME:fk_tasksum_project TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksum_project';
if @cons_cnt > 0  
ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_project;
go

print 'Dropping constraint fk_tasksum_projwbs on table TASKSUM'


--METADATA NAME:fk_tasksum_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksum_projwbs';
if @cons_cnt > 0  
ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_projwbs;
go

print 'Dropping constraint fk_tasksumfin_findates on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_findates TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_findates';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_findates;
go

print 'Dropping constraint fk_tasksumfin_project on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_project TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_project';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_project;
go

print 'Dropping constraint fk_tasksumfin_projwbs on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_projwbs';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_projwbs;
go

print 'Dropping constraint fk_tasksumfin_tasksum on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_tasksum TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_tasksum';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_tasksum;
go

print 'Dropping constraint fk_timesht_rsrc on table TIMESHT'


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_timesht_rsrc';
if @cons_cnt > 0  
ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_rsrc;
go

print 'Dropping constraint fk_timesht_tsdates on table TIMESHT'


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_timesht_tsdates';
if @cons_cnt > 0  
ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_tsdates;
go

print 'Dropping constraint fk_trsrcsum_project on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_project';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_project;
go

print 'Dropping constraint fk_trsrcsum_roles on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_roles';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_roles;
go

print 'Dropping constraint fk_trsrcsum_rsrc on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_rsrc';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_rsrc;
go

print 'Dropping constraint fk_trsrcsumfn_findates on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_findates TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_findates';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_findates;
go

print 'Dropping constraint fk_trsrcsumfn_project on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_project';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_project;
go

print 'Dropping constraint fk_trsrcsumfn_roles on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_roles';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_roles;
go

print 'Dropping constraint fk_trsrcsumfn_rsrc on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_rsrc';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_rsrc;
go

print 'Dropping constraint fk_trsrcsumfn_trsrcsum on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_trsrcsum TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_trsrcsum';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_trsrcsum;
go

print 'Creating table ASGNMNTACAT'

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  "taskrsrc_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "asgnmnt_catg_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATTYPE'

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_len"  integer NOT NULL,
  "asgnmnt_catg_type"  varchar(60) NOT NULL,
  "super_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATVAL'

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  "asgnmnt_catg_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_name"  varchar(60) NOT NULL,
  "asgnmnt_catg_name"  varchar(100) NULL,
  "parent_asgnmnt_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)  )


go
print 'Creating table DISCUSSION'

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  "discussion_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "discussion_value"  varchar(4000) NULL,
  "discussion_date"  datetime NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )


go
print 'Creating table DISCUSSION_READ'

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  "discussion_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )


go
print 'Creating table DOCREVIEW'

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEW(
  "doc_review_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_name"  varchar(255) NULL,
  "review_descr"  varchar(255) NULL,
  "review_type"  varchar(15) NULL,
  "due_date"  datetime NULL,
  "status"  varchar(15) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)  )


go
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,162,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=162)
go
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,163,case p.allow_flag when 'Y' then 'Y' else 'N' END,getdate(),session_user from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=163)
go

print 'Creating table DOCREVIEWTASK'

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEWTASK(
  "review_task_id"  integer NOT NULL,
  "doc_review_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_date"  datetime NULL,
  "comments"  varchar(4000) NULL,
  "priority"  integer NULL,
  "status"  varchar(15) NULL,
  "attachment_uuid"  varchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)  )


go
print 'Creating table FINTMPL'

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  "fintmpl_id"  integer NOT NULL,
  "fintmpl_name"  varchar(255) NOT NULL,
  "default_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)  )


go
--METADATA  TYPE:ADHOC_SQL
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) Select 1, 'Calendar', 'Y', getdate(), getdate() WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

print 'Creating table IMAGEDATA'

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  "image_id"  integer NOT NULL,
  "image_name"  varchar(120) NULL,
  "image_data"  varbinary(max) NOT NULL,
  "image_thumbnail"  varbinary(max) NOT NULL,
  "image_extension"  varchar(20) DEFAULT 'png' NOT NULL,
  "default_flag"  varchar(1) NOT NULL,
  "image_purpose"  varchar(50) NOT NULL,
  "image_description"  varchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )


go
print 'Creating table LOCATION'

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  "location_id"  integer NOT NULL,
  "location_name"  varchar(255) NOT NULL,
  "location_type"  varchar(24) NULL,
  "address_line1"  varchar(200) NULL,
  "address_line2"  varchar(200) NULL,
  "address_line3"  varchar(200) NULL,
  "city_name"  varchar(200) NULL,
  "municipality_name"  varchar(200) NULL,
  "state_name"  varchar(200) NULL,
  "state_code"  varchar(2) NULL,
  "country_name"  varchar(200) NULL,
  "country_code"  varchar(3) NULL,
  "postal_code"  varchar(20) NULL,
  "longitude"  DECIMAL(28,10) NULL,
  "latitude"  DECIMAL(28,10) NULL,
  "geo_location"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id)  )


go
print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )


go
print 'Creating table ROLECATTYPE'

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATTYPE(
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_len"  integer NOT NULL,
  "role_catg_type"  varchar(60) NOT NULL,
  "super_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)  )


go
print 'Creating table ROLECATVAL'

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATVAL(
  "role_catg_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_name"  varchar(60) NOT NULL,
  "role_catg_name"  varchar(100) NULL,
  "parent_role_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)  )


go
print 'Creating table ROLERCAT'

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERCAT(
  "role_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "role_catg_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)  )


go
print 'Creating table SUMPROJCOST'

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMPROJCOST(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "cost_type_id"  integer NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  varchar(20) NULL,
  "act_cost"  numeric(23,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "target_cost"  numeric(23,6) NULL,
  "total_cost"  numeric(23,6) NULL
  )


go
print 'Creating table SUMTASK'

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASK(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "complete_cnt"  integer NULL,
  "active_cnt"  integer NULL,
  "notstarted_cnt"  integer NULL,
  "base_complete_cnt"  integer NULL,
  "base_active_cnt"  integer NULL,
  "base_notstarted_cnt"  integer NULL,
  "act_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_drtn_hr_cnt"  numeric(17,6) NULL,
  "base_drtn_hr_cnt"  numeric(17,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_float_hr_cnt"  numeric(17,6) NULL,
  "act_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "base_end_date"  datetime NULL,
  "base_start_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "act_this_per_work_cost"  numeric(25,6) NULL,
  "act_this_per_work_qty"  numeric(22,6) NULL,
  "act_this_per_equip_cost"  numeric(25,6) NULL,
  "act_this_per_equip_qty"  numeric(22,6) NULL,
  "act_this_per_mat_cost"  numeric(25,6) NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "target_drtn_hr_cnt"  numeric(17,6) NULL
  )


go
--METADATA  TYPE:ADHOC_SQL
UPDATE prefer SET phase_label='WBS Category',update_date=getdate(),update_user=session_user 
go
--METADATA  TYPE:ADHOC_SQL
UPDATE projwbs SET sum_data_flag='N' where sum_data_flag != 'N'
go
--METADATA  TYPE:ADHOC_SQL
UPDATE project SET last_tasksum_date=null where last_tasksum_date is not null
go

print 'Creating table SUMTASKSPREAD'

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASKSPREAD(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "end_date"  datetime NOT NULL,
  "spread_type"  varchar(20) NOT NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "late_remain_cost"  numeric(25,6) NULL,
  "late_remain_equip_cost"  numeric(25,6) NULL,
  "late_remain_expense_cost"  numeric(25,6) NULL,
  "late_remain_mat_cost"  numeric(25,6) NULL,
  "late_remain_work_cost"  numeric(25,6) NULL,
  "late_remain_equip_qty"  numeric(22,6) NULL,
  "late_remain_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_cost"  numeric(25,6) NULL,
  "fin_period_act_equip_qty"  numeric(22,6) NULL,
  "fin_period_act_equip_cost"  numeric(25,6) NULL,
  "fin_period_act_mat_cost"  numeric(25,6) NULL,
  "fin_period_act_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_work_qty"  numeric(22,6) NULL,
  "fin_period_total_work_cost"  numeric(25,6) NULL,
  "fin_period_total_equip_qty"  numeric(22,6) NULL,
  "fin_period_total_equip_cost"  numeric(25,6) NULL,
  "fin_period_total_mat_cost"  numeric(25,6) NULL,
  "fin_period_total_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_cost"  numeric(25,6) NULL,
  "fin_period_act_cost"  numeric(25,6) NULL,
  "fin_period_bcwp"  numeric(25,6) NULL,
  "fin_period_perfm_work_qty"  numeric(22,6) NULL,
  "fin_period_eac"  numeric(25,6) NULL,
  "fin_period_eac_work_qty"  numeric(22,6) NULL,
  "fin_period_bcws"  numeric(25,6) NULL,
  "fin_period_sched_work_qty"  numeric(22,6) NULL
  )


go
print 'Creating table SUMTRSRC'

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTRSRC(
  "sumtrsrc_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "wbs_id"  integer NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  varchar(20) NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "remain_start_date"  datetime NULL,
  "remain_end_date"  datetime NULL,
  "overalloc_date"  datetime NULL,
  "staffed_act_qty"  numeric(23,6) NULL,
  "unstaffed_act_qty"  numeric(23,6) NULL,
  "staffed_act_cost"  numeric(23,6) NULL,
  "unstaffed_act_cost"  numeric(23,6) NULL,
  "staffed_act_ot_qty"  numeric(23,6) NULL,
  "unstaffed_act_ot_qty"  numeric(23,6) NULL,
  "staffed_act_ot_cost"  numeric(23,6) NULL,
  "unstaffed_act_ot_cost"  numeric(23,6) NULL,
  "staffed_act_reg_cost"  numeric(23,6) NULL,
  "unstaffed_act_reg_cost"  numeric(23,6) NULL,
  "staffed_act_reg_qty"  numeric(23,6) NULL,
  "unstaffed_act_reg_qty"  numeric(23,6) NULL,
  "staffed_late_remain_qty"  numeric(23,6) NULL,
  "unstaffed_late_remain_qty"  numeric(23,6) NULL,
  "staffed_late_remain_cost"  numeric(23,6) NULL,
  "unstaffed_late_remain_cost"  numeric(23,6) NULL,
  "staffed_remain_qty"  numeric(23,6) NULL,
  "unstaffed_remain_qty"  numeric(23,6) NULL,
  "staffed_remain_cost"  numeric(23,6) NULL,
  "unstaffed_remain_cost"  numeric(23,6) NULL,
  "staffed_target_qty"  numeric(23,6) NULL,
  "unstaffed_target_qty"  numeric(23,6) NULL,
  "staffed_target_cost"  numeric(23,6) NULL,
  "unstaffed_target_cost"  numeric(23,6) NULL,
  "staffed_total_qty"  numeric(23,6) NULL,
  "unstaffed_total_qty"  numeric(23,6) NULL,
  "staffed_total_cost"  numeric(23,6) NULL,
  "unstaffed_total_cost"  numeric(23,6) NULL,
  "fin_period_act_qty"  numeric(23,6) NULL,
  "fin_period_act_cost"  numeric(23,6) NULL,
  "fin_period_total_qty"  numeric(23,6) NULL,
  "fin_period_total_cost"  numeric(23,6) NULL
,CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)  )


go
print 'Creating table TASKRISK'

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRISK(
  "task_id"  integer NOT NULL,
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)  )


go
print 'Creating table USER_ACCEPTANCE_CONSENT'

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  "user_id"  integer NOT NULL,
  "status"  integer NULL,
  "modified_date"  datetime DEFAULT getDate() NULL,
  "consent_type"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )


go
--METADATA NAME:rsrc_private TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('rsrc_private');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "rsrc_private"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
if @col_exist = 0
ALTER TABLE DLTACTV 
  add   "parent_actv_code_id"  integer NULL
go

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
if @col_exist = 0
ALTER TABLE FILTPROP 
  add   "rpt_id"  integer NULL
go

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:FINDATES CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FINDATES') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE FINDATES 
  add   "fintmpl_id"  integer DEFAULT 1 with values  NOT NULL
go

--METADATA NAME:parent_job_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('JOBSVC') and column_name=upper('parent_job_id');
if @col_exist = 0
ALTER TABLE JOBSVC 
  add   "parent_job_id"  integer NULL
go

--METADATA NAME:min_pro_version TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('min_pro_version');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "min_pro_version"  varchar(10) NULL
go

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "ts_rsrc_def_asgn_out_actv_flag"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go

--METADATA NAME:prof_descr TYPE:FIELD TABLE_NAME:PROFILE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROFILE') and column_name=upper('prof_descr');
if @col_exist = 0
ALTER TABLE PROFILE 
  add   "prof_descr"  varchar(255) NULL
go

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "rsrc_role_match_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:description TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('description');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "description"  varchar(500) NULL
go

--METADATA NAME:matrix_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('matrix_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "matrix_id"  integer NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "location_id"  integer NULL
go

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "last_schedule_date"  datetime NULL
go

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('control_updates_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "control_updates_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,169,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=169)
go

--METADATA NAME:hist_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('hist_interval');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "hist_interval"  varchar(25) DEFAULT 'Month' with values  NOT NULL
go

--METADATA NAME:hist_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('hist_level');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "hist_level"  varchar(10) DEFAULT 'HL_None' with values  NOT NULL
go

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "fintmpl_id"  integer NULL
go

--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_to_type');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_to_type"  varchar(12) DEFAULT 'RT_Threat' with values  NOT NULL
go

--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('identified_by_id');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "identified_by_id"  integer NULL
go

--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('response_type');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "response_type"  varchar(12) NULL
go

--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('response_text');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "response_text"  varchar(255) NULL
go

--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_prblty"  varchar(2) NULL
go

--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_schd_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_schd_prblty"  varchar(2) NULL
go

--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_cost_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_cost_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_schd_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_schd_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_cost_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_cost_prblty"  varchar(2) NULL
go

--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_cause');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_cause"  varchar(4000) NULL
go

--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_effect');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_effect"  varchar(4000) NULL
go

--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('notes');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "notes"  varchar(4000) NULL
go

--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_code');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_code"  varchar(40) DEFAULT 0 with values  NOT NULL
go

--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_desc');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_desc"  varchar(4000) NULL
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJWBS') and column_name=upper('intg_type');
if @col_exist = 0
ALTER TABLE PROJWBS 
  add   "intg_type"  varchar(100) NULL
go

--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
if @col_exist = 0
ALTER TABLE PROJWBS 
  add   "status_reviewer"  integer NULL
go

--METADATA NAME:parent_risk_type_id TYPE:FIELD TABLE_NAME:RISKTYPE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RISKTYPE') and column_name=upper('parent_risk_type_id');
if @col_exist = 0
ALTER TABLE RISKTYPE 
  add   "parent_risk_type_id"  integer NULL
go

--METADATA NAME:start_date TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('ROLERATE') and column_name=upper('start_date');
if @col_exist = 0
ALTER TABLE ROLERATE 
  add   "start_date"  datetime DEFAULT getDate() with values  NOT NULL
go

--METADATA NAME:max_qty_per_hr TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('ROLERATE') and column_name=upper('max_qty_per_hr');
if @col_exist = 0
ALTER TABLE ROLERATE 
  add   "max_qty_per_hr"  numeric(16,8) DEFAULT 1 with values  NULL
go

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RPT') and column_name=upper('user_id');
if @col_exist = 0
ALTER TABLE RPT 
  add   "user_id"  integer NULL
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RSRC') and column_name=upper('intg_type');
if @col_exist = 0
ALTER TABLE RSRC 
  add   "intg_type"  varchar(100) NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RSRC') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE RSRC 
  add   "location_id"  integer NULL
go

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
if @col_exist = 0
ALTER TABLE SPIDMAP 
  add   "refrdel_project_bypass"  integer NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASK') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE TASK 
  add   "location_id"  integer NULL
go

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASK') and column_name=upper('control_updates_flag');
if @col_exist = 0
ALTER TABLE TASK 
  add   "control_updates_flag"  varchar(1) DEFAULT 'N' with values  NULL
go

--METADATA NAME:comments TYPE:FIELD TABLE_NAME:TASKPRED CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKPRED') and column_name=upper('comments');
if @col_exist = 0
ALTER TABLE TASKPRED 
  add   "comments"  varchar(250) NULL
go

--METADATA NAME:userset_blob TYPE:FIELD TABLE_NAME:USERSET CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('USERSET') and column_name=upper('userset_blob');
if @col_exist = 0
ALTER TABLE USERSET 
  add   "userset_blob"  TEXT NULL
go

print 'Dropping constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='pk_nextkey';
if @cons_cnt > 0  
ALTER TABLE NEXTKEY DROP CONSTRAINT pk_nextkey;
go

print 'Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
go

print 'Creating constraint fk_discussion_task on table DISCUSSION'


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_discussion_read_users on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_docreview_document on table DOCREVIEW'


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
go

print 'Creating constraint fk_docreview_users on table DOCREVIEW'


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
go

print 'Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_filtprop_rpt on table FILTPROP'


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
go

print 'Creating constraint fk_findates_fintmpl on table FINDATES'


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_project_fintmpl on table PROJECT'


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
go

print 'Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL'


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolercat_rolecattype on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolercat_rolecatval on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
go

print 'Creating constraint fk_rolercat_roles on table ROLERCAT'


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_rpt_users on table RPT'


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_sumprojcost_project on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_project on table SUMTASK'


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_projwbs on table SUMTASK'


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_project on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_risk_riskid on table TASKRISK'


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
go

print 'Creating constraint fk_risk_task on table TASKRISK'


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskrisk_project on table TASKRISK'


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT'


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go
 
--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER

--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER
ALTER TABLE BUDGCHNG ALTER COLUMN chng_by_name varchar(255)
go

--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER 
--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER 
--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER

--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER
ALTER TABLE CALENDAR ALTER COLUMN clndr_name varchar(255) NOT NULL 
go

--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER 
--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER 
--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN author_name varchar(255)
go

--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN private_loc varchar(4000)
go

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN public_loc varchar(4000)
go

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER

--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC ALTER COLUMN job_name varchar(255) NOT NULL 
go

--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER
ALTER TABLE NEXTKEY ALTER COLUMN key_name varchar(60) NOT NULL 
go

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER
ALTER TABLE NOTE ALTER COLUMN user_name varchar(255) NOT NULL 
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE ALTER COLUMN proj_catg_type varchar(60) NOT NULL 
go

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL ALTER COLUMN proj_catg_short_name varchar(60) NOT NULL 
go

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER

--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT ALTER COLUMN prm_user_name varchar(255)
go

--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER

--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT ALTER COLUMN netaddress varchar(64)
go

--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER

--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN enqueue_user varchar(255)
go

--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER

--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN sender_name varchar(255)
go

--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER

--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN dequeue_user varchar(255)
go

--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT ALTER COLUMN add_by_name varchar(255)
go

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER
ALTER TABLE PROJISSU ALTER COLUMN add_by_name varchar(255)
go

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN add_date datetime NULL
go
 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER

--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN risk_name varchar(200) NOT NULL 
go

--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS ALTER COLUMN est_wt numeric(10,2) NULL
go
 
--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER

--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER
ALTER TABLE PUBUSER ALTER COLUMN private_db_user_name varchar(255) NOT NULL 
go

--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER 
--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN rsrc_short_name varchar(255) NOT NULL 
go

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN rsrc_name varchar(255) NOT NULL 
go

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER
ALTER TABLE SPIDMAP ALTER COLUMN user_name varchar(255)
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK ALTER COLUMN est_wt numeric(10,2) NULL
go
 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER

--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
 
declare @default sysname, @sql nvarchar(max)

select @default = name
from sys.default_constraints
where parent_object_id = object_id('TASK')
AND type = 'D'
AND parent_column_id = (
    select column_id
    from sys.columns
    where object_id = object_id('TASK')
    and name = 'review_type'
    )

set @sql = N'alter table TASK drop constraint ' + @default
print @sql
exec sp_executesql @sql
 
ALTER TABLE TASK ADD DEFAULT ('RV_OK') FOR [review_type] 
go
 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN rsrc_short_name varchar(255)
go

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN rsrc_name varchar(255)
go

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN user_name varchar(255)
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
DROP INDEX UEVNTREG.ndx_uevntreg_user_name
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
ALTER TABLE UEVNTREG ALTER COLUMN user_name varchar(255)
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
CREATE INDEX ndx_uevntreg_user_name
ON UEVNTREG (user_name)

go 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN user_name varchar(255) NOT NULL 
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER

--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN actual_name varchar(255)
go

--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD ALTER COLUMN user_name varchar(255)
go

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD ALTER COLUMN os_user_name varchar(255)
go

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
ALTER TABLE USESSION ALTER COLUMN os_user_name varchar(255)
go

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
print 'Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnacat_asgnmntcattype
ON ASGNMNTACAT (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_asgnmntcatval
ON ASGNMNTACAT (asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_update_date1
ON ASGNMNTACAT (update_date)

go

print 'Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_dsi
ON ASGNMNTACAT (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_upd
ON ASGNMNTACAT (update_date,delete_session_id)

go

print 'Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_proj_id
ON ASGNMNTACAT (proj_id)

go

print 'Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_taskrsrc_id
ON ASGNMNTACAT (taskrsrc_id)

go

print 'Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_dsi
ON ASGNMNTCATTYPE (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_upd
ON ASGNMNTCATTYPE (update_date,delete_session_id)

go

print 'Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgncatval_asgnmntcattype
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_parent_catg
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_dsi
ON ASGNMNTCATVAL (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_upd
ON ASGNMNTCATVAL (update_date,delete_session_id)

go

print 'Creating index ndx_discussion_1 on table DISCUSSION'

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)

go

print 'Creating index ndx_discussion_2 on table DISCUSSION'

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)

go

print 'Creating index ndx_discussion_dsi on table DISCUSSION'

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)

go

print 'Creating index ndx_discussion_read_dsi on table DISCUSSION_READ'

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE  INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)

go

print 'Creating index ndx_docreview_document on table DOCREVIEW'

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_document
ON DOCREVIEW (doc_id)

go

print 'Creating index ndx_docreview_users on table DOCREVIEW'

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_users
ON DOCREVIEW (user_id)

go

print 'Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_docreview
ON DOCREVIEWTASK (doc_review_id)

go

print 'Creating index ndx_docreviewtask_users on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_users
ON DOCREVIEWTASK (user_id)

go

print 'Creating index ndx_findates_fintmpl on table FINDATES'

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_fintmpl
ON FINDATES (fintmpl_id)

go

print 'Creating index ndx_fintmpl_dsi on table FINTMPL'

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_dsi
ON FINTMPL (delete_session_id,delete_date)

go

print 'Creating index ndx_fintmpl_upd on table FINTMPL'

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_upd
ON FINTMPL (update_date,delete_session_id)

go

print 'Creating index ndx_imagedata_image_name on table IMAGEDATA'

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)

go

print 'Creating index ndx_project_last_fin_dates on table PROJECT'

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_last_fin_dates
ON PROJECT (last_fin_dates_id)

go

print 'Creating index ndx_project_matrix on table PROJECT'

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_matrix
ON PROJECT (matrix_id)

go

print 'Creating index ndx_project_fintmpl on table PROJECT'

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_fintmpl
ON PROJECT (fintmpl_id)

go

print 'Creating index ndx_rolecattype_dsi on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_dsi
ON ROLECATTYPE (delete_session_id,delete_date)

go

print 'Creating index ndx_rolecattype_upd on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_upd
ON ROLECATTYPE (update_date,delete_session_id)

go

print 'Creating index ndx_rolecatval_rolecattype on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_rolecattype
ON ROLECATVAL (role_catg_type_id)

go

print 'Creating index ndx_rolecatval_parent_catg on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_parent_catg
ON ROLECATVAL (parent_role_catg_id)

go

print 'Creating index ndx_rolecatval_dsi on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_dsi
ON ROLECATVAL (delete_session_id,delete_date)

go

print 'Creating index ndx_rolecatval_upd on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_upd
ON ROLECATVAL (update_date,delete_session_id)

go

print 'Creating index ndx_rolercat_rolecattype on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecattype
ON ROLERCAT (role_catg_type_id)

go

print 'Creating index ndx_rolercat_rolecatval on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecatval
ON ROLERCAT (role_catg_id)

go

print 'Creating index ndx_rolercat_update_date1 on table ROLERCAT'

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_update_date1
ON ROLERCAT (update_date)

go

print 'Creating index ndx_rolercat_dsi on table ROLERCAT'

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_dsi
ON ROLERCAT (delete_session_id,delete_date)

go

print 'Creating index ndx_rolercat_upd on table ROLERCAT'

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_upd
ON ROLERCAT (update_date,delete_session_id)

go

print 'Creating index ndx_rsrc_unit on table RSRC'

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_unit
ON RSRC (unit_id)

go

print 'Creating index ndx_rsrc_curr on table RSRC'

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_curr
ON RSRC (curr_id)

go

print 'Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_ts_rsrc
ON RSRCHOUR (ts_id,rsrc_id)

go

print 'Creating index ndx_sumprojcost_wbs on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_wbs
ON SUMPROJCOST (wbs_id)

go

print 'Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_cost_type
ON SUMPROJCOST (cost_type_id)

go

print 'Creating index ndx_sumprojcost_proj on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_proj
ON SUMPROJCOST (proj_id)

go

print 'Creating index ndx_sumtask_proj on table SUMTASK'

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_proj
ON SUMTASK (proj_id)

go

print 'Creating index ndx_sumtask_wbs on table SUMTASK'

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_wbs
ON SUMTASK (wbs_id)

go

print 'Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_proj
ON SUMTASKSPREAD (proj_id)

go

print 'Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_wbs
ON SUMTASKSPREAD (wbs_id)

go

print 'Creating index ndx_sumtrsrc_project on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_project
ON SUMTRSRC (proj_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projwbs
ON SUMTRSRC (wbs_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_rsrcrole
ON SUMTRSRC (rsrc_id,role_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)

go

print 'Creating index ndx_taskrisk_risk on table TASKRISK'

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_risk
ON TASKRISK (risk_id)

go

print 'Creating index ndx_taskrisk_proj on table TASKRISK'

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_proj
ON TASKRISK (proj_id)

go

print 'Creating index ndx_taskrisk_task on table TASKRISK'

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_task
ON TASKRISK (task_id)

go

print 'Creating index ndx_users_curr on table USERS'

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_curr
ON USERS (curr_id)

go

print 'Creating index ndx_userset_user on table USERSET'

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE  INDEX ndx_userset_user
ON USERSET (user_id)

go

print 'Creating index ndx_usropnval_user_open_id on table USROPNVAL'

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE  INDEX ndx_usropnval_user_open_id
ON USROPNVAL (user_open_id)

go

print 'Creating index ndx_wbsrsrc_role on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_role
ON WBSRSRC (role_id)

go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id2
ON WBSRSRC_QTY (fin_dates_id2)

go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id1
ON WBSRSRC_QTY (fin_dates_id1)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVAL_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVAL_asgnmnt_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEW_doc_review_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEW_doc_review_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEWTASK_review_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEWTASK_review_task_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('FINTMPL_fintmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('FINTMPL_fintmpl_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LOCATION_location_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LOCATION_location_id')) 
go

print 'Creating constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATTYPE_role_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATTYPE_role_catg_type_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVAL_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVAL_role_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SUMTRSRC_sumtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SUMTRSRC_sumtrsrc_id')) 
go



--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare @vprefid integer,@max_view_pref_id integer,@vpid int,@pos int
declare vpdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.Filter')  and upper(view_pref_value) like upper('CustomFilter');
BEGIN
select @vprefid=key_seq_num  from nextkey where key_name='viewpref_view_pref_id';
  select @max_view_pref_id=max(view_pref_id)   from viewpref;
  if (@vprefid<=@max_view_pref_id ) 
   set  @vprefid=@max_view_pref_id+1
  open vpdata
FETCH NEXT FROM vpdata INTO @vpid
WHILE @@Fetch_Status = 0
   BEGIN
insert into viewpref(view_pref_id,view_pref_name,view_pref_type,user_id) select @vprefid,view_pref_name,'VT_FILTER',user_id from viewpref where view_pref_id=@vpid  ;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select @vprefid, 'VT_FILTER.FilterCriteria', view_pref_value
from VWPREFDATA
where view_pref_id = @vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria') and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_FILTER.FilterCriteria') and view_pref_id = @vprefid)
insert into vwprefuser(view_pref_id,user_id) select @vprefid,user_id from vwprefuser where view_pref_id=@vpid;
UPDATE VWPREFDATA SET VIEW_PREF_VALUE = 'TreeFilter' WHERE VIEW_PREF_KEY = 'VT_ACTIVITY.Filter' AND VIEW_PREF_ID =@vpid;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value) values(@vpid,'VT_ACTIVITY.FiltersList',@vprefid) --from vwprefdata where not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.FiltersList') and view_pref_id = @vpid)
delete from VWPREFDATA where view_pref_id=@vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria');
set @vprefid=@vprefid+1;
FETCH NEXT FROM vpdata INTO @vpid             
END
CLOSE vpdata
DEALLOCATE vpdata
update nextkey set key_seq_num=@vprefid where key_name='viewpref_view_pref_id';
declare vpfilterdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_FILTER.FilterCriteria') 
  open vpfilterdata
  FETCH NEXT FROM vpfilterdata INTO @vpid
  WHILE (@@FETCH_STATUS =0)
  BEGIN
     set @pos=0
     select @pos=charindex('UDF:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid
     if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'UDF:','UDF_') where view_pref_id=@vpid
     select @pos=charindex('ActivityCodeTypeId:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid	
      if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'ActivityCodeTypeId:','ActivityCodeTypeId_') where view_pref_id=@vpid
  FETCH NEXT FROM vpfilterdata INTO @vpid                 	
  END
CLOSE vpfilterdata
DEALLOCATE vpfilterdata
END
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare vwcur cursor local for select view_pref_id from viewpref  where view_pref_type='VT_UIVIEW' 
declare @view_pref_id int
begin try
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,case p.prof_id when 12 then 'Y' else 'N' end,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
open vwcur
fetch vwcur into @view_pref_id
WHILE (@@FETCH_STATUS = 0)
BEGIN 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProject','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProjectSeq','6')
fetch vwcur into @view_pref_id
END
close vwcur
deallocate vwcur
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
Declare @earnedValue integer
Declare @valuePatternAtCompl VARCHAR(30) 
Declare @valuePatternBudgCur VARCHAR(30) 
Declare @valuePatternBudg VARCHAR(30)
 
Declare @insertValueAtCompl VARCHAR(30)
Declare @insertValueBudgCur VARCHAR(30)
Declare @insertValueBudg    VARCHAR(30)
Declare @settingsName VARCHAR(30)
Declare @position integer
   begin
	 set @valuePatternAtCompl = '%EV_AtCompl%'
	 set @valuePatternBudgCur = '%EV_Budg_With_Start_Dates%'
	 set @valuePatternBudg = '%EV_Budg%'

	 set @insertValueAtCompl = 'EV_AtCompl'
	 set @insertValueBudgCur = 'EV_BudgCur'
	 set @insertValueBudg    = 'EV_Budg'
     set @settingsName= 'EVCalculation'
	 set @earnedValue=0
     
	 select @earnedValue=1 from settings where setting_name='EVCalculation';
	 if @earnedValue=0
	 begin
		select @position=patindex(@valuePatternAtCompl,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			insert into settings(namespace, setting_name, setting_value) 
			values('Administrator_Settings', @settingsName, @insertValueAtCompl);
			return
        end
		select @position=patindex(@valuePatternBudgCur,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			 insert into settings(namespace, setting_name, setting_value) 
			 values('Administrator_Settings', @settingsName, @insertValueBudgCur);
			 return
        end
		select @position=patindex(@valuePatternBudg,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			  insert into settings(namespace, setting_name, setting_value) 
			  values('Administrator_Settings', @settingsName, @insertValueBudg);
			  return
        end
     end
	end

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
Declare @valuePattern VARCHAR(30) 
 
Declare @position integer
begin
	 set @valuePattern = '%pvurl%'

   UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines'
	 select @position=patindex(@valuePattern, config_data) from admin_config where config_name='CS_ADMIN'
		if @position>0
        begin
			insert into settings(namespace, setting_name) 
			values('Administrator_Settings', 'WebAccessURL')
			return
        end

   UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
   UPDATE project set msp_managed_flag = 'N',sum_only_flag = 'N' where msp_managed_flag != 'N' or sum_only_flag != 'N';
end

go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160); 

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , getdate(), session_user from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end


go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=getdate(),update_user=session_user WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0 );
end
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
declare @vprefid integer
begin
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 

  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'MyActivities','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
end;

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=view_pref_value+1,update_date=getdate()  where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and view_pref_value>='1'
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 

DECLARE cur_notfin_vpid CURSOR FOR
  SELECT view_pref_id
  FROM   vwprefdata
  WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
         AND view_pref_value = 'NotFinishedActivitiesOnly'
DECLARE @v_id_list VARCHAR(100),
        @v_pref_id INT
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
     and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select *
                    from vwprefdata vw
                    where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                       and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
  select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
     
    SELECT @v_id_list = CAST(Min(view_pref_id) AS varchar(30)) + ',' + CAST(Max(view_pref_id) AS varchar(30))
    FROM   viewpref
    WHERE  view_pref_name IN ( 'InProgressActivitiesOnly',
                               'NotStartedActivitiesOnly' );
    OPEN cur_notfin_vpid
    FETCH next FROM cur_notfin_vpid INTO @v_pref_id
    WHILE ( @@FETCH_STATUS = 0 )
      BEGIN
          UPDATE vwprefdata
          SET    view_pref_value = 'TreeFilter'
          WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
                 AND view_pref_id = @v_pref_id;

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersList',
                      @v_id_list);

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersOperator',
                      'OR');

          FETCH next FROM cur_notfin_vpid INTO @v_pref_id
      END

    CLOSE cur_notfin_vpid
    DEALLOCATE cur_notfin_vpid     
end;


go 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE from usereng
where db_engine_type ='TS'
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS');
go

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END,getdate(),session_user from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
BEGIN
BEGIN TRY
  create table #temprisk (risk_id integer,notes varchar(4000))
  insert into #temprisk select p.risk_id,substring('Applies to WBS-'+ Pw.Wbs_name+char(10) +'Applies to Resource-'+isnull(r.rsrc_name,'')+char(10)+'Responsible Manager-'+isnull(o.obs_name,'')+char(10)
+ 'Priority-'+ isnull(P.Priority_type,'')+char(10) + 'Date Identified-'+ isnull(CONVERT(varchar(20) , p.add_date, 100),'')+char(10)+'Impact Date-'+isnull(CONVERT(varchar(20) , p.impact_date, 100),'')+char(10)+ 'Probability-' +isnull(str(p.prbly_pct),'') + char(10)+'Impact - Labor Units-'+isnull(str(p.impact_work_qty),'')+ char(10)+'Impact - Nonlabor Units-'+isnull(str(p.impact_equip_qty),'') +char(10)+'Impact - Material Units-'+isnull(str(p.impact_mat_qty),'') + char(10) +'Impact - Expenses-'+ isnull(str(p.impact_expense_cost),'')+  char(10)+substring(rc.risk_control,1,2000),1,4000) From  Projrisk P Left outer join Riskctrl rc on p.risk_id=rc.risk_id left outer join projwbs pw on p.wbs_id=pw.wbs_id  Left Outer Join Obs O On P.Obs_id=O.Obs_id Left Outer Join  Rsrc R On P.Rsrc_id=R.Rsrc_id 
   update PROJRISK set notes=#temprisk.notes,risk_code='PROJRISK-'+ltrim(str(projrisk.risk_id)),risk_desc=SUBSTRING(risk_descr,1,4000),status_code=CASE status_code when 'RS_Closed' then 'RS_Manage' else status_code end from #temprisk where #temprisk.risk_id=projrisk.risk_id
   drop table #temprisk
END TRY
BEGIN CATCH
   DECLARE @ErrorMessage NVARCHAR(4000),  @ErrorSeverity integer, @ErrorState integer, @ErrorNumber integer;
   SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE()
               ,@ErrorNumber = ERROR_NUMBER() ;
   RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState );
END CATCH  
END
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK 
--METADATA NAME:wbs_id TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='wbs_id'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  wbs_id
go
 
--METADATA NAME:priority_type TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='priority_type'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  priority_type
go
 
--METADATA NAME:obs_id TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='obs_id'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  obs_id
go
 
--METADATA NAME:prbly_pct TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='prbly_pct'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  prbly_pct
go
 
--METADATA NAME:impact_work_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_work_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_work_qty
go
 
--METADATA NAME:impact_equip_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_equip_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_equip_qty
go
 
--METADATA NAME:impact_expense_cost TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_expense_cost'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_expense_cost
go
 
--METADATA NAME:impact_date TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_date'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_date
go
 
--METADATA NAME:impact_mat_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_mat_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_mat_qty
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/');
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
declare @vpropid integer
begin
  exec pc_get_next_key 'viewprop_view_id', @vpropid OUTPUT;
  insert into viewprop (VIEW_ID,VIEW_NAME,VIEW_TYPE)
  select @vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
  where not exists ( select view_id from viewprop where VIEW_NAME='Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ; 
  end;
go


go 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
DECLARE RiskCursor CURSOR LOCAL FOR SELECT risk_id, risk_desc from PROJRISK
OPEN RiskCursor
DECLARE @riskID INT, @HTMLText VARCHAR(4000), @Start INT, @End INT, @Length INT
FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @Start = CHARINDEX('<',@HTMLText)
	SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
	SET @Length = (@End - @Start) + 1
	WHILE @Start > 0 AND @End > 0 AND @Length > 0
    BEGIN
        SET @HTMLText = STUFF(@HTMLText,@Start,@Length,'')
        SET @Start = CHARINDEX('<',@HTMLText)
        SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
        SET @Length = (@End - @Start) + 1
    END
    SET @HTMLText = REPLACE(@HTMLText, '&amp;', '&')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp;', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&lt;', '<')
	SET @HTMLText = REPLACE(@HTMLText, '&gt;', '>')
	SET @HTMLText = REPLACE(@HTMLText, char(13) , ' ')
	SET @HTMLText = REPLACE(@HTMLText, char(10) , '')
	SET @HTMLText = LTRIM(RTRIM(@HTMLText))
	UPDATE PROJRISK SET risk_desc = @HTMLText where risk_id = @riskID 
	FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText 
END
CLOSE RiskCursor
DEALLOCATE RiskCursor
GO
go 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Administrator_Settings', 'AlwaysLaunchOnlineHelp',
'Y' from settings where not exists ( select 1 from settings where namespace='Administrator_Settings' and setting_name =
'AlwaysLaunchOnlineHelp' )
end
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
go


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select ue1.user_id from usereng ue1
where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM')
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'VIS')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go
go 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION_DEL' and type in ('TR'))
  DROP TRIGGER RT_USESSION_DEL
go

--METADATA  TYPE:SSCR NAME:RT_USESSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION' and type in ('TR'))
  DROP TRIGGER RT_USESSION
go

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_USESSION
on USESSION
for update,insert
as     
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;

update USESSION
set update_date = getdate()    
, update_user = @user_name
, create_user =  case @del_cnt WHEN 0 then @user_name else USESSION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else USESSION.create_date end
from inserted 
where USESSION.session_id = inserted.session_id
go
go 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
go
go 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
update prefer set license_data=null
go
go 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
go

go 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=177;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=177;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=177;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'N');
  end
FETCH NEXT FROM @profile_cur INTO @v_prof_id
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

go 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
go

go 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv 
where prof_id in
(select pp.prof_id from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
and priv_num in
(select pp.priv_num from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
go

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
select 'no update' 
go

go 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21);
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56);
go


--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 181
WHILE @i < 184
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE @v_role_rate_id int,@v_role_id int,@v_rolelimit_id int,@v_start_date datetime,
        @v_max_qty_per_hr numeric(16,8),@v_cost_per_qty numeric(21,8),
		@v_cost_per_qty2 numeric(21,8),@v_cost_per_qty3 numeric(21,8),
	    @v_cost_per_qty4 numeric(21,8),@v_cost_per_qty5 numeric(21,8),@new_role_rate_id int

SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
       rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5 
	   into #temp
       FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id;
	   
DECLARE @cur_rr_rl AS CURSOR 
SET @cur_rr_rl = CURSOR 
             			
FOR SELECT role_rate_id, role_id,rolelimit_id,start_date,max_qty_per_hr,
       cost_per_qty, cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5 FROM #temp
 WHERE  role_id IS NOT NULL
 ORDER BY 3;
 
OPEN @cur_rr_rl; 
FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
WHILE @@FETCH_STATUS = 0 
BEGIN
    IF @v_rolelimit_id is NOT NULL
	  BEGIN
       DELETE FROM rolerate WHERE role_rate_id = @v_role_rate_id;
       exec getnextkeys 'rolerate_role_rate_id', 1, @new_role_rate_id OUTPUT
	   INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (@new_role_rate_id,@v_role_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty,@v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5); 
      END;
    ELSE
      BEGIN
        UPDATE rolerate SET max_qty_per_hr = 0 , start_date=Dateadd(yy, Datediff(yy, 0, Getdate()), 0)  WHERE  role_id =@v_role_id ;
      END;
   FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
END;
	   
CLOSE @cur_rr_rl; 
DEALLOCATE @cur_rr_rl; 
DELETE FROM rolelimit;
DROP TABLE #temp;
go


go 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', getdate(), getdate()
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2);
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    @v_fin_dates_id int, 
    @v_count        int 
BEGIN 
    SELECT @v_count=count(*) 
    FROM   findates; 
    IF @v_count = 0  
      BEGIN 
          EXEC getnextkeys 'findates_fin_dates_id', 1, @v_fin_dates_id OUTPUT; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT @v_fin_dates_id, LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10), DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0),DATEADD (dd, -1, DATEADD(mm, DATEDIFF(mm, 0, GETDATE()) + 1, 0)), 1, GETDATE(), 'NotPrmUser', GETDATE(), 'NotPrmUser'	  
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = @v_fin_dates_id AND fin_dates_name=LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10) and fintmpl_id = 1); 
               
      END; 
 END; 
 go
go 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 185
WHILE @i < 188
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',1);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',1);
go
go 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
go
go 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_extdep_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_extdep_point = charindex('P_EXTDEP',@view_data)
  if (@v_extdep_point is null or @v_extdep_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||P_TASKPRED(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||P_TASKPRED(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||P_EXTDEP(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||P_EXTDEP(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
go

go 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
DROP CONSTRAINT pk_taskuser
go
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

go 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
go

go 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2312.0002.0000.0001'
go

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:23.10.00
update prefer set min_pro_version='23.10.00'
go

