
SET QUOTED_IDENTIFIER ON

print 'Creating table ASGNMNTACAT'

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  "taskrsrc_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "asgnmnt_catg_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATTYPE'

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_len"  integer NOT NULL,
  "asgnmnt_catg_type"  varchar(60) NOT NULL,
  "super_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATVAL'

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  "asgnmnt_catg_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_name"  varchar(60) NOT NULL,
  "asgnmnt_catg_name"  varchar(100) NULL,
  "parent_asgnmnt_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)  )


go
print 'Creating table FINTMPL'

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  "fintmpl_id"  integer NOT NULL,
  "fintmpl_name"  varchar(255) NOT NULL,
  "default_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)  )


go
--METADATA  TYPE:ADHOC_SQL
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) Select 1, 'Calendar', 'Y', getdate(), getdate() WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

print 'Creating table IMAGEDATA'

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  "image_id"  integer NOT NULL,
  "image_name"  varchar(120) NULL,
  "image_data"  varbinary(max) NOT NULL,
  "image_thumbnail"  varbinary(max) NOT NULL,
  "image_extension"  varchar(20) DEFAULT 'png' NOT NULL,
  "default_flag"  varchar(1) NOT NULL,
  "image_purpose"  varchar(50) NOT NULL,
  "image_description"  varchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )


go
print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )


go
print 'Creating table ROLECATTYPE'

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATTYPE(
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_len"  integer NOT NULL,
  "role_catg_type"  varchar(60) NOT NULL,
  "super_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)  )


go
print 'Creating table ROLECATVAL'

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATVAL(
  "role_catg_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_name"  varchar(60) NOT NULL,
  "role_catg_name"  varchar(100) NULL,
  "parent_role_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)  )


go
print 'Creating table ROLERCAT'

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERCAT(
  "role_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "role_catg_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)  )


go
--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:FINDATES CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FINDATES') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE FINDATES 
  add   "fintmpl_id"  integer DEFAULT 1 with values  NOT NULL
go

--METADATA NAME:min_pro_version TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('min_pro_version');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "min_pro_version"  varchar(10) NULL
go

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "ts_rsrc_def_asgn_out_actv_flag"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "rsrc_role_match_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "last_schedule_date"  datetime NULL
go

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "fintmpl_id"  integer NULL
go

--METADATA NAME:start_date TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('ROLERATE') and column_name=upper('start_date');
if @col_exist = 0
ALTER TABLE ROLERATE 
  add   "start_date"  datetime DEFAULT getDate() with values  NOT NULL
go

--METADATA NAME:max_qty_per_hr TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('ROLERATE') and column_name=upper('max_qty_per_hr');
if @col_exist = 0
ALTER TABLE ROLERATE 
  add   "max_qty_per_hr"  numeric(16,8) DEFAULT 1 with values  NULL
go

--METADATA NAME:comments TYPE:FIELD TABLE_NAME:TASKPRED CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKPRED') and column_name=upper('comments');
if @col_exist = 0
ALTER TABLE TASKPRED 
  add   "comments"  varchar(250) NULL
go

print 'Dropping constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='pk_nextkey';
if @cons_cnt > 0  
ALTER TABLE NEXTKEY DROP CONSTRAINT pk_nextkey;
go

print 'Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
go

print 'Creating constraint fk_findates_fintmpl on table FINDATES'


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_project_fintmpl on table PROJECT'


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
go

print 'Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL'


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolercat_rolecattype on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolercat_rolecatval on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
go

print 'Creating constraint fk_rolercat_roles on table ROLERCAT'


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go
 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN private_loc varchar(4000)
go

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN public_loc varchar(4000)
go

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER
ALTER TABLE NEXTKEY ALTER COLUMN key_name varchar(60) NOT NULL 
go

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE ALTER COLUMN proj_catg_type varchar(60) NOT NULL 
go

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL ALTER COLUMN proj_catg_short_name varchar(60) NOT NULL 
go

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS ALTER COLUMN intg_type varchar(100)
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN intg_type varchar(100)
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
print 'Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnacat_asgnmntcattype
ON ASGNMNTACAT (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_asgnmntcatval
ON ASGNMNTACAT (asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_update_date1
ON ASGNMNTACAT (update_date)

go

print 'Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_dsi
ON ASGNMNTACAT (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_upd
ON ASGNMNTACAT (update_date,delete_session_id)

go

print 'Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_proj_id
ON ASGNMNTACAT (proj_id)

go

print 'Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_taskrsrc_id
ON ASGNMNTACAT (taskrsrc_id)

go

print 'Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_dsi
ON ASGNMNTCATTYPE (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_upd
ON ASGNMNTCATTYPE (update_date,delete_session_id)

go

print 'Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgncatval_asgnmntcattype
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_parent_catg
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_dsi
ON ASGNMNTCATVAL (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_upd
ON ASGNMNTCATVAL (update_date,delete_session_id)

go

print 'Creating index ndx_findates_fintmpl on table FINDATES'

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_fintmpl
ON FINDATES (fintmpl_id)

go

print 'Creating index ndx_fintmpl_dsi on table FINTMPL'

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_dsi
ON FINTMPL (delete_session_id,delete_date)

go

print 'Creating index ndx_fintmpl_upd on table FINTMPL'

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_upd
ON FINTMPL (update_date,delete_session_id)

go

print 'Creating index ndx_imagedata_image_name on table IMAGEDATA'

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)

go

print 'Creating index ndx_project_fintmpl on table PROJECT'

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_fintmpl
ON PROJECT (fintmpl_id)

go

print 'Creating index ndx_rolecattype_dsi on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_dsi
ON ROLECATTYPE (delete_session_id,delete_date)

go

print 'Creating index ndx_rolecattype_upd on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_upd
ON ROLECATTYPE (update_date,delete_session_id)

go

print 'Creating index ndx_rolecatval_rolecattype on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_rolecattype
ON ROLECATVAL (role_catg_type_id)

go

print 'Creating index ndx_rolecatval_parent_catg on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_parent_catg
ON ROLECATVAL (parent_role_catg_id)

go

print 'Creating index ndx_rolecatval_dsi on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_dsi
ON ROLECATVAL (delete_session_id,delete_date)

go

print 'Creating index ndx_rolecatval_upd on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_upd
ON ROLECATVAL (update_date,delete_session_id)

go

print 'Creating index ndx_rolercat_rolecattype on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecattype
ON ROLERCAT (role_catg_type_id)

go

print 'Creating index ndx_rolercat_rolecatval on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecatval
ON ROLERCAT (role_catg_id)

go

print 'Creating index ndx_rolercat_update_date1 on table ROLERCAT'

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_update_date1
ON ROLERCAT (update_date)

go

print 'Creating index ndx_rolercat_dsi on table ROLERCAT'

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_dsi
ON ROLERCAT (delete_session_id,delete_date)

go

print 'Creating index ndx_rolercat_upd on table ROLERCAT'

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_upd
ON ROLERCAT (update_date,delete_session_id)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVAL_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVAL_asgnmnt_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('FINTMPL_fintmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('FINTMPL_fintmpl_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
go

print 'Creating constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATTYPE_role_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATTYPE_role_catg_type_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVAL_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVAL_role_catg_id')) 
go



--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=177;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=177;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=177;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'N');
  end
FETCH NEXT FROM @profile_cur INTO @v_prof_id
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

go 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
go

go 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv 
where prof_id in
(select pp.prof_id from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
and priv_num in
(select pp.priv_num from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
go

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
select 'no update' 
go

go 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21);
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56);
go


--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 181
WHILE @i < 184
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE @v_role_rate_id int,@v_role_id int,@v_rolelimit_id int,@v_start_date datetime,
        @v_max_qty_per_hr numeric(16,8),@v_cost_per_qty numeric(21,8),
		@v_cost_per_qty2 numeric(21,8),@v_cost_per_qty3 numeric(21,8),
	    @v_cost_per_qty4 numeric(21,8),@v_cost_per_qty5 numeric(21,8),@new_role_rate_id int

SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
       rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5 
	   into #temp
       FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id;
	   
DECLARE @cur_rr_rl AS CURSOR 
SET @cur_rr_rl = CURSOR 
             			
FOR SELECT role_rate_id, role_id,rolelimit_id,start_date,max_qty_per_hr,
       cost_per_qty, cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5 FROM #temp
 WHERE  role_id IS NOT NULL
 ORDER BY 3;
 
OPEN @cur_rr_rl; 
FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
WHILE @@FETCH_STATUS = 0 
BEGIN
    IF @v_rolelimit_id is NOT NULL
	  BEGIN
       DELETE FROM rolerate WHERE role_rate_id = @v_role_rate_id;
       exec getnextkeys 'rolerate_role_rate_id', 1, @new_role_rate_id OUTPUT
	   INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (@new_role_rate_id,@v_role_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty,@v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5); 
      END;
    ELSE
      BEGIN
        UPDATE rolerate SET max_qty_per_hr = 0 , start_date=Dateadd(yy, Datediff(yy, 0, Getdate()), 0)  WHERE  role_id =@v_role_id ;
      END;
   FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
END;
	   
CLOSE @cur_rr_rl; 
DEALLOCATE @cur_rr_rl; 
DELETE FROM rolelimit;
DROP TABLE #temp;
go


go 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', getdate(), getdate()
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2);
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    @v_fin_dates_id int, 
    @v_count        int 
BEGIN 
    SELECT @v_count=count(*) 
    FROM   findates; 
    IF @v_count = 0  
      BEGIN 
          EXEC getnextkeys 'findates_fin_dates_id', 1, @v_fin_dates_id OUTPUT; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT @v_fin_dates_id, LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10), DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0),DATEADD (dd, -1, DATEADD(mm, DATEDIFF(mm, 0, GETDATE()) + 1, 0)), 1, GETDATE(), 'NotPrmUser', GETDATE(), 'NotPrmUser'	  
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = @v_fin_dates_id AND fin_dates_name=LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10) and fintmpl_id = 1); 
               
      END; 
 END; 
 go
go 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 185
WHILE @i < 188
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',1);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',1);
go
go 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
go
go 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_extdep_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_extdep_point = charindex('P_EXTDEP',@view_data)
  if (@v_extdep_point is null or @v_extdep_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||P_TASKPRED(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||P_TASKPRED(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||P_EXTDEP(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||P_EXTDEP(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
go

go 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
DROP CONSTRAINT pk_taskuser
go
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

go 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
go

go 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2312.0002.0000.0001'
go

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:23.10.00
update prefer set min_pro_version='23.10.00'
go

