--METADATA NAME:orpm_settings TYPE:EXEC
begin
merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N');
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
begin
insert into settings(namespace,setting_name,setting_value)  
select 'Administrator_Settings','OnlineHelpRootUrl','https://docs.oracle.com/cd/F74771_01/client_help/' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','AlwaysLaunchOnlineHelp','Y' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','MaxRoleCodeTreeLevelCnt','20' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxRoleCodeTreeLevelCnt');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt','20' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxAssignmentCodeTreeLevelCnt');
insert into settings(namespace,setting_name,setting_value) 
 select 'Administrator_Settings','EnablePasswordPolicy','Y' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='EnablePasswordPolicy');
commit;
END;
/

--METADATA NAME:orpm_settings TYPE:EXEC
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
	v_no_data_found NUMBER;
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
		  select count(*) into v_no_data_found from nextkey
          where key_name='findates_fin_dates_id';
          if  v_no_data_found = 0 then
           insert into nextkey select 'findates_fin_dates_id',1 from dual where not exists (select * from nextkey where key_name=lower('findates_fin_dates_id')); 
          commit;
          end if; 
          select key_seq_num into v_fin_dates_id from nextkey
          where key_name='findates_fin_dates_id';
          update nextkey set key_seq_num = key_seq_num + 1
          where key_name='findates_fin_dates_id'; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 