/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.RecursiveNoOpNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.propgen.Identification;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.TemplateAccessor;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ActionNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.EnumFieldNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ReferenceNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.SimpleFieldNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.TextNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.WizardNode;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageNode
extends PropSubNode<WizardNode>
implements TemplateAccessor {
    private final Identification m_ident;
    private final String m_id;
    private final Map<String, Identification> m_fields = new HashMap<String, Identification>();

    public PageNode(WizardNode parent, Attributes attr) {
        super(parent, "page", attr);
        this.m_id = attr.getValue("id");
        this.m_ident = new Identification(attr);
    }

    @Override
    public String getPropertyPrefix() {
        return ((WizardNode)this.getParent()).getPropertyPrefix() + ".page." + this.m_id;
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("string".equals(elemName) || "password".equals(elemName) || "bool".equals(elemName) || "int".equals(elemName) || "file".equals(elemName)) {
            return new SimpleFieldNode(this, elemName, attr);
        }
        if ("enum".equals(elemName) || "select".equals(elemName)) {
            return new EnumFieldNode(this, attr);
        }
        if ("text".equals(elemName)) {
            return new TextNode(this, attr);
        }
        if ("reference".equals(elemName)) {
            return new ReferenceNode(this, attr);
        }
        return new RecursiveNoOpNode(this, elemName, attr);
    }

    @Override
    public void onStart() {
        this.m_ident.addProperties(this.getPropertyPrefix(), this);
    }

    @Override
    public void addFieldIdent(String id, Identification ident) {
        this.m_fields.put(id, ident);
    }

    @Override
    public void onEnd() throws SAXException {
        String prefix = this.getPropertyPrefix() + ".fld.";
        for (Map.Entry<String, Identification> entry : this.m_fields.entrySet()) {
            entry.getValue().addProperties(prefix + entry.getKey(), this);
        }
    }

    @Override
    public Map<String, Identification> getTemplate(String id) {
        return ((ActionContainer)((ActionNode)((WizardNode)this.getParent()).getParent()).getParent()).getTemplate(id);
    }
}

