/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.ForwardLogic;
import com.primavera.database.tools.dbmt.actions.InteractorDataDef;
import com.primavera.database.tools.dbmt.actions.TextDefinition;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.actions.AbstractFieldHolderNode;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionNodeContext;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.FinishNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ForwardNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.WizardNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageNode
extends AbstractFieldHolderNode<WizardNode>
implements ActionNodeContext {
    private final InteractorDataDef m_dataDef;
    private boolean m_finishable = false;
    private boolean m_previousable = true;
    private final Collection<FieldTester> m_finishValidators = new ArrayList<FieldTester>();
    private final Collection<FieldTester> m_forwardValidators = new ArrayList<FieldTester>();
    private final Collection<String> m_forwardDependencies = new HashSet<String>();
    private final WizardNavigationAction m_nextPageAction;

    public PageNode(WizardNode parent, Attributes attr) {
        super(parent, "page", attr);
        this.m_dataDef = new InteractorDataDef(this.getPropertyRoot());
        String back = attr.getValue("back");
        if (back != null) {
            this.m_previousable = back.toUpperCase().equals(Boolean.TRUE.toString());
        }
        WizardNavigationAction nextPageAction = WizardNavigationAction.NEXT;
        String specifiedAction = attr.getValue("next");
        if (specifiedAction != null) {
            try {
                nextPageAction = WizardNavigationAction.valueOf(specifiedAction.toUpperCase());
            }
            catch (Throwable e) {
                DBMTLogger.warn(Channel.DEV, "Unable to evaluate the specified next action (" + specifiedAction + ") for page " + this.getId());
            }
        }
        this.m_nextPageAction = nextPageAction;
        String cancel = attr.getValue("cancel");
        this.m_dataDef.setCancel(cancel == null || cancel.toUpperCase().equals(Boolean.TRUE.toString().toUpperCase()));
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("forward".equals(elemName)) {
            return new ForwardNode(this, attr);
        }
        if ("finish".equals(elemName)) {
            return new FinishNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String getPropertyRoot() {
        return ((WizardNode)this.getParent()).getPropertyRoot() + ".page." + this.getId();
    }

    @Override
    public void addTests(String fieldName, Collection<FieldTester> tests) {
        this.m_dataDef.getValidatorMap().put(fieldName, tests);
        PageNode.addFieldDepenencies(this.m_dataDef, fieldName, tests);
    }

    @Override
    public void addField(String valueId, ValueDef valueDef) {
        this.m_dataDef.addValueDef(valueId, valueDef);
    }

    @Override
    public void addText(String id, String textKey, List<String> substitutionKeys) {
        this.m_dataDef.addText(id, new TextDefinition(textKey, substitutionKeys));
    }

    @Override
    public void onStart() {
        ((WizardNode)this.getParent()).getDataDef().getDataDefMap().put(this.getId(), this.m_dataDef);
        ((WizardNode)this.getParent()).getDataDef().setPageNext(this.getId(), this.m_nextPageAction);
    }

    public final boolean isFinishable() {
        return this.m_finishable;
    }

    public final boolean isPreviousable() {
        return this.m_previousable;
    }

    public final void setFinishable(boolean finishable) {
        this.m_finishable = finishable;
    }

    public final void setPreviousable(boolean previousable) {
        this.m_previousable = previousable;
    }

    public final void addForwardValidators(Iterable<FieldTester> tests) {
        for (FieldTester test : tests) {
            this.m_forwardValidators.add(test);
            for (String field : test.getFields()) {
                this.m_forwardDependencies.add(field);
            }
        }
    }

    public final void setForward(ForwardLogic forward) {
        ((WizardNode)this.getParent()).setForwardForPage(this.getId(), forward);
    }

    public void addFinishValidators(Iterable<FieldTester> tests) {
        for (FieldTester test : tests) {
            this.m_finishValidators.add(test);
        }
    }

    @Override
    public void onEnd() throws SAXException {
        ((WizardNode)this.getParent()).getDataDef().getForwardValidators(this.getId()).addAll(this.m_forwardValidators);
        for (String field : this.m_forwardDependencies) {
            ((WizardNode)this.getParent()).getDataDef().getForwardDependencies(this.getId()).add(field);
        }
        this.m_dataDef.addFinishValidators(this.m_finishValidators);
        if (this.isFinishable()) {
            ((WizardNode)this.getParent()).getDataDef().addFinishablePage(this.getId());
        }
        if (this.isPreviousable()) {
            ((WizardNode)this.getParent()).getDataDef().addPreviousPage(this.getId());
        }
    }

    @Override
    public ActionLogicManager getActionManager() {
        return ((WizardNode)this.getParent()).getActionManager();
    }

    protected final WizardNavigationAction getNextPageAction() {
        return this.m_nextPageAction;
    }
}

