/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleHandler
extends DefaultHandler {
    private NodeLink m_rootLink;
    private List<NodeHandler> m_currentPath = new ArrayList<NodeHandler>();

    public SimpleHandler(NodeLink rootLink) {
        this.m_rootLink = rootLink;
    }

    private NodeLink currentLink() {
        if (this.m_currentPath.isEmpty()) {
            return this.m_rootLink;
        }
        return this.m_currentPath.get(this.m_currentPath.size() - 1);
    }

    private NodeHandler currentNode() {
        if (this.m_currentPath.isEmpty()) {
            return null;
        }
        return this.m_currentPath.get(this.m_currentPath.size() - 1);
    }

    private final void pushNode(NodeHandler currentNode) {
        this.m_currentPath.add(currentNode);
    }

    private final NodeHandler popNode() {
        if (this.m_currentPath.isEmpty()) {
            return null;
        }
        int index = this.m_currentPath.size() - 1;
        NodeHandler node = this.m_currentPath.get(index);
        this.m_currentPath.remove(index);
        return node;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        NodeHandler node = this.currentLink().nextNode(qName, attributes);
        if (node == null) {
            throw new SAXException("Node " + qName + " not found under " + this.currentLink().path());
        }
        this.pushNode(node);
        this.currentNode().onStart();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        NodeHandler node = this.popNode();
        node.onEnd();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentNode().onContent(ch, start, length);
    }
}

