/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins;

import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginsTableModel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class LoginTableDelta {
    public final DeltaType type;
    public final int row;

    public LoginTableDelta(int row, DeltaType type) {
        this.row = row;
        this.type = type;
    }

    public abstract void write(PrintStream var1);

    public abstract String asSql();

    public abstract void setParametersIntoStatement(PreparedStatement var1) throws SQLException;

    public final String toString() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buffer);
        this.write(out);
        return buffer.toString();
    }

    public static class AlterPassword
    extends LoginTableDelta {
        public final String from;
        public final String to;
        public final int groupId;

        public AlterPassword(int row, int groupId, String from, String to) {
            super(row, DeltaType.ALTER_PASSWORD);
            this.from = from;
            this.to = to;
            this.groupId = groupId;
        }

        @Override
        public void write(PrintStream out) {
            out.print("ALTER password (" + this.from.hashCode() + " -> " + this.to.hashCode() + ")");
        }

        @Override
        public String asSql() {
            return "UPDATE pubuser SET private_db_passwd = ? WHERE public_group_id = ?";
        }

        @Override
        public void setParametersIntoStatement(PreparedStatement stmt) throws SQLException {
            stmt.setString(1, this.to);
            stmt.setInt(2, this.groupId);
        }
    }

    public static class AlterGroupId
    extends LoginTableDelta {
        public final int from;
        public final int to;

        public AlterGroupId(int row, int from, int to) {
            super(row, DeltaType.ALTER_GROUP_ID);
            this.from = from;
            this.to = to;
        }

        @Override
        public void write(PrintStream out) {
            out.print("ALTER group id (" + this.from + " -> " + this.to + ")");
        }

        @Override
        public String asSql() {
            return "UPDATE pubuser SET public_group_id = ? WHERE public_group_id = ?";
        }

        @Override
        public void setParametersIntoStatement(PreparedStatement stmt) throws SQLException {
            stmt.setInt(1, this.to);
            stmt.setInt(2, this.from);
        }
    }

    public static class AlterUsername
    extends LoginTableDelta {
        public final String from;
        public final String to;
        public final int groupId;

        public AlterUsername(int row, int groupId, String from, String to) {
            super(row, DeltaType.ALTER_USERNAME);
            this.from = from;
            this.to = to;
            this.groupId = groupId;
        }

        @Override
        public void write(PrintStream out) {
            out.print("ALTER username (" + this.from + " -> " + this.to + ")");
        }

        @Override
        public String asSql() {
            return "UPDATE pubuser SET private_db_user_name = ? WHERE public_group_id = ?";
        }

        @Override
        public void setParametersIntoStatement(PreparedStatement stmt) throws SQLException {
            stmt.setString(1, this.to);
            stmt.setInt(2, this.groupId);
        }
    }

    public static class DeleteDelta
    extends LoginTableDelta {
        public final PrivateDatabaseLoginsTableModel.Record record;

        public DeleteDelta(int row, PrivateDatabaseLoginsTableModel.Record r) {
            super(row, DeltaType.DELETE_RECORD);
            this.record = r;
        }

        @Override
        public void write(PrintStream out) {
            out.print("DELETE {" + this.record.group_id + ", " + this.record.username + "}");
        }

        @Override
        public String asSql() {
            return "DELETE FROM pubuser WHERE public_group_id = ?";
        }

        @Override
        public void setParametersIntoStatement(PreparedStatement stmt) throws SQLException {
            stmt.setInt(1, this.record.group_id);
        }
    }

    public static class AddDelta
    extends LoginTableDelta {
        public final PrivateDatabaseLoginsTableModel.Record record;

        public AddDelta(int row, PrivateDatabaseLoginsTableModel.Record r) {
            super(row, DeltaType.ADD_RECORD);
            this.record = r;
        }

        @Override
        public void write(PrintStream out) {
            out.print("ADD {" + this.record.group_id + ", " + this.record.username + "}");
        }

        @Override
        public String asSql() {
            return "INSERT INTO pubuser (public_group_id, private_db_user_name, private_db_passwd) VALUES (?,?,?)";
        }

        @Override
        public void setParametersIntoStatement(PreparedStatement stmt) throws SQLException {
            stmt.setInt(1, this.record.group_id);
            stmt.setString(2, this.record.username);
            stmt.setString(3, this.record.password);
        }
    }

    public static enum DeltaType {
        ADD_RECORD,
        DELETE_RECORD,
        ALTER_USERNAME,
        ALTER_GROUP_ID,
        ALTER_PASSWORD;

    }
}

