/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.BaseDialogRunner;
import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.DialogNavigationAction;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.InteractorPage;
import com.primavera.database.tools.dbmt.gui.LayoutManager;
import com.primavera.database.tools.dbmt.gui.dialogs.GUILayoutSpec;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class GuiDialogRunner
extends BaseDialogRunner
implements InteractorPage {
    private final Map<String, ComponentBinding> m_bindingMap = new HashMap<String, ComponentBinding>();
    private final Map<String, JTextArea> m_textBindings = new HashMap<String, JTextArea>();

    public GuiDialogRunner(InteractorData data, String actionPath) {
        super(data, actionPath);
    }

    public abstract JDialog getDialog();

    public abstract boolean isAccept();

    public abstract JButton getButton(DialogNavigationAction var1);

    public abstract JPanel getButtonPanel();

    @Override
    protected boolean performDialogAction() {
        JDialog dialog = this.getDialog();
        dialog.setTitle(this.getData().getTitle());
        GUILayoutSpec layout = LayoutManager.getDialogLayout(this.getActionPath());
        layout.layoutPanel(this.getData(), this);
        this.initializeComponents();
        this.getButtonPanel().add(this.getButton(DialogNavigationAction.CANCEL));
        this.getButtonPanel().add(this.getButton(DialogNavigationAction.OK));
        dialog.pack();
        dialog.setModal(true);
        dialog.setVisible(true);
        return this.isAccept();
    }

    @Override
    public Action getNextAction() {
        return this.getButton(DialogNavigationAction.OK).getAction();
    }

    private void initializeComponents() {
        final InteractorData dlgData = this.getData();
        dlgData.addDataChangedListener(new DataChangedListener(){

            @Override
            public void onDataChanged(InteractorData data, String field) {
                ArrayList<String> reasons = new ArrayList<String>();
                for (FieldTester tester : dlgData.getFinishValidators()) {
                    try {
                        if (tester.doTest(dlgData)) continue;
                        reasons.add(tester.getReason(dlgData));
                    }
                    catch (InteractorDataError error) {
                        DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                    }
                }
                GuiDialogRunner.this.getButton(DialogNavigationAction.OK).setEnabled(reasons.isEmpty());
            }
        });
        ArrayList<String> reasons = new ArrayList<String>();
        for (FieldTester tester : dlgData.getFinishValidators()) {
            try {
                if (tester.doTest(dlgData)) continue;
                reasons.add(tester.getReason(dlgData));
            }
            catch (InteractorDataError error) {
                DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
            }
        }
        this.getButton(DialogNavigationAction.OK).setEnabled(reasons.isEmpty());
        for (String fieldId : dlgData.getFieldIds()) {
            Collection<FieldTester> testers = dlgData.getDef().getValidatorMap().get(fieldId);
            if (testers == null) continue;
            reasons.clear();
            for (FieldTester tester : testers) {
                try {
                    if (tester.doTest(dlgData)) continue;
                    reasons.add(tester.getReason(dlgData));
                }
                catch (InteractorDataError error) {
                    DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                }
            }
            for (JComponent comp : this.getBinding(fieldId).getComponents()) {
                comp.setEnabled(reasons.isEmpty());
            }
        }
    }

    @Override
    public ComponentBinding getBinding(String fieldId) {
        return this.m_bindingMap.get(fieldId);
    }

    @Override
    public Map<String, JTextArea> getTextBindingMap() {
        return this.m_textBindings;
    }

    @Override
    public final Map<String, ComponentBinding> getBindingMap() {
        return this.m_bindingMap;
    }
}

