/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;

public abstract class BaseExpDatabaseTypeProcessor
implements FieldProcessor {
    static final Object DBTYPE_EXP_GROUP = "GROUP";
    static final Object DBTYPE_EXP_ADMIN = "ADMIN";

    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        if (fieldValue == null || fieldValue.isEmpty()) {
            return this.returnExpGroupValue(data, props);
        }
        String uppercaseString = fieldValue.toUpperCase();
        if (uppercaseString.equals(DBTYPE_EXP_ADMIN)) {
            return this.returnExpAdminValue(data, props);
        }
        return this.returnExpGroupValue(data, props);
    }

    protected abstract String returnExpGroupValue(WizardInteractorData var1, JobProperties var2);

    protected abstract String returnExpAdminValue(WizardInteractorData var1, JobProperties var2);

    @Override
    public boolean validateValue(String fieldValue) {
        if (fieldValue.isEmpty()) {
            return true;
        }
        String uppercaseString = fieldValue.toUpperCase();
        return uppercaseString.equals(DBTYPE_EXP_GROUP) || uppercaseString.equals(DBTYPE_EXP_ADMIN);
    }
}

