/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.util.SchemaVersionsCompare;

public class SetUpgradeNeedsWebUserOptionsPage
implements TransitionMap.TransitionOperation {
    private static final String FIRST_SCHEMA_VERSION_WITH_WEB_USER = "0700.0001.0001.0002";
    private static final String NEEDS_WEBUSER_OPTIONS_FIELD_NAME = "webuseroptions";

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        boolean value = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM;
        boolean versionAlreadyHasWebUser = SchemaVersionsCompare.versionGreaterThanOrEqualTo(jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY).toString(), FIRST_SCHEMA_VERSION_WITH_WEB_USER);
        data.getPageData(page).setValue(NEEDS_WEBUSER_OPTIONS_FIELD_NAME, Boolean.toString(value && !versionAlreadyHasWebUser));
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

