/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.TablespaceNotFoundException;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;

public class SetOracleTablespacesForExpUpgrade
implements TransitionMap.TransitionOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(jobProps.getConnection(ConnectionClass.ADMINISTRATIVE));
            if (jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY) == SchemaType.EXP) {
                OracleLogic.TablespaceSet expTablespaces = OracleLogic.getExpTablespaces(connection);
                jobProps.getScriptProperties().setProperty("exp.data_tablespace", expTablespaces.getDataTablespaceName());
                jobProps.getScriptProperties().setProperty("exp.index_tablespace", expTablespaces.getIndexTablespaceName());
                jobProps.getScriptProperties().setProperty("exp.lob_tablespace", expTablespaces.getLobTablespaceName());
            } else {
                jobProps.getScriptProperties().setProperty("expadm.data_tablespace", OracleLogic.getExpAdminTablespace(connection));
            }
        }
        catch (SQLException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            return string;
        }
        catch (TablespaceNotFoundException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")");
                }
            }
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

