/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.LicenseType;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetLicenseTypeTransOp
implements TransitionMap.TransitionOperation {
    public static final String LICTYPE = "lictype";
    private final String m_pageId;
    private final String m_fieldId;

    public SetLicenseTypeTransOp(String pageId, String fieldId) {
        this.m_pageId = pageId;
        this.m_fieldId = fieldId;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        LicenseType licenseType = this.getLicenseKeyType(data);
        jobProps.setJobProperty(InstallSuiteOptionKeys.LICNESE_KEY_TYPE, (Object)licenseType);
        jobProps.setJobProperty(LICTYPE, "_" + licenseType.asId().toLowerCase());
        return null;
    }

    private LicenseType getLicenseKeyType(WizardInteractorData data) throws InteractorDataError {
        String productKey = data.getValue(this.m_pageId, this.m_fieldId);
        return LicenseType.valueOf(productKey.trim().substring(0, 2).toUpperCase());
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.LICNESE_KEY_TYPE);
        properties.clearJobProperty(LICTYPE);
    }
}

