/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;
import java.util.List;

public class SetBGjobUserSelectOptions
implements TransitionMap.PageInitializer {
    private static final String BGJOBUSER_FIELD_NAME = "bgjobuser";

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        String connectionSting = jobProps.getConnection(ConnectionClass.SYSUSER);
        String admUserConn = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        String[] stringArr = admUserConn.split("/");
        if (stringArr.length <= 0) {
            return null;
        }
        String admUserName = stringArr[0];
        List<String> bgUsersList = this.getBGJobUsers(connectionSting, admUserName);
        SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef(BGJOBUSER_FIELD_NAME);
        typeDef.reset();
        for (String username : bgUsersList) {
            typeDef.addValue(new EnumDataEntry(username, username, username, ""));
        }
        if (typeDef.getValues().size() > 0) {
            data.getPageData(page).setValue(BGJOBUSER_FIELD_NAME, typeDef.getValues().get(0).getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBGJobUsers(String connectionSting, String admUserName) {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            List<String> list = OracleLogic.getBGJobUsers(connection, admUserName);
            return list;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        return null;
    }
}

