/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UnknownProductSuiteException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SetAvailableTablespaces
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectStringName;
    private final TablespaceUtil.TablespaceDefaultsInfo m_info;
    private SchemaType m_schemaType;

    public SetAvailableTablespaces(ConnectionClass connectStringName, TablespaceUtil.TablespaceDefaultsInfo info, SchemaType schemaType) {
        this.m_connectStringName = connectStringName;
        this.m_info = info;
        this.m_schemaType = schemaType;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError, DBMTException, UnknownProductSuiteException {
        if (!PageInitializerHelper.isOracle(jobProps, data)) {
            return null;
        }
        Object productSuiteType = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY);
        if (productSuiteType != ProductSuiteType.PM && productSuiteType != ProductSuiteType.PPM) {
            return null;
        }
        HashMap<String, String> oracleTablespaceMap = new HashMap<String, String>();
        try {
            oracleTablespaceMap.putAll(TablespaceUtil.getAvailableTablespaces(jobProps.getConnection(this.m_connectStringName)));
        }
        catch (ConnectionNotFoundException e) {
            return e.getLocalizedMessage();
        }
        String tablespaceBaseName = TablespaceUtil.getTablespaceBaseName(jobProps);
        for (String field : this.m_info.getTablespaceFields()) {
            SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef(field);
            typeDef.reset();
            List<String> sortedTablespaces = this.sortKeys(oracleTablespaceMap.keySet());
            for (String tablespaceName : sortedTablespaces) {
                typeDef.addValue(new EnumDataEntry(tablespaceName, tablespaceName, tablespaceName, ""));
            }
            if (typeDef.getValues().size() <= 0) continue;
            String defaultTablespaceName = this.m_info.getTablespaceSuffix(field);
            if (defaultTablespaceName == null) {
                data.getPageData(page).setValue(field, typeDef.getValues().get(0).getId());
                continue;
            }
            boolean foundTablespace = false;
            String desiredTablespaceName = tablespaceBaseName + defaultTablespaceName;
            for (EnumDataEntry entry : typeDef.getValues()) {
                if (!entry.getId().equalsIgnoreCase(desiredTablespaceName)) continue;
                foundTablespace = true;
                break;
            }
            if (foundTablespace) {
                data.getPageData(page).setValue(field, desiredTablespaceName);
                continue;
            }
            if (typeDef.getValues().size() <= 0) continue;
            data.getPageData(page).setValue(field, typeDef.getValues().get(0).getId());
        }
        return null;
    }

    private List<String> sortKeys(Set<String> keyNameSet) {
        Object[] keyArray = new String[keyNameSet.size()];
        int nextIndex = 0;
        for (String key : keyNameSet) {
            keyArray[nextIndex++] = key;
        }
        Arrays.sort(keyArray);
        ArrayList<String> sortedList = new ArrayList<String>();
        for (Object key : keyArray) {
            sortedList.add((String)key);
        }
        return sortedList;
    }
}

