/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.workflow.SqlScriptJob;
import java.io.InputStreamReader;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.jdbc.OracleDriver;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RollbackJob {
    private final JobProperties m_jobProperty;
    private final SchemaInfo m_schema;
    private final String m_rollbackFilePrefix;
    private final String m_installedSchemaVersion;
    private final String m_gettingInstallSchemaVersion;

    public RollbackJob(JobProperties jobProperty, String rollbackFilePrefix) {
        this.m_jobProperty = jobProperty;
        this.m_schema = this.getSchema();
        this.m_rollbackFilePrefix = rollbackFilePrefix;
        this.m_installedSchemaVersion = (String)this.getPropertyFromJobProperties(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY);
        this.m_gettingInstallSchemaVersion = this.getToBeInstalledVersion(this.m_schema);
    }

    private String getConnectionString(ConnectionClass userType) {
        String connString = null;
        try {
            connString = this.m_jobProperty.getConnection(userType);
        }
        catch (ConnectionNotFoundException e) {
            DBMTLogger.error(e.getLocalizedMessage());
        }
        return connString;
    }

    private SchemaInfo getSchema() {
        SchemaInfo schemaInfo = null;
        SchemaType schemaType = (SchemaType)((Object)this.getPropertyFromJobProperties(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY));
        List schemas = (List)this.getPropertyFromJobProperties(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
        for (SchemaInfo schema : schemas) {
            if (schema == null || schema.getSchemaType() != schemaType) continue;
            schemaInfo = schema;
            break;
        }
        return schemaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRollBack(JFrame frame, boolean isCompleteRollback) {
        String rollbackStatusMessage = null;
        String serverType = this.getPropertyFromJobProperties(InstallSuiteOptionKeys.SERVER_TYPE_KEY).toString();
        boolean wasRollbacked = false;
        boolean wasSrcRollbacked = false;
        boolean wasPrivSchemaCompiled = false;
        try {
            ActionClass actionClass = new ActionClass(ActionType.ROLLBACK, (ServerType)((Object)this.getPropertyFromJobProperties(InstallSuiteOptionKeys.SERVER_TYPE_KEY)));
            Properties scriptProperties = this.m_jobProperty.getScriptProperties();
            String scriptFileName = this.getScriptFileName();
            String adminConnString = this.getConnectionString(ConnectionClass.ADMINISTRATIVE);
            String filename = "orpm_src.sql";
            String srcCodeDir = System.getProperty("user.dir");
            String dbType = serverType.equals("ORACLE") ? "OR" : "SS";
            this.grantDBAToAdmUser();
            if (scriptFileName != null) {
                SqlScriptJob job = new SqlScriptJob(actionClass, this.m_schema, scriptFileName, null, adminConnString, scriptProperties);
                wasRollbacked = ((AbstractJob)job).doJob(new RollbackJobListener(), new JobWatcher());
            }
            wasSrcRollbacked = this.runSourceCode();
            wasPrivSchemaCompiled = this.compilePrivUser();
            boolean allSuccess = false;
            allSuccess = scriptFileName != null ? wasRollbacked && wasSrcRollbacked && wasPrivSchemaCompiled : wasSrcRollbacked && wasPrivSchemaCompiled;
            rollbackStatusMessage = allSuccess ? this.getSuccessMessage(allSuccess) : StringLocalizer.get("dbmt.upgrade.rollback.unsuccessMessage");
        }
        catch (Exception e) {
            rollbackStatusMessage = StringLocalizer.get("dbmt.upgrade.rollback.unsuccessMessage");
            wasRollbacked = false;
            wasSrcRollbacked = false;
        }
        finally {
            this.revokeDBAFromAdmUser();
            if (frame != null) {
                JOptionPane.showMessageDialog(frame, rollbackStatusMessage);
                frame.dispose();
            } else {
                System.out.println(rollbackStatusMessage);
            }
        }
    }

    private String getSuccessMessage(boolean isCompleteRollback) {
        if (isCompleteRollback) {
            return StringLocalizer.get("dbmt.upgrade.rollback.successMessage.success", new String[]{this.getInstalledSchemaVersion()});
        }
        return StringLocalizer.get("dbmt.upgrade.rollback.successMessage.partial", new String[]{this.getToBeInstalledSchemaVersion()});
    }

    private void grantDBAToAdmUser() {
        try {
            DriverManager.registerDriver(new OracleDriver());
            String adminUser = this.getUserName(ConnectionClass.ADMINISTRATIVE);
            DatabaseConnection c = new DatabaseConnection(this.getConnectionString(ConnectionClass.SYSADMIN));
            String sqlStatement = "GRANT DBA TO " + adminUser;
            String sqlStatement1 = "alter user " + adminUser + " default role all";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.execute(sqlStatement1);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.grant.system.to.admin.unsuccessMessage"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSourceCode() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
        DatabaseConnection con = new DatabaseConnection(this.getConnectionString(ConnectionClass.ADMINISTRATIVE));
        ArrayList<String> type = new ArrayList<String>();
        ArrayList<String> name = new ArrayList<String>();
        String query = "select distinct name,type from SRC_BKP where type IN ('PACKAGE','PACKAGE BODY','FUNCTION','PROCEDURE','TRIGGER') order by 2,1";
        Statement statement = con.getConnection().createStatement();
        Statement statement1 = con.getConnection().createStatement();
        try {
            try {
                ResultSet rs = statement.executeQuery(query);
                while (rs.next()) {
                    String l_type = rs.getString("TYPE");
                    String l_name = rs.getString("NAME");
                    type.add(l_type);
                    name.add(l_name);
                }
            }
            finally {
                statement.close();
            }
            try {
                for (int i = 0; i < name.size(); ++i) {
                    String query1 = "SELECT TEXT,LINE FROM SRC_BKP WHERE TYPE='" + (String)type.get(i) + "' AND NAME='" + (String)name.get(i) + "' ORDER BY 2";
                    statement = con.getConnection().createStatement();
                    ResultSet rs1 = statement.executeQuery(query1);
                    String v_text = null;
                    while (rs1.next()) {
                        Integer v_line = rs1.getInt("LINE");
                        String l_text = rs1.getString("TEXT");
                        if (v_line.equals(1)) {
                            v_text = "create or replace " + l_text;
                            continue;
                        }
                        v_text = v_text + l_text;
                    }
                    statement1.execute(v_text);
                }
            }
            finally {
                statement.close();
                statement1.close();
            }
        }
        catch (SQLException e) {
            DBMTLogger.error(e.getLocalizedMessage());
        }
        finally {
            con.close();
        }
        return true;
    }

    private String getUserName(ConnectionClass administrative) {
        String connString = this.getConnectionString(administrative);
        String[] stringArr = connString.split("/");
        if (stringArr.length > 0) {
            return stringArr[0];
        }
        DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.userName.from.connectionString.unsuccessful"));
        return null;
    }

    private void revokeDBAFromAdmUser() {
        try {
            DriverManager.registerDriver(new OracleDriver());
            String adminUser = this.getUserName(ConnectionClass.ADMINISTRATIVE);
            DatabaseConnection c = new DatabaseConnection(this.getConnectionString(ConnectionClass.SYSADMIN));
            String sqlStatement = "REVOKE DBA FROM " + adminUser;
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.revoke.system.from.admin.unsuccessMessage"));
            return;
        }
    }

    private String getScriptFileName() {
        String serverType = this.getPropertyFromJobProperties(InstallSuiteOptionKeys.SERVER_TYPE_KEY).toString();
        String dbType = serverType.equals("ORACLE") ? "OR" : "SS";
        String fileName = null;
        if (!(this.m_rollbackFilePrefix.startsWith("P18") || this.m_rollbackFilePrefix.startsWith("P17") || this.m_rollbackFilePrefix.startsWith("P16"))) {
            fileName = dbType + this.getPropertyFromJobProperties(InstallSuiteOptionKeys.PRODUCT_UPGRADE_KEY).toString() + "_" + this.m_rollbackFilePrefix + ".sql";
        }
        return fileName;
    }

    public Object getPropertyFromJobProperties(Object key) {
        Object prop = null;
        try {
            prop = this.m_jobProperty.getJobProperty(key);
        }
        catch (JobPropertyNotFound e) {
            DBMTLogger.warn(e.getLocalizedMessage());
        }
        return prop;
    }

    private String getToBeInstalledVersion(SchemaInfo schema) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath currentVersionPath = factory.newXPath();
            XPathExpression currentVersionExpr = currentVersionPath.compile("/PrimaveraDatabaseSchema");
            Node currentVersionResult = (Node)currentVersionExpr.evaluate(RollbackJob.getSchemaXMLInputSource(schema), XPathConstants.NODE);
            return currentVersionResult.getAttributes().getNamedItem("VERSION").getNodeValue();
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    private static InputSource getSchemaXMLInputSource(SchemaInfo schema) {
        String resource = SchemaJarUtil.getResource(schema, "install", SchemaJarUtil.getSchemaSpecFilename(schema));
        InputSource in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resource)));
        return in;
    }

    public String getInstalledSchemaVersion() {
        return this.m_installedSchemaVersion;
    }

    public String getToBeInstalledSchemaVersion() {
        return this.m_gettingInstallSchemaVersion;
    }

    private boolean compilePrivUser() {
        try {
            String privuserName = this.getUserName(ConnectionClass.PRIVILEGED);
            DatabaseConnection c = new DatabaseConnection(this.getConnectionString(ConnectionClass.ADMINISTRATIVE));
            String sqlStatement = "begin DBMS_UTILITY.compile_schema(schema => '" + privuserName.toUpperCase() + "'); end;";
            Statement stmt = c.getConnection().createStatement();
            stmt.execute(sqlStatement);
            stmt.close();
            c.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(e.getMessage());
            return false;
        }
        return true;
    }

    private class RollbackJobListener
    extends JobListenerAdaptor {
        private RollbackJobListener() {
        }
    }
}

