/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.tools.dbmt.ProductUpgradeVersionInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProductUpgradeVersionMap {
    private final Map<String, ProductUpgradeVersionInfo> m_versionInfoMap = new HashMap<String, ProductUpgradeVersionInfo>();
    private final ProductUpgradeVersionInfo m_lastest;

    private ProductUpgradeVersionMap(ProductUpgradeVersionInfo latest, Map<String, ProductUpgradeVersionInfo> map) {
        this.m_versionInfoMap.putAll(map);
        this.m_lastest = latest;
    }

    public ProductUpgradeVersionInfo get(String schemaVersionString) {
        return this.m_versionInfoMap.get(schemaVersionString);
    }

    private static InputSource getSchemaXMLInputSource(SchemaInfo schema) {
        String resource = SchemaJarUtil.getResource(schema, "install", SchemaJarUtil.getSchemaSpecFilename(schema));
        InputSource in = new InputSource(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resource)));
        return in;
    }

    public static ProductUpgradeVersionMap create(SchemaInfo schema) throws XPathException, ParserConfigurationException, SAXException, IOException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath currentVersionPath = factory.newXPath();
        XPathExpression currentVersionExpr = currentVersionPath.compile("/PrimaveraDatabaseSchema");
        Node currentVersionResult = (Node)currentVersionExpr.evaluate(ProductUpgradeVersionMap.getSchemaXMLInputSource(schema), XPathConstants.NODE);
        String currentSchemaVersion = currentVersionResult.getAttributes().getNamedItem("VERSION").getNodeValue();
        XPath versionHistoryPath = factory.newXPath();
        String versionHistoryPathString = "/PrimaveraDatabaseSchema/HISTORY";
        XPathExpression verisionHistoryExpression = versionHistoryPath.compile(versionHistoryPathString);
        DocumentBuilderFactory domfactory = DocumentBuilderFactory.newInstance();
        domfactory.setNamespaceAware(true);
        DocumentBuilder builder = domfactory.newDocumentBuilder();
        Document doc = builder.parse(ProductUpgradeVersionMap.getSchemaXMLInputSource(schema));
        NodeList result = (NodeList)verisionHistoryExpression.evaluate(doc, XPathConstants.NODESET);
        int length = result.getLength();
        HashMap<String, ProductUpgradeVersionInfo> versionMap = new HashMap<String, ProductUpgradeVersionInfo>();
        for (int i = 0; i < length; ++i) {
            String schemaVersion = result.item(i).getAttributes().getNamedItem("VERSION").getNodeValue();
            String upgradeFile = result.item(i).getAttributes().getNamedItem("UPGRADE_FILE").getNodeValue();
            String shortName = result.item(i).getAttributes().getNamedItem("VERSION_SHORT_NAME").getNodeValue();
            String versionName = result.item(i).getAttributes().getNamedItem("VERSION_NAME").getNodeValue();
            versionMap.put(schemaVersion, new ProductUpgradeVersionInfo(schemaVersion, upgradeFile, shortName, versionName));
        }
        return new ProductUpgradeVersionMap((ProductUpgradeVersionInfo)versionMap.get(currentSchemaVersion), versionMap);
    }

    public final ProductUpgradeVersionInfo getLastest() {
        return this.m_lastest;
    }
}

