/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util.test;

import com.primavera.database.TestingConnection;
import fixtures.util.DatabaseSetup;
import java.sql.Connection;
import junit.framework.TestCase;

public class DatabaseSetupTest
extends TestCase {
    public void setUp() {
        DatabaseSetup ds = new DatabaseSetup();
        try {
            ds.setProperty("setup_test=newprop");
            ds.setProperty("setup_test2=newval");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DatabaseSetupTest.fail((String)ex.getMessage());
        }
    }

    private void catchInvalidString(DatabaseSetup ds, String s) {
        try {
            ds.setProperty(s);
            DatabaseSetupTest.fail((String)"exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetProperties() {
        DatabaseSetup ds = new DatabaseSetup();
        try {
            ds.setProperty("test_property=oracle");
            DatabaseSetupTest.assertEquals((String)"oracle", (String)DatabaseSetup.getProperty("test_property"));
            ds.setProperty("secondary_propery=sqlserver");
            ds.setCurrentKey("test_property");
            DatabaseSetupTest.assertEquals((String)"oracle", (String)ds.getProperty());
            DatabaseSetupTest.assertNotNull((String)"not_a_property", (Object)DatabaseSetup.getProperty("no_a_property"));
            this.catchInvalidString(ds, "=123");
            this.catchInvalidString(ds, "abc");
            this.catchInvalidString(ds, "abc=");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DatabaseSetupTest.fail((String)ex.getMessage());
        }
    }

    public void testStaticGet() {
        DatabaseSetupTest.assertEquals((String)"newprop", (String)DatabaseSetup.getProperty("setup_test"));
        DatabaseSetupTest.assertEquals((String)"newval", (String)DatabaseSetup.getProperty("setup_test2"));
    }

    public void testDatabaseConnection() {
        try {
            DatabaseSetup ds = new DatabaseSetup();
            Connection conn = TestingConnection.getConnection();
            String url = TestingConnection.getUrl();
            System.out.println(url);
            ds.setProperty("PRIMARY_ORACLE_URL=" + url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DatabaseSetupTest.fail((String)ex.getMessage());
        }
    }
}

