/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class RetrieveExpCustomfieldInfoFromDatabase {
    private static final String GCDF_FIELDS = "CDI_NAME, CDI_LENGTH, CDI_TABLE, CDI_TYPE, DESCRIPTION";
    private static final String GET_CGDF_RECORDS_SQL = "SELECT DISTINCT CDI_NAME, CDI_LENGTH, CDI_TABLE, CDI_TYPE, DESCRIPTION FROM gcdf";
    private static final String GET_CSDF_RECORDS_SQL = "SELECT * FROM csdf";
    private final String m_connnectionString;
    public final RetrieveExpCustomFieldInfo<CSDFRecord> m_csdfRecordRetriever = new RetrieveExpCustomFieldInfo<CSDFRecord>(){

        @Override
        public Collection<CSDFRecord> getRecords() throws SQLException {
            return RetrieveExpCustomfieldInfoFromDatabase.this.getCSDFRecords();
        }
    };
    public final RetrieveExpCustomFieldInfo<GCDFRecord> m_gcdfRecordRetriever = new RetrieveExpCustomFieldInfo<GCDFRecord>(){

        @Override
        public Collection<GCDFRecord> getRecords() throws SQLException {
            return RetrieveExpCustomfieldInfoFromDatabase.this.getGCDFRecords();
        }
    };

    public RetrieveExpCustomfieldInfoFromDatabase(String connnectionString) {
        this.m_connnectionString = connnectionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CSDFRecord> getCSDFRecords() throws SQLException {
        ArrayList<CSDFRecord> recordList = new ArrayList<CSDFRecord>();
        DatabaseConnection conn = new DatabaseConnection(this.m_connnectionString);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.getConnection().prepareStatement(GET_CSDF_RECORDS_SQL);
            rset = stmt.executeQuery();
            while (rset.next()) {
                CSDFRecord record = new CSDFRecord();
                record.setMasterKey(rset.getString("master_key"));
                record.setDefinitionName(rset.getString("definition_name"));
                record.setDescription(rset.getString("description"));
                record.setStartColumn(rset.getInt("start_column"));
                record.setWidth(rset.getInt("width"));
                record.setColumnNumber(rset.getInt("colno"));
                recordList.add(record);
            }
        }
        finally {
            conn.close();
            if (stmt != null) {
                stmt.close();
            }
            if (rset != null) {
                rset.close();
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GCDFRecord> getGCDFRecords() throws SQLException {
        ArrayList<GCDFRecord> recordList = new ArrayList<GCDFRecord>();
        DatabaseConnection conn = new DatabaseConnection(this.m_connnectionString);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.getConnection().prepareStatement(GET_CGDF_RECORDS_SQL);
            rset = stmt.executeQuery();
            while (rset.next()) {
                GCDFRecord record = new GCDFRecord();
                record.setCdiLength(rset.getInt("cdi_length"));
                record.setCdiName(rset.getString("cdi_name"));
                record.setCdiTable(rset.getString("cdi_table"));
                record.setCdiType(rset.getString("cdi_type"));
                recordList.add(record);
            }
        }
        finally {
            conn.close();
            if (stmt != null) {
                stmt.close();
            }
            if (rset != null) {
                rset.close();
            }
        }
        return recordList;
    }
}

