/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.logging;

import com.primavera.database.common.logging.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DBMTLogger {
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.OFF;
    private static Map<ChannelAppenderLogLevelMapKey, LogLevel> m_logLevelMap = new HashMap<ChannelAppenderLogLevelMapKey, LogLevel>();
    private static Set<Appender> m_appenderSet = new HashSet<Appender>();
    private static Set<Channel> m_channelSet = new HashSet<Channel>();
    public static final Appender CONSOLE_APPENDER = new ConsoleAppender();
    public static final Channel DEFAULT_CHANNEL = new Channel("DEFAULT");
    public static final Appender LOG4J_APPENDER = new Log4JAppender();

    public static synchronized void addChannel(String name) {
        Channel channel = new Channel(name);
        m_channelSet.add(channel);
    }

    public static synchronized void removeChanel(String name) {
        Channel chanel = new Channel(name);
        m_channelSet.remove(chanel);
    }

    public static synchronized void addAppender(Appender appender) {
        m_appenderSet.add(appender);
    }

    public static synchronized void removeAppender(Appender appender) {
        m_appenderSet.remove(appender);
    }

    public static Iterable<Channel> getChannels() {
        return m_channelSet;
    }

    public static Iterable<Appender> getAppenders() {
        return m_appenderSet;
    }

    private static synchronized Iterable<Appender> getAppenders(Channel ch, LogLevel level) {
        ArrayList<Appender> m_results = new ArrayList<Appender>();
        for (Appender appender : m_appenderSet) {
            if (DBMTLogger.findLogLevel(ch.getName(), appender).compareTo(level) > 0) continue;
            m_results.add(appender);
        }
        return m_results;
    }

    public static synchronized void setLogLevel(String ch, Appender appender, LogLevel logLevel) {
        ChannelAppenderLogLevelMapKey key = new ChannelAppenderLogLevelMapKey(new Channel(ch), appender);
        if (logLevel.equals((Object)DEFAULT_LOG_LEVEL)) {
            m_logLevelMap.remove(key);
        } else {
            m_logLevelMap.put(key, logLevel);
        }
    }

    public static LogLevel findLogLevel(String ch, Appender appender) {
        ChannelAppenderLogLevelMapKey key = new ChannelAppenderLogLevelMapKey(new Channel(ch), appender);
        LogLevel level = m_logLevelMap.get(key);
        if (level != null) {
            return level;
        }
        return DEFAULT_LOG_LEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Channel ch, LogLevel ll, String msg) {
        Iterator<Appender> iterator = DBMTLogger.getAppenders(ch, ll).iterator();
        while (iterator.hasNext()) {
            Appender appender;
            Appender appender2 = appender = iterator.next();
            synchronized (appender2) {
                appender.write(ch, ll, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Channel ch, LogLevel ll, String msg, Throwable e) {
        Iterator<Appender> iterator = DBMTLogger.getAppenders(ch, ll).iterator();
        while (iterator.hasNext()) {
            Appender appender;
            Appender appender2 = appender = iterator.next();
            synchronized (appender2) {
                appender.write(ch, ll, msg, e);
            }
        }
    }

    public static void error(String msg) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.ERROR, msg);
    }

    public static void error(String msg, Throwable e) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.ERROR, msg, e);
    }

    public static void warn(String msg) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.WARN, msg);
    }

    public static void warn(String msg, Throwable e) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.WARN, msg, e);
    }

    public static void info(String msg) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.INFO, msg);
    }

    public static void info(String msg, Throwable e) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.INFO, msg, e);
    }

    public static void debug(String msg) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.DEBUG, msg);
    }

    public static void debug(String msg, Throwable e) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.DEBUG, msg, e);
    }

    public static void trace(String msg) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.TRACE, msg);
    }

    public static void trace(String msg, Throwable e) {
        DBMTLogger.write(DEFAULT_CHANNEL, LogLevel.TRACE, msg, e);
    }

    public static void error(String chanel, String msg) {
        DBMTLogger.write(new Channel(chanel), LogLevel.ERROR, msg);
    }

    public static void warn(String chanel, String msg) {
        DBMTLogger.write(new Channel(chanel), LogLevel.WARN, msg);
    }

    public static void info(String chanel, String msg) {
        DBMTLogger.write(new Channel(chanel), LogLevel.INFO, msg);
    }

    public static void debug(String chanel, String msg) {
        DBMTLogger.write(new Channel(chanel), LogLevel.DEBUG, msg);
    }

    public static void trace(String chanel, String msg) {
        DBMTLogger.write(new Channel(chanel), LogLevel.OFF, msg);
    }

    public static void error(String chanel, String msg, Throwable e) {
        DBMTLogger.write(new Channel(chanel), LogLevel.ERROR, msg, e);
    }

    public static void warn(String chanel, String msg, Throwable e) {
        DBMTLogger.write(new Channel(chanel), LogLevel.WARN, msg, e);
    }

    public static void info(String chanel, String msg, Throwable e) {
        DBMTLogger.write(new Channel(chanel), LogLevel.INFO, msg, e);
    }

    public static void debug(String chanel, String msg, Throwable e) {
        DBMTLogger.write(new Channel(chanel), LogLevel.DEBUG, msg, e);
    }

    public static void trace(String chanel, String msg, Throwable e) {
        DBMTLogger.write(new Channel(chanel), LogLevel.OFF, msg, e);
    }

    private static class ChannelAppenderLogLevelMapKey {
        private Appender m_appender;
        private Channel m_channel;

        public ChannelAppenderLogLevelMapKey(Channel chanel, Appender appender) {
            this.m_appender = appender;
            this.m_channel = chanel;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChannelAppenderLogLevelMapKey) {
                ChannelAppenderLogLevelMapKey key = (ChannelAppenderLogLevelMapKey)obj;
                return this.m_appender == key.m_appender && this.m_channel.getName() == key.m_channel.getName();
            }
            return false;
        }

        public int hashCode() {
            return this.m_channel.hashCode();
        }
    }

    public static class FileAppender
    implements Appender {
        private BufferedWriter out;

        public FileAppender(String filename) {
            try {
                this.out = new BufferedWriter(new FileWriter(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized int write(Channel ch, LogLevel level, String str) {
            String fmtstr = ch.getName() + " [" + level.toString() + "] : " + str;
            try {
                this.out.write(fmtstr);
                this.out.newLine();
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return fmtstr.length();
        }

        @Override
        public synchronized int write(Channel ch, LogLevel level, String str, Throwable e) {
            String fmtstr = ch.getName() + " [" + level.toString() + "] : " + str;
            try {
                this.out.write(fmtstr);
                this.out.newLine();
                e.printStackTrace(new PrintWriter(this.out));
                this.out.flush();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return fmtstr.length();
        }
    }

    public static class Log4JAppender
    implements Appender {
        @Override
        public int write(Channel ch, LogLevel level, String str) {
            String msg = "[" + ch.getName() + "] " + str;
            int len = msg.length();
            if (level == LogLevel.DEBUG) {
                Log.debug(msg);
                return len;
            }
            if (level == LogLevel.ERROR) {
                Log.error(msg);
                return len;
            }
            if (level == LogLevel.INFO) {
                Log.info(msg);
                return len;
            }
            if (level == LogLevel.TRACE) {
                Log.trace(msg);
                return len;
            }
            if (level == LogLevel.WARN) {
                Log.warn(msg);
                return len;
            }
            return 0;
        }

        @Override
        public int write(Channel ch, LogLevel level, String str, Throwable e) {
            return this.write(ch, level, str + "\n" + Log4JAppender.getStackTraceString(e));
        }

        private static String getStackTraceString(Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }

    public static class ConsoleAppender
    implements Appender {
        @Override
        public synchronized int write(Channel ch, LogLevel level, String str) {
            String fmtstr = ch.getName() + " [" + level.toString() + "] : " + str;
            System.out.println(fmtstr);
            return fmtstr.length();
        }

        @Override
        public int write(Channel ch, LogLevel level, String str, Throwable e) {
            String fmtstr = ch.getName() + " [" + level.toString() + "] : " + str;
            System.out.println(fmtstr);
            e.printStackTrace(System.out);
            return fmtstr.length();
        }
    }

    public static final class Channel {
        private String m_name;

        public Channel(String name) {
            this.m_name = name.intern();
        }

        public String getName() {
            return this.m_name;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Channel) {
                Channel ch = (Channel)obj;
                return ch.m_name == this.m_name;
            }
            return false;
        }
    }

    public static interface Appender {
        public int write(Channel var1, LogLevel var2, String var3);

        public int write(Channel var1, LogLevel var2, String var3, Throwable var4);
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

