/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.connection;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.connection.IDatabaseMetaData;
import com.primavera.database.common.dbo.DatabaseColumn;
import com.primavera.database.common.dbo.DatabaseConstraint;
import com.primavera.database.common.dbo.DatabaseIndex;
import com.primavera.database.common.dbo.DatabasePrivilege;
import com.primavera.database.common.dbo.DatabaseProcedure;
import com.primavera.database.common.dbo.DatabaseSynonym;
import com.primavera.database.common.dbo.DatabaseTable;
import com.primavera.database.common.dbo.DatabaseTrigger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class DatabaseMetaData
implements IDatabaseMetaData {
    public DatabaseConnection m_conn;
    private Connection m_jconn;

    public void setDatabaseConnection(DatabaseConnection conn) {
        this.m_conn = conn;
        this.m_jconn = conn.getConnection();
    }

    private String schemaPattern() {
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            return this.m_conn.getUsername().toUpperCase();
        }
        if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            return "dbo";
        }
        return "%";
    }

    @Override
    public ArrayList<DatabaseTable> getTables() throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = jmetadata.getTables(null, this.schemaPattern(), "%", types);
        while (rs.next()) {
            if (rs.getString("TABLE_NAME").toUpperCase().startsWith("BIN$") || rs.getString("TABLE_NAME").toUpperCase().startsWith("DR$")) continue;
            DatabaseTable table = new DatabaseTable();
            table.setName(rs.getString("TABLE_NAME").toUpperCase());
            tables.add(table);
        }
        rs.close();
        return tables;
    }

    @Override
    public ArrayList<DatabaseColumn> getColumns(String table) throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<DatabaseColumn> columns = new ArrayList<DatabaseColumn>();
        ResultSet rs = jmetadata.getColumns(null, this.schemaPattern(), table, "%");
        while (rs.next()) {
            int nullable;
            DatabaseColumn column = new DatabaseColumn();
            column.setTableName(rs.getString("TABLE_NAME").toUpperCase());
            column.setName(rs.getString("COLUMN_NAME").toLowerCase());
            int prec = rs.getInt("COLUMN_SIZE");
            column.setPrecision(prec);
            column.setScale(rs.getInt("DECIMAL_DIGITS"));
            column.setDataType(rs.getString("TYPE_NAME"));
            if (this.m_conn.getServerType() == ServerType.ORACLE) {
                column.setLength(rs.getInt("COLUMN_SIZE"));
            } else {
                if (column.getDataType().equalsIgnoreCase("nvarchar")) {
                    column.setLength(rs.getInt("CHAR_OCTET_LENGTH") / 2);
                } else if (column.getDataType().equalsIgnoreCase("varchar")) {
                    column.setLength(rs.getInt("CHAR_OCTET_LENGTH"));
                } else {
                    column.setLength(rs.getInt("COLUMN_SIZE"));
                }
                if (column.getTableName().equalsIgnoreCase("PC_PROCESS_STAT") && (column.getName().equalsIgnoreCase("start_ts") || column.getName().equalsIgnoreCase("end_ts"))) {
                    column.setGenericDataType("ortimestamp");
                }
            }
            if (column.getTableName().equalsIgnoreCase("PC_PROCESS_STAT") && column.getName().equalsIgnoreCase("pc_process_stat_id")) {
                column.setGenericDataType("identity");
            }
            if ((nullable = rs.getInt("NULLABLE")) == 1) {
                column.setNotNull(false);
            } else {
                column.setNotNull(true);
            }
            column.setDefaultValue(rs.getString("COLUMN_DEF"));
            columns.add(column);
        }
        rs.close();
        return columns;
    }

    @Override
    public ArrayList<DatabaseIndex> getIndexes(String table) throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<DatabaseIndex> indexes = new ArrayList<DatabaseIndex>();
        DatabaseConstraint pk = this.getPrimary(table);
        ResultSet rs = jmetadata.getIndexInfo(null, this.schemaPattern(), table, false, true);
        String lastName = "xxxxxx";
        DatabaseIndex index = new DatabaseIndex();
        while (rs.next()) {
            if (rs.getString("INDEX_NAME") == null || rs.getString("INDEX_NAME").equalsIgnoreCase(pk.getName())) continue;
            String name = rs.getString("INDEX_NAME").toLowerCase();
            if (!name.equalsIgnoreCase(lastName)) {
                if (index.getName() != null) {
                    indexes.add(index);
                }
                index = new DatabaseIndex();
                index.setName(name);
                index.setTableName(rs.getString("TABLE_NAME").toUpperCase());
                lastName = name;
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
            }
            index.addField(rs.getString("COLUMN_NAME").toLowerCase());
        }
        if (index.getName() != null) {
            indexes.add(index);
        }
        rs.close();
        return indexes;
    }

    @Override
    public DatabaseConstraint getPrimary(String table) throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        DatabaseConstraint pk = new DatabaseConstraint();
        ResultSet rs = jmetadata.getPrimaryKeys(null, this.schemaPattern(), table);
        while (rs.next()) {
            pk.setName(rs.getString("PK_NAME").toLowerCase());
            pk.addField(rs.getString("COLUMN_NAME").toLowerCase());
            pk.setType("PRIMARY");
        }
        rs.close();
        return pk;
    }

    @Override
    public ArrayList<DatabaseConstraint> getForeign(String table) throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<DatabaseConstraint> constraints = new ArrayList<DatabaseConstraint>();
        ResultSet rs = jmetadata.getImportedKeys(null, this.schemaPattern(), table);
        String lastName = "xxxxxx";
        DatabaseConstraint con = new DatabaseConstraint();
        while (rs.next()) {
            if (rs.getString("FK_NAME") == null) continue;
            String name = rs.getString("FK_NAME").toLowerCase();
            if (!name.equalsIgnoreCase(lastName)) {
                if (con.getName() != null) {
                    constraints.add(con);
                }
                con = new DatabaseConstraint();
                con.setName(name);
                con.setTableName(rs.getString("FKTABLE_NAME").toUpperCase());
                con.setTargetTableName(rs.getString("FKTABLE_NAME").toUpperCase());
                con.setType("FOREIGN");
                lastName = name;
            }
            con.addField(rs.getString("FKCOLUMN_NAME").toLowerCase());
            con.addTargetField(rs.getString("PKCOLUMN_NAME").toLowerCase());
        }
        if (con.getName() != null) {
            constraints.add(con);
        }
        rs.close();
        return constraints;
    }

    @Override
    public ArrayList<DatabaseConstraint> getCheck(String table) throws SQLException {
        ArrayList<DatabaseConstraint> checks = new ArrayList<DatabaseConstraint>();
        String sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "select constraint_name NAME, search_condition CONTEXT";
            sql = sql + " from user_constraints where constraint_type='C' and table_name = ?";
            sql = sql + " and constraint_name not like 'BIN%'";
        } else if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            sql = "select c_obj.name NAME, sc.text CONTEXT";
            sql = sql + " from  sysobjects t_obj, syscomments sc right outer join sysobjects c_obj on sc.id = c_obj.id";
            sql = sql + " where c_obj.xtype = 'c' and c_obj.parent_obj = t_obj.id and t_obj.name = ?";
        }
        PreparedStatement pstmt = this.m_jconn.prepareStatement(sql);
        pstmt.setString(1, table);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            DatabaseConstraint con = new DatabaseConstraint();
            con.setName(rs.getString("NAME").toLowerCase());
            String condition = rs.getString("CONTEXT");
            if (condition.contains("IS NOT NULL")) continue;
            con.setSearchCondition(condition);
            con.setType("CHECK");
            checks.add(con);
        }
        rs.close();
        pstmt.close();
        return checks;
    }

    @Override
    public ArrayList<DatabaseConstraint> getConstraints(String table) throws SQLException {
        ArrayList<DatabaseConstraint> constraints = new ArrayList<DatabaseConstraint>();
        constraints.addAll(this.getForeign(table));
        constraints.addAll(this.getCheck(table));
        constraints.add(this.getPrimary(table));
        return constraints;
    }

    @Override
    public ArrayList<DatabaseTrigger> getTriggers(String table) throws SQLException {
        ArrayList<DatabaseTrigger> trigs = new ArrayList<DatabaseTrigger>();
        String sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "select trigger_name NAME from user_triggers";
            sql = sql + " where trigger_name not like 'BIN%'";
            sql = sql + "  and table_name = ?";
        } else if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            sql = "select so.name NAME from sysobjects so, sysobjects po";
            sql = sql + " where so.xtype = 'TR'";
            sql = sql + " and po.id = so.parent_obj and po.name = ?";
        }
        PreparedStatement pstmt = this.m_jconn.prepareStatement(sql);
        pstmt.setString(1, table);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            DatabaseTrigger trig = new DatabaseTrigger();
            trig.setName(rs.getString("NAME").toUpperCase());
            trig.setTableName(table);
            trigs.add(trig);
        }
        rs.close();
        pstmt.close();
        return trigs;
    }

    @Override
    public ArrayList<DatabaseProcedure> getProcedures() throws SQLException {
        ArrayList<DatabaseProcedure> procs = new ArrayList<DatabaseProcedure>();
        String sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "select object_name OBJNAME , object_type OBJTYPE";
            sql = sql + " from user_objects where object_type in ('PROCEDURE','FUNCTION','PACKAGE')";
            sql = sql + " and object_name not like 'BIN%'";
        } else if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            sql = "select so.name OBJNAME,case so.xtype WHEN 'FN' THEN 'FUNCTION' WHEN 'TF' THEN 'FUNCTION'  ELSE 'PROCEDURE' END  OBJTYPE";
            sql = sql + " from sysobjects so";
            sql = sql + " where so.xtype in ('P','FN','TF')";
        }
        ResultSet rs = this.m_jconn.createStatement().executeQuery(sql);
        while (rs.next()) {
            DatabaseProcedure proc = new DatabaseProcedure();
            proc.setName(rs.getString("OBJNAME").toUpperCase());
            proc.setType(rs.getString("OBJTYPE").toUpperCase());
            procs.add(proc);
        }
        rs.close();
        return procs;
    }

    @Override
    public ArrayList<String> getViews() throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<String> views = new ArrayList<String>();
        String[] types = new String[]{"VIEW"};
        ResultSet rs = jmetadata.getTables(null, this.schemaPattern(), "%", types);
        while (rs.next()) {
            views.add(rs.getString("TABLE_NAME").toUpperCase());
        }
        rs.close();
        return views;
    }

    @Override
    public ArrayList<DatabasePrivilege> getPrivs(String objectname) throws SQLException {
        java.sql.DatabaseMetaData jmetadata = this.m_jconn.getMetaData();
        ArrayList<DatabasePrivilege> privs = new ArrayList<DatabasePrivilege>();
        ResultSet rs = jmetadata.getTablePrivileges(null, this.schemaPattern(), objectname);
        ArrayList<String> grantees = new ArrayList<String>();
        HashMap<String, String> allprivs = new HashMap<String, String>();
        while (rs.next()) {
            if (!grantees.contains(rs.getString("GRANTEE"))) {
                grantees.add(rs.getString("GRANTEE"));
            }
            allprivs.put(rs.getString("GRANTEE") + rs.getString("PRIVILEGE"), "");
        }
        ListIterator iter = grantees.listIterator();
        while (iter.hasNext()) {
            String grantee = (String)iter.next();
            DatabasePrivilege priv = new DatabasePrivilege();
            priv.setName(grantee.toUpperCase());
            priv.setGrantee(grantee.toUpperCase());
            priv.setDelete(allprivs.containsKey(grantee + "DELETE"));
            priv.setInsert(allprivs.containsKey(grantee + "INSERT"));
            priv.setUpdate(allprivs.containsKey(grantee + "UPDATE"));
            priv.setSelect(allprivs.containsKey(grantee + "SELECT"));
            privs.add(priv);
        }
        rs.close();
        return privs;
    }

    @Override
    public ArrayList<DatabasePrivilege> getProcedurePrivs(String objectname) throws SQLException {
        ArrayList<DatabasePrivilege> privs = new ArrayList<DatabasePrivilege>();
        String sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "SELECT GRANTEE ,PRIVILEGE FROM ALL_TAB_PRIVS WHERE TABLE_schema = user AND TABLE_NAME = ?";
        } else if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            sql = "select su.name GRANTEE, permission_name PRIVILEGE";
            sql = sql + " FROM sys.database_permissions sp, sysobjects so, sysusers su";
            sql = sql + " WHERE su.uid=sp.grantee_principal_id and MAJOR_ID=so.id and so.name = ?";
        }
        PreparedStatement stmt = this.m_jconn.prepareStatement(sql);
        stmt.setString(1, objectname);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            DatabasePrivilege priv = new DatabasePrivilege();
            priv.setName(rs.getString("GRANTEE").toUpperCase());
            priv.setGrantee(rs.getString("GRANTEE").toUpperCase());
            priv.setExecute(true);
            privs.add(priv);
        }
        rs.close();
        stmt.close();
        return privs;
    }

    @Override
    public ArrayList<DatabaseSynonym> getSynonyms(String objectname) throws SQLException {
        DatabaseSynonym syn;
        ArrayList<DatabaseSynonym> syns = new ArrayList<DatabaseSynonym>();
        String sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "SELECT OWNER, VIEW_NAME SYNONYM_NAME FROM sys.dba_views";
            sql = sql + " WHERE OWNER IN (SELECT GRANTEE FROM ALL_TAB_PRIVS WHERE TABLE_SCHEMA = USER AND TABLE_NAME = ?)";
            sql = sql + " and view_name = ?";
        } else {
            sql = "select su.name OWNER, so.name SYNONYM_NAME from sysobjects so, sysusers su";
            sql = sql + " where type = 'V' and so.uid in (";
            sql = sql + " select su.uid FROM sys.database_permissions sp, sysobjects so";
            sql = sql + " WHERE su.uid=sp.grantee_principal_id and MAJOR_ID=so.id and so.name = ?";
            sql = sql + " and permission_name = 'SELECT')";
            sql = sql + " and so.name = ? and so.uid=su.uid";
        }
        PreparedStatement stmt = this.m_jconn.prepareStatement(sql);
        stmt.setString(1, objectname);
        stmt.setString(2, objectname);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            syn = new DatabaseSynonym();
            syn.setOwner(rs.getString("OWNER").toUpperCase());
            syn.setType("LDV");
            syns.add(syn);
        }
        rs.close();
        stmt.close();
        if (this.m_conn.getServerType() == ServerType.SQLSERVER) {
            return syns;
        }
        sql = "";
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            sql = "select owner OWNER, synonym_name SYNONYM_NAME from all_synonyms where table_owner = user and table_name = ?";
        }
        stmt = this.m_jconn.prepareStatement(sql);
        stmt.setString(1, objectname);
        rs = stmt.executeQuery();
        while (rs.next()) {
            syn = new DatabaseSynonym();
            syn.setOwner(rs.getString("OWNER").toUpperCase());
            syn.setType("SYNONYM");
            syns.add(syn);
        }
        rs.close();
        stmt.close();
        return syns;
    }

    public static void main(String[] args) throws SQLException {
        DatabaseConnection conn = new DatabaseConnection("admuser/admuser@oracle:bdiehl:xe");
        DatabaseMetaData md = new DatabaseMetaData();
        md.setDatabaseConnection(conn);
        ArrayList<DatabaseTable> tables = md.getTables();
        ListIterator<DatabaseTable> iter = tables.listIterator();
        while (iter.hasNext()) {
            DatabaseTable tab = iter.next();
            System.out.println(tab.getName());
        }
        conn.close();
    }
}

